/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellEnabledDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.Log;
import com.android.ddmlib.MultiLineReceiver;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.TimeoutException;
import com.android.ddmlib.logcat.LogCatHeader;
import com.android.ddmlib.logcat.LogCatMessage;
import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.logcat.AndroidLogcatReceiver;
import com.android.tools.idea.run.LoggingReceiver;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.intellij.execution.impl.ConsoleBuffer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidOutputReceiver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@ThreadSafe
public final class AndroidLogcatService
implements AndroidDebugBridge.IDeviceChangeListener,
Disposable {
    private final Object myLock = new Object();
    @GuardedBy(value="myLock")
    private final Map<IDevice, AndroidLogcatReceiver> myLogReceivers = new HashMap<IDevice, AndroidLogcatReceiver>();
    @GuardedBy(value="myLock")
    private final Map<IDevice, LogcatBuffer> myLogBuffers = new HashMap<IDevice, LogcatBuffer>();
    @GuardedBy(value="myLock")
    private final Map<IDevice, ExecutorService> myExecutors = new HashMap<IDevice, ExecutorService>();
    @GuardedBy(value="myLock")
    private final Multimap<IDevice, ListenerConnector> myDeviceToListenerMultimap = ArrayListMultimap.create();

    private static Logger getLog() {
        return Logger.getInstance(AndroidLogcatService.class);
    }

    @NotNull
    public static AndroidLogcatService getInstance() {
        AndroidLogcatService androidLogcatService = (AndroidLogcatService)ApplicationManager.getApplication().getService(AndroidLogcatService.class);
        if (androidLogcatService == null) {
            AndroidLogcatService.$$$reportNull$$$0(0);
        }
        return androidLogcatService;
    }

    @TestOnly
    AndroidLogcatService() {
        AndroidDebugBridge.addDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startReceiving(@NotNull IDevice device) {
        if (device == null) {
            AndroidLogcatService.$$$reportNull$$$0(1);
        }
        Object object = this.myLock;
        synchronized (object) {
            if (this.myLogReceivers.containsKey(device)) {
                return;
            }
            this.connect(device);
            AndroidLogcatReceiver receiver = this.newAndroidLogcatReceiver(device);
            this.myLogReceivers.put(device, receiver);
            this.myLogBuffers.put(device, new LogcatBuffer());
            this.myExecutors.get(device).execute(() -> AndroidLogcatService.executeLogcat((IShellEnabledDevice)device, receiver));
        }
    }

    @NotNull
    private AndroidLogcatReceiver newAndroidLogcatReceiver(final @NotNull IDevice device) {
        if (device == null) {
            AndroidLogcatService.$$$reportNull$$$0(2);
        }
        return new AndroidLogcatReceiver(device, new LogcatListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onLogLineReceived(@NotNull LogCatMessage line2) {
                ImmutableList connectors;
                if (line2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                Object object = AndroidLogcatService.this.myLock;
                synchronized (object) {
                    connectors = ImmutableList.copyOf((Collection)AndroidLogcatService.this.myDeviceToListenerMultimap.get((Object)device));
                    LogcatBuffer buffer = AndroidLogcatService.this.myLogBuffers.get(device);
                    if (buffer != null) {
                        buffer.addMessage(line2);
                    }
                }
                connectors.forEach(connector -> connector.onLogLineReceived(line2));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/android/tools/idea/logcat/AndroidLogcatService$1", "onLogLineReceived"));
            }
        });
    }

    private static void executeLogcat(@NotNull IShellEnabledDevice device, @NotNull AndroidLogcatReceiver receiver) {
        if (device == null) {
            AndroidLogcatService.$$$reportNull$$$0(3);
        }
        if (receiver == null) {
            AndroidLogcatService.$$$reportNull$$$0(4);
        }
        try {
            AndroidLogcatService.execute(device, AndroidLogcatService.supportsEpochFormatModifier(device) ? "logcat -v long -v epoch" : "logcat -v long", receiver, Duration.ZERO);
        }
        catch (Throwable throwable) {
            AndroidLogcatService.getLog().warn(throwable);
            String app = IdeInfo.getInstance().isAndroidStudio() ? "com.android.studio" : "com.jetbrains.idea";
            receiver.notifyLine(new LogCatHeader(Log.LogLevel.ERROR, 0, 0, app, "AndroidLogcatService", Instant.now()), throwable.toString());
        }
    }

    private static boolean supportsEpochFormatModifier(@NotNull IShellEnabledDevice device) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        if (device == null) {
            AndroidLogcatService.$$$reportNull$$$0(5);
        }
        LogcatHelpReceiver receiver = new LogcatHelpReceiver();
        device.executeShellCommand("logcat --help", (IShellOutputReceiver)receiver, 10L, TimeUnit.SECONDS);
        return receiver.mySupportsEpochFormatModifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connect(@NotNull IDevice device) {
        if (device == null) {
            AndroidLogcatService.$$$reportNull$$$0(6);
        }
        Object object = this.myLock;
        synchronized (object) {
            if (!this.myExecutors.containsKey(device)) {
                ThreadFactory factory2 = new ThreadFactoryBuilder().setNameFormat("Android Logcat Service Thread %s for Device Serial Number " + device).build();
                this.myExecutors.put(device, Executors.newSingleThreadExecutor(factory2));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disconnect(@NotNull IDevice device) {
        if (device == null) {
            AndroidLogcatService.$$$reportNull$$$0(7);
        }
        Object object = this.myLock;
        synchronized (object) {
            this.stopReceiving(device);
            this.myExecutors.remove(device);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopReceiving(@NotNull IDevice device) {
        if (device == null) {
            AndroidLogcatService.$$$reportNull$$$0(8);
        }
        Object object = this.myLock;
        synchronized (object) {
            if (this.myLogReceivers.containsKey(device)) {
                this.myLogReceivers.get(device).cancel();
                this.myLogReceivers.remove(device);
                this.myLogBuffers.remove(device);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearLogcat(@NotNull IDevice device, @NotNull Project project) {
        if (device == null) {
            AndroidLogcatService.$$$reportNull$$$0(9);
        }
        if (project == null) {
            AndroidLogcatService.$$$reportNull$$$0(10);
        }
        Object object = this.myLock;
        synchronized (object) {
            ExecutorService executor = this.myExecutors.get(device);
            if (executor == null) {
                this.notifyThatLogcatWasCleared(device);
                return;
            }
            this.stopReceiving(device);
            executor.execute(() -> {
                try {
                    AndroidLogcatService.execute((IShellEnabledDevice)device, "logcat -c", new LoggingReceiver(AndroidLogcatService.getLog()), Duration.ofSeconds(5L));
                }
                catch (Exception exception) {
                    AndroidLogcatService.getLog().warn((Throwable)exception);
                    ApplicationManager.getApplication().invokeLater(() -> {
                        String title = AndroidBundle.message("android.logcat.error.dialog.title", new Object[0]);
                        Messages.showErrorDialog((Project)project, (String)exception.toString(), (String)title);
                    });
                }
                this.notifyThatLogcatWasCleared(device);
            });
            this.startReceiving(device);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyThatLogcatWasCleared(@NotNull IDevice device) {
        ImmutableList connectors;
        if (device == null) {
            AndroidLogcatService.$$$reportNull$$$0(11);
        }
        Object object = this.myLock;
        synchronized (object) {
            connectors = ImmutableList.copyOf((Collection)this.myDeviceToListenerMultimap.get((Object)device));
        }
        connectors.forEach(ListenerConnector::onCleared);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(@NotNull IDevice device, @NotNull LogcatListener listener2, boolean addOldLogs) {
        if (device == null) {
            AndroidLogcatService.$$$reportNull$$$0(12);
        }
        if (listener2 == null) {
            AndroidLogcatService.$$$reportNull$$$0(13);
        }
        Object object = this.myLock;
        synchronized (object) {
            ImmutableList oldMessages = addOldLogs && this.myLogBuffers.containsKey(device) ? this.myLogBuffers.get(device).getMessages() : ImmutableList.of();
            ListenerConnector listenerConnector = new ListenerConnector(listener2, (Collection<LogCatMessage>)oldMessages);
            this.myDeviceToListenerMultimap.put((Object)device, (Object)listenerConnector);
            if (device.isOnline()) {
                this.startReceiving(device);
            }
            if (!oldMessages.isEmpty()) {
                ExecutorService executor = this.myExecutors.get(device);
                assert (executor != null);
                executor.execute(() -> listenerConnector.processBacklog());
            }
        }
    }

    public void addListener(@NotNull IDevice device, @NotNull LogcatListener listener2) {
        if (device == null) {
            AndroidLogcatService.$$$reportNull$$$0(14);
        }
        if (listener2 == null) {
            AndroidLogcatService.$$$reportNull$$$0(15);
        }
        this.addListener(device, listener2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(@NotNull IDevice device, @NotNull LogcatListener listener2) {
        if (device == null) {
            AndroidLogcatService.$$$reportNull$$$0(16);
        }
        if (listener2 == null) {
            AndroidLogcatService.$$$reportNull$$$0(17);
        }
        Object object = this.myLock;
        synchronized (object) {
            Collection connectors = this.myDeviceToListenerMultimap.get((Object)device);
            if (connectors.isEmpty()) {
                return;
            }
            Iterator iter = connectors.iterator();
            while (iter.hasNext()) {
                ListenerConnector connector = (ListenerConnector)iter.next();
                if (!connector.isConnectedTo(listener2)) continue;
                connector.disconnectListener();
                iter.remove();
                break;
            }
            if (connectors.isEmpty()) {
                this.stopReceiving(device);
                this.myDeviceToListenerMultimap.removeAll((Object)device);
            }
        }
    }

    public void deviceConnected(@NotNull IDevice device) {
        if (device == null) {
            AndroidLogcatService.$$$reportNull$$$0(18);
        }
        if (device.isOnline()) {
            this.startReceiving(device);
        }
    }

    public void deviceDisconnected(@NotNull IDevice device) {
        if (device == null) {
            AndroidLogcatService.$$$reportNull$$$0(19);
        }
        this.disconnect(device);
    }

    public void deviceChanged(@NotNull IDevice device, int changeMask) {
        if (device == null) {
            AndroidLogcatService.$$$reportNull$$$0(20);
        }
        if (device.isOnline()) {
            this.startReceiving(device);
        } else {
            this.disconnect(device);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        AndroidDebugBridge.removeDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
        Object object = this.myLock;
        synchronized (object) {
            for (AndroidLogcatReceiver receiver : this.myLogReceivers.values()) {
                receiver.cancel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestOnly
    public void shutdown() {
        Disposer.dispose((Disposable)this);
        Object object = this.myLock;
        synchronized (object) {
            this.myExecutors.values().forEach(executor -> {
                try {
                    executor.shutdownNow();
                    executor.awaitTermination(5000L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    AndroidLogcatService.getLog().info("Error shutting down executor", (Throwable)e);
                }
            });
        }
    }

    private static void execute(@NotNull IShellEnabledDevice device, @NotNull String command, @NotNull AndroidOutputReceiver receiver, @NotNull Duration duration2) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        if (device == null) {
            AndroidLogcatService.$$$reportNull$$$0(21);
        }
        if (command == null) {
            AndroidLogcatService.$$$reportNull$$$0(22);
        }
        if (receiver == null) {
            AndroidLogcatService.$$$reportNull$$$0(23);
        }
        if (duration2 == null) {
            AndroidLogcatService.$$$reportNull$$$0(24);
        }
        device.executeShellCommand(command, (IShellOutputReceiver)receiver, duration2.toMillis(), TimeUnit.MILLISECONDS);
        if (receiver.isCancelled()) {
            return;
        }
        receiver.invalidate();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/logcat/AndroidLogcatService";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 4: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "receiver";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 13: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "duration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/logcat/AndroidLogcatService";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "startReceiving";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "newAndroidLogcatReceiver";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "executeLogcat";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "supportsEpochFormatModifier";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "connect";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "disconnect";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "stopReceiving";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "clearLogcat";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "notifyThatLogcatWasCleared";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "removeListener";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "deviceConnected";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "deviceDisconnected";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "deviceChanged";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class LogcatHelpReceiver
    extends MultiLineReceiver {
        private boolean mySupportsEpochFormatModifier;
        private boolean myCancelled;

        private LogcatHelpReceiver() {
        }

        public void processNewLines(@NotNull String[] lines2) {
            if (lines2 == null) {
                LogcatHelpReceiver.$$$reportNull$$$0(0);
            }
            if (this.mySupportsEpochFormatModifier) {
                this.myCancelled = true;
                return;
            }
            this.mySupportsEpochFormatModifier = Arrays.stream(lines2).anyMatch(line2 -> line2.contains("epoch"));
        }

        public boolean isCancelled() {
            return this.myCancelled;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lines", "com/android/tools/idea/logcat/AndroidLogcatService$LogcatHelpReceiver", "processNewLines"));
        }
    }

    public static interface LogcatListener {
        default public void onLogLineReceived(@NotNull LogCatMessage line2) {
            if (line2 == null) {
                LogcatListener.$$$reportNull$$$0(0);
            }
        }

        default public void onCleared() {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/android/tools/idea/logcat/AndroidLogcatService$LogcatListener", "onLogLineReceived"));
        }
    }

    private static class ListenerConnector
    implements LogcatListener {
        @GuardedBy(value="myListenerLock")
        @Nullable
        private LogcatListener myListener;
        @GuardedBy(value="myBacklogLock")
        @Nullable
        private Queue<LogCatMessage> myBacklog;
        @NotNull
        private final Object myListenerLock;
        @NotNull
        private final Object myBacklogLock;

        ListenerConnector(@NotNull LogcatListener listener2, @NotNull Collection<LogCatMessage> messageBacklog) {
            if (listener2 == null) {
                ListenerConnector.$$$reportNull$$$0(0);
            }
            if (messageBacklog == null) {
                ListenerConnector.$$$reportNull$$$0(1);
            }
            this.myListenerLock = new Object();
            this.myBacklogLock = new Object();
            this.myListener = listener2;
            this.myBacklog = messageBacklog.isEmpty() ? null : new ArrayDeque<LogCatMessage>(messageBacklog);
        }

        @Override
        public void onLogLineReceived(@NotNull LogCatMessage message2) {
            if (message2 == null) {
                ListenerConnector.$$$reportNull$$$0(2);
            }
            this.processBacklog();
            this.dispatchMessage(message2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCleared() {
            Object object = this.myBacklogLock;
            synchronized (object) {
                this.myBacklog = null;
            }
            object = this.myListenerLock;
            synchronized (object) {
                if (this.myListener != null) {
                    this.myListener.onCleared();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean isConnectedTo(@NotNull LogcatListener listener2) {
            if (listener2 == null) {
                ListenerConnector.$$$reportNull$$$0(3);
            }
            Object object = this.myListenerLock;
            synchronized (object) {
                return listener2 == this.myListener;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void disconnectListener() {
            Object object = this.myListenerLock;
            synchronized (object) {
                this.myListener = null;
            }
            object = this.myBacklogLock;
            synchronized (object) {
                this.myBacklog = null;
            }
        }

        void processBacklog() {
            LogCatMessage message2;
            while ((message2 = this.getMessageFromBacklog()) != null) {
                this.dispatchMessage(message2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void dispatchMessage(@NotNull LogCatMessage message2) {
            if (message2 == null) {
                ListenerConnector.$$$reportNull$$$0(4);
            }
            Object object = this.myListenerLock;
            synchronized (object) {
                if (this.myListener != null) {
                    this.myListener.onLogLineReceived(message2);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        private LogCatMessage getMessageFromBacklog() {
            Object object = this.myBacklogLock;
            synchronized (object) {
                if (this.myBacklog == null) {
                    return null;
                }
                LogCatMessage message2 = this.myBacklog.remove();
                if (this.myBacklog.isEmpty()) {
                    this.myBacklog = null;
                }
                return message2;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "listener";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "messageBacklog";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/logcat/AndroidLogcatService$ListenerConnector";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onLogLineReceived";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isConnectedTo";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "dispatchMessage";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class LogcatBuffer {
        private int myBufferSize;
        private final LinkedList<LogCatMessage> myMessages = new LinkedList();

        private LogcatBuffer() {
        }

        public void addMessage(@NotNull LogCatMessage message2) {
            if (message2 == null) {
                LogcatBuffer.$$$reportNull$$$0(0);
            }
            this.myMessages.add(message2);
            this.myBufferSize += message2.getMessage().length();
            if (ConsoleBuffer.useCycleBuffer()) {
                while (this.myBufferSize > ConsoleBuffer.getCycleBufferSize()) {
                    this.myBufferSize -= this.myMessages.removeFirst().getMessage().length();
                }
            }
        }

        @NotNull
        public List<LogCatMessage> getMessages() {
            LinkedList<LogCatMessage> linkedList = this.myMessages;
            if (linkedList == null) {
                LogcatBuffer.$$$reportNull$$$0(1);
            }
            return linkedList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/logcat/AndroidLogcatService$LogcatBuffer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/logcat/AndroidLogcatService$LogcatBuffer";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMessages";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "addMessage";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

