/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat;

import com.android.ddmlib.logcat.LogCatHeader;
import com.android.ddmlib.logcat.LogCatMessage;
import com.android.tools.idea.logcat.AndroidLogcatPreferences;
import com.android.tools.idea.logcat.LongEpochMessageFormatter;
import com.android.tools.idea.logcat.LongMessageFormatter;
import com.android.tools.idea.logcat.MessageFormatter;
import com.intellij.diagnostic.logging.DefaultLogFormatter;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AndroidLogcatFormatter
extends DefaultLogFormatter {
    private static final String FULL_FORMAT = AndroidLogcatFormatter.createCustomFormat(true, true, true, true);
    @NonNls
    private static final Pattern CONTINUATION_PATTERN = Pattern.compile("^\\+ (.*)$");
    public static final CharSequence CONTINUATION_INDENT = "    ";
    private final MessageFormatter myLongEpochFormatter;
    private final MessageFormatter myLongFormatter;
    private final AndroidLogcatPreferences myPreferences;

    public AndroidLogcatFormatter(@NotNull ZoneId timeZone, @NotNull AndroidLogcatPreferences preferences) {
        if (timeZone == null) {
            AndroidLogcatFormatter.$$$reportNull$$$0(0);
        }
        if (preferences == null) {
            AndroidLogcatFormatter.$$$reportNull$$$0(1);
        }
        this.myLongEpochFormatter = new LongEpochMessageFormatter(preferences, timeZone);
        this.myLongFormatter = new LongMessageFormatter();
        this.myPreferences = preferences;
    }

    @NotNull
    String formatMessageFull(@NotNull LogCatHeader header, @NotNull String message2) {
        if (header == null) {
            AndroidLogcatFormatter.$$$reportNull$$$0(2);
        }
        if (message2 == null) {
            AndroidLogcatFormatter.$$$reportNull$$$0(3);
        }
        String string = this.formatMessage(FULL_FORMAT, header, message2);
        if (string == null) {
            AndroidLogcatFormatter.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public static String formatContinuation(@NotNull String message2) {
        if (message2 == null) {
            AndroidLogcatFormatter.$$$reportNull$$$0(5);
        }
        String string = String.format("+ %s", message2);
        if (string == null) {
            AndroidLogcatFormatter.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public static String createCustomFormat(boolean showTime, boolean showPid, boolean showPackage, boolean showTag) {
        StringBuilder builder2 = new StringBuilder();
        if (showTime) {
            builder2.append("%1$s ");
        }
        if (showPid) {
            builder2.append("%2$s").append(showPackage ? (char)'/' : ' ');
        }
        if (showPackage) {
            builder2.append("%3$s ");
        }
        builder2.append("%4$c");
        if (showTag) {
            builder2.append("/%5$s");
        }
        builder2.append(": %6$s");
        String string = builder2.toString();
        if (string == null) {
            AndroidLogcatFormatter.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public String formatMessage(@NotNull String format2, @NotNull LogCatHeader header, @NotNull String message2) {
        if (format2 == null) {
            AndroidLogcatFormatter.$$$reportNull$$$0(8);
        }
        if (header == null) {
            AndroidLogcatFormatter.$$$reportNull$$$0(9);
        }
        if (message2 == null) {
            AndroidLogcatFormatter.$$$reportNull$$$0(10);
        }
        if (header.getTimestamp() == null) {
            String string = this.myLongEpochFormatter.format(format2, header, message2);
            if (string == null) {
                AndroidLogcatFormatter.$$$reportNull$$$0(11);
            }
            return string;
        }
        if (header.getTimestampInstant() == null) {
            String string = this.myLongFormatter.format(format2, header, message2);
            if (string == null) {
                AndroidLogcatFormatter.$$$reportNull$$$0(12);
            }
            return string;
        }
        throw new AssertionError(header);
    }

    @NotNull
    LogCatMessage parseMessage(@NotNull String message2) {
        LogCatMessage result2;
        if (message2 == null) {
            AndroidLogcatFormatter.$$$reportNull$$$0(13);
        }
        if ((result2 = this.tryParseMessage(message2)) == null) {
            throw new IllegalArgumentException("Invalid message doesn't match expected logcat pattern: " + message2);
        }
        LogCatMessage logCatMessage = result2;
        if (logCatMessage == null) {
            AndroidLogcatFormatter.$$$reportNull$$$0(14);
        }
        return logCatMessage;
    }

    @Nullable
    LogCatMessage tryParseMessage(@NotNull String message2) {
        LogCatMessage logcatMessage;
        if (message2 == null) {
            AndroidLogcatFormatter.$$$reportNull$$$0(15);
        }
        if ((logcatMessage = this.myLongEpochFormatter.tryParse(message2)) != null) {
            return logcatMessage;
        }
        logcatMessage = this.myLongFormatter.tryParse(message2);
        if (logcatMessage != null) {
            return logcatMessage;
        }
        return null;
    }

    @Nullable
    public static String tryParseContinuation(@NotNull String msg) {
        Matcher matcher;
        if (msg == null) {
            AndroidLogcatFormatter.$$$reportNull$$$0(16);
        }
        if (!(matcher = CONTINUATION_PATTERN.matcher(msg)).matches()) {
            return null;
        }
        return matcher.group(1);
    }

    public String formatPrefix(String prefix) {
        if (prefix.isEmpty()) {
            return prefix;
        }
        return Arrays.stream(prefix.split("\n", -1)).map(this::formatMessage).collect(Collectors.joining("\n"));
    }

    @NotNull
    public String formatMessage(@NotNull String message2) {
        String continuation;
        if (message2 == null) {
            AndroidLogcatFormatter.$$$reportNull$$$0(17);
        }
        if ((continuation = AndroidLogcatFormatter.tryParseContinuation(message2)) != null) {
            String string = CONTINUATION_INDENT + continuation;
            if (string == null) {
                AndroidLogcatFormatter.$$$reportNull$$$0(18);
            }
            return string;
        }
        LogCatMessage logcatMessage = this.tryParseMessage(message2);
        if (logcatMessage == null || this.myPreferences.LOGCAT_FORMAT_STRING.isEmpty()) {
            String string = message2;
            if (string == null) {
                AndroidLogcatFormatter.$$$reportNull$$$0(19);
            }
            return string;
        }
        String string = this.formatMessage(logcatMessage);
        if (string == null) {
            AndroidLogcatFormatter.$$$reportNull$$$0(20);
        }
        return string;
    }

    @NotNull
    String formatMessage(@NotNull LogCatMessage message2) {
        if (message2 == null) {
            AndroidLogcatFormatter.$$$reportNull$$$0(21);
        }
        String format2 = this.myPreferences.LOGCAT_FORMAT_STRING.isEmpty() ? FULL_FORMAT : this.myPreferences.LOGCAT_FORMAT_STRING;
        String string = this.formatMessage(format2, message2.getHeader(), message2.getMessage());
        if (string == null) {
            AndroidLogcatFormatter.$$$reportNull$$$0(22);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 14: 
            case 18: 
            case 19: 
            case 20: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 14: 
            case 18: 
            case 19: 
            case 20: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timeZone";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preferences";
                break;
            }
            case 2: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "header";
                break;
            }
            case 3: 
            case 5: 
            case 10: 
            case 13: 
            case 15: 
            case 17: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 14: 
            case 18: 
            case 19: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/logcat/AndroidLogcatFormatter";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "msg";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/logcat/AndroidLogcatFormatter";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "formatMessageFull";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "formatContinuation";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createCustomFormat";
                break;
            }
            case 11: 
            case 12: 
            case 18: 
            case 19: 
            case 20: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "formatMessage";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "parseMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "formatMessageFull";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 14: 
            case 18: 
            case 19: 
            case 20: 
            case 22: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "formatContinuation";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 17: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "formatMessage";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "parseMessage";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "tryParseMessage";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "tryParseContinuation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 14: 
            case 18: 
            case 19: 
            case 20: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

