/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint;

import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.tools.idea.lint.GenerateBackupDescriptorFix;
import com.android.tools.idea.lint.common.AndroidQuickfixContexts;
import com.android.tools.idea.lint.common.DefaultLintQuickFix;
import com.android.tools.idea.lint.common.SetAttributeQuickFix;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import org.jetbrains.annotations.NotNull;

class SetAndGenerateBackupDescriptor
extends DefaultLintQuickFix {
    private static final String RESOURCE_URL_NAME = "backup_descriptor";
    private final SetAttributeQuickFix mySetAttributeQuickFix;
    private final GenerateBackupDescriptorFix myGenerateDescriptorFix;

    public SetAndGenerateBackupDescriptor() {
        super("Set fullBackupContent attribute and generate descriptor");
        ResourceUrl resourceUrl = ResourceUrl.create((ResourceType)ResourceType.XML, (String)RESOURCE_URL_NAME, (boolean)false);
        this.mySetAttributeQuickFix = new SetAttributeQuickFix(this.myName, null, "fullBackupContent", resourceUrl.toString());
        this.myGenerateDescriptorFix = new GenerateBackupDescriptorFix(resourceUrl);
    }

    public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
        if (startElement == null) {
            SetAndGenerateBackupDescriptor.$$$reportNull$$$0(0);
        }
        if (endElement == null) {
            SetAndGenerateBackupDescriptor.$$$reportNull$$$0(1);
        }
        if (context == null) {
            SetAndGenerateBackupDescriptor.$$$reportNull$$$0(2);
        }
        this.mySetAttributeQuickFix.apply(startElement, endElement, context);
        this.myGenerateDescriptorFix.apply(startElement, endElement, context);
    }

    public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
        if (startElement == null) {
            SetAndGenerateBackupDescriptor.$$$reportNull$$$0(3);
        }
        if (endElement == null) {
            SetAndGenerateBackupDescriptor.$$$reportNull$$$0(4);
        }
        if (contextType == null) {
            SetAndGenerateBackupDescriptor.$$$reportNull$$$0(5);
        }
        return SetAndGenerateBackupDescriptor.isAllowBackupEnabled(startElement) && this.mySetAttributeQuickFix.isApplicable(startElement, endElement, contextType) && this.myGenerateDescriptorFix.isApplicable(startElement, endElement, contextType);
    }

    static boolean isAllowBackupEnabled(@NotNull PsiElement startElement) {
        XmlTag tag;
        if (startElement == null) {
            SetAndGenerateBackupDescriptor.$$$reportNull$$$0(6);
        }
        if ((tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)startElement, XmlTag.class, (boolean)false)) == null) {
            return true;
        }
        return !"false".equals(tag.getAttributeValue("allowBackup", "http://schemas.android.com/apk/res/android"));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextType";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/lint/SetAndGenerateBackupDescriptor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "apply";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isApplicable";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isAllowBackupEnabled";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

