/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint;

import com.android.ide.common.gradle.model.IdeAndroidProject;
import com.android.ide.common.gradle.model.IdeLintOptions;
import com.android.tools.analytics.Anonymizer;
import com.android.tools.analytics.CommonMetricsData;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.lint.LintIdeAnalytics$WhenMappings;
import com.android.tools.idea.lint.common.LintProblemData;
import com.android.tools.idea.stats.UsageTrackerUtils;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Severity;
import com.android.utils.ILogger;
import com.android.utils.NullLogger;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.LintAction;
import com.google.wireless.android.sdk.stats.LintIssueId;
import com.google.wireless.android.sdk.stats.LintPerformance;
import com.google.wireless.android.sdk.stats.LintSession;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0002\u001a\u00020\u0003H\u0002JV\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t0\b2\u000e\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b2&\u0010\r\u001a\"\u0012\u0004\u0012\u00020\u000e\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\b\u0018\u00010\b2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0014\u0010\u0018\u001a\u0004\u0018\u00010\u00062\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0002J\u0016\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u001fJX\u0010 \u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u000e\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b2&\u0010\r\u001a\"\u0012\u0004\u0012\u00020\u000e\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\b\u0018\u00010\bJ:\u0010#\u001a\u00020\u001c2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\"\u0010%\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t0&j\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t`'H\u0002J<\u0010(\u001a\u00020\u001c2\"\u0010%\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t0&j\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t`'2\u0006\u0010)\u001a\u00020\u00062\u0006\u0010*\u001a\u00020+H\u0002J\f\u0010,\u001a\u00020+*\u00020-H\u0002J\f\u0010,\u001a\u00020+*\u00020.H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/android/tools/idea/lint/LintIdeAnalytics;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "computeApplicationId", "", "computeIssueData", "", "Lcom/google/wireless/android/sdk/stats/LintIssueId$Builder;", "warnings1", "", "Lcom/android/tools/idea/lint/common/LintProblemData;", "warnings2", "Lcom/android/tools/lint/detector/api/Issue;", "Ljava/io/File;", "severityModule", "Lcom/intellij/openapi/module/Module;", "computePerformance", "Lcom/google/wireless/android/sdk/stats/LintPerformance;", "driver", "Lcom/android/tools/lint/client/api/LintDriver;", "singleFileAnalysis", "", "computeProjectId", "projectPath", "Ljava/nio/file/Path;", "logFeedback", "", "issue", "feedback", "Lcom/google/wireless/android/sdk/stats/LintAction$LintFeedback;", "logSession", "type", "Lcom/google/wireless/android/sdk/stats/LintSession$AnalysisType;", "recordIssueData", "warnings", "map", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "recordSeverityOverride", "id", "lintSeverity", "Lcom/google/wireless/android/sdk/stats/LintIssueId$LintSeverity;", "toAnalyticsSeverity", "Lcom/android/tools/lint/detector/api/Severity;", "", "intellij.android.core"})
public final class LintIdeAnalytics {
    private final Project project;

    public final void logFeedback(@NotNull String issue2, @NotNull LintAction.LintFeedback feedback) {
        String it;
        boolean bl;
        boolean bl2;
        String string;
        Intrinsics.checkNotNullParameter((Object)issue2, (String)"issue");
        Intrinsics.checkNotNullParameter((Object)feedback, (String)"feedback");
        AndroidStudioEvent.Builder builder2 = AndroidStudioEvent.newBuilder();
        boolean bl3 = false;
        boolean bl4 = false;
        AndroidStudioEvent.Builder $this$apply = builder2;
        boolean bl5 = false;
        $this$apply.setKind(AndroidStudioEvent.EventKind.LINT_ACTION);
        String string2 = this.computeProjectId(this.project);
        if (string2 != null) {
            string = string2;
            bl2 = false;
            bl = false;
            it = string;
            boolean bl6 = false;
            $this$apply.setProjectId(it);
        }
        String string3 = this.computeApplicationId(this.project);
        if (string3 != null) {
            string = string3;
            bl2 = false;
            bl = false;
            it = string;
            boolean bl7 = false;
            $this$apply.setRawProjectId(it);
        }
        LintAction.Builder builder3 = LintAction.newBuilder();
        bl = false;
        boolean bl8 = false;
        LintAction.Builder $this$apply2 = builder3;
        boolean bl9 = false;
        $this$apply2.setIssueId(issue2);
        $this$apply2.setLintFeedback(feedback);
        LintAction action2 = builder3.build();
        $this$apply.setLintAction(action2);
        AndroidStudioEvent.Builder builder4 = builder2;
        Intrinsics.checkNotNullExpressionValue((Object)builder4, (String)"AndroidStudioEvent.newBu\u2026lintAction = action\n    }");
        AndroidStudioEvent.Builder event = UsageTrackerUtils.withProjectId(builder4, this.project);
        UsageTracker.log((AndroidStudioEvent.Builder)event);
    }

    public final void logSession(@NotNull LintSession.AnalysisType type, @NotNull LintDriver driver, @Nullable Module severityModule, @Nullable List<? extends LintProblemData> warnings1, @Nullable Map<Issue, ? extends Map<File, ? extends List<? extends LintProblemData>>> warnings2) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        if (this.project.isDisposed()) {
            return;
        }
        LintSession.Builder builder2 = LintSession.newBuilder();
        boolean bl = false;
        boolean bl2 = false;
        LintSession.Builder $this$apply = builder2;
        boolean bl3 = false;
        $this$apply.setAnalysisType(type);
        $this$apply.setProjectId(this.computeProjectId(this.project));
        $this$apply.setLintPerformance(this.computePerformance(driver, type == LintSession.AnalysisType.IDE_FILE));
        $this$apply.setBaselineEnabled(driver.getBaseline() != null);
        $this$apply.setIncludingGeneratedSources(driver.getCheckGeneratedSources());
        $this$apply.setIncludingTestSources(driver.getCheckTestSources());
        $this$apply.setIncludingDependencies(driver.getCheckDependencies());
        for (LintIssueId.Builder issueBuilder : this.computeIssueData(warnings1, warnings2, severityModule).values()) {
            $this$apply.addIssueIds(issueBuilder);
        }
        LintSession session = builder2.build();
        AndroidStudioEvent.Builder builder3 = AndroidStudioEvent.newBuilder();
        bl2 = false;
        boolean bl4 = false;
        AndroidStudioEvent.Builder $this$apply2 = builder3;
        boolean bl5 = false;
        $this$apply2.setKind(AndroidStudioEvent.EventKind.LINT_SESSION);
        $this$apply2.setLintSession(session);
        $this$apply2.setJavaProcessStats(CommonMetricsData.getJavaProcessStats());
        $this$apply2.setJvmDetails(CommonMetricsData.getJvmDetails());
        AndroidStudioEvent.Builder builder4 = builder3;
        Intrinsics.checkNotNullExpressionValue((Object)builder4, (String)"AndroidStudioEvent.newBu\u2026ricsData.jvmDetails\n    }");
        AndroidStudioEvent.Builder event = UsageTrackerUtils.withProjectId(builder4, this.project);
        UsageTracker.log((AndroidStudioEvent.Builder)event);
    }

    private final LintPerformance computePerformance(LintDriver driver, boolean singleFileAnalysis) {
        LintPerformance.Builder builder2 = LintPerformance.newBuilder();
        boolean bl = false;
        boolean bl2 = false;
        LintPerformance.Builder $this$apply = builder2;
        boolean bl3 = false;
        $this$apply.setAnalysisTimeMs(System.currentTimeMillis() - driver.getAnalysisStartTime());
        $this$apply.setFileCount((long)driver.getFileCount());
        if (!singleFileAnalysis) {
            $this$apply.setModuleCount((long)driver.getModuleCount());
            $this$apply.setJavaSourceCount((long)driver.getJavaFileCount());
            $this$apply.setKotlinSourceCount((long)driver.getKotlinFileCount());
            $this$apply.setResourceFileCount((long)driver.getResourceFileCount());
            $this$apply.setTestSourceCount((long)driver.getTestSourceCount());
        }
        LintPerformance lintPerformance = builder2.build();
        Intrinsics.checkNotNullExpressionValue((Object)lintPerformance, (String)"LintPerformance.newBuild\u2026g()\n      }\n    }.build()");
        return lintPerformance;
    }

    private final void recordSeverityOverride(HashMap<String, LintIssueId.Builder> map2, String id, LintIssueId.LintSeverity lintSeverity) {
        LintIssueId.Builder builder2 = map2.get(id);
        if (builder2 != null) {
            return;
        }
        LintIssueId.Builder builder3 = LintIssueId.newBuilder();
        boolean bl = false;
        boolean bl2 = false;
        LintIssueId.Builder $this$apply = builder3;
        boolean bl3 = false;
        Map map3 = map2;
        LintIssueId.Builder builder4 = $this$apply;
        Intrinsics.checkNotNullExpressionValue((Object)builder4, (String)"this");
        map3.put(id, builder4);
        $this$apply.setIssueId(id);
        $this$apply.setCount(0L);
        $this$apply.setSeverity(lintSeverity);
    }

    private final LintIssueId.LintSeverity toAnalyticsSeverity(Severity $this$toAnalyticsSeverity) {
        LintIssueId.LintSeverity lintSeverity;
        switch (LintIdeAnalytics$WhenMappings.$EnumSwitchMapping$0[$this$toAnalyticsSeverity.ordinal()]) {
            case 1: {
                lintSeverity = LintIssueId.LintSeverity.FATAL_SEVERITY;
                break;
            }
            case 2: {
                lintSeverity = LintIssueId.LintSeverity.ERROR_SEVERITY;
                break;
            }
            case 3: {
                lintSeverity = LintIssueId.LintSeverity.WARNING_SEVERITY;
                break;
            }
            case 4: {
                lintSeverity = LintIssueId.LintSeverity.INFORMATIONAL_SEVERITY;
                break;
            }
            case 5: {
                lintSeverity = LintIssueId.LintSeverity.IGNORE_SEVERITY;
                break;
            }
            default: {
                lintSeverity = LintIssueId.LintSeverity.UNKNOWN_SEVERITY;
            }
        }
        return lintSeverity;
    }

    private final LintIssueId.LintSeverity toAnalyticsSeverity(int $this$toAnalyticsSeverity) {
        LintIssueId.LintSeverity lintSeverity;
        switch ($this$toAnalyticsSeverity) {
            case 1: {
                lintSeverity = LintIssueId.LintSeverity.FATAL_SEVERITY;
                break;
            }
            case 2: {
                lintSeverity = LintIssueId.LintSeverity.ERROR_SEVERITY;
                break;
            }
            case 3: {
                lintSeverity = LintIssueId.LintSeverity.WARNING_SEVERITY;
                break;
            }
            case 4: {
                lintSeverity = LintIssueId.LintSeverity.INFORMATIONAL_SEVERITY;
                break;
            }
            case 5: {
                lintSeverity = LintIssueId.LintSeverity.IGNORE_SEVERITY;
                break;
            }
            default: {
                lintSeverity = LintIssueId.LintSeverity.UNKNOWN_SEVERITY;
            }
        }
        return lintSeverity;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, LintIssueId.Builder> computeIssueData(List<? extends LintProblemData> warnings1, Map<Issue, ? extends Map<File, ? extends List<? extends LintProblemData>>> warnings2, Module severityModule) {
        AndroidModuleModel androidModuleModel;
        HashMap<String, LintIssueId.Builder> map2 = new HashMap<String, LintIssueId.Builder>(100);
        if (warnings1 != null) {
            this.recordIssueData(warnings1, map2);
        }
        if (warnings2 != null) {
            for (Map<File, ? extends List<? extends LintProblemData>> map3 : warnings2.values()) {
                for (List<? extends LintProblemData> list : map3.values()) {
                    this.recordIssueData(list, map2);
                }
            }
        }
        if (severityModule != null && (androidModuleModel = AndroidModuleModel.get(severityModule)) != null) {
            try {
                IdeAndroidProject ideAndroidProject = androidModuleModel.getAndroidProject();
                Intrinsics.checkNotNullExpressionValue((Object)ideAndroidProject, (String)"model.androidProject");
                IdeAndroidProject gradleModel = ideAndroidProject;
                IdeLintOptions ideLintOptions = gradleModel.getLintOptions();
                Map overrides = ideLintOptions.getSeverityOverrides();
                if (overrides != null && !overrides.isEmpty()) {
                    Iterator iterator = overrides.entrySet().iterator();
                    while (iterator.hasNext()) {
                        void id;
                        Map.Entry entry;
                        Map.Entry entry2 = entry = iterator.next();
                        boolean bl = false;
                        String string = (String)entry2.getKey();
                        entry2 = entry;
                        bl = false;
                        int severity = ((Number)entry2.getValue()).intValue();
                        this.recordSeverityOverride(map2, (String)id, this.toAnalyticsSeverity(severity));
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return map2;
    }

    private final void recordIssueData(List<? extends LintProblemData> warnings, HashMap<String, LintIssueId.Builder> map2) {
        for (LintProblemData lintProblemData : warnings) {
            LintIssueId.Builder issueBuilder;
            Issue issue2;
            Intrinsics.checkNotNullExpressionValue((Object)lintProblemData.getIssue(), (String)"warning.issue");
            String id = issue2.getId();
            LintIssueId.Builder builder2 = map2.get(id);
            if (builder2 == null) {
                LintIdeAnalytics lintIdeAnalytics = this;
                boolean bl = false;
                boolean bl2 = false;
                LintIdeAnalytics $this$run = lintIdeAnalytics;
                boolean bl3 = false;
                LintIssueId.Builder builder3 = LintIssueId.newBuilder();
                boolean bl4 = false;
                boolean bl5 = false;
                LintIssueId.Builder $this$apply = builder3;
                boolean bl6 = false;
                Map map3 = map2;
                LintIssueId.Builder builder4 = $this$apply;
                Intrinsics.checkNotNullExpressionValue((Object)builder4, (String)"this");
                map3.put(id, builder4);
                $this$apply.setIssueId(issue2.getId());
                Severity configuredSeverity = lintProblemData.getConfiguredSeverity();
                $this$apply.setSeverity(configuredSeverity == null || configuredSeverity == issue2.getDefaultSeverity() ? LintIssueId.LintSeverity.DEFAULT_SEVERITY : $this$run.toAnalyticsSeverity(configuredSeverity));
                builder2 = builder3;
            }
            LintIssueId.Builder builder5 = issueBuilder = builder2;
            Intrinsics.checkNotNullExpressionValue((Object)builder5, (String)"issueBuilder");
            builder5.setCount(issueBuilder.getCount() + 1L);
        }
    }

    private final String computeApplicationId(Project project) {
        ModuleManager moduleManager;
        ModuleManager moduleManager2 = moduleManager = ModuleManager.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)moduleManager2, (String)"moduleManager");
        for (Module module2 : moduleManager2.getModules()) {
            AndroidModuleModel androidModel = AndroidModuleModel.get(module2);
            if (androidModel == null || androidModel.getAndroidProject().getProjectType() != 0) continue;
            return androidModel.getApplicationId();
        }
        return null;
    }

    private final String computeProjectId(Project project) {
        return this.computeProjectId(Paths.get(project.getBasePath(), new String[0]));
    }

    private final String computeProjectId(Path projectPath) {
        String string;
        if (projectPath == null) {
            return null;
        }
        try {
            string = Anonymizer.anonymizeUtf8((ILogger)((ILogger)new NullLogger()), (String)((Object)projectPath.toAbsolutePath()).toString());
        }
        catch (IOException e) {
            string = "*ANONYMIZATION_ERROR*";
        }
        return string;
    }

    public LintIdeAnalytics(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }
}

