/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint;

import com.android.tools.idea.lint.common.AndroidLintInspectionBase;
import com.android.tools.idea.lint.common.AndroidQuickfixContexts;
import com.android.tools.idea.lint.common.LintIdeQuickFix;
import com.android.tools.lint.checks.AnnotationDetector;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.TextFormat;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.core.ShortenReferences;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;

public class AndroidLintSwitchIntDefInspection
extends AndroidLintInspectionBase {
    public AndroidLintSwitchIntDefInspection() {
        super(AndroidBundle.message("android.lint.inspections.switch.int.def", new Object[0]), AnnotationDetector.SWITCH_TYPE_DEF);
    }

    @NotNull
    public LintIdeQuickFix[] getQuickFixes(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message2, @Nullable LintFix fixData) {
        List missingCases;
        if (startElement == null) {
            AndroidLintSwitchIntDefInspection.$$$reportNull$$$0(0);
        }
        if (endElement == null) {
            AndroidLintSwitchIntDefInspection.$$$reportNull$$$0(1);
        }
        if (message2 == null) {
            AndroidLintSwitchIntDefInspection.$$$reportNull$$$0(2);
        }
        if ((missingCases = (List)LintFix.getData((LintFix)fixData, List.class)) != null && !missingCases.isEmpty()) {
            LintIdeQuickFix[] lintIdeQuickFixArray = new LintIdeQuickFix[]{new LintIdeQuickFix(){

                public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
                    if (startElement == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (endElement == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (context == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    if (!FileModificationService.getInstance().preparePsiElementForWrite(startElement)) {
                        return;
                    }
                    if (startElement.getParent() instanceof PsiSwitchStatement) {
                        PsiSwitchStatement switchStatement = (PsiSwitchStatement)startElement.getParent();
                        Project project = switchStatement.getProject();
                        PsiElementFactory factory2 = JavaPsiFacade.getElementFactory((Project)project);
                        PsiCodeBlock body = switchStatement.getBody();
                        if (body == null) {
                            return;
                        }
                        PsiElement anchor = body.getLastChild();
                        for (String constant : missingCases) {
                            constant = TextFormat.RAW.convertTo(constant, TextFormat.TEXT);
                            PsiElement parent = anchor.getParent();
                            PsiStatement caseStatement = factory2.createStatementFromText("case " + constant + ":", anchor);
                            parent.addBefore((PsiElement)caseStatement, anchor);
                            PsiStatement breakStatement = factory2.createStatementFromText("break;", anchor);
                            parent.addBefore((PsiElement)breakStatement, anchor);
                        }
                        CodeStyleManager.getInstance((Project)project).reformat((PsiElement)switchStatement);
                    } else {
                        KtWhenExpression when = (KtWhenExpression)PsiTreeUtil.getParentOfType((PsiElement)startElement, KtWhenExpression.class, (boolean)false);
                        if (when != null) {
                            Project project = when.getProject();
                            KtPsiFactory factory3 = new KtPsiFactory(project);
                            PsiElement anchor = when.getCloseBrace();
                            for (String constant : missingCases) {
                                constant = TextFormat.RAW.convertTo(constant, TextFormat.TEXT);
                                KtWhenEntry caseStatement = factory3.createWhenEntry(constant + "-> { TODO() }");
                                when.addBefore((PsiElement)caseStatement, anchor);
                                ShortenReferences.DEFAULT.process((KtElement)when);
                            }
                        }
                    }
                }

                public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
                    if (startElement == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    if (endElement == null) {
                        1.$$$reportNull$$$0(4);
                    }
                    if (contextType == null) {
                        1.$$$reportNull$$$0(5);
                    }
                    return startElement.isValid();
                }

                @NotNull
                public String getName() {
                    return "Add Missing @IntDef Constants";
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "startElement";
                            break;
                        }
                        case 1: 
                        case 4: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "endElement";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "context";
                            break;
                        }
                        case 5: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "contextType";
                            break;
                        }
                    }
                    objectArray2[1] = "com/android/tools/idea/lint/AndroidLintSwitchIntDefInspection$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "apply";
                            break;
                        }
                        case 3: 
                        case 4: 
                        case 5: {
                            objectArray = objectArray2;
                            objectArray2[2] = "isApplicable";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }};
            if (lintIdeQuickFixArray == null) {
                AndroidLintSwitchIntDefInspection.$$$reportNull$$$0(3);
            }
            return lintIdeQuickFixArray;
        }
        LintIdeQuickFix[] lintIdeQuickFixArray = super.getQuickFixes(startElement, endElement, message2, fixData);
        if (lintIdeQuickFixArray == null) {
            AndroidLintSwitchIntDefInspection.$$$reportNull$$$0(4);
        }
        return lintIdeQuickFixArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/lint/AndroidLintSwitchIntDefInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/lint/AndroidLintSwitchIntDefInspection";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuickFixes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getQuickFixes";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

