/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint;

import com.android.sdklib.SdkVersionInfo;
import com.android.support.AndroidxName;
import com.android.tools.idea.kotlin.AndroidKtPsiUtilsKt;
import com.android.tools.idea.lint.AddTargetVersionCheckQuickFix;
import com.android.tools.idea.lint.common.AndroidQuickfixContexts;
import com.android.tools.idea.lint.common.LintIdeQuickFix;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.util.DependencyManagementUtil;
import com.android.tools.lint.checks.ApiDetector;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.AddAnnotationFix;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.idea.util.ModifierListModifactorKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtTypeParameter;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0010\u0010\b\u001a\f\u0012\u0006\b\u0001\u0012\u00020\n\u0018\u00010\t\u00a2\u0006\u0002\u0010\u000bJ \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0005H\u0002J\b\u0010\u0016\u001a\u00020\u0014H\u0016J\u0010\u0010\u0017\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0007H\u0002J\u0010\u0010\u0018\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0007H\u0002J\u0010\u0010\u0019\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0007H\u0002J \u0010\u001a\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\f\u0010\u001d\u001a\u00020\u0005*\u00020\u001eH\u0002J\f\u0010\u001f\u001a\u00020\u0005*\u00020\u0007H\u0002J\f\u0010 \u001a\u00020\u0005*\u00020\u0007H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\b\u001a\f\u0012\u0006\b\u0001\u0012\u00020\n\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/android/tools/idea/lint/AddTargetApiQuickFix;", "Lcom/android/tools/idea/lint/common/LintIdeQuickFix;", "api", "", "requiresApi", "", "element", "Lcom/intellij/psi/PsiElement;", "filter", "Ljava/lang/Class;", "Lcom/intellij/psi/PsiModifierListOwner;", "(IZLcom/intellij/psi/PsiElement;Ljava/lang/Class;)V", "apply", "", "startElement", "endElement", "context", "Lcom/android/tools/idea/lint/common/AndroidQuickfixContexts$Context;", "getAnnotationContainer", "getAnnotationValue", "", "fullyQualified", "getName", "handleJava", "handleKotlin", "handleXml", "isApplicable", "contextType", "Lcom/android/tools/idea/lint/common/AndroidQuickfixContexts$ContextType;", "isNewLineNeededForAnnotation", "Lorg/jetbrains/kotlin/psi/KtElement;", "isRequiresApiAnnotationValidTarget", "isTargetApiAnnotationValidTarget", "intellij.android.core"})
public final class AddTargetApiQuickFix
implements LintIdeQuickFix {
    private final int api;
    private final boolean requiresApi;
    private final PsiElement element;
    private final Class<? extends PsiModifierListOwner> filter;

    private final String getAnnotationValue(boolean fullyQualified) {
        return AddTargetVersionCheckQuickFix.Companion.getVersionField(this.api, fullyQualified);
    }

    @NotNull
    public String getName() {
        String string;
        if (Intrinsics.areEqual((Object)this.element.getLanguage(), (Object)XMLLanguage.INSTANCE)) {
            string = "Suppress with tools:targetApi attribute";
        } else if (this.requiresApi) {
            String string2 = AndroidBundle.message("android.lint.fix.add.requires.api", this.getAnnotationValue(false));
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"AndroidBundle.message(\"a\u2026etAnnotationValue(false))");
        } else {
            String string3 = AndroidBundle.message("android.lint.fix.add.target.api", this.getAnnotationValue(false));
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"AndroidBundle.message(\"a\u2026etAnnotationValue(false))");
        }
        return string;
    }

    public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
        Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
        Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
        Intrinsics.checkNotNullParameter((Object)contextType, (String)"contextType");
        return this.getAnnotationContainer(startElement) != null;
    }

    public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
        block1: {
            Language language;
            block2: {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
                    Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
                    Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                    language = startElement.getLanguage();
                    if (!Intrinsics.areEqual((Object)language, (Object)JavaLanguage.INSTANCE)) break block0;
                    this.handleJava(startElement);
                    break block1;
                }
                if (!Intrinsics.areEqual((Object)language, (Object)KotlinLanguage.INSTANCE)) break block2;
                this.handleKotlin(startElement);
                break block1;
            }
            if (!Intrinsics.areEqual((Object)language, (Object)XMLLanguage.INSTANCE)) break block1;
            this.handleXml(startElement);
        }
    }

    private final void handleXml(PsiElement startElement) {
        block6: {
            String string;
            XmlTag element2;
            block8: {
                block7: {
                    PsiElement psiElement = this.getAnnotationContainer(startElement);
                    if (!(psiElement instanceof XmlTag)) {
                        psiElement = null;
                    }
                    XmlTag xmlTag = (XmlTag)psiElement;
                    if (xmlTag == null) {
                        return;
                    }
                    element2 = xmlTag;
                    XmlFile file2 = (XmlFile)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)element2), XmlFile.class, (boolean)false);
                    if (file2 == null) break block6;
                    IdeResourcesUtil.ensureNamespaceImported$default(file2, "http://schemas.android.com/tools", null, 4, null);
                    string = SdkVersionInfo.getBuildCode((int)this.api);
                    if (string == null) break block7;
                    String string2 = string;
                    Locale locale = Locale.US;
                    Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"Locale.US");
                    Locale locale2 = locale;
                    boolean bl = false;
                    String string3 = string2;
                    boolean bl2 = false;
                    String string4 = string3;
                    if (string4 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string5 = string4.toLowerCase(locale2);
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).toLowerCase(locale)");
                    string = string5;
                    if (string5 != null) break block8;
                }
                string = String.valueOf(this.api);
            }
            String codeName = string;
            element2.setAttribute("targetApi", "http://schemas.android.com/tools", codeName);
        }
    }

    private final void handleJava(PsiElement startElement) {
        PsiElement psiElement = this.getAnnotationContainer(startElement);
        if (!(psiElement instanceof PsiModifierListOwner)) {
            psiElement = null;
        }
        PsiModifierListOwner psiModifierListOwner = (PsiModifierListOwner)psiElement;
        if (psiModifierListOwner == null) {
            return;
        }
        PsiModifierListOwner container = psiModifierListOwner;
        PsiModifierList modifierList = container.getModifierList();
        if (modifierList != null) {
            Project project = startElement.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"startElement.project");
            Project project2 = project;
            JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)project2);
            Intrinsics.checkNotNullExpressionValue((Object)javaPsiFacade, (String)"JavaPsiFacade.getInstance(project)");
            PsiElementFactory psiElementFactory = javaPsiFacade.getElementFactory();
            Intrinsics.checkNotNullExpressionValue((Object)psiElementFactory, (String)"JavaPsiFacade.getInstance(project).elementFactory");
            PsiElementFactory elementFactory = psiElementFactory;
            String fqcn = null;
            String annotationText = null;
            if (this.requiresApi) {
                Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)startElement);
                AndroidxName androidxName = ApiDetector.REQUIRES_API_ANNOTATION;
                Intrinsics.checkNotNullExpressionValue((Object)androidxName, (String)"REQUIRES_API_ANNOTATION");
                fqcn = DependencyManagementUtil.mapAndroidxName(module2, androidxName);
                annotationText = "@" + fqcn + "(api=" + this.getAnnotationValue(true) + ")";
            } else {
                fqcn = "android.annotation.TargetApi";
                annotationText = "@" + fqcn + "(" + this.getAnnotationValue(true) + ")";
            }
            PsiAnnotation psiAnnotation = elementFactory.createAnnotationFromText(annotationText, (PsiElement)container);
            Intrinsics.checkNotNullExpressionValue((Object)psiAnnotation, (String)"elementFactory.createAnn\u2026nnotationText, container)");
            PsiAnnotation newAnnotation = psiAnnotation;
            PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)container, (String[])new String[]{"android.annotation.TargetApi"});
            if (annotation != null && annotation.isPhysical()) {
                annotation.replace((PsiElement)newAnnotation);
            } else {
                PsiAnnotationParameterList psiAnnotationParameterList = newAnnotation.getParameterList();
                Intrinsics.checkNotNullExpressionValue((Object)psiAnnotationParameterList, (String)"newAnnotation.parameterList");
                PsiNameValuePair[] attributes = psiAnnotationParameterList.getAttributes();
                AddAnnotationFix fix = new AddAnnotationFix(fqcn, container, attributes, new String[0]);
                fix.invoke(project2, null, container.getContainingFile());
            }
        }
    }

    private final void handleKotlin(PsiElement startElement) {
        PsiElement psiElement = this.getAnnotationContainer(startElement);
        if (psiElement == null) {
            return;
        }
        PsiElement annotationContainer = psiElement;
        if (!FileModificationService.getInstance().preparePsiElementForWrite(annotationContainer)) {
            return;
        }
        if (annotationContainer instanceof KtModifierListOwner) {
            FqName fqName;
            KtModifierListOwner ktModifierListOwner = (KtModifierListOwner)annotationContainer;
            if (this.requiresApi) {
                Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)startElement);
                AndroidxName androidxName = ApiDetector.REQUIRES_API_ANNOTATION;
                Intrinsics.checkNotNullExpressionValue((Object)androidxName, (String)"REQUIRES_API_ANNOTATION");
                fqName = new FqName(DependencyManagementUtil.mapAndroidxName(module2, androidxName));
            } else {
                fqName = new FqName("android.annotation.TargetApi");
            }
            ModifierListModifactorKt.addAnnotation$default((KtModifierListOwner)ktModifierListOwner, (FqName)fqName, (String)this.getAnnotationValue(true), (String)(this.isNewLineNeededForAnnotation((KtElement)annotationContainer) ? "\n" : " "), null, (int)8, null);
        }
    }

    private final boolean isNewLineNeededForAnnotation(KtElement $this$isNewLineNeededForAnnotation) {
        return !($this$isNewLineNeededForAnnotation instanceof KtParameter) && !($this$isNewLineNeededForAnnotation instanceof KtTypeParameter) && !($this$isNewLineNeededForAnnotation instanceof KtPropertyAccessor);
    }

    private final PsiElement getAnnotationContainer(PsiElement element2) {
        Object object;
        Language language = element2.getLanguage();
        if (Intrinsics.areEqual((Object)language, (Object)JavaLanguage.INSTANCE)) {
            PsiModifierListOwner container = null;
            container = this.filter != null ? (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)element2, (Class[])new Class[]{this.filter}) : (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)element2, (Class[])new Class[]{PsiMethod.class, PsiClass.class});
            while (container != null && container instanceof PsiAnonymousClass) {
                container = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)container), PsiMethod.class, (boolean)true, (Class[])new Class[]{PsiClass.class});
            }
            object = (PsiElement)container;
        } else {
            object = Intrinsics.areEqual((Object)language, (Object)XMLLanguage.INSTANCE) ? PsiTreeUtil.getParentOfType((PsiElement)element2, XmlTag.class, (boolean)false) : (Intrinsics.areEqual((Object)language, (Object)KotlinLanguage.INSTANCE) ? PsiTreeUtil.findFirstParent((PsiElement)element2, (Condition)new Condition(this){
                final /* synthetic */ AddTargetApiQuickFix this$0;

                public final boolean value(PsiElement it) {
                    boolean bl;
                    if (AddTargetApiQuickFix.access$getRequiresApi$p(this.this$0)) {
                        PsiElement psiElement = it;
                        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"it");
                        bl = AddTargetApiQuickFix.access$isRequiresApiAnnotationValidTarget(this.this$0, psiElement);
                    } else {
                        PsiElement psiElement = it;
                        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"it");
                        bl = AddTargetApiQuickFix.access$isTargetApiAnnotationValidTarget(this.this$0, psiElement);
                    }
                    return bl;
                }
                {
                    this.this$0 = addTargetApiQuickFix;
                }
            }) : null);
        }
        return object;
    }

    private final boolean isRequiresApiAnnotationValidTarget(PsiElement $this$isRequiresApiAnnotationValidTarget) {
        return $this$isRequiresApiAnnotationValidTarget instanceof KtClassOrObject || $this$isRequiresApiAnnotationValidTarget instanceof KtFunction && !($this$isRequiresApiAnnotationValidTarget instanceof KtFunctionLiteral) || $this$isRequiresApiAnnotationValidTarget instanceof KtProperty && !((KtProperty)$this$isRequiresApiAnnotationValidTarget).isLocal() && AndroidKtPsiUtilsKt.hasBackingField((KtProperty)((KtProperty)$this$isRequiresApiAnnotationValidTarget)) || $this$isRequiresApiAnnotationValidTarget instanceof KtPropertyAccessor;
    }

    private final boolean isTargetApiAnnotationValidTarget(PsiElement $this$isTargetApiAnnotationValidTarget) {
        return $this$isTargetApiAnnotationValidTarget instanceof KtClassOrObject || $this$isTargetApiAnnotationValidTarget instanceof KtFunction && !($this$isTargetApiAnnotationValidTarget instanceof KtFunctionLiteral) || $this$isTargetApiAnnotationValidTarget instanceof KtPropertyAccessor;
    }

    public AddTargetApiQuickFix(int api, boolean requiresApi, @NotNull PsiElement element2, @Nullable Class<? extends PsiModifierListOwner> filter2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        this.api = api;
        this.requiresApi = requiresApi;
        this.element = element2;
        this.filter = filter2;
    }

    public static final /* synthetic */ boolean access$getRequiresApi$p(AddTargetApiQuickFix $this) {
        return $this.requiresApi;
    }

    public static final /* synthetic */ boolean access$isRequiresApiAnnotationValidTarget(AddTargetApiQuickFix $this, PsiElement $this$access_u24isRequiresApiAnnotationValidTarget) {
        return $this.isRequiresApiAnnotationValidTarget($this$access_u24isRequiresApiAnnotationValidTarget);
    }

    public static final /* synthetic */ boolean access$isTargetApiAnnotationValidTarget(AddTargetApiQuickFix $this, PsiElement $this$access_u24isTargetApiAnnotationValidTarget) {
        return $this.isTargetApiAnnotationValidTarget($this$access_u24isTargetApiAnnotationValidTarget);
    }
}

