/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.layoutinspector.ui;

import com.android.tools.adtui.common.AdtPrimaryPanel;
import com.android.tools.idea.layoutinspector.common.ViewContextMenuFactoryKt;
import com.android.tools.idea.layoutinspector.model.DrawViewNode;
import com.android.tools.idea.layoutinspector.model.InspectorModel;
import com.android.tools.idea.layoutinspector.model.ViewNode;
import com.android.tools.idea.layoutinspector.ui.DeviceViewPanelModel;
import com.android.tools.idea.layoutinspector.ui.DeviceViewSettings;
import com.android.tools.idea.layoutinspector.ui.ViewDrawInfo;
import com.intellij.ui.PopupHandler;
import com.intellij.util.ui.JBUI;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.AffineTransform;
import java.util.Map;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0018\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001f2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u001e\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020$H\u0002J\u001a\u0010&\u001a\u0004\u0018\u00010\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020$H\u0002J\b\u0010'\u001a\u00020(H\u0016J\u0012\u0010)\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001fH\u0016R*\u0010\u0007\u001a\u001e\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t\u0012\f\u0012\n \n*\u0004\u0018\u00010\u000b0\u000b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006*"}, d2={"Lcom/android/tools/idea/layoutinspector/ui/DeviceViewContentPanel;", "Lcom/android/tools/adtui/common/AdtPrimaryPanel;", "inspectorModel", "Lcom/android/tools/idea/layoutinspector/model/InspectorModel;", "viewSettings", "Lcom/android/tools/idea/layoutinspector/ui/DeviceViewSettings;", "(Lcom/android/tools/idea/layoutinspector/model/InspectorModel;Lcom/android/tools/idea/layoutinspector/ui/DeviceViewSettings;)V", "HQ_RENDERING_HINTS", "", "Ljava/awt/RenderingHints$Key;", "kotlin.jvm.PlatformType", "", "getInspectorModel", "()Lcom/android/tools/idea/layoutinspector/model/InspectorModel;", "model", "Lcom/android/tools/idea/layoutinspector/ui/DeviceViewPanelModel;", "getModel", "()Lcom/android/tools/idea/layoutinspector/ui/DeviceViewPanelModel;", "rootLocation", "Ljava/awt/Point;", "getRootLocation", "()Ljava/awt/Point;", "getViewSettings", "()Lcom/android/tools/idea/layoutinspector/ui/DeviceViewSettings;", "drawBorders", "", "g", "Ljava/awt/Graphics2D;", "drawInfo", "Lcom/android/tools/idea/layoutinspector/ui/ViewDrawInfo;", "drawImages", "Ljava/awt/Graphics;", "findComponentsAt", "Lkotlin/sequences/Sequence;", "Lcom/android/tools/idea/layoutinspector/model/ViewNode;", "x", "", "y", "findTopViewAt", "getPreferredSize", "Ljava/awt/Dimension;", "paint", "intellij.android.layout-inspector"})
public final class DeviceViewContentPanel
extends AdtPrimaryPanel {
    @NotNull
    private final DeviceViewPanelModel model;
    private final Map<RenderingHints.Key, Object> HQ_RENDERING_HINTS;
    @NotNull
    private final InspectorModel inspectorModel;
    @NotNull
    private final DeviceViewSettings viewSettings;

    @NotNull
    public final DeviceViewPanelModel getModel() {
        return this.model;
    }

    @NotNull
    public final Point getRootLocation() {
        Object object = (ViewDrawInfo)CollectionsKt.firstOrNull(this.model.getHitRects());
        if (object == null || (object = ((ViewDrawInfo)object).getBounds()) == null || (object = object.getBounds()) == null || (object = ((Rectangle)object).getLocation()) == null) {
            object = new Point(0, 0);
        }
        Object modelLocation = object;
        return new Point((int)((double)((Point)modelLocation).x * this.viewSettings.getScaleFraction()) + this.getSize().width / 2, (int)((double)((Point)modelLocation).y * this.viewSettings.getScaleFraction()) + this.getSize().height / 2);
    }

    private final Sequence<ViewNode> findComponentsAt(int x, int y) {
        return this.model.findViewsAt(((double)x - (double)this.getSize().width / 2.0) / this.viewSettings.getScaleFraction(), ((double)y - (double)this.getSize().height / 2.0) / this.viewSettings.getScaleFraction());
    }

    private final ViewNode findTopViewAt(int x, int y) {
        return this.model.findTopViewAt(((double)x - (double)this.getSize().width / 2.0) / this.viewSettings.getScaleFraction(), ((double)y - (double)this.getSize().height / 2.0) / this.viewSettings.getScaleFraction());
    }

    public void paint(@Nullable Graphics g) {
        ViewDrawInfo it;
        Graphics graphics = g;
        if (!(graphics instanceof Graphics2D)) {
            graphics = null;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (graphics2D == null) {
            return;
        }
        Graphics2D g2d = graphics2D;
        g2d.setColor(this.getBackground());
        g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
        g2d.setRenderingHints(this.HQ_RENDERING_HINTS);
        g2d.translate((double)this.getSize().width / 2.0, (double)this.getSize().height / 2.0);
        g2d.scale(this.viewSettings.getScaleFraction(), this.viewSettings.getScaleFraction());
        Iterable $this$forEach$iv = this.model.getHitRects();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (ViewDrawInfo)element$iv;
            boolean bl = false;
            this.drawImages(g2d, it);
        }
        $this$forEach$iv = this.model.getHitRects();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (ViewDrawInfo)element$iv;
            boolean bl = false;
            this.drawBorders(g2d, it);
        }
        if (this.model.getOverlay() != null) {
            g2d.setComposite(AlphaComposite.SrcOver.derive(this.model.getOverlayAlpha()));
            Rectangle bounds2 = this.model.getHitRects().get(0).getBounds().getBounds();
            g2d.drawImage(this.model.getOverlay(), bounds2.x, bounds2.y, bounds2.width, bounds2.height, null);
        }
    }

    @NotNull
    public Dimension getPreferredSize() {
        return this.inspectorModel.isEmpty() ? new Dimension(0, 0) : new Dimension((int)((double)this.model.getMaxWidth$intellij_android_layout_inspector() * this.viewSettings.getScaleFraction() + (double)JBUI.scale((int)50)) * 2, (int)((double)this.model.getMaxHeight$intellij_android_layout_inspector() * this.viewSettings.getScaleFraction() + (double)JBUI.scale((int)50)) * 2);
    }

    /*
     * WARNING - void declaration
     */
    private final void drawBorders(Graphics2D g, ViewDrawInfo drawInfo) {
        ViewNode hoveredNode = this.inspectorModel.getHoveredNode();
        DrawViewNode drawView = drawInfo.getNode();
        ViewNode view = drawView.getOwner();
        ViewNode selection = this.inspectorModel.getSelection();
        if (!drawInfo.isCollapsed() && (this.viewSettings.getDrawBorders() || this.viewSettings.getDrawUntransformedBounds() || Intrinsics.areEqual((Object)view, (Object)selection) || Intrinsics.areEqual((Object)view, (Object)hoveredNode))) {
            void $this$apply;
            Graphics graphics = g.create();
            if (graphics == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.awt.Graphics2D");
            }
            Graphics2D g2 = (Graphics2D)graphics;
            AffineTransform affineTransform = g2.getTransform();
            boolean bl = false;
            boolean bl2 = false;
            AffineTransform affineTransform2 = affineTransform;
            Graphics2D graphics2D = g2;
            boolean bl3 = false;
            $this$apply.concatenate(drawInfo.getTransform());
            Unit unit = Unit.INSTANCE;
            graphics2D.setTransform(affineTransform);
            drawView.paintBorder(g2, Intrinsics.areEqual((Object)view, (Object)selection), Intrinsics.areEqual((Object)view, (Object)hoveredNode), this.viewSettings);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void drawImages(Graphics g, ViewDrawInfo drawInfo) {
        void $this$apply;
        Graphics graphics = g.create();
        if (graphics == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.awt.Graphics2D");
        }
        Graphics2D g2 = (Graphics2D)graphics;
        g2.setRenderingHints(this.HQ_RENDERING_HINTS);
        AffineTransform affineTransform = g2.getTransform();
        boolean bl = false;
        boolean bl2 = false;
        AffineTransform affineTransform2 = affineTransform;
        Graphics2D graphics2D = g2;
        boolean bl3 = false;
        $this$apply.concatenate(drawInfo.getTransform());
        Unit unit = Unit.INSTANCE;
        graphics2D.setTransform(affineTransform);
        drawInfo.getNode().paint(g2, this.inspectorModel);
    }

    @NotNull
    public final InspectorModel getInspectorModel() {
        return this.inspectorModel;
    }

    @NotNull
    public final DeviceViewSettings getViewSettings() {
        return this.viewSettings;
    }

    public DeviceViewContentPanel(@NotNull InspectorModel inspectorModel, @NotNull DeviceViewSettings viewSettings) {
        Intrinsics.checkNotNullParameter((Object)inspectorModel, (String)"inspectorModel");
        Intrinsics.checkNotNullParameter((Object)viewSettings, (String)"viewSettings");
        super(null, 1, null);
        this.inspectorModel = inspectorModel;
        this.viewSettings = viewSettings;
        this.model = new DeviceViewPanelModel(this.inspectorModel);
        this.HQ_RENDERING_HINTS = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)RenderingHints.KEY_ANTIALIASING, (Object)RenderingHints.VALUE_ANTIALIAS_ON), TuplesKt.to((Object)RenderingHints.KEY_RENDERING, (Object)RenderingHints.VALUE_RENDER_QUALITY), TuplesKt.to((Object)RenderingHints.KEY_INTERPOLATION, (Object)RenderingHints.VALUE_INTERPOLATION_BILINEAR), TuplesKt.to((Object)RenderingHints.KEY_STROKE_CONTROL, (Object)RenderingHints.VALUE_STROKE_PURE)});
        this.inspectorModel.getSelectionListeners().add(new Function2<ViewNode, ViewNode, Unit>(){

            public final void invoke(@Nullable ViewNode $noName_0, @Nullable ViewNode $noName_1) {
                this.repaint();
            }
        });
        this.inspectorModel.getHoverListeners().add(new Function2<ViewNode, ViewNode, Unit>(){

            public final void invoke(@Nullable ViewNode $noName_0, @Nullable ViewNode $noName_1) {
                this.repaint();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(@Nullable ComponentEvent e) {
                this.repaint();
            }
        });
        MouseAdapter listener2 = new MouseAdapter(this){
            private int x;
            private int y;
            final /* synthetic */ DeviceViewContentPanel this$0;

            public void mousePressed(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (e.isConsumed()) {
                    return;
                }
                this.x = e.getX();
                this.y = e.getY();
            }

            public void mouseDragged(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (e.isConsumed()) {
                    return;
                }
                if (!this.this$0.getModel().getRotatable()) {
                    return;
                }
                double xRotation = (double)(e.getX() - this.x) * 0.001;
                double yRotation = (double)(e.getY() - this.y) * 0.001;
                this.x = e.getX();
                this.y = e.getY();
                if (xRotation != 0.0 || yRotation != 0.0) {
                    this.this$0.getModel().rotate(xRotation, yRotation);
                }
                this.this$0.repaint();
            }

            private final ViewNode nodeAtPoint(MouseEvent e) {
                return this.this$0.getModel().findTopViewAt(((double)e.getX() - (double)this.this$0.getSize().width / 2.0) / this.this$0.getViewSettings().getScaleFraction(), ((double)e.getY() - (double)this.this$0.getSize().height / 2.0) / this.this$0.getViewSettings().getScaleFraction());
            }

            public void mouseClicked(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (e.isConsumed()) {
                    return;
                }
                this.this$0.getInspectorModel().setSelection(this.nodeAtPoint(e));
                this.this$0.getInspectorModel().getStats().selectionMadeFromImage();
            }

            public void mouseMoved(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (e.isConsumed()) {
                    return;
                }
                this.this$0.getInspectorModel().setHoveredNode(DeviceViewContentPanel.access$findTopViewAt(this.this$0, e.getX(), e.getY()));
            }
            {
                this.this$0 = this$0;
            }
        };
        this.addMouseListener(listener2);
        this.addMouseMotionListener(listener2);
        this.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(@NotNull Component comp, int x, int y) {
                Intrinsics.checkNotNullParameter((Object)comp, (String)"comp");
                ViewContextMenuFactoryKt.showViewContextMenu(SequencesKt.toList((Sequence)this.findComponentsAt(x, y)), this.getInspectorModel(), (JComponent)((Object)this), x, y);
            }
        });
        this.viewSettings.getModificationListeners().add(new Function0<Unit>(){

            public final void invoke() {
                this.repaint();
            }
        });
        this.model.getModificationListeners().add(new Function0<Unit>(){

            public final void invoke() {
                this.revalidate();
                this.repaint();
            }
        });
    }

    public static final /* synthetic */ ViewNode access$findTopViewAt(DeviceViewContentPanel $this, int x, int y) {
        return $this.findTopViewAt(x, y);
    }
}

