/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.layoutinspector.tree;

import com.android.tools.idea.layoutinspector.LayoutInspector;
import com.android.tools.idea.layoutinspector.LayoutInspectorToolWindowFactoryKt;
import com.android.tools.idea.layoutinspector.model.ComposeViewNode;
import com.android.tools.idea.layoutinspector.model.InspectorModel;
import com.android.tools.idea.layoutinspector.model.ViewNode;
import com.android.tools.idea.layoutinspector.resource.ResourceLookup;
import com.android.tools.idea.layoutinspector.resource.SourceLocation;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\"\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u0019"}, d2={"Lcom/android/tools/idea/layoutinspector/tree/GotoDeclarationAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "()V", "actionPerformed", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "findKotlinFile", "Lcom/intellij/psi/PsiFile;", "project", "Lcom/intellij/openapi/project/Project;", "fileName", "", "packageHash", "", "findNavigatable", "Lcom/intellij/pom/Navigatable;", "model", "Lcom/android/tools/idea/layoutinspector/model/InspectorModel;", "findNavigatableFromComposable", "node", "Lcom/android/tools/idea/layoutinspector/model/ComposeViewNode;", "packageNameHashMatch", "", "file", "intellij.android.layout-inspector"})
public final class GotoDeclarationAction
extends AnAction {
    @NotNull
    public static final GotoDeclarationAction INSTANCE;

    public void actionPerformed(@NotNull AnActionEvent event) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Navigatable navigatable = this.findNavigatable(event);
            if (navigatable == null) break block0;
            navigatable.navigate(true);
        }
    }

    private final Navigatable findNavigatable(AnActionEvent event) {
        Navigatable navigatable;
        InspectorModel inspectorModel = this.model(event);
        if (inspectorModel != null) {
            InspectorModel inspectorModel2 = inspectorModel;
            boolean bl = false;
            boolean bl2 = false;
            InspectorModel it = inspectorModel2;
            boolean bl3 = false;
            navigatable = INSTANCE.findNavigatable(it);
        } else {
            navigatable = null;
        }
        return navigatable;
    }

    @Nullable
    public final Navigatable findNavigatable(@NotNull InspectorModel model2) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        ResourceLookup resourceLookup = model2.getResourceLookup();
        ViewNode viewNode = model2.getSelection();
        if (viewNode == null) {
            return null;
        }
        ViewNode node2 = viewNode;
        if (node2 instanceof ComposeViewNode) {
            return this.findNavigatableFromComposable(model2, (ComposeViewNode)node2);
        }
        SourceLocation sourceLocation2 = resourceLookup.findFileLocation(node2);
        return sourceLocation2 != null ? sourceLocation2.getNavigatable() : null;
    }

    private final Navigatable findNavigatableFromComposable(InspectorModel model2, ComposeViewNode node2) {
        Project project = model2.getProject();
        PsiFile psiFile2 = this.findKotlinFile(project, node2.getComposeFilename(), node2.getComposePackageHash());
        if (psiFile2 == null) {
            return null;
        }
        PsiFile ktFile = psiFile2;
        VirtualFile virtualFile = ktFile.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        VirtualFile vFile = virtualFile;
        return PsiNavigationSupport.getInstance().createNavigatable(project, vFile, node2.getComposeOffset());
    }

    private final PsiFile findKotlinFile(Project project, String fileName, int packageHash) {
        Object v2;
        block2: {
            Object[] objectArray = FilenameIndex.getFilesByName((Project)project, (String)fileName, (GlobalSearchScope)GlobalSearchScope.allScope((Project)project));
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"FilenameIndex.getFilesBy\u2026hScope.allScope(project))");
            Object[] files2 = objectArray;
            if (files2.length == 1) {
                return files2[0];
            }
            Sequence $this$firstOrNull$iv = ArraysKt.asSequence((Object[])files2);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PsiFile it = (PsiFile)element$iv;
                boolean bl = false;
                PsiFile psiFile2 = it;
                Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"it");
                if (!INSTANCE.packageNameHashMatch(psiFile2, packageHash)) continue;
                v2 = element$iv;
                break block2;
            }
            v2 = null;
        }
        return v2;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean packageNameHashMatch(PsiFile file2, int packageHash) {
        void $this$fold$iv;
        String packageName;
        PsiFile psiFile2 = file2;
        if (!(psiFile2 instanceof PsiClassOwner)) {
            psiFile2 = null;
        }
        PsiClassOwner psiClassOwner = (PsiClassOwner)psiFile2;
        if (psiClassOwner == null) {
            return false;
        }
        PsiClassOwner classOwner = psiClassOwner;
        String string = packageName = classOwner.getPackageName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"packageName");
        CharSequence charSequence = string;
        int initial$iv = 0;
        boolean $i$f$fold = false;
        int accumulator$iv = initial$iv;
        void var10_10 = $this$fold$iv;
        for (int j = 0; j < var10_10.length(); ++j) {
            void char_;
            char element$iv;
            char c = element$iv = var10_10.charAt(j);
            int hash2 = accumulator$iv;
            boolean bl = false;
            accumulator$iv = hash2 * 31 + char_;
        }
        int n = accumulator$iv;
        boolean bl = false;
        int hash3 = Math.abs(n);
        return hash3 == packageHash;
    }

    private final InspectorModel model(AnActionEvent event) {
        LayoutInspector layoutInspector = (LayoutInspector)event.getData(LayoutInspectorToolWindowFactoryKt.getLAYOUT_INSPECTOR_DATA_KEY());
        return layoutInspector != null ? layoutInspector.getLayoutInspectorModel() : null;
    }

    private GotoDeclarationAction() {
        super("Go to Declaration");
    }

    static {
        GotoDeclarationAction gotoDeclarationAction;
        INSTANCE = gotoDeclarationAction = new GotoDeclarationAction();
    }
}

