/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.layoutinspector.transport;

import com.android.ide.common.rendering.api.ResourceReference;
import com.android.tools.idea.layoutinspector.common.StringTableImpl;
import com.android.tools.idea.layoutinspector.model.ComposeViewNode;
import com.android.tools.idea.layoutinspector.model.InspectorModel;
import com.android.tools.idea.layoutinspector.model.ViewNode;
import com.android.tools.idea.layoutinspector.properties.InspectorGroupPropertyItem;
import com.android.tools.idea.layoutinspector.properties.InspectorPropertyItem;
import com.android.tools.idea.layoutinspector.properties.PropertiesProvider;
import com.android.tools.idea.layoutinspector.properties.PropertiesProviderKt;
import com.android.tools.idea.layoutinspector.properties.PropertySection;
import com.android.tools.idea.layoutinspector.properties.ViewNodeAndResourceLookup;
import com.android.tools.idea.layoutinspector.resource.SourceLocation;
import com.android.tools.idea.layoutinspector.transport.DefaultPropertiesProvider$Generator$WhenMappings;
import com.android.tools.idea.layoutinspector.transport.DefaultPropertiesProviderKt;
import com.android.tools.idea.layoutinspector.transport.InspectorClient;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.layoutinspector.proto.LayoutInspectorProto;
import com.android.tools.profiler.proto.Common;
import com.android.tools.property.panel.api.PropertiesTable;
import com.android.tools.property.panel.api.PropertyItem;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.util.ThrowableRunnable;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002()B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\nH\u0002J\u001a\u0010\u001a\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J(\u0010\u001e\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00112\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 H\u0002J\u0018\u0010\"\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\nH\u0002J\u0010\u0010#\u001a\u00020\u00142\u0006\u0010$\u001a\u00020%H\u0002J\u0014\u0010&\u001a\u0006\u0012\u0002\b\u00030'2\u0006\u0010\u0018\u001a\u00020\u0011H\u0016R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R8\u0010\u000e\u001a&\u0012\"\u0012 \u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u0012\u0012\u0004\u0012\u00020\u00140\u00100\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006*"}, d2={"Lcom/android/tools/idea/layoutinspector/transport/DefaultPropertiesProvider;", "Lcom/android/tools/idea/layoutinspector/properties/PropertiesProvider;", "client", "Lcom/android/tools/idea/layoutinspector/transport/InspectorClient;", "model", "Lcom/android/tools/idea/layoutinspector/model/InspectorModel;", "(Lcom/android/tools/idea/layoutinspector/transport/InspectorClient;Lcom/android/tools/idea/layoutinspector/model/InspectorModel;)V", "cache", "", "", "Lcom/android/tools/idea/layoutinspector/transport/DefaultPropertiesProvider$PropertiesData;", "lastGeneration", "", "lastRequestedViewId", "resultListeners", "", "Lkotlin/Function3;", "Lcom/android/tools/idea/layoutinspector/model/ViewNode;", "Lcom/android/tools/property/panel/api/PropertiesTable;", "Lcom/android/tools/idea/layoutinspector/properties/InspectorPropertyItem;", "", "getResultListeners", "()Ljava/util/List;", "completeProperties", "view", "propertiesData", "convertToItemWithClassLocation", "item", "className", "", "convertToResolutionStackItem", "resolutionStack", "", "Lcom/android/ide/common/rendering/api/ResourceReference;", "firePropertiesProvided", "loadProperties", "event", "", "requestProperties", "Ljava/util/concurrent/Future;", "Generator", "PropertiesData", "intellij.android.layout-inspector"})
public final class DefaultPropertiesProvider
implements PropertiesProvider {
    private long lastRequestedViewId;
    private int lastGeneration;
    private final Map<Long, PropertiesData> cache;
    @NotNull
    private final List<Function3<PropertiesProvider, ViewNode, PropertiesTable<InspectorPropertyItem>, Unit>> resultListeners;
    private final InspectorClient client;
    private final InspectorModel model;

    @Override
    @NotNull
    public List<Function3<PropertiesProvider, ViewNode, PropertiesTable<InspectorPropertyItem>, Unit>> getResultListeners() {
        return this.resultListeners;
    }

    @Override
    @NotNull
    public Future<?> requestProperties(@NotNull ViewNode view) {
        PropertiesData properties2;
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        if (!this.client.isConnected()) {
            this.lastRequestedViewId = -1L;
            this.firePropertiesProvided(view, DefaultPropertiesProviderKt.access$getEMPTY_PROPERTIES_DATA$p());
            ListenableFuture listenableFuture = Futures.immediateFuture(null);
            Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"Futures.immediateFuture(null)");
            return (Future)listenableFuture;
        }
        this.lastRequestedViewId = view.getDrawId();
        if (this.lastGeneration == this.model.getLastGeneration() && (properties2 = this.cache.get(view.getDrawId())) != null) {
            this.firePropertiesProvided(view, properties2);
            ListenableFuture listenableFuture = Futures.immediateFuture(null);
            Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"Futures.immediateFuture(null)");
            return (Future)listenableFuture;
        }
        if (!this.client.isCapturing()) {
            ListenableFuture listenableFuture = Futures.immediateFuture(null);
            Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"Futures.immediateFuture(null)");
            return (Future)listenableFuture;
        }
        LayoutInspectorProto.LayoutInspectorCommand inspectorCommand = LayoutInspectorProto.LayoutInspectorCommand.newBuilder().setType(LayoutInspectorProto.LayoutInspectorCommand.Type.GET_PROPERTIES).setViewId(view.getDrawId()).build();
        Future future2 = ApplicationManager.getApplication().executeOnPooledThread(new Runnable(this, inspectorCommand){
            final /* synthetic */ DefaultPropertiesProvider this$0;
            final /* synthetic */ LayoutInspectorProto.LayoutInspectorCommand $inspectorCommand;

            public final void run() {
                InspectorClient inspectorClient = DefaultPropertiesProvider.access$getClient$p(this.this$0);
                LayoutInspectorProto.LayoutInspectorCommand layoutInspectorCommand = this.$inspectorCommand;
                Intrinsics.checkNotNullExpressionValue((Object)layoutInspectorCommand, (String)"inspectorCommand");
                inspectorClient.execute(layoutInspectorCommand);
            }
            {
                this.this$0 = defaultPropertiesProvider;
                this.$inspectorCommand = layoutInspectorCommand;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)future2, (String)"ApplicationManager.getAp\u2026ecute(inspectorCommand) }");
        return future2;
    }

    private final void loadProperties(Object event) {
        Object object = event;
        if (!(object instanceof LayoutInspectorProto.LayoutInspectorEvent)) {
            object = null;
        }
        LayoutInspectorProto.LayoutInspectorEvent layoutInspectorEvent = (LayoutInspectorProto.LayoutInspectorEvent)object;
        if (layoutInspectorEvent == null) {
            return;
        }
        LayoutInspectorProto.LayoutInspectorEvent transportEvent = layoutInspectorEvent;
        if (!transportEvent.hasProperties()) {
            return;
        }
        LayoutInspectorProto.PropertyEvent propertyEvent = transportEvent.getProperties();
        Intrinsics.checkNotNullExpressionValue((Object)propertyEvent, (String)"transportEvent.properties");
        long viewId = propertyEvent.getViewId();
        LayoutInspectorProto.PropertyEvent propertyEvent2 = transportEvent.getProperties();
        Intrinsics.checkNotNullExpressionValue((Object)propertyEvent2, (String)"transportEvent.properties");
        int generation = propertyEvent2.getGeneration();
        if (generation < this.lastGeneration || generation < this.model.getLastGeneration()) {
            return;
        }
        LayoutInspectorProto.PropertyEvent propertyEvent3 = transportEvent.getProperties();
        Intrinsics.checkNotNullExpressionValue((Object)propertyEvent3, (String)"transportEvent.properties");
        Generator generator2 = new Generator(propertyEvent3, this.model);
        PropertiesData propertiesData = generator2.generate();
        if (generation > this.lastGeneration) {
            this.cache.clear();
            this.lastGeneration = generation;
        }
        this.cache.put(viewId, propertiesData);
        if (this.lastRequestedViewId == viewId && generation == this.model.getLastGeneration()) {
            ViewNode viewNode = this.model.get(viewId);
            if (viewNode == null) {
                return;
            }
            ViewNode view = viewNode;
            this.firePropertiesProvided(view, propertiesData);
        }
    }

    private final void firePropertiesProvided(ViewNode view, PropertiesData propertiesData) {
        PropertiesTable<InspectorPropertyItem> properties2 = this.completeProperties(view, propertiesData);
        Iterable $this$forEach$iv = this.getResultListeners();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Function3 it = (Function3)element$iv;
            boolean bl = false;
            it.invoke((Object)this, (Object)view, properties2);
        }
    }

    private final PropertiesTable<InspectorPropertyItem> completeProperties(ViewNode view, PropertiesData propertiesData) {
        PropertiesTable<InspectorPropertyItem> properties2;
        block6: {
            block5: {
                properties2 = propertiesData.getProperties();
                if (properties2.isEmpty()) break block5;
                Map<String, InspectorPropertyItem> map2 = properties2.getByNamespace("internal");
                boolean bl = false;
                if (!(!map2.isEmpty())) break block6;
            }
            return properties2;
        }
        if (!(view instanceof ComposeViewNode)) {
            Iterable $this$forEach$iv = properties2.getValues();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                InspectorPropertyItem it = (InspectorPropertyItem)element$iv;
                boolean bl = false;
                it.resolveDimensionType(view);
            }
        }
        PropertiesProviderKt.addInternalProperties(properties2, view, this.model);
        ReadAction.run((ThrowableRunnable)new ThrowableRunnable(this, propertiesData, properties2, view){
            final /* synthetic */ DefaultPropertiesProvider this$0;
            final /* synthetic */ PropertiesData $propertiesData;
            final /* synthetic */ PropertiesTable $properties;
            final /* synthetic */ ViewNode $view;

            public final void run() {
                boolean bl;
                InspectorPropertyItem it$iv$iv;
                boolean bl2;
                boolean bl3;
                InspectorPropertyItem inspectorPropertyItem;
                InspectorPropertyItem it;
                InspectorPropertyItem inspectorPropertyItem2;
                boolean bl4;
                boolean bl5;
                Table.Cell cell;
                boolean bl6;
                T element$iv$iv;
                T element$iv$iv$iv;
                Iterable $this$mapNotNullTo$iv$iv;
                Set set = this.$propertiesData.getClassNames().cellSet();
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"propertiesData.classNames.cellSet()");
                Iterable $this$mapNotNull$iv = set;
                boolean $i$f$mapNotNull = false;
                Iterable iterable = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$mapNotNullTo = false;
                Iterable $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator<T> iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    InspectorPropertyItem inspectorPropertyItem3;
                    element$iv$iv = element$iv$iv$iv = iterator.next();
                    bl6 = false;
                    cell = (Table.Cell)element$iv$iv;
                    boolean bl7 = false;
                    Table.Cell cell2 = cell;
                    Intrinsics.checkNotNullExpressionValue((Object)cell2, (String)"cell");
                    Object object = cell2.getRowKey();
                    Intrinsics.checkNotNull((Object)object);
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"cell.rowKey!!");
                    String string = (String)object;
                    Object object2 = cell.getColumnKey();
                    Intrinsics.checkNotNull((Object)object2);
                    Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"cell.columnKey!!");
                    if ((InspectorPropertyItem)this.$properties.getOrNull(string, (String)object2) != null) {
                        bl5 = false;
                        bl4 = false;
                        it = inspectorPropertyItem2;
                        boolean bl8 = false;
                        Object object3 = cell.getValue();
                        Intrinsics.checkNotNull((Object)object3);
                        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"cell.value!!");
                        inspectorPropertyItem3 = DefaultPropertiesProvider.access$convertToItemWithClassLocation(this.this$0, it, (String)object3);
                    } else {
                        inspectorPropertyItem3 = null;
                    }
                    if (inspectorPropertyItem3 == null) continue;
                    inspectorPropertyItem = inspectorPropertyItem3;
                    bl3 = false;
                    bl2 = false;
                    it$iv$iv = inspectorPropertyItem;
                    bl = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                Iterable $this$forEach$iv = (List)destination$iv$iv;
                boolean $i$f$forEach2 = false;
                for (Object element$iv : $this$forEach$iv) {
                    InspectorPropertyItem it2 = (InspectorPropertyItem)element$iv;
                    boolean bl9 = false;
                    this.$properties.put((PropertyItem)it2);
                }
                Set set2 = this.$propertiesData.getResolutionStacks().cellSet();
                Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"propertiesData.resolutionStacks.cellSet()");
                $this$mapNotNull$iv = set2;
                $i$f$mapNotNull = false;
                $this$mapNotNullTo$iv$iv = $this$mapNotNull$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$mapNotNullTo = false;
                $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                $i$f$forEach = false;
                iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    InspectorPropertyItem inspectorPropertyItem4;
                    element$iv$iv = element$iv$iv$iv = iterator.next();
                    bl6 = false;
                    cell = (Table.Cell)element$iv$iv;
                    boolean bl10 = false;
                    Table.Cell cell3 = cell;
                    Intrinsics.checkNotNullExpressionValue((Object)cell3, (String)"cell");
                    Object object = cell3.getRowKey();
                    Intrinsics.checkNotNull((Object)object);
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"cell.rowKey!!");
                    String string = (String)object;
                    Object object4 = cell.getColumnKey();
                    Intrinsics.checkNotNull((Object)object4);
                    Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"cell.columnKey!!");
                    if ((InspectorPropertyItem)this.$properties.getOrNull(string, (String)object4) != null) {
                        bl5 = false;
                        bl4 = false;
                        it = inspectorPropertyItem2;
                        boolean bl11 = false;
                        Object object5 = cell.getValue();
                        Intrinsics.checkNotNull((Object)object5);
                        Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"cell.value!!");
                        inspectorPropertyItem4 = DefaultPropertiesProvider.access$convertToResolutionStackItem(this.this$0, it, this.$view, (List)object5);
                    } else {
                        inspectorPropertyItem4 = null;
                    }
                    if (inspectorPropertyItem4 == null) continue;
                    inspectorPropertyItem = inspectorPropertyItem4;
                    bl3 = false;
                    bl2 = false;
                    it$iv$iv = inspectorPropertyItem;
                    bl = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                $this$forEach$iv = (List)destination$iv$iv;
                $i$f$forEach2 = false;
                for (Object element$iv : $this$forEach$iv) {
                    InspectorPropertyItem it3 = (InspectorPropertyItem)element$iv;
                    boolean bl12 = false;
                    this.$properties.put((PropertyItem)it3);
                }
            }
            {
                this.this$0 = defaultPropertiesProvider;
                this.$propertiesData = propertiesData;
                this.$properties = propertiesTable;
                this.$view = viewNode;
            }
        });
        return properties2;
    }

    private final InspectorPropertyItem convertToItemWithClassLocation(InspectorPropertyItem item, String className2) {
        SourceLocation sourceLocation2 = this.model.getResourceLookup().resolveClassNameAsSourceLocation(className2);
        if (sourceLocation2 == null) {
            return null;
        }
        SourceLocation classLocation = sourceLocation2;
        return new InspectorGroupPropertyItem(item.getNamespace(), item.getName(), item.getType(), item.getInitialValue(), classLocation, item.getGroup(), item.getSource(), item.getViewId(), item.getLookup(), CollectionsKt.emptyList());
    }

    /*
     * WARNING - void declaration
     */
    private final InspectorPropertyItem convertToResolutionStackItem(InspectorPropertyItem item, ViewNode view, List<ResourceReference> resolutionStack2) {
        InspectorPropertyItem inspectorPropertyItem;
        void $this$filterValues$iv;
        String it;
        Map $this$associateWith$iv;
        Iterable iterable = resolutionStack2;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)((Object)$this$associateWith$iv), (int)10)), (int)16));
        void $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object t : $this$associateWithTo$iv$iv) {
            ResourceReference resourceReference = (ResourceReference)t;
            Object t2 = t;
            Map map2 = result$iv;
            boolean bl = false;
            String string = this.model.getResourceLookup().findAttributeValue(item, view, (ResourceReference)it);
            map2.put(t2, string);
        }
        $this$associateWith$iv = result$iv;
        boolean $i$f$filterValues = false;
        result$iv = new LinkedHashMap();
        void var8_8 = $this$filterValues$iv;
        boolean bl = false;
        for (Map.Entry entry : var8_8.entrySet()) {
            it = (String)entry.getValue();
            boolean bl2 = false;
            if (!(it != null)) continue;
            result$iv.put(entry.getKey(), entry.getValue());
        }
        Map map3 = MapsKt.toMutableMap((Map)result$iv);
        ResourceReference firstRef = (ResourceReference)CollectionsKt.firstOrNull((Iterable)map3.keySet());
        if (firstRef != null && Intrinsics.areEqual((Object)firstRef, (Object)item.getSource())) {
            map3.remove(firstRef);
        }
        if (!((inspectorPropertyItem = item) instanceof InspectorGroupPropertyItem)) {
            inspectorPropertyItem = null;
        }
        InspectorGroupPropertyItem inspectorGroupPropertyItem = (InspectorGroupPropertyItem)inspectorPropertyItem;
        SourceLocation classLocation = inspectorGroupPropertyItem != null ? inspectorGroupPropertyItem.getClassLocation() : null;
        Map map4 = map3;
        boolean bl3 = false;
        if (!map4.isEmpty() || item.getSource() != null || classLocation != null) {
            return new InspectorGroupPropertyItem(item.getNamespace(), item.getName(), item.getType(), item.getInitialValue(), classLocation, item.getGroup(), item.getSource(), item.getViewId(), item.getLookup(), map3);
        }
        return null;
    }

    public DefaultPropertiesProvider(@NotNull InspectorClient client, @NotNull InspectorModel model2) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        this.client = client;
        this.model = model2;
        this.lastRequestedViewId = -1L;
        boolean bl = false;
        this.cache = new LinkedHashMap();
        this.client.register(Common.Event.EventGroupIds.PROPERTIES, (Function1<Object, Unit>)((Function1)new Function1<Object, Unit>(this){

            public final void invoke(@NotNull Object p1) {
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                ((DefaultPropertiesProvider)this.receiver).loadProperties(p1);
            }
        }));
        this.model.getConnectionListeners().add(new Function1<InspectorClient, Unit>(){

            public final void invoke(@Nullable InspectorClient it) {
                cache.clear();
                lastGeneration = 0;
            }
        });
        bl = false;
        this.resultListeners = new ArrayList();
    }

    public static final /* synthetic */ InspectorClient access$getClient$p(DefaultPropertiesProvider $this) {
        return $this.client;
    }

    public static final /* synthetic */ InspectorPropertyItem access$convertToItemWithClassLocation(DefaultPropertiesProvider $this, InspectorPropertyItem item, String className2) {
        return $this.convertToItemWithClassLocation(item, className2);
    }

    public static final /* synthetic */ InspectorPropertyItem access$convertToResolutionStackItem(DefaultPropertiesProvider $this, InspectorPropertyItem item, ViewNode view, List resolutionStack2) {
        return $this.convertToResolutionStackItem(item, view, resolutionStack2);
    }

    public static final /* synthetic */ int access$getLastGeneration$p(DefaultPropertiesProvider $this) {
        return $this.lastGeneration;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u000eH\u0002J\u0010\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0017\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002\u00a2\u0006\u0002\u0010 J\u0017\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002\u00a2\u0006\u0002\u0010#J\u0012\u0010$\u001a\u0004\u0018\u00010\t2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0017\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002\u00a2\u0006\u0002\u0010'J\u0010\u0010(\u001a\u00020\t2\u0006\u0010)\u001a\u00020*H\u0002J\u0017\u0010+\u001a\u0004\u0018\u00010,2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002\u00a2\u0006\u0002\u0010-J\u0017\u0010.\u001a\u0004\u0018\u00010/2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002\u00a2\u0006\u0002\u00100J\u0017\u00101\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u001c\u001a\u00020\u001dH\u0002\u00a2\u0006\u0002\u00102J\u0012\u00103\u001a\u0004\u0018\u00010\t2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u001a\u00104\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J\u0006\u00105\u001a\u000206J\u0010\u00107\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0014\u00108\u001a\u0004\u0018\u00010\t2\b\u00109\u001a\u0004\u0018\u00010\tH\u0002Rj\u0010\u0007\u001a^\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t \n*.\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000Rj\u0010\r\u001a^\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t\u0012\f\u0012\n \n*\u0004\u0018\u00010\u000e0\u000e \n*.\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t\u0012\f\u0012\n \n*\u0004\u0018\u00010\u000e0\u000e\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u000f\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0082\u0001\u0010\u0013\u001av\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\f \n*\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u00110\u0011 \n*:\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\f \n*\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u00110\u0011\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lcom/android/tools/idea/layoutinspector/transport/DefaultPropertiesProvider$Generator;", "", "properties", "Lcom/android/tools/layoutinspector/proto/LayoutInspectorProto$PropertyEvent;", "lookup", "Lcom/android/tools/idea/layoutinspector/properties/ViewNodeAndResourceLookup;", "(Lcom/android/tools/layoutinspector/proto/LayoutInspectorProto$PropertyEvent;Lcom/android/tools/idea/layoutinspector/properties/ViewNodeAndResourceLookup;)V", "classNamesTable", "Lcom/google/common/collect/HashBasedTable;", "", "kotlin.jvm.PlatformType", "layout", "Lcom/android/ide/common/rendering/api/ResourceReference;", "propertyTable", "Lcom/android/tools/idea/layoutinspector/properties/InspectorPropertyItem;", "resolutionStackMap", "", "", "Lcom/android/tools/layoutinspector/proto/LayoutInspectorProto$Resource;", "resolutionStackTable", "stringTable", "Lcom/android/tools/idea/layoutinspector/common/StringTableImpl;", "viewId", "", "add", "", "item", "addResolutionStack", "property", "Lcom/android/tools/layoutinspector/proto/LayoutInspectorProto$Property;", "fromBoolean", "", "(Lcom/android/tools/layoutinspector/proto/LayoutInspectorProto$Property;)Ljava/lang/Boolean;", "fromChar", "", "(Lcom/android/tools/layoutinspector/proto/LayoutInspectorProto$Property;)Ljava/lang/Character;", "fromColor", "fromDouble", "", "(Lcom/android/tools/layoutinspector/proto/LayoutInspectorProto$Property;)Ljava/lang/Double;", "fromFlags", "flagValue", "Lcom/android/tools/layoutinspector/proto/LayoutInspectorProto$FlagValue;", "fromFloat", "", "(Lcom/android/tools/layoutinspector/proto/LayoutInspectorProto$Property;)Ljava/lang/Float;", "fromInt32", "", "(Lcom/android/tools/layoutinspector/proto/LayoutInspectorProto$Property;)Ljava/lang/Integer;", "fromInt64", "(Lcom/android/tools/layoutinspector/proto/LayoutInspectorProto$Property;)Ljava/lang/Long;", "fromKnownObjectType", "fromResource", "generate", "Lcom/android/tools/idea/layoutinspector/transport/DefaultPropertiesProvider$PropertiesData;", "generateItem", "valueFromInterpolatorClass", "className", "intellij.android.layout-inspector"})
    private static final class Generator {
        private final StringTableImpl stringTable;
        private final ResourceReference layout;
        private final HashBasedTable<String, String, InspectorPropertyItem> propertyTable;
        private final HashBasedTable<String, String, String> classNamesTable;
        private final HashBasedTable<String, String, List<ResourceReference>> resolutionStackTable;
        private final Map<List<LayoutInspectorProto.Resource>, List<ResourceReference>> resolutionStackMap;
        private final long viewId;
        private final LayoutInspectorProto.PropertyEvent properties;
        private final ViewNodeAndResourceLookup lookup;

        @NotNull
        public final PropertiesData generate() {
            Iterator iterator = this.properties.getPropertyList().iterator();
            while (iterator.hasNext()) {
                LayoutInspectorProto.Property property2;
                LayoutInspectorProto.Property property3 = property2 = (LayoutInspectorProto.Property)iterator.next();
                Intrinsics.checkNotNullExpressionValue((Object)property3, (String)"property");
                this.add(this.generateItem(property3));
                this.addResolutionStack(property2);
            }
            HashBasedTable<String, String, InspectorPropertyItem> hashBasedTable = this.propertyTable;
            Intrinsics.checkNotNullExpressionValue(hashBasedTable, (String)"propertyTable");
            PropertiesTable<InspectorPropertyItem> propertiesTable = PropertiesTable.Companion.create((Table)hashBasedTable);
            HashBasedTable<String, String, List<ResourceReference>> hashBasedTable2 = this.resolutionStackTable;
            Intrinsics.checkNotNullExpressionValue(hashBasedTable2, (String)"resolutionStackTable");
            Table table2 = (Table)hashBasedTable2;
            HashBasedTable<String, String, String> hashBasedTable3 = this.classNamesTable;
            Intrinsics.checkNotNullExpressionValue(hashBasedTable3, (String)"classNamesTable");
            return new PropertiesData(propertiesTable, (Table<String, String, List<ResourceReference>>)table2, (Table<String, String, String>)((Table)hashBasedTable3));
        }

        /*
         * Unable to fully structure code
         */
        private final InspectorPropertyItem generateItem(LayoutInspectorProto.Property property) {
            name = this.stringTable.get(property.getName());
            isDeclared = Intrinsics.areEqual((Object)property.getSource(), (Object)this.properties.getLayout()) != false && (Intrinsics.areEqual((Object)property.getSource(), (Object)LayoutInspectorProto.Resource.getDefaultInstance()) ^ true) != false;
            source = this.stringTable.get(property.getSource());
            group = property.getIsLayout() != false ? PropertySection.LAYOUT : (isDeclared != false ? PropertySection.DECLARED : PropertySection.DEFAULT);
            v0 = property.getType();
            if (v0 == null) ** GOTO lbl-1000
            switch (DefaultPropertiesProvider$Generator$WhenMappings.$EnumSwitchMapping$0[v0.ordinal()]) {
                case 1: 
                case 2: {
                    v1 = this.stringTable.get(property.getInt32Value());
                    break;
                }
                case 3: 
                case 4: {
                    v2 = property.getFlagValue();
                    Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"property.flagValue");
                    v1 = this.fromFlags(v2);
                    break;
                }
                case 5: {
                    v3 = this.fromBoolean(property);
                    if (v3 != null) {
                        v1 = String.valueOf(v3);
                        break;
                    }
                    v1 = null;
                    break;
                }
                case 6: {
                    v4 = this.fromChar(property);
                    if (v4 != null) {
                        v1 = String.valueOf(v4.charValue());
                        break;
                    }
                    v1 = null;
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    v5 = this.fromInt32(property);
                    if (v5 != null) {
                        v1 = String.valueOf(v5);
                        break;
                    }
                    v1 = null;
                    break;
                }
                case 10: {
                    v6 = this.fromInt64(property);
                    if (v6 != null) {
                        v1 = String.valueOf(v6);
                        break;
                    }
                    v1 = null;
                    break;
                }
                case 11: 
                case 12: 
                case 13: 
                case 14: {
                    v7 = this.fromFloat(property);
                    if (v7 != null) {
                        v1 = String.valueOf(v7.floatValue());
                        break;
                    }
                    v1 = null;
                    break;
                }
                case 15: {
                    v8 = this.fromDouble(property);
                    if (v8 != null) {
                        v1 = String.valueOf(v8);
                        break;
                    }
                    v1 = null;
                    break;
                }
                case 16: {
                    v9 = this.fromFloat(property);
                    if (v9 != null) {
                        v1 = String.valueOf(v9.floatValue());
                        break;
                    }
                    v1 = null;
                    break;
                }
                case 17: {
                    v1 = this.fromResource(property, this.layout);
                    break;
                }
                case 18: {
                    v1 = this.fromColor(property);
                    break;
                }
                case 19: 
                case 20: 
                case 21: 
                case 22: {
                    v1 = this.fromKnownObjectType(property);
                    break;
                }
                default: lbl-1000:
                // 2 sources

                {
                    v1 = "";
                }
            }
            value = v1;
            type = property.getType();
            if (property.getElementList().isEmpty()) {
                v10 = type;
                Intrinsics.checkNotNullExpressionValue((Object)v10, (String)"type");
                return new InspectorPropertyItem("http://schemas.android.com/apk/res/android", name, v10, value, group, source, this.viewId, this.lookup);
            }
            v11 = property.getElementList();
            Intrinsics.checkNotNullExpressionValue((Object)v11, (String)"property.elementList");
            $this$map$iv = v11;
            $i$f$map = false;
            var11_10 = $this$map$iv;
            destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (T item$iv$iv : $this$mapTo$iv$iv) {
                var16_15 = (LayoutInspectorProto.Property)item$iv$iv;
                var18_17 = destination$iv$iv;
                $i$a$-map-DefaultPropertiesProvider$Generator$generateItem$children$1 = false;
                v12 = it;
                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)"it");
                var19_18 = this.generateItem((LayoutInspectorProto.Property)v12);
                var18_17.add(var19_18);
            }
            children = (List)destination$iv$iv;
            v13 = type;
            Intrinsics.checkNotNullExpressionValue((Object)v13, (String)"type");
            return new InspectorGroupPropertyItem("http://schemas.android.com/apk/res/android", name, v13, value, null, group, source, this.viewId, this.lookup, children);
        }

        private final void addResolutionStack(LayoutInspectorProto.Property property2) {
            List encodedResolutionStack = property2.getResolutionStackList();
            if (encodedResolutionStack.isEmpty()) {
                if (Intrinsics.areEqual((Object)property2.getSource(), (Object)LayoutInspectorProto.Resource.getDefaultInstance())) {
                    return;
                }
                encodedResolutionStack = CollectionsKt.listOf((Object)property2.getSource());
            }
            List<ResourceReference> list = this.resolutionStackMap.computeIfAbsent(encodedResolutionStack, new Function(this){
                final /* synthetic */ Generator this$0;

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final List<ResourceReference> apply(@NotNull List<LayoutInspectorProto.Resource> it) {
                    void $this$mapNotNullTo$iv$iv;
                    Intrinsics.checkNotNullParameter(it, (String)"it");
                    Iterable $this$mapNotNull$iv = it;
                    boolean $i$f$mapNotNull = false;
                    Iterable iterable = $this$mapNotNull$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    Iterator<T> iterator = $this$forEach$iv$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        ResourceReference resourceReference;
                        T element$iv$iv$iv;
                        T element$iv$iv = element$iv$iv$iv = iterator.next();
                        boolean bl = false;
                        LayoutInspectorProto.Resource res = (LayoutInspectorProto.Resource)element$iv$iv;
                        boolean bl2 = false;
                        if (Generator.access$getStringTable$p(this.this$0).get(res) == null) continue;
                        boolean bl3 = false;
                        boolean bl4 = false;
                        ResourceReference it$iv$iv = resourceReference;
                        boolean bl5 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    return (List)destination$iv$iv;
                }
                {
                    this.this$0 = generator2;
                }
            });
            Intrinsics.checkNotNullExpressionValue(list, (String)"resolutionStackMap.compu\u2026s -> stringTable[res] } }");
            List<ResourceReference> resolutionStack2 = list;
            if (resolutionStack2.isEmpty()) {
                return;
            }
            String name = this.stringTable.get(property2.getName());
            this.resolutionStackTable.put((Object)"http://schemas.android.com/apk/res/android", (Object)name, resolutionStack2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final String fromKnownObjectType(LayoutInspectorProto.Property property2) {
            String name = this.stringTable.get(property2.getName());
            String className2 = this.stringTable.get(property2.getInt32Value());
            CharSequence charSequence = className2;
            boolean bl = false;
            if (charSequence.length() > 0) {
                this.classNamesTable.put((Object)"http://schemas.android.com/apk/res/android", (Object)name, (Object)className2);
            }
            LayoutInspectorProto.Property.Type type = property2.getType();
            if (type == null) return null;
            switch (DefaultPropertiesProvider$Generator$WhenMappings.$EnumSwitchMapping$1[type.ordinal()]) {
                case 1: {
                    return "@anim/?";
                }
                case 2: {
                    return "@animator/?";
                }
                case 3: {
                    return "@drawable/?";
                }
                case 4: {
                    String string = this.valueFromInterpolatorClass(className2);
                    String string2 = string;
                    if (string == null) return "@interpolator/?";
                    return string2;
                }
                default: {
                    return null;
                }
            }
        }

        private final String fromResource(LayoutInspectorProto.Property property2, ResourceReference layout2) {
            ResourceReference url;
            Object object;
            Object object2;
            block5: {
                ResourceReference reference2;
                block4: {
                    reference2 = this.stringTable.get(property2.getResourceValue());
                    object2 = layout2;
                    if (object2 == null) break block4;
                    ResourceReference resourceReference = object2;
                    boolean bl = false;
                    boolean bl2 = false;
                    ResourceReference it = resourceReference;
                    boolean bl3 = false;
                    ResourceReference resourceReference2 = reference2;
                    object2 = resourceReference2 != null ? resourceReference2.getRelativeResourceUrl(layout2.getNamespace()) : null;
                    if (object2 != null) break block5;
                }
                ResourceReference resourceReference = reference2;
                object2 = resourceReference != null ? resourceReference.getResourceUrl() : null;
            }
            if ((object = (url = object2)) == null || (object = object.toString()) == null) {
                object = "";
            }
            return object;
        }

        private final String fromFlags(LayoutInspectorProto.FlagValue flagValue) {
            List list = flagValue.getFlagList();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"flagValue.flagList");
            return CollectionsKt.joinToString$default((Iterable)list, (CharSequence)"|", null, null, (int)0, null, (Function1)((Function1)new Function1<Integer, CharSequence>(this){
                final /* synthetic */ Generator this$0;

                @NotNull
                public final CharSequence invoke(Integer it) {
                    StringTableImpl stringTableImpl = Generator.access$getStringTable$p(this.this$0);
                    Integer n = it;
                    Intrinsics.checkNotNullExpressionValue((Object)n, (String)"it");
                    return stringTableImpl.get(n);
                }
                {
                    this.this$0 = generator2;
                    super(1);
                }
            }), (int)30, null);
        }

        private final Boolean fromBoolean(LayoutInspectorProto.Property property2) {
            Integer n = this.fromInt32(property2);
            if (n == null) {
                return null;
            }
            int intValue = n;
            return intValue != 0;
        }

        private final Character fromChar(LayoutInspectorProto.Property property2) {
            Integer n = this.fromInt32(property2);
            if (n == null) {
                return null;
            }
            int intValue = n;
            return Character.valueOf((char)intValue);
        }

        private final Integer fromInt32(LayoutInspectorProto.Property property2) {
            int intValue = property2.getInt32Value();
            if (intValue == 0 && !property2.hasField(DefaultPropertiesProviderKt.access$getINT32_FIELD_DESCRIPTOR$p())) {
                return null;
            }
            return intValue;
        }

        private final Long fromInt64(LayoutInspectorProto.Property property2) {
            long intValue = property2.getInt64Value();
            if (intValue == 0L && !property2.hasField(DefaultPropertiesProviderKt.access$getINT64_FIELD_DESCRIPTOR$p())) {
                return null;
            }
            return intValue;
        }

        private final Double fromDouble(LayoutInspectorProto.Property property2) {
            double doubleValue = property2.getDoubleValue();
            if (doubleValue == 0.0 && !property2.hasField(DefaultPropertiesProviderKt.access$getDOUBLE_FIELD_DESCRIPTOR$p())) {
                return null;
            }
            return doubleValue;
        }

        private final Float fromFloat(LayoutInspectorProto.Property property2) {
            float floatValue = property2.getFloatValue();
            if (floatValue == 0.0f && !property2.hasField(DefaultPropertiesProviderKt.access$getFLOAT_FIELD_DESCRIPTOR$p())) {
                return null;
            }
            return Float.valueOf(floatValue);
        }

        private final String fromColor(LayoutInspectorProto.Property property2) {
            Integer n = this.fromInt32(property2);
            if (n == null) {
                return null;
            }
            int intValue = n;
            return IdeResourcesUtil.colorToString(new Color(intValue));
        }

        private final void add(InspectorPropertyItem item) {
            this.propertyTable.put((Object)item.getNamespace(), (Object)item.getName(), (Object)item);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final String valueFromInterpolatorClass(String className2) {
            String string = className2;
            if (string == null) return null;
            switch (string) {
                case "android.view.animation.AccelerateDecelerateInterpolator": {
                    return "@android:interpolator/accelerate_decelerate";
                }
                case "android.view.animation.AnticipateInterpolator": {
                    return "@android:interpolator/anticipate";
                }
                case "android.view.animation.AnticipateOvershootInterpolator": {
                    return "@android:interpolator/anticipate_overshoot";
                }
                case "android.view.animation.BounceInterpolator": {
                    return "@android:interpolator/bounce";
                }
                case "android.view.animation.CycleInterpolator": {
                    return "@android:interpolator/cycle";
                }
                case "android.view.animation.LinearInterpolator": {
                    return "@android:interpolator/linear";
                }
                case "android.view.animation.OvershootInterpolator": {
                    return "@android:interpolator/overshoot";
                }
                default: {
                    return null;
                }
            }
        }

        public Generator(@NotNull LayoutInspectorProto.PropertyEvent properties2, @NotNull ViewNodeAndResourceLookup lookup) {
            Intrinsics.checkNotNullParameter((Object)properties2, (String)"properties");
            Intrinsics.checkNotNullParameter((Object)lookup, (String)"lookup");
            this.properties = properties2;
            this.lookup = lookup;
            List list = this.properties.getStringList();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"properties.stringList");
            this.stringTable = new StringTableImpl(list);
            this.layout = this.stringTable.get(this.properties.getLayout());
            this.propertyTable = HashBasedTable.create();
            this.classNamesTable = HashBasedTable.create();
            this.resolutionStackTable = HashBasedTable.create();
            boolean bl = false;
            this.resolutionStackMap = new LinkedHashMap();
            this.viewId = this.properties.getViewId();
        }

        public static final /* synthetic */ StringTableImpl access$getStringTable$p(Generator $this) {
            return $this.stringTable;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001BM\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u001e\u0010\u0005\u001a\u001a\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0006\u0012\u0018\u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\u000bR#\u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR)\u0010\u0005\u001a\u001a\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\r\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/idea/layoutinspector/transport/DefaultPropertiesProvider$PropertiesData;", "", "properties", "Lcom/android/tools/property/panel/api/PropertiesTable;", "Lcom/android/tools/idea/layoutinspector/properties/InspectorPropertyItem;", "resolutionStacks", "Lcom/google/common/collect/Table;", "", "", "Lcom/android/ide/common/rendering/api/ResourceReference;", "classNames", "(Lcom/android/tools/property/panel/api/PropertiesTable;Lcom/google/common/collect/Table;Lcom/google/common/collect/Table;)V", "getClassNames", "()Lcom/google/common/collect/Table;", "getProperties", "()Lcom/android/tools/property/panel/api/PropertiesTable;", "getResolutionStacks", "intellij.android.layout-inspector"})
    public static final class PropertiesData {
        @NotNull
        private final PropertiesTable<InspectorPropertyItem> properties;
        @NotNull
        private final Table<String, String, List<ResourceReference>> resolutionStacks;
        @NotNull
        private final Table<String, String, String> classNames;

        @NotNull
        public final PropertiesTable<InspectorPropertyItem> getProperties() {
            return this.properties;
        }

        @NotNull
        public final Table<String, String, List<ResourceReference>> getResolutionStacks() {
            return this.resolutionStacks;
        }

        @NotNull
        public final Table<String, String, String> getClassNames() {
            return this.classNames;
        }

        public PropertiesData(@NotNull PropertiesTable<InspectorPropertyItem> properties2, @NotNull Table<String, String, List<ResourceReference>> resolutionStacks, @NotNull Table<String, String, String> classNames) {
            Intrinsics.checkNotNullParameter(properties2, (String)"properties");
            Intrinsics.checkNotNullParameter(resolutionStacks, (String)"resolutionStacks");
            Intrinsics.checkNotNullParameter(classNames, (String)"classNames");
            this.properties = properties2;
            this.resolutionStacks = resolutionStacks;
            this.classNames = classNames;
        }
    }
}

