/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.layoutinspector.properties;

import com.android.ide.common.rendering.api.ResourceReference;
import com.android.tools.adtui.model.stdui.EditingSupport;
import com.android.tools.idea.layoutinspector.model.ViewNode;
import com.android.tools.idea.layoutinspector.properties.DimensionUnits;
import com.android.tools.idea.layoutinspector.properties.InspectorPropertyItem$WhenMappings;
import com.android.tools.idea.layoutinspector.properties.PropertiesSettings;
import com.android.tools.idea.layoutinspector.properties.PropertySection;
import com.android.tools.idea.layoutinspector.properties.ViewNodeAndResourceLookup;
import com.android.tools.idea.layoutinspector.resource.ResourceLookup;
import com.android.tools.idea.layoutinspector.resource.SourceLocation;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.layoutinspector.proto.LayoutInspectorProto;
import com.android.tools.property.panel.api.ActionIconButton;
import com.android.tools.property.panel.api.HelpSupport;
import com.android.tools.property.panel.api.PropertyItem;
import com.android.utils.HashCodes;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.pom.Navigatable;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.ColorIcon;
import java.awt.Color;
import java.text.DecimalFormat;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.FloatCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0007\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001:\u0001RBK\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010BQ\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0011\u001a\u00020\u0003\u0012\u0006\u0010\u0012\u001a\u00020\u0006\u0012\b\u0010\u0013\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0014J\u0010\u0010=\u001a\u00020\u001e2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\n\u0010>\u001a\u0004\u0018\u00010\u0018H\u0002J\u0013\u0010?\u001a\u00020@2\b\u0010A\u001a\u0004\u0018\u00010BH\u0096\u0002J\u0012\u0010C\u001a\u0004\u0018\u00010\u00032\u0006\u0010D\u001a\u00020\u001eH\u0002J\u0012\u0010E\u001a\u0004\u0018\u00010\u00032\u0006\u0010D\u001a\u00020.H\u0002J\u0012\u0010F\u001a\u0004\u0018\u00010\u00032\u0006\u0010G\u001a\u00020.H\u0002J\u0012\u0010H\u001a\u0004\u0018\u00010\u00032\u0006\u0010I\u001a\u00020.H\u0002J\u0012\u0010J\u001a\u0004\u0018\u00010\u00032\u0006\u0010K\u001a\u00020.H\u0002J\u0010\u0010L\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020.H\u0002J\b\u0010M\u001a\u00020\u001eH\u0016J\u000e\u0010N\u001a\u00020O2\u0006\u0010P\u001a\u00020QR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001e\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\u001d\u001a\u00020\u001e@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0014\u0010$\u001a\u00020%X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0013\u0010\u0013\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\u0016R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u0014\u0010\u0011\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010\u0016R\u0014\u0010-\u001a\u00020.8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u00100R\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u00102R$\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u00104\"\u0004\b5\u00106R(\u0010\u0007\u001a\u0004\u0018\u00010\u00032\b\u00107\u001a\u0004\u0018\u00010\u00038V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b8\u0010\u0016\"\u0004\b9\u0010:R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b;\u0010<\u00a8\u0006S"}, d2={"Lcom/android/tools/idea/layoutinspector/properties/InspectorPropertyItem;", "Lcom/android/tools/property/panel/api/PropertyItem;", "namespace", "", "attrName", "type", "Lcom/android/tools/layoutinspector/proto/LayoutInspectorProto$Property$Type;", "value", "group", "Lcom/android/tools/idea/layoutinspector/properties/PropertySection;", "source", "Lcom/android/ide/common/rendering/api/ResourceReference;", "viewId", "", "lookup", "Lcom/android/tools/idea/layoutinspector/properties/ViewNodeAndResourceLookup;", "(Ljava/lang/String;Ljava/lang/String;Lcom/android/tools/layoutinspector/proto/LayoutInspectorProto$Property$Type;Ljava/lang/String;Lcom/android/tools/idea/layoutinspector/properties/PropertySection;Lcom/android/ide/common/rendering/api/ResourceReference;JLcom/android/tools/idea/layoutinspector/properties/ViewNodeAndResourceLookup;)V", "name", "initialType", "initialValue", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/android/tools/layoutinspector/proto/LayoutInspectorProto$Property$Type;Ljava/lang/String;Lcom/android/tools/idea/layoutinspector/properties/PropertySection;Lcom/android/ide/common/rendering/api/ResourceReference;JLcom/android/tools/idea/layoutinspector/properties/ViewNodeAndResourceLookup;)V", "getAttrName", "()Ljava/lang/String;", "colorButton", "Lcom/android/tools/property/panel/api/ActionIconButton;", "getColorButton", "()Lcom/android/tools/property/panel/api/ActionIconButton;", "setColorButton", "(Lcom/android/tools/property/panel/api/ActionIconButton;)V", "<set-?>", "", "dimensionValue", "getDimensionValue", "()I", "getGroup", "()Lcom/android/tools/idea/layoutinspector/properties/PropertySection;", "helpSupport", "Lcom/android/tools/property/panel/api/HelpSupport;", "getHelpSupport", "()Lcom/android/tools/property/panel/api/HelpSupport;", "getInitialValue", "getLookup", "()Lcom/android/tools/idea/layoutinspector/properties/ViewNodeAndResourceLookup;", "getName", "getNamespace", "pixelsToSpFactor", "", "getPixelsToSpFactor", "()F", "getSource", "()Lcom/android/ide/common/rendering/api/ResourceReference;", "getType", "()Lcom/android/tools/layoutinspector/proto/LayoutInspectorProto$Property$Type;", "setType", "(Lcom/android/tools/layoutinspector/proto/LayoutInspectorProto$Property$Type;)V", "<anonymous parameter 0>", "getValue", "setValue", "(Ljava/lang/String;)V", "getViewId", "()J", "computeDimensionValue", "createColorButton", "equals", "", "other", "", "formatDimension", "pixels", "formatDimensionFloat", "formatDimensionFloatAsEm", "em", "formatDimensionFloatAsSp", "sp", "formatDimensionFloatDp", "dp", "formatFloat", "hashCode", "resolveDimensionType", "", "view", "Lcom/android/tools/idea/layoutinspector/model/ViewNode;", "ColorActionIconButton", "intellij.android.layout-inspector"})
public class InspectorPropertyItem
implements PropertyItem {
    @NotNull
    private LayoutInspectorProto.Property.Type type;
    private int dimensionValue;
    @NotNull
    private final HelpSupport helpSupport;
    @Nullable
    private ActionIconButton colorButton;
    @NotNull
    private final String namespace;
    @NotNull
    private final String attrName;
    @NotNull
    private final String name;
    @Nullable
    private final String initialValue;
    @NotNull
    private final PropertySection group;
    @Nullable
    private final ResourceReference source;
    private final long viewId;
    @NotNull
    private final ViewNodeAndResourceLookup lookup;

    @NotNull
    public final LayoutInspectorProto.Property.Type getType() {
        return this.type;
    }

    private final void setType(LayoutInspectorProto.Property.Type value2) {
        this.type = value2;
        this.dimensionValue = this.computeDimensionValue(value2);
    }

    public final int getDimensionValue() {
        return this.dimensionValue;
    }

    private final int computeDimensionValue(LayoutInspectorProto.Property.Type type) {
        int n;
        switch (InspectorPropertyItem$WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: {
                Object object = this.initialValue;
                if (object != null && (object = StringsKt.toIntOrNull((String)object)) != null) {
                    n = (Integer)object;
                    break;
                }
                n = -1;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                Object object = this.initialValue;
                float f = object != null && (object = StringsKt.toFloatOrNull((String)object)) != null ? ((Float)object).floatValue() : Float.NaN;
                boolean bl = false;
                n = Float.floatToRawIntBits(f);
                break;
            }
            default: {
                n = -1;
            }
        }
        return n;
    }

    @Override
    @Nullable
    public String getValue() {
        String string;
        switch (InspectorPropertyItem$WhenMappings.$EnumSwitchMapping$1[this.type.ordinal()]) {
            case 1: {
                string = this.formatDimension(this.dimensionValue);
                break;
            }
            case 2: {
                FloatCompanionObject floatCompanionObject = FloatCompanionObject.INSTANCE;
                int n = this.dimensionValue;
                boolean bl = false;
                string = this.formatDimensionFloatDp(Float.intBitsToFloat(n));
                break;
            }
            case 3: {
                FloatCompanionObject floatCompanionObject = FloatCompanionObject.INSTANCE;
                int n = this.dimensionValue;
                boolean bl = false;
                string = this.formatDimensionFloatAsEm(Float.intBitsToFloat(n));
                break;
            }
            case 4: {
                FloatCompanionObject floatCompanionObject = FloatCompanionObject.INSTANCE;
                int n = this.dimensionValue;
                boolean bl = false;
                string = this.formatDimensionFloat(Float.intBitsToFloat(n));
                break;
            }
            case 5: {
                FloatCompanionObject floatCompanionObject = FloatCompanionObject.INSTANCE;
                int n = this.dimensionValue;
                boolean bl = false;
                string = this.formatDimensionFloatAsSp(Float.intBitsToFloat(n));
                break;
            }
            default: {
                string = this.initialValue;
            }
        }
        return string;
    }

    @Override
    public void setValue(@Nullable String $noName_0) {
    }

    public int hashCode() {
        ResourceReference resourceReference = this.source;
        return HashCodes.mix((int)this.getNamespace().hashCode(), (int)this.attrName.hashCode(), (int)(resourceReference != null ? resourceReference.hashCode() : 0));
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof InspectorPropertyItem && Intrinsics.areEqual((Object)this.getNamespace(), (Object)((InspectorPropertyItem)other).getNamespace()) && Intrinsics.areEqual((Object)this.attrName, (Object)((InspectorPropertyItem)other).attrName) && Intrinsics.areEqual((Object)this.source, (Object)((InspectorPropertyItem)other).source) && Intrinsics.areEqual(this.getClass(), ((InspectorPropertyItem)other).getClass());
    }

    @Override
    @NotNull
    public HelpSupport getHelpSupport() {
        return this.helpSupport;
    }

    @Override
    @Nullable
    public ActionIconButton getColorButton() {
        return this.colorButton;
    }

    public void setColorButton(@Nullable ActionIconButton actionIconButton) {
        this.colorButton = actionIconButton;
    }

    private final String formatDimension(int pixels) {
        String string;
        if (pixels == -1 || pixels == Integer.MIN_VALUE || pixels == Integer.MAX_VALUE) {
            return this.initialValue;
        }
        ResourceLookup resourceLookup = this.lookup.getResourceLookup();
        if (resourceLookup.getDpi() <= 0) {
            return pixels + "px";
        }
        switch (InspectorPropertyItem$WhenMappings.$EnumSwitchMapping$2[PropertiesSettings.INSTANCE.getDimensionUnits().ordinal()]) {
            case 1: {
                string = pixels + "px";
                break;
            }
            case 2: {
                string = pixels * 160 / resourceLookup.getDpi() + "dp";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    private final String formatDimensionFloat(float pixels) {
        String string;
        float f = pixels;
        boolean bl = false;
        if (Float.isNaN(f)) {
            return this.initialValue;
        }
        ResourceLookup resourceLookup = this.lookup.getResourceLookup();
        if (resourceLookup.getDpi() <= 0) {
            return this.formatFloat(pixels) + "px";
        }
        if (Intrinsics.areEqual((Object)this.getName(), (Object)"textSize") && resourceLookup.getFontScale() != 0.0f && PropertiesSettings.INSTANCE.getDimensionUnits() == DimensionUnits.DP) {
            return new DecimalFormat("0.0").format(Float.valueOf(pixels * this.getPixelsToSpFactor())) + "sp";
        }
        switch (InspectorPropertyItem$WhenMappings.$EnumSwitchMapping$3[PropertiesSettings.INSTANCE.getDimensionUnits().ordinal()]) {
            case 1: {
                string = this.formatFloat(pixels) + "px";
                break;
            }
            case 2: {
                string = this.formatFloat(pixels * 160.0f / (float)resourceLookup.getDpi()) + "dp";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    private final String formatDimensionFloatDp(float dp) {
        String string;
        float f = dp;
        boolean bl = false;
        if (Float.isNaN(f)) {
            return this.initialValue;
        }
        ResourceLookup resourceLookup = this.lookup.getResourceLookup();
        if (resourceLookup.getDpi() <= 0) {
            return this.formatFloat(dp) + "dp";
        }
        switch (InspectorPropertyItem$WhenMappings.$EnumSwitchMapping$4[PropertiesSettings.INSTANCE.getDimensionUnits().ordinal()]) {
            case 1: {
                string = this.formatFloat(dp) + "dp";
                break;
            }
            case 2: {
                string = this.formatFloat(dp / 160.0f * (float)resourceLookup.getDpi()) + "px";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    private final String formatDimensionFloatAsSp(float sp) {
        String string;
        float f = sp;
        boolean bl = false;
        if (Float.isNaN(f)) {
            return this.initialValue;
        }
        if (this.lookup.getResourceLookup().getDpi() <= 0) {
            return this.formatFloat(sp) + "sp";
        }
        switch (InspectorPropertyItem$WhenMappings.$EnumSwitchMapping$5[PropertiesSettings.INSTANCE.getDimensionUnits().ordinal()]) {
            case 1: {
                string = this.formatFloat(sp / this.getPixelsToSpFactor()) + "px";
                break;
            }
            case 2: {
                string = this.formatFloat(sp) + "sp";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    private final String formatDimensionFloatAsEm(float em) {
        float f = em;
        boolean bl = false;
        if (Float.isNaN(f)) {
            return this.initialValue;
        }
        return this.formatFloat(em) + "em";
    }

    private final float getPixelsToSpFactor() {
        return 160.0f / this.lookup.getResourceLookup().getFontScale() / (float)this.lookup.getResourceLookup().getDpi();
    }

    private final String formatFloat(float value2) {
        String string;
        if (value2 == 0.0f) {
            string = "0";
        } else {
            String string2 = new DecimalFormat("0.0##").format(Float.valueOf(value2));
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"DecimalFormat(\"0.0##\").format(value)");
        }
        return string;
    }

    private final ActionIconButton createColorButton() {
        ActionIconButton actionIconButton;
        switch (InspectorPropertyItem$WhenMappings.$EnumSwitchMapping$6[this.type.ordinal()]) {
            case 1: 
            case 2: {
                ColorActionIconButton colorActionIconButton;
                String string = this.getValue();
                if (string != null) {
                    String string2 = string;
                    boolean bl = false;
                    boolean bl2 = false;
                    String it = string2;
                    boolean bl3 = false;
                    colorActionIconButton = new ColorActionIconButton(this);
                } else {
                    colorActionIconButton = null;
                }
                actionIconButton = colorActionIconButton;
                break;
            }
            default: {
                actionIconButton = null;
            }
        }
        return actionIconButton;
    }

    public final void resolveDimensionType(@NotNull ViewNode view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        if ((this.type == LayoutInspectorProto.Property.Type.INT32 || this.type == LayoutInspectorProto.Property.Type.FLOAT) && this.lookup.getResourceLookup().isDimension(view, this.getName())) {
            this.setType(this.type == LayoutInspectorProto.Property.Type.INT32 ? LayoutInspectorProto.Property.Type.DIMENSION : LayoutInspectorProto.Property.Type.DIMENSION_FLOAT);
        }
    }

    @Override
    @NotNull
    public String getNamespace() {
        return this.namespace;
    }

    @NotNull
    public final String getAttrName() {
        return this.attrName;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Nullable
    public final String getInitialValue() {
        return this.initialValue;
    }

    @NotNull
    public final PropertySection getGroup() {
        return this.group;
    }

    @Nullable
    public final ResourceReference getSource() {
        return this.source;
    }

    public final long getViewId() {
        return this.viewId;
    }

    @NotNull
    public final ViewNodeAndResourceLookup getLookup() {
        return this.lookup;
    }

    public InspectorPropertyItem(@NotNull String namespace, @NotNull String attrName, @NotNull String name, @NotNull LayoutInspectorProto.Property.Type initialType, @Nullable String initialValue, @NotNull PropertySection group2, @Nullable ResourceReference source, long viewId, @NotNull ViewNodeAndResourceLookup lookup) {
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)attrName, (String)"attrName");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)initialType, (String)"initialType");
        Intrinsics.checkNotNullParameter((Object)((Object)group2), (String)"group");
        Intrinsics.checkNotNullParameter((Object)lookup, (String)"lookup");
        this.namespace = namespace;
        this.attrName = attrName;
        this.name = name;
        this.initialValue = initialValue;
        this.group = group2;
        this.source = source;
        this.viewId = viewId;
        this.lookup = lookup;
        this.type = initialType;
        this.dimensionValue = this.computeDimensionValue(initialType);
        this.helpSupport = new HelpSupport(this){
            final /* synthetic */ InspectorPropertyItem this$0;

            public void browse() {
                block2: {
                    ViewNode viewNode = this.this$0.getLookup().get(this.this$0.getViewId());
                    if (viewNode == null) {
                        return;
                    }
                    ViewNode view = viewNode;
                    SourceLocation sourceLocation2 = (SourceLocation)CollectionsKt.singleOrNull(this.this$0.getLookup().getResourceLookup().findFileLocations(this.this$0, view, 1));
                    if (sourceLocation2 == null) {
                        return;
                    }
                    SourceLocation location = sourceLocation2;
                    Navigatable navigatable = location.getNavigatable();
                    if (navigatable == null) break block2;
                    navigatable.navigate(true);
                }
            }
            {
                this.this$0 = this$0;
            }

            @Nullable
            public AnAction getHelp() {
                return HelpSupport.DefaultImpls.getHelp(this);
            }

            @Nullable
            public AnAction getSecondaryHelp() {
                return HelpSupport.DefaultImpls.getSecondaryHelp(this);
            }
        };
        this.colorButton = this.createColorButton();
    }

    public InspectorPropertyItem(@NotNull String namespace, @NotNull String attrName, @NotNull LayoutInspectorProto.Property.Type type, @Nullable String value2, @NotNull PropertySection group2, @Nullable ResourceReference source, long viewId, @NotNull ViewNodeAndResourceLookup lookup) {
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)attrName, (String)"attrName");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)((Object)group2), (String)"group");
        Intrinsics.checkNotNullParameter((Object)lookup, (String)"lookup");
        this(namespace, attrName, attrName, type, value2, group2, source, viewId, lookup);
    }

    @Override
    @Nullable
    public ActionIconButton getBrowseButton() {
        return PropertyItem.DefaultImpls.getBrowseButton(this);
    }

    @Override
    @Nullable
    public String getDefaultValue() {
        return PropertyItem.DefaultImpls.getDefaultValue(this);
    }

    @Override
    @NotNull
    public EditingSupport getEditingSupport() {
        return PropertyItem.DefaultImpls.getEditingSupport(this);
    }

    @Override
    public boolean isReference() {
        return PropertyItem.DefaultImpls.isReference(this);
    }

    @Override
    @Nullable
    public Icon getNamespaceIcon() {
        return PropertyItem.DefaultImpls.getNamespaceIcon(this);
    }

    @Override
    @Nullable
    public String getResolvedValue() {
        return PropertyItem.DefaultImpls.getResolvedValue(this);
    }

    @Override
    @NotNull
    public String getTooltipForName() {
        return PropertyItem.DefaultImpls.getTooltipForName(this);
    }

    @Override
    @NotNull
    public String getTooltipForValue() {
        return PropertyItem.DefaultImpls.getTooltipForValue(this);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\r\u001a\u0004\u0018\u00010\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/idea/layoutinspector/properties/InspectorPropertyItem$ColorActionIconButton;", "Lcom/android/tools/property/panel/api/ActionIconButton;", "property", "Lcom/android/tools/idea/layoutinspector/properties/InspectorPropertyItem;", "(Lcom/android/tools/idea/layoutinspector/properties/InspectorPropertyItem;)V", "action", "Lcom/intellij/openapi/actionSystem/AnAction;", "getAction", "()Lcom/intellij/openapi/actionSystem/AnAction;", "actionButtonFocusable", "", "getActionButtonFocusable", "()Z", "actionIcon", "Ljavax/swing/Icon;", "getActionIcon", "()Ljavax/swing/Icon;", "intellij.android.layout-inspector"})
    private static final class ColorActionIconButton
    implements ActionIconButton {
        private final boolean actionButtonFocusable;
        @Nullable
        private final AnAction action;
        private final InspectorPropertyItem property;

        @Override
        public boolean getActionButtonFocusable() {
            return this.actionButtonFocusable;
        }

        @Override
        @Nullable
        public AnAction getAction() {
            return this.action;
        }

        @Override
        @Nullable
        public Icon getActionIcon() {
            Object object;
            block6: {
                block5: {
                    ViewNode viewNode = this.property.getLookup().get(this.property.getViewId());
                    if (viewNode == null) {
                        return null;
                    }
                    ViewNode view = viewNode;
                    Icon icon2 = this.property.getLookup().getResourceLookup().resolveAsIcon(this.property, view);
                    if (icon2 != null) {
                        Icon icon3 = icon2;
                        boolean bl = false;
                        boolean bl2 = false;
                        Icon it = icon3;
                        boolean bl3 = false;
                        return it;
                    }
                    String value2 = this.property.getValue();
                    object = value2;
                    if (object == null) break block5;
                    String string = object;
                    boolean bl = false;
                    boolean bl4 = false;
                    String it = string;
                    boolean bl5 = false;
                    object = IdeResourcesUtil.parseColor(value2);
                    if (object != null) break block6;
                }
                return null;
            }
            Object color = object;
            return (Icon)new ColorIcon(16, (Color)color, false).scale(JBUIScale.scale((float)1.0f));
        }

        public ColorActionIconButton(@NotNull InspectorPropertyItem property2) {
            Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
            this.property = property2;
        }
    }
}

