/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.layoutinspector.legacydevice;

import com.android.annotations.concurrency.Slow;
import com.android.ddmlib.Client;
import com.android.ddmlib.DebugViewDumpHandler;
import com.android.ddmlib.IDevice;
import com.android.tools.idea.layoutinspector.legacydevice.LegacyClient;
import com.android.tools.idea.layoutinspector.legacydevice.LegacyEvent;
import com.android.tools.idea.layoutinspector.legacydevice.LegacyPropertiesProvider;
import com.android.tools.idea.layoutinspector.legacydevice.LegacyTreeLoader;
import com.android.tools.idea.layoutinspector.model.AndroidWindow;
import com.android.tools.idea.layoutinspector.model.DrawViewChild;
import com.android.tools.idea.layoutinspector.model.DrawViewImage;
import com.android.tools.idea.layoutinspector.model.DrawViewNode;
import com.android.tools.idea.layoutinspector.model.TreeLoader;
import com.android.tools.idea.layoutinspector.model.ViewNode;
import com.android.tools.idea.layoutinspector.resource.ResourceLookup;
import com.android.tools.idea.layoutinspector.transport.InspectorClient;
import com.android.tools.layoutinspector.proto.LayoutInspectorProto;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.wireless.android.sdk.stats.DynamicLayoutInspectorEvent;
import com.intellij.openapi.project.Project;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0003\u001e\u001f B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0003J.\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\b0\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\nH\u0002J\"\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00122\b\u0010\u000f\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J8\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0015\u0018\u00010\f2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J&\u0010\u001a\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\b\u0018\u00010\f2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\nH\u0007\u00a8\u0006!"}, d2={"Lcom/android/tools/idea/layoutinspector/legacydevice/LegacyTreeLoader;", "Lcom/android/tools/idea/layoutinspector/model/TreeLoader;", "()V", "capture", "Lcom/android/tools/idea/layoutinspector/model/AndroidWindow;", "client", "Lcom/android/tools/idea/layoutinspector/transport/InspectorClient;", "windowName", "", "propertiesUpdater", "Lcom/android/tools/idea/layoutinspector/legacydevice/LegacyPropertiesProvider$Updater;", "createViewNode", "Lkotlin/Pair;", "Lcom/android/tools/idea/layoutinspector/model/ViewNode;", "parent", "data", "propertyLoader", "getAllWindowIds", "", "", "loadComponentTree", "", "resourceLookup", "Lcom/android/tools/idea/layoutinspector/resource/ResourceLookup;", "project", "Lcom/intellij/openapi/project/Project;", "parseLiveViewNode", "bytes", "", "propertyUpdater", "CaptureByteArrayHandler", "ListViewRootsHandler", "MergeNewLineCollector", "intellij.android.layout-inspector"})
public final class LegacyTreeLoader
implements TreeLoader {
    @NotNull
    public static final LegacyTreeLoader INSTANCE;

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Pair<AndroidWindow, Integer> loadComponentTree(@Nullable Object data, @NotNull ResourceLookup resourceLookup, @NotNull InspectorClient client, @NotNull Project project) {
        Pair pair;
        void windowName;
        Intrinsics.checkNotNullParameter((Object)resourceLookup, (String)"resourceLookup");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Object object = data;
        if (!(object instanceof LegacyEvent)) {
            object = null;
        }
        LegacyEvent legacyEvent = (LegacyEvent)object;
        if (legacyEvent == null) {
            return null;
        }
        Object object2 = legacyEvent;
        String string = ((LegacyEvent)object2).component1();
        LegacyPropertiesProvider.Updater updater = ((LegacyEvent)object2).component2();
        AndroidWindow androidWindow = this.capture(client, (String)windowName, updater);
        if (androidWindow != null) {
            object2 = androidWindow;
            boolean bl = false;
            boolean bl2 = false;
            Object it = object2;
            boolean bl3 = false;
            pair = new Pair(it, (Object)0);
        } else {
            pair = null;
        }
        return pair;
    }

    @Nullable
    public List<String> getAllWindowIds(@Nullable Object data, @NotNull InspectorClient client) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        if (data instanceof LegacyEvent) {
            return ((LegacyEvent)data).getAllWindows();
        }
        InspectorClient inspectorClient = client;
        if (!(inspectorClient instanceof LegacyClient)) {
            inspectorClient = null;
        }
        LegacyClient legacyClient = (LegacyClient)inspectorClient;
        if (legacyClient == null) {
            return null;
        }
        LegacyClient legacyClient2 = legacyClient;
        Client client2 = legacyClient2.getSelectedClient();
        if (client2 == null) {
            return null;
        }
        Client ddmClient = client2;
        return new ListViewRootsHandler().getWindows(ddmClient, 5L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - void declaration
     */
    @Slow
    private final AndroidWindow capture(InspectorClient client, String windowName, LegacyPropertiesProvider.Updater propertiesUpdater) {
        void rootNode;
        InspectorClient inspectorClient = client;
        if (!(inspectorClient instanceof LegacyClient)) {
            inspectorClient = null;
        }
        LegacyClient legacyClient = (LegacyClient)inspectorClient;
        if (legacyClient == null) {
            return null;
        }
        LegacyClient legacyClient2 = legacyClient;
        Client client2 = legacyClient2.getSelectedClient();
        if (client2 == null) {
            return null;
        }
        Client ddmClient = client2;
        CaptureByteArrayHandler hierarchyHandler = new CaptureByteArrayHandler(DebugViewDumpHandler.CHUNK_VURT);
        ddmClient.dumpViewHierarchy(windowName, false, true, false, (DebugViewDumpHandler)hierarchyHandler);
        ResourceLookup resourceLookup = propertiesUpdater.getLookup().getResourceLookup();
        IDevice iDevice = ddmClient.getDevice();
        Intrinsics.checkNotNullExpressionValue((Object)iDevice, (String)"ddmClient.device");
        resourceLookup.setDpi(iDevice.getDensity());
        byte[] byArray = hierarchyHandler.getData();
        if (byArray == null) {
            return null;
        }
        byte[] hierarchyData = byArray;
        Pair<ViewNode, String> pair = this.parseLiveViewNode(hierarchyData, propertiesUpdater);
        if (pair == null) {
            return null;
        }
        Pair<ViewNode, String> pair2 = pair;
        ViewNode viewNode = (ViewNode)pair2.component1();
        String hash2 = (String)pair2.component2();
        CaptureByteArrayHandler imageHandler = new CaptureByteArrayHandler(DebugViewDumpHandler.CHUNK_VUOP);
        ddmClient.captureView(windowName, hash2, (DebugViewDumpHandler)imageHandler);
        ViewNode.Companion.writeDrawChildren((Function1<? super Function1<? super ViewNode, ? extends List<DrawViewNode>>, Unit>)((Function1)new Function1<Function1<? super ViewNode, ? extends List<DrawViewNode>>, Unit>(imageHandler, (ViewNode)rootNode, client){
            final /* synthetic */ CaptureByteArrayHandler $imageHandler;
            final /* synthetic */ ViewNode $rootNode;
            final /* synthetic */ InspectorClient $client;

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull Function1<? super ViewNode, ? extends List<DrawViewNode>> drawChildren) {
                Intrinsics.checkNotNullParameter(drawChildren, (String)"drawChildren");
                try {
                    byte[] imageData = this.$imageHandler.getData();
                    if (imageData != null) {
                        List list = (List)drawChildren.invoke((Object)this.$rootNode);
                        BufferedImage bufferedImage = ImageIO.read(new ByteArrayInputStream(imageData));
                        Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"ImageIO.read(ByteArrayInputStream(imageData))");
                        list.add(new DrawViewImage(bufferedImage, this.$rootNode));
                    }
                }
                catch (IOException imageData) {
                    // empty catch block
                }
                Sequence<ViewNode> $this$forEach$iv = this.$rootNode.flatten();
                boolean $i$f$forEach = false;
                for (E element$iv : $this$forEach$iv) {
                    void $this$mapTo$iv;
                    ViewNode it = (ViewNode)element$iv;
                    boolean bl = false;
                    Iterable iterable = it.getChildren();
                    Collection destination$iv = (Collection)drawChildren.invoke((Object)it);
                    boolean $i$f$mapTo = false;
                    for (T item$iv : $this$mapTo$iv) {
                        void child;
                        ViewNode viewNode = (ViewNode)item$iv;
                        Collection collection2 = destination$iv;
                        boolean bl2 = false;
                        DrawViewChild drawViewChild = new DrawViewChild((ViewNode)child);
                        collection2.add(drawViewChild);
                    }
                }
                if (((List)drawChildren.invoke((Object)this.$rootNode)).size() != this.$rootNode.getChildren().size()) {
                    this.$client.logEvent(DynamicLayoutInspectorEvent.DynamicLayoutInspectorEventType.COMPATIBILITY_RENDER);
                } else {
                    this.$client.logEvent(DynamicLayoutInspectorEvent.DynamicLayoutInspectorEventType.COMPATIBILITY_RENDER_NO_PICTURE);
                }
            }
            {
                this.$imageHandler = captureByteArrayHandler;
                this.$rootNode = viewNode;
                this.$client = inspectorClient;
                super(1);
            }
        }));
        return new AndroidWindow((ViewNode)rootNode, windowName, LayoutInspectorProto.ComponentTreeEvent.PayloadType.PNG_AS_REQUESTED, 0, null, 24, null);
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    @Nullable
    public final Pair<ViewNode, String> parseLiveViewNode(@NotNull byte[] bytes, @NotNull LegacyPropertiesProvider.Updater propertyUpdater) {
        String line2;
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        Intrinsics.checkNotNullParameter((Object)propertyUpdater, (String)"propertyUpdater");
        Pair<ViewNode, String> rootNodeAndHash = null;
        Pair<ViewNode, String> lastNodeAndHash = null;
        int lastWhitespaceCount = Integer.MIN_VALUE;
        Stack<ViewNode> stack = new Stack<ViewNode>();
        BufferedReader input = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(bytes), Charsets.UTF_8));
        Iterator iterator = ((List)input.lines().collect(MergeNewLineCollector.INSTANCE)).iterator();
        while (iterator.hasNext() && !StringsKt.equals((String)"DONE.", (String)(line2 = (String)iterator.next()), (boolean)true)) {
            int n;
            int whitespaceCount = 0;
            while (line2.charAt(whitespaceCount) == ' ') {
                ++whitespaceCount;
            }
            if (lastWhitespaceCount < whitespaceCount) {
                Pair<ViewNode, String> pair = lastNodeAndHash;
                stack.push(pair != null ? (ViewNode)pair.getFirst() : null);
            } else if (!stack.isEmpty()) {
                int count = lastWhitespaceCount - whitespaceCount;
                int n2 = 0;
                n = count;
                while (n2 < n) {
                    void i2;
                    stack.pop();
                    ++i2;
                }
            }
            lastWhitespaceCount = whitespaceCount;
            ViewNode parent = null;
            if (!stack.isEmpty()) {
                parent = (ViewNode)stack.peek();
            }
            String string = line2;
            n = 0;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            lastNodeAndHash = this.createViewNode(parent, ((Object)StringsKt.trim((CharSequence)string2)).toString(), propertyUpdater);
            if (rootNodeAndHash != null) continue;
            rootNodeAndHash = lastNodeAndHash;
        }
        return rootNodeAndHash;
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<ViewNode, String> createViewNode(ViewNode parent, String data, LegacyPropertiesProvider.Updater propertyLoader) {
        void name;
        void hash2;
        List list;
        Object object = StringsKt.split$default((CharSequence)data, (char[])new char[]{'@'}, (boolean)false, (int)2, (int)2, null);
        List list2 = object;
        boolean bl = false;
        String string = (String)list2.get(0);
        list2 = object;
        bl = false;
        String dataWithoutName = (String)list2.get(1);
        List list3 = list = StringsKt.split$default((CharSequence)dataWithoutName, (char[])new char[]{' '}, (boolean)false, (int)2, (int)2, null);
        boolean bl2 = false;
        object = (String)list3.get(0);
        list3 = list;
        bl2 = false;
        String properties2 = (String)list3.get(1);
        Long l = StringsKt.toLongOrNull((String)hash2, (int)16);
        long hashId = l != null ? l : 0L;
        ViewNode view = new ViewNode(hashId, (String)name, null, 0, 0, 0, 0, null, null, "", 0);
        view.setParent(parent);
        Object object2 = parent;
        if (object2 != null && (object2 = ((ViewNode)object2).getChildren()) != null) {
            object2.add(view);
        }
        propertyLoader.parseProperties(view, properties2);
        return new Pair((Object)view, (Object)((String)name + '@' + (String)hash2));
    }

    private LegacyTreeLoader() {
    }

    static {
        LegacyTreeLoader legacyTreeLoader;
        INSTANCE = legacyTreeLoader = new LegacyTreeLoader();
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\b\u001a\u0004\u0018\u00010\u0007J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/android/tools/idea/layoutinspector/legacydevice/LegacyTreeLoader$CaptureByteArrayHandler;", "Lcom/android/ddmlib/DebugViewDumpHandler;", "type", "", "(I)V", "mData", "Ljava/util/concurrent/atomic/AtomicReference;", "", "getData", "handleViewDebugResult", "", "data", "Ljava/nio/ByteBuffer;", "intellij.android.layout-inspector"})
    private static final class CaptureByteArrayHandler
    extends DebugViewDumpHandler {
        private final AtomicReference<byte[]> mData = new AtomicReference();

        protected void handleViewDebugResult(@NotNull ByteBuffer data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            byte[] b = new byte[data.remaining()];
            data.get(b);
            this.mData.set(b);
        }

        @Nullable
        public final byte[] getData() {
            this.waitForResult(15L, TimeUnit.SECONDS);
            return this.mData.get();
        }

        public CaptureByteArrayHandler(int type) {
            super(type);
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010!\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002 \u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00040\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0005J\u001a\u0010\u0006\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u0003\u0012\u0004\u0012\u00020\u00020\u0007H\u0016J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016J\u0014\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00030\fH\u0016J \u0010\r\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00040\u000eH\u0016J\u0014\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00030\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/idea/layoutinspector/legacydevice/LegacyTreeLoader$MergeNewLineCollector;", "Ljava/util/stream/Collector;", "", "", "", "()V", "accumulator", "Ljava/util/function/BiConsumer;", "characteristics", "", "Ljava/util/stream/Collector$Characteristics;", "combiner", "Ljava/util/function/BinaryOperator;", "finisher", "Ljava/util/function/Function;", "supplier", "Ljava/util/function/Supplier;", "intellij.android.layout-inspector"})
    private static final class MergeNewLineCollector
    implements Collector<String, List<String>, List<? extends String>> {
        @NotNull
        public static final MergeNewLineCollector INSTANCE;

        @Override
        @NotNull
        public Set<Collector.Characteristics> characteristics() {
            return SetsKt.setOf((Object)((Object)Collector.Characteristics.CONCURRENT));
        }

        @Override
        @NotNull
        public Supplier<List<String>> supplier() {
            return supplier.1.INSTANCE;
        }

        @Override
        @NotNull
        public Function<List<String>, List<String>> finisher() {
            return finisher.1.INSTANCE;
        }

        @Override
        @NotNull
        public BinaryOperator<List<String>> combiner() {
            return combiner.1.INSTANCE;
        }

        @Override
        @NotNull
        public BiConsumer<List<String>, String> accumulator() {
            return accumulator.1.INSTANCE;
        }

        private MergeNewLineCollector() {
        }

        static {
            MergeNewLineCollector mergeNewLineCollector;
            INSTANCE = mergeNewLineCollector = new MergeNewLineCollector();
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014R2\u0010\u0003\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/idea/layoutinspector/legacydevice/LegacyTreeLoader$ListViewRootsHandler;", "Lcom/android/ddmlib/DebugViewDumpHandler;", "()V", "viewRoots", "Ljava/util/concurrent/CopyOnWriteArrayList;", "", "kotlin.jvm.PlatformType", "getWindows", "", "c", "Lcom/android/ddmlib/Client;", "timeout", "", "unit", "Ljava/util/concurrent/TimeUnit;", "handleViewDebugResult", "", "data", "Ljava/nio/ByteBuffer;", "intellij.android.layout-inspector"})
    private static final class ListViewRootsHandler
    extends DebugViewDumpHandler {
        private final CopyOnWriteArrayList<String> viewRoots = Lists.newCopyOnWriteArrayList();

        /*
         * WARNING - void declaration
         */
        protected void handleViewDebugResult(@NotNull ByteBuffer data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            int nWindows = data.getInt();
            int n = 0;
            int n2 = nWindows;
            while (n < n2) {
                void i2;
                int len = data.getInt();
                this.viewRoots.add(DebugViewDumpHandler.getString((ByteBuffer)data, (int)len));
                ++i2;
            }
        }

        @Slow
        @NotNull
        public final List<String> getWindows(@NotNull Client c, long timeout, @NotNull TimeUnit unit) throws IOException {
            Intrinsics.checkNotNullParameter((Object)c, (String)"c");
            Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
            c.listViewRoots((DebugViewDumpHandler)this);
            this.waitForResult(timeout, unit);
            CopyOnWriteArrayList<String> copyOnWriteArrayList = this.viewRoots;
            Intrinsics.checkNotNullExpressionValue(copyOnWriteArrayList, (String)"viewRoots");
            return copyOnWriteArrayList;
        }

        public ListViewRootsHandler() {
            super(DebugViewDumpHandler.CHUNK_VULW);
        }
    }
}

