/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.layoutinspector.common;

import com.android.tools.idea.layoutinspector.common.ViewContextMenuFactoryKt;
import com.android.tools.idea.layoutinspector.model.InspectorModel;
import com.android.tools.idea.layoutinspector.model.ViewNode;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import icons.StudioIcons;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.dom.AndroidDomElementDescriptorProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/idea/layoutinspector/common/SelectViewAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "view", "Lcom/android/tools/idea/layoutinspector/model/ViewNode;", "inspectorModel", "Lcom/android/tools/idea/layoutinspector/model/InspectorModel;", "(Lcom/android/tools/idea/layoutinspector/model/ViewNode;Lcom/android/tools/idea/layoutinspector/model/InspectorModel;)V", "getInspectorModel", "()Lcom/android/tools/idea/layoutinspector/model/InspectorModel;", "getView", "()Lcom/android/tools/idea/layoutinspector/model/ViewNode;", "actionPerformed", "", "unused", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.android.layout-inspector"})
final class SelectViewAction
extends AnAction {
    @NotNull
    private final ViewNode view;
    @NotNull
    private final InspectorModel inspectorModel;

    public void actionPerformed(@NotNull AnActionEvent unused) {
        Intrinsics.checkNotNullParameter((Object)unused, (String)"unused");
        this.inspectorModel.setSelection(this.view);
        this.inspectorModel.getStats().selectionMadeFromImage();
    }

    @NotNull
    public final ViewNode getView() {
        return this.view;
    }

    @NotNull
    public final InspectorModel getInspectorModel() {
        return this.inspectorModel;
    }

    public SelectViewAction(@NotNull ViewNode view, @NotNull InspectorModel inspectorModel) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)inspectorModel, (String)"inspectorModel");
        String string = ViewContextMenuFactoryKt.access$generateText(view);
        Icon icon2 = AndroidDomElementDescriptorProvider.getIconForViewTag(view.getUnqualifiedName());
        if (icon2 == null) {
            icon2 = StudioIcons.LayoutEditor.Palette.UNKNOWN_VIEW;
        }
        super(string, null, icon2);
        this.view = view;
        this.inspectorModel = inspectorModel;
    }
}

