/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lang.databinding.validation;

import com.android.tools.idea.databinding.DataBindingMode;
import com.android.tools.idea.databinding.util.DataBindingUtil;
import com.android.tools.idea.lang.databinding.config.DbFile;
import com.android.tools.idea.lang.databinding.model.ModelClassResolvable;
import com.android.tools.idea.lang.databinding.model.ModelClassResolvableKt;
import com.android.tools.idea.lang.databinding.model.PsiModelClass;
import com.android.tools.idea.lang.databinding.psi.PsiDbCallExpr;
import com.android.tools.idea.lang.databinding.psi.PsiDbExpr;
import com.android.tools.idea.lang.databinding.psi.PsiDbFunctionRefExpr;
import com.android.tools.idea.lang.databinding.psi.PsiDbId;
import com.android.tools.idea.lang.databinding.psi.PsiDbInferredFormalParameter;
import com.android.tools.idea.lang.databinding.psi.PsiDbInferredFormalParameterList;
import com.android.tools.idea.lang.databinding.psi.PsiDbLambdaExpression;
import com.android.tools.idea.lang.databinding.psi.PsiDbLambdaParameters;
import com.android.tools.idea.lang.databinding.psi.PsiDbRefExpr;
import com.android.tools.idea.lang.databinding.psi.PsiDbVisitor;
import com.android.tools.idea.lang.databinding.reference.DataBindingXmlAttributeReferenceContributorKt;
import com.android.tools.idea.lang.databinding.reference.PsiFieldReference;
import com.android.tools.idea.lang.databinding.reference.PsiMethodReference;
import com.android.tools.idea.lang.databinding.reference.PsiParameterReference;
import com.android.tools.idea.lang.databinding.reference.XmlVariableReference;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.projectsystem.ScopeType;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AnnotatedElementsSearch;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Query;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 /2\u00020\u00012\u00020\u0002:\u0002./B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J5\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\u0016\u0010\r\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u000f0\u000e\"\u0004\u0018\u00010\u000fH\u0002\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\tH\u0002J \u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\t2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\f0\u001aH\u0002J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\f0\u001a2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\t2\u0006\u0010!\u001a\u00020\fH\u0002J\u001e\u0010\"\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020$2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020$0&H\u0002J\u0010\u0010'\u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\fH\u0002J\u0010\u0010(\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\tH\u0002J\u0016\u0010)\u001a\b\u0012\u0004\u0012\u00020\f0&2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010*\u001a\u00020\u00072\u0006\u0010+\u001a\u00020,H\u0016J\u0010\u0010-\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/android/tools/idea/lang/databinding/validation/DataBindingExpressionAnnotator;", "Lcom/android/tools/idea/lang/databinding/psi/PsiDbVisitor;", "Lcom/intellij/lang/annotation/Annotator;", "()V", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "annotate", "", "element", "Lcom/intellij/psi/PsiElement;", "annotateError", "error", "", "args", "", "", "(Lcom/intellij/psi/PsiElement;Ljava/lang/String;[Ljava/lang/Object;)V", "annotateIfLambdaParameterCountMismatch", "parameters", "Lcom/android/tools/idea/lang/databinding/psi/PsiDbInferredFormalParameterList;", "annotateMethodsWithUnmatchedSignatures", "rootExpression", "findAssignableTypeToBindingExpression", "Lcom/android/tools/idea/lang/databinding/model/PsiModelClass;", "dbExpr", "invertibleMethodNames", "", "getInvertibleMethodNames", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "isLambdaParameter", "", "psiElement", "name", "isMethodMatchingAttribute", "method", "Lcom/intellij/psi/PsiMethod;", "attributeMethods", "", "isViewDataBindingMethod", "matchAttributeTypeWhenAtRoot", "toNames", "visitId", "id", "Lcom/android/tools/idea/lang/databinding/psi/PsiDbId;", "visitInferredFormalParameterList", "AttributeTypeMatcher", "Companion", "intellij.android.lang-databinding"})
public final class DataBindingExpressionAnnotator
extends PsiDbVisitor
implements Annotator {
    private AnnotationHolder holder;
    @NotNull
    public static final String UNRESOLVED_IDENTIFIER = "Cannot find identifier '%s'";
    @NotNull
    public static final String DUPLICATE_CALLBACK_ARGUMENT = "Callback parameter '%s' is not unique";
    @NotNull
    public static final String SETTER_NOT_FOUND = "Cannot find a setter for <%s %s> that accepts parameter type '%s'";
    @NotNull
    public static final String GETTER_NOT_FOUND = "Cannot find a getter for <%s %s> that accepts parameter type '%s'";
    @NotNull
    public static final String ARGUMENT_COUNT_MISMATCH = "Unexpected parameter count. Expected %d, found %d.";
    @NotNull
    public static final String METHOD_SIGNATURE_MISMATCH = "Listener class '%s' with method '%s' did not match signature of any method '%s'";
    @NotNull
    public static final String EXPRESSION_NOT_INVERTIBLE = "The expression '%s' cannot be inverted, so it cannot be used in a two-way binding";
    @NotNull
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void annotate(@NotNull PsiElement element2, @NotNull AnnotationHolder holder) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        try {
            this.holder = holder;
            element2.accept((PsiElementVisitor)this);
            this.matchAttributeTypeWhenAtRoot(element2);
        }
        finally {
            this.holder = null;
        }
    }

    private final void annotateError(PsiElement element2, String error, Object ... args) {
        AnnotationHolder annotationHolder = this.holder;
        Intrinsics.checkNotNull((Object)annotationHolder);
        String string = error;
        Object[] objectArray = Arrays.copyOf(args, args.length);
        boolean bl = false;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(this, *args)");
        annotationHolder.createErrorAnnotation(element2, string2);
    }

    private final void matchAttributeTypeWhenAtRoot(PsiElement rootExpression) {
        Collection $this$firstNotNullResult$iv;
        boolean $i$f$firstNotNullResult;
        Object object;
        List<PsiModelClass> attributeSetterTypes;
        AttributeTypeMatcher attributeMatcher;
        AndroidFacet androidFacet;
        XmlAttribute attribute;
        Object dbExprType;
        block32: {
            block31: {
                Object object2;
                block28: {
                    Object object3;
                    if (!(rootExpression.getParent() instanceof DbFile)) {
                        return;
                    }
                    if (rootExpression instanceof PsiDbLambdaExpression) {
                        return;
                    }
                    PsiReference psiReference = rootExpression.getReference();
                    if (!(psiReference instanceof PsiMethodReference)) {
                        psiReference = null;
                    }
                    PsiMethodReference psiMethodReference = (PsiMethodReference)psiReference;
                    if ((psiMethodReference != null ? psiMethodReference.getKind() : null) == PsiMethodReference.Kind.METHOD_REFERENCE) {
                        this.annotateMethodsWithUnmatchedSignatures(rootExpression);
                        return;
                    }
                    PsiReference psiReference2 = rootExpression.getReference();
                    if (!(psiReference2 instanceof ModelClassResolvable)) {
                        psiReference2 = null;
                    }
                    if ((object3 = (ModelClassResolvable)psiReference2) == null || (object3 = object3.getResolvedType()) == null) {
                        return;
                    }
                    dbExprType = object3;
                    PsiFile psiFile2 = rootExpression.getContainingFile();
                    Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"rootExpression.containingFile");
                    PsiElement psiElement = psiFile2.getContext();
                    Object object4 = psiElement != null ? psiElement.getParent() : null;
                    if (!(object4 instanceof XmlAttribute)) {
                        object4 = null;
                    }
                    XmlAttribute xmlAttribute = (XmlAttribute)object4;
                    if (xmlAttribute == null) {
                        return;
                    }
                    attribute = xmlAttribute;
                    AndroidFacet androidFacet2 = AndroidFacet.getInstance((PsiElement)rootExpression);
                    if (androidFacet2 == null) {
                        return;
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)androidFacet2, (String)"AndroidFacet.getInstance(rootExpression) ?: return");
                    androidFacet = androidFacet2;
                    attributeMatcher = new AttributeTypeMatcher(((PsiModelClass)dbExprType).getType(), androidFacet);
                    attributeSetterTypes = DataBindingXmlAttributeReferenceContributorKt.getAllSetterTypes(attribute);
                    Object $this$parentOfType$iv = attribute;
                    boolean withSelf$iv = false;
                    boolean $i$f$parentOfType22 = false;
                    object = (PsiReference[])PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, XmlTag.class, (boolean)true);
                    if (object == null || (object = object.getReferences()) == null) break block31;
                    $this$parentOfType$iv = object;
                    $i$f$firstNotNullResult = false;
                    void $i$f$parentOfType22 = $this$firstNotNullResult$iv;
                    int n = 0;
                    int n2 = ((void)$i$f$parentOfType22).length;
                    while (n < n2) {
                        Object result$iv;
                        void element$iv = $i$f$parentOfType22[n];
                        ++n;
                        void it = element$iv;
                        boolean bl = false;
                        PsiElement psiElement2 = it.resolve();
                        if (!(psiElement2 instanceof PsiClass)) {
                            psiElement2 = null;
                        }
                        if ((result$iv = (Object)psiElement2) == null) continue;
                        object2 = result$iv;
                        break block28;
                    }
                    object2 = object = null;
                }
                if (object2 != null && (object = object.getName()) != null) break block32;
            }
            object = "view";
        }
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"attribute.parentOfType<X\u2026 ?: SdkConstants.VIEW_TAG");
        Object tagName = object;
        $this$firstNotNullResult$iv = attributeSetterTypes;
        $i$f$firstNotNullResult = false;
        if (!$this$firstNotNullResult$iv.isEmpty()) {
            boolean bl;
            block29: {
                Iterable $this$none$iv = attributeSetterTypes;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        PsiModelClass it = (PsiModelClass)element$iv;
                        boolean bl2 = false;
                        if (!attributeMatcher.matches(it.getUnwrapped().erasure())) continue;
                        bl = false;
                        break block29;
                    }
                    bl = true;
                }
            }
            if (bl) {
                this.annotateError(rootExpression, SETTER_NOT_FOUND, tagName, attribute.getName(), ((PsiModelClass)dbExprType).getType().getCanonicalText());
            }
        }
        String string = attribute.getValue();
        if (string == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"attribute.value ?: return");
        String attributeValue = string;
        if (DataBindingUtil.isTwoWayBindingExpression(attributeValue)) {
            PsiModelClass assignableType = this.findAssignableTypeToBindingExpression(rootExpression, this.getInvertibleMethodNames(androidFacet));
            if (assignableType == null) {
                this.annotateError(rootExpression, EXPRESSION_NOT_INVERTIBLE, rootExpression.getText());
                return;
            }
            List<PsiModelClass> attributeGetterTypes = DataBindingXmlAttributeReferenceContributorKt.getAllGetterTypes(attribute);
            Collection element$iv = attributeGetterTypes;
            boolean it = false;
            if (!element$iv.isEmpty()) {
                boolean bl;
                block30: {
                    Iterable $this$none$iv = attributeGetterTypes;
                    boolean $i$f$none = false;
                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv2 : $this$none$iv) {
                            PsiModelClass attributeType = (PsiModelClass)element$iv2;
                            boolean bl3 = false;
                            if (!assignableType.erasure().getUnwrapped().isAssignableFrom(attributeType)) continue;
                            bl = false;
                            break block30;
                        }
                        bl = true;
                    }
                }
                if (bl) {
                    this.annotateError(rootExpression, GETTER_NOT_FOUND, tagName, attribute.getName(), ((PsiModelClass)dbExprType).getType().getCanonicalText());
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Set<String> getInvertibleMethodNames(AndroidFacet facet2) {
        void $this$forEach$iv;
        Module module2 = facet2.getModule();
        Intrinsics.checkNotNullExpressionValue((Object)module2, (String)"facet.module");
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)module2.getProject());
        DataBindingMode dataBindingMode = DataBindingUtil.getDataBindingMode(facet2);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)dataBindingMode), (String)"DataBindingUtil.getDataBindingMode(facet)");
        DataBindingMode mode = dataBindingMode;
        GlobalSearchScope moduleScope = ProjectSystemUtil.getModuleSystem(facet2).getResolveScope(ScopeType.MAIN);
        PsiClass psiClass = facade.findClass(mode.inverseMethod, moduleScope);
        if (psiClass == null) {
            boolean bl = false;
            return SetsKt.emptySet();
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiClass, (String)"facade.findClass(mode.in\u2026eScope) ?: return setOf()");
        PsiClass inverseMethodAnnotation = psiClass;
        boolean bl = false;
        Set nameSet = new LinkedHashSet();
        Query query = AnnotatedElementsSearch.searchElements((PsiClass)inverseMethodAnnotation, (SearchScope)((SearchScope)moduleScope), (Class[])new Class[]{PsiMethod.class});
        Intrinsics.checkNotNullExpressionValue((Object)query, (String)"AnnotatedElementsSearch.\u2026e, PsiMethod::class.java)");
        Iterable iterable = (Iterable)query;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PsiAnnotation annotation;
            PsiMethod annotatedMethod = (PsiMethod)element$iv;
            boolean bl2 = false;
            Collection collection2 = nameSet;
            PsiMethod psiMethod = annotatedMethod;
            Intrinsics.checkNotNullExpressionValue((Object)psiMethod, (String)"annotatedMethod");
            CollectionsKt.addIfNotNull((Collection)collection2, (Object)psiMethod.getName());
            if (AnnotationUtil.findAnnotation((PsiModifierListOwner)((PsiModifierListOwner)annotatedMethod), (String[])new String[]{mode.inverseMethod}) == null) {
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)annotation, (String)"AnnotationUtil.findAnnot\u2026Method) ?: return@forEach");
            Collection collection3 = nameSet;
            PsiAnnotationMemberValue psiAnnotationMemberValue = annotation.findAttributeValue(null);
            if (!(psiAnnotationMemberValue instanceof PsiLiteralExpression)) {
                psiAnnotationMemberValue = null;
            }
            PsiLiteralExpression psiLiteralExpression = (PsiLiteralExpression)psiAnnotationMemberValue;
            Object object = psiLiteralExpression != null ? psiLiteralExpression.getValue() : null;
            if (!(object instanceof String)) {
                object = null;
            }
            CollectionsKt.addIfNotNull((Collection)collection3, (Object)((String)object));
        }
        return nameSet;
    }

    /*
     * Unable to fully structure code
     */
    private final PsiModelClass findAssignableTypeToBindingExpression(PsiElement dbExpr, Set<String> invertibleMethodNames) {
        block21: {
            block19: {
                block18: {
                    block17: {
                        v0 = dbExpr.getReferences();
                        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"dbExpr.references");
                        $this$firstNotNullResult$iv = v0;
                        $i$f$firstNotNullResult = false;
                        var6_8 = $this$firstNotNullResult$iv;
                        var7_10 = 0;
                        var8_13 = var6_8.length;
                        while (var7_10 < var8_13) {
                            element$iv = var6_8[var7_10];
                            ++var7_10;
                            it = element$iv;
                            $i$a$-firstNotNullResult-DataBindingExpressionAnnotator$findAssignableTypeToBindingExpression$type$1 = false;
                            v1 = it;
                            if (!(it instanceof ModelClassResolvable)) {
                                v1 = null;
                            }
                            v2 = (ModelClassResolvable)v1;
                            result$iv = v2 != null ? v2.getResolvedType() : null;
                            if (result$iv == null) continue;
                            v3 = result$iv;
                            break block17;
                        }
                        v3 = null;
                    }
                    if (v3 == null) {
                        return null;
                    }
                    type = v3;
                    if (type.isLiveData() || type.isObservableField()) {
                        return type.getUnwrapped();
                    }
                    if (!(dbExpr instanceof PsiDbRefExpr)) break block19;
                    v4 = ((PsiDbRefExpr)dbExpr).getReferences();
                    Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"dbExpr.references");
                    $i$f$firstNotNullResult = v4;
                    $i$f$any = false;
                    var7_11 = $this$any$iv;
                    var8_13 = ((void)var7_11).length;
                    for (element$iv = 0; element$iv < var8_13; ++element$iv) {
                        block20: {
                            it = element$iv = var7_11[element$iv];
                            $i$a$-any-DataBindingExpressionAnnotator$findAssignableTypeToBindingExpression$settable$1 = false;
                            v5 = it;
                            if (!(v5 instanceof PsiMethodReference)) {
                                v5 = null;
                            }
                            v6 = v5;
                            if (v6 == null) break block20;
                            v7 = ((PsiDbRefExpr)dbExpr).getId();
                            Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"dbExpr.id");
                            v8 = v7.getText();
                            Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"dbExpr.id.text");
                            if (v6.isSetterReferenceFrom(v8)) ** GOTO lbl-1000
                        }
                        if (it instanceof PsiFieldReference || it instanceof XmlVariableReference) lbl-1000:
                        // 2 sources

                        {
                            v9 = true;
                        } else {
                            v9 = false;
                        }
                        if (!v9) continue;
                        v10 = true;
                        break block18;
                    }
                    v10 = settable = false;
                }
                if (settable) {
                    v11 = ModelClassResolvableKt.toModelClassResolvable(dbExpr);
                    return v11 != null ? v11.getResolvedType() : null;
                }
                break block21;
            }
            if (dbExpr instanceof PsiDbCallExpr) {
                v12 = ((PsiDbCallExpr)dbExpr).getExpressionList();
                if (v12 == null || (v12 = v12.getExprList()) == null) {
                    return null;
                }
                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)"dbExpr.expressionList?.exprList ?: return null");
                parameters = v12;
                v13 = (PsiDbExpr)kotlin.collections.CollectionsKt.lastOrNull((List)parameters);
                if (v13 == null) {
                    return null;
                }
                parameter = v13;
                if (this.findAssignableTypeToBindingExpression(parameter, invertibleMethodNames) == null) {
                    return null;
                }
                v14 = ((PsiDbCallExpr)dbExpr).getReferences();
                Intrinsics.checkNotNullExpressionValue((Object)v14, (String)"dbExpr.references");
                $this$filterIsInstance$iv = v14;
                $i$f$filterIsInstance = false;
                element$iv = $this$filterIsInstance$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterIsInstanceTo = false;
                for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof PsiMethodReference)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                v15 = (PsiMethodReference)kotlin.collections.CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
                if (v15 == null) {
                    return null;
                }
                reference = v15;
                v16 = reference.resolve();
                if (v16 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.intellij.psi.PsiMethod");
                }
                if (invertibleMethodNames.contains(((PsiMethod)v16).getName())) {
                    return reference.getResolvedType();
                }
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final void annotateMethodsWithUnmatchedSignatures(PsiElement rootExpression) {
        Iterator $this$mapNotNullTo$iv$iv;
        Collection $this$mapNotNull$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv;
        boolean bl;
        void $this$mapNotNullTo$iv$iv2;
        void $this$mapNotNull$iv2;
        void $this$filterIsInstanceTo$iv$iv2;
        Iterable $this$filterIsInstance$iv2;
        PsiFile psiFile2 = rootExpression.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"rootExpression.containingFile");
        PsiElement psiElement = psiFile2.getContext();
        Object object = psiElement != null ? psiElement.getParent() : null;
        if (!(object instanceof XmlAttribute)) {
            object = null;
        }
        XmlAttribute xmlAttribute = (XmlAttribute)object;
        if (xmlAttribute == null) {
            return;
        }
        XmlAttribute attribute = xmlAttribute;
        PsiReference[] psiReferenceArray = attribute.getReferences();
        Intrinsics.checkNotNullExpressionValue((Object)psiReferenceArray, (String)"attribute.references");
        PsiReference[] psiReferenceArray2 = psiReferenceArray;
        boolean $i$f$filterIsInstance = false;
        void var6_6 = $this$filterIsInstance$iv2;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv2) {
            if (!(element$iv$iv instanceof PsiParameterReference)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv2 = (List)destination$iv$iv;
        boolean $i$f$mapNotNull22 = false;
        $this$filterIsInstanceTo$iv$iv2 = $this$mapNotNull$iv2;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            PsiMethod psiMethod;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl2 = false;
            PsiParameterReference it = (PsiParameterReference)element$iv$iv;
            boolean bl3 = false;
            if (LambdaUtil.getFunctionalInterfaceMethod((PsiType)it.getResolvedType().getType()) == null) continue;
            boolean bl4 = false;
            bl = false;
            PsiMethod it$iv$iv = psiMethod;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List attributeMethods = (List)destination$iv$iv;
        if (attributeMethods.isEmpty()) {
            return;
        }
        PsiReference[] psiReferenceArray3 = rootExpression.getReferences();
        Intrinsics.checkNotNullExpressionValue((Object)psiReferenceArray3, (String)"rootExpression.references");
        PsiReference[] $i$f$mapNotNull22 = psiReferenceArray3;
        boolean $i$f$filterIsInstance2 = false;
        destination$iv$iv = $this$filterIsInstance$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterIsInstanceTo2 = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof PsiMethodReference)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv2;
        boolean $i$f$mapNotNull = false;
        $this$filterIsInstanceTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo2 = false;
        void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach2 = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv2.iterator();
        while (iterator2.hasNext()) {
            PsiMethod psiMethod;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl6 = false;
            PsiMethodReference it = (PsiMethodReference)element$iv$iv;
            boolean bl7 = false;
            PsiElement psiElement2 = it.resolve();
            if (!(psiElement2 instanceof PsiMethod)) {
                psiElement2 = null;
            }
            if ((PsiMethod)psiElement2 == null) continue;
            bl = false;
            boolean bl8 = false;
            PsiMethod it$iv$iv = psiMethod;
            boolean bl9 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        List dbMethods = (List)destination$iv$iv2;
        $this$mapNotNull$iv = dbMethods;
        $i$f$mapNotNull = false;
        if (!$this$mapNotNull$iv.isEmpty()) {
            boolean bl10;
            block16: {
                Iterable $this$none$iv = dbMethods;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl10 = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        PsiMethod method2 = (PsiMethod)element$iv;
                        boolean bl11 = false;
                        if (!this.isMethodMatchingAttribute(method2, attributeMethods)) continue;
                        bl10 = false;
                        break block16;
                    }
                    bl10 = true;
                }
            }
            if (bl10) {
                String string;
                String string2;
                block17: {
                    void $this$firstNotNullResult$iv;
                    void $this$filterIsInstanceTo$iv$iv3;
                    Iterable $this$filterIsInstance$iv3;
                    Object element$iv;
                    PsiReference[] psiReferenceArray4 = attribute.getReferences();
                    Intrinsics.checkNotNullExpressionValue((Object)psiReferenceArray4, (String)"attribute.references");
                    PsiReference[] $i$f$none = psiReferenceArray4;
                    boolean $i$f$filterIsInstance3 = false;
                    element$iv = $this$filterIsInstance$iv3;
                    Collection destination$iv$iv3 = new ArrayList();
                    boolean $i$f$filterIsInstanceTo3 = false;
                    for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv3) {
                        if (!(element$iv$iv instanceof PsiParameterReference)) continue;
                        destination$iv$iv3.add(element$iv$iv);
                    }
                    $this$filterIsInstance$iv3 = (List)destination$iv$iv3;
                    boolean $i$f$firstNotNullResult = false;
                    for (Object element$iv2 : $this$firstNotNullResult$iv) {
                        PsiParameterReference it = (PsiParameterReference)element$iv2;
                        boolean bl12 = false;
                        String result$iv = it.getResolvedType().getType().getCanonicalText();
                        if (result$iv == null) continue;
                        string2 = result$iv;
                        break block17;
                    }
                    string2 = string = null;
                }
                if (string2 == null) {
                    string = "Listener";
                }
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"attribute.references\n   \u2026nicalText } ?: \"Listener\"");
                String listenerClassName = string;
                Object[] objectArray = new Object[3];
                objectArray[0] = listenerClassName;
                Object e = attributeMethods.get(0);
                Intrinsics.checkNotNullExpressionValue(e, (String)"attributeMethods[0]");
                objectArray[1] = ((PsiMethod)e).getName();
                objectArray[2] = attribute.getName();
                this.annotateError(rootExpression, METHOD_SIGNATURE_MISMATCH, objectArray);
            }
        }
    }

    private final boolean isViewDataBindingMethod(String name) {
        return Intrinsics.areEqual((Object)name, (Object)"safeUnbox");
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> toNames(PsiDbInferredFormalParameterList parameters2) {
        void $this$mapTo$iv$iv;
        List<PsiDbInferredFormalParameter> list = parameters2.getInferredFormalParameterList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"parameters.inferredFormalParameterList");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PsiDbInferredFormalParameter psiDbInferredFormalParameter = (PsiDbInferredFormalParameter)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            void v1 = it;
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"it");
            String string = v1.getText();
            collection2.add(string);
        }
        return (List)destination$iv$iv;
    }

    private final boolean isLambdaParameter(PsiElement psiElement, String name) {
        boolean bl;
        block6: {
            PsiElement element2;
            for (element2 = psiElement; element2 != null && !(element2 instanceof PsiDbLambdaExpression); element2 = element2.getParent()) {
            }
            if (element2 == null) {
                return false;
            }
            PsiDbLambdaParameters psiDbLambdaParameters = ((PsiDbLambdaExpression)element2).getLambdaParameters();
            Intrinsics.checkNotNullExpressionValue((Object)psiDbLambdaParameters, (String)"(element as PsiDbLambdaE\u2026ression).lambdaParameters");
            PsiDbInferredFormalParameterList psiDbInferredFormalParameterList = psiDbLambdaParameters.getInferredFormalParameterList();
            if (psiDbInferredFormalParameterList == null) {
                return false;
            }
            Intrinsics.checkNotNullExpressionValue((Object)psiDbInferredFormalParameterList, (String)"(element as PsiDbLambdaE\u2026meterList ?: return false");
            PsiDbInferredFormalParameterList parameters2 = psiDbInferredFormalParameterList;
            Iterable $this$any$iv = this.toNames(parameters2);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it, (Object)name)) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Override
    public void visitId(@NotNull PsiDbId id) {
        PsiElement parent;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        super.visitId(id);
        PsiElement psiElement = parent = id.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"parent");
        if (psiElement.getReference() != null) {
            return;
        }
        PsiElement psiElement2 = parent;
        if (psiElement2 instanceof PsiDbRefExpr) {
            PsiElement psiElement3 = ((PsiDbRefExpr)parent).getParent();
            if (!(psiElement3 instanceof PsiDbCallExpr)) {
                psiElement3 = null;
            }
            PsiDbCallExpr psiDbCallExpr = (PsiDbCallExpr)psiElement3;
            if ((psiDbCallExpr != null ? psiDbCallExpr.getReference() : null) != null) {
                return;
            }
            PsiDbExpr expr = ((PsiDbRefExpr)parent).getExpr();
            if (expr == null) {
                String string = id.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"id.text");
                if (this.isViewDataBindingMethod(string)) {
                    return;
                }
                PsiElement psiElement4 = id;
                String string2 = id.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"id.text");
                if (this.isLambdaParameter(psiElement4, string2)) {
                    return;
                }
            } else {
                if (expr.getReference() == null) {
                    return;
                }
                Object object = ModelClassResolvableKt.toModelClassResolvable(expr);
                if (object != null && (object = object.getResolvedType()) != null) {
                    if (((PsiModelClass)object).isArray()) {
                        return;
                    }
                }
            }
        } else if (psiElement2 instanceof PsiDbFunctionRefExpr) {
            PsiDbExpr psiDbExpr = ((PsiDbFunctionRefExpr)parent).getExpr();
            Intrinsics.checkNotNullExpressionValue((Object)psiDbExpr, (String)"parent.expr");
            if (psiDbExpr.getReference() == null) {
                return;
            }
        }
        this.annotateError(id, UNRESOLVED_IDENTIFIER, id.getText());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitInferredFormalParameterList(@NotNull PsiDbInferredFormalParameterList parameters2) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)parameters2, (String)"parameters");
        super.visitInferredFormalParameterList(parameters2);
        this.annotateIfLambdaParameterCountMismatch(parameters2);
        List<PsiDbInferredFormalParameter> list = parameters2.getInferredFormalParameterList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"parameters.inferredFormalParameterList");
        Iterable $this$filter$iv = list;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            int n;
            PsiDbInferredFormalParameter parameter = (PsiDbInferredFormalParameter)element$iv$iv;
            boolean bl = false;
            List<PsiDbInferredFormalParameter> list2 = parameters2.getInferredFormalParameterList();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"parameters.inferredFormalParameterList");
            Iterable $this$count$iv = list2;
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    PsiDbInferredFormalParameter it = (PsiDbInferredFormalParameter)element$iv;
                    boolean bl2 = false;
                    PsiDbInferredFormalParameter psiDbInferredFormalParameter = it;
                    Intrinsics.checkNotNullExpressionValue((Object)psiDbInferredFormalParameter, (String)"it");
                    String string = psiDbInferredFormalParameter.getText();
                    PsiDbInferredFormalParameter psiDbInferredFormalParameter2 = parameter;
                    Intrinsics.checkNotNullExpressionValue((Object)psiDbInferredFormalParameter2, (String)"parameter");
                    if (!Intrinsics.areEqual((Object)string, (Object)psiDbInferredFormalParameter2.getText())) continue;
                    int n2 = ++count$iv;
                    boolean bl3 = false;
                    if (n2 >= 0) continue;
                    kotlin.collections.CollectionsKt.throwCountOverflow();
                }
                n = count$iv;
            }
            if (!(n > 1)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PsiDbInferredFormalParameter it = (PsiDbInferredFormalParameter)element$iv;
            boolean bl = false;
            PsiDbInferredFormalParameter psiDbInferredFormalParameter = it;
            Intrinsics.checkNotNullExpressionValue((Object)psiDbInferredFormalParameter, (String)"it");
            this.annotateError(psiDbInferredFormalParameter, DUPLICATE_CALLBACK_ARGUMENT, it.getText());
        }
    }

    private final boolean isMethodMatchingAttribute(PsiMethod method2, List<? extends PsiMethod> attributeMethods) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = attributeMethods;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    PsiMethod attributeMethod = (PsiMethod)element$iv;
                    boolean bl2 = false;
                    if (!MethodSignatureUtil.areErasedParametersEqual((MethodSignature)method2.getSignature(PsiSubstitutor.EMPTY), (MethodSignature)attributeMethod.getSignature(PsiSubstitutor.EMPTY))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final void annotateIfLambdaParameterCountMismatch(PsiDbInferredFormalParameterList parameters2) {
        void $this$filterIsInstanceTo$iv$iv;
        void $this$filterIsInstance$iv;
        int found = parameters2.getInferredFormalParameterList().size();
        if (found == 0) {
            return;
        }
        PsiElement psiElement = parameters2.getParent();
        if (psiElement == null) {
            return;
        }
        PsiElement lambdaParameters = psiElement;
        PsiReference[] psiReferenceArray = lambdaParameters.getReferences();
        Intrinsics.checkNotNullExpressionValue((Object)psiReferenceArray, (String)"lambdaParameters.references");
        PsiReference[] psiReferenceArray2 = psiReferenceArray;
        boolean $i$f$filterIsInstance = false;
        void var7_7 = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof PsiMethodReference)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        PsiMethodReference psiMethodReference = (PsiMethodReference)kotlin.collections.CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
        Object object = psiMethodReference != null ? psiMethodReference.resolve() : null;
        if (!(object instanceof PsiMethod)) {
            object = null;
        }
        PsiMethod psiMethod = (PsiMethod)object;
        if (psiMethod == null) {
            return;
        }
        PsiMethod listenerMethod = psiMethod;
        PsiParameterList psiParameterList = listenerMethod.getParameterList();
        Intrinsics.checkNotNullExpressionValue((Object)psiParameterList, (String)"listenerMethod.parameterList");
        int expected2 = psiParameterList.getParameters().length;
        if (found != expected2) {
            this.annotateError(parameters2, ARGUMENT_COUNT_MISMATCH, expected2, found);
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\tR\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/android/tools/idea/lang/databinding/validation/DataBindingExpressionAnnotator$AttributeTypeMatcher;", "", "dbExprType", "Lcom/intellij/psi/PsiType;", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "(Lcom/intellij/psi/PsiType;Lorg/jetbrains/android/facet/AndroidFacet;)V", "bindingConversionTypes", "", "Lcom/android/tools/idea/lang/databinding/model/PsiModelClass;", "matches", "", "attributeType", "intellij.android.lang-databinding"})
    private static final class AttributeTypeMatcher {
        private final List<PsiModelClass> bindingConversionTypes;

        public final boolean matches(@NotNull PsiModelClass attributeType) {
            boolean bl;
            block3: {
                Intrinsics.checkNotNullParameter((Object)attributeType, (String)"attributeType");
                Iterable $this$any$iv = this.bindingConversionTypes;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        PsiModelClass it = (PsiModelClass)element$iv;
                        boolean bl2 = false;
                        if (!attributeType.isAssignableFrom(it)) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        /*
         * WARNING - void declaration
         */
        public AttributeTypeMatcher(@NotNull PsiType dbExprType, @NotNull AndroidFacet facet2) {
            Intrinsics.checkNotNullParameter((Object)dbExprType, (String)"dbExprType");
            Intrinsics.checkNotNullParameter((Object)facet2, (String)"facet");
            Module module2 = facet2.getModule();
            Intrinsics.checkNotNullExpressionValue((Object)module2, (String)"facet.module");
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)module2.getProject());
            DataBindingMode dataBindingMode = DataBindingUtil.getDataBindingMode(facet2);
            Intrinsics.checkNotNullExpressionValue((Object)((Object)dataBindingMode), (String)"DataBindingUtil.getDataBindingMode(facet)");
            DataBindingMode mode = dataBindingMode;
            GlobalSearchScope moduleScope = ProjectSystemUtil.getModuleSystem(facet2).getResolveScope(ScopeType.MAIN);
            PsiClass bindingConversionAnnotation = facade.findClass(mode.bindingConversion, moduleScope);
            this.bindingConversionTypes = kotlin.collections.CollectionsKt.mutableListOf((Object[])new PsiModelClass[]{new PsiModelClass(dbExprType, mode).getUnwrapped()});
            if (bindingConversionAnnotation != null) {
                void $this$forEach$iv;
                Query query = AnnotatedElementsSearch.searchElements((PsiClass)bindingConversionAnnotation, (SearchScope)((SearchScope)moduleScope), (Class[])new Class[]{PsiMethod.class});
                Intrinsics.checkNotNullExpressionValue((Object)query, (String)"AnnotatedElementsSearch.\u2026e, PsiMethod::class.java)");
                Iterable iterable = (Iterable)query;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    PsiType returnType;
                    PsiMethod annotatedMethod = (PsiMethod)element$iv;
                    boolean bl = false;
                    PsiMethod psiMethod = annotatedMethod;
                    Intrinsics.checkNotNullExpressionValue((Object)psiMethod, (String)"annotatedMethod");
                    PsiParameterList psiParameterList = psiMethod.getParameterList();
                    Intrinsics.checkNotNullExpressionValue((Object)psiParameterList, (String)"annotatedMethod.parameterList");
                    PsiParameter[] parameters2 = psiParameterList.getParameters();
                    if (annotatedMethod.getReturnType() == null) {
                        continue;
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)returnType, (String)"annotatedMethod.returnType ?: return@forEach");
                    if (parameters2.length != 1) continue;
                    PsiParameter psiParameter = parameters2[0];
                    Intrinsics.checkNotNullExpressionValue((Object)psiParameter, (String)"parameters[0]");
                    if (!TypeConversionUtil.erasure((PsiType)psiParameter.getType()).isAssignableFrom(dbExprType)) continue;
                    this.bindingConversionTypes.add(new PsiModelClass(returnType, mode).getUnwrapped());
                }
            }
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/idea/lang/databinding/validation/DataBindingExpressionAnnotator$Companion;", "", "()V", "ARGUMENT_COUNT_MISMATCH", "", "DUPLICATE_CALLBACK_ARGUMENT", "EXPRESSION_NOT_INVERTIBLE", "GETTER_NOT_FOUND", "METHOD_SIGNATURE_MISMATCH", "SETTER_NOT_FOUND", "UNRESOLVED_IDENTIFIER", "intellij.android.lang-databinding"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

