/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lang.databinding.reference;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\t\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u0003H\u0016J\b\u0010\r\u001a\u00020\bH\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000f\u001a\u00020\u000bH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\b\u0010\u0012\u001a\u00020\u0011H\u0016J\n\u0010\u0013\u001a\u0004\u0018\u00010\u0005H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/idea/lang/databinding/reference/PsiPackageReference;", "Lcom/intellij/psi/PsiReference;", "element", "Lcom/intellij/psi/PsiElement;", "target", "Lcom/intellij/psi/PsiPackage;", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/psi/PsiPackage;)V", "textRange", "Lcom/intellij/openapi/util/TextRange;", "bindToElement", "getCanonicalText", "", "getElement", "getRangeInElement", "handleElementRename", "newElementName", "isReferenceTo", "", "isSoft", "resolve", "intellij.android.lang-databinding"})
public final class PsiPackageReference
implements PsiReference {
    private final TextRange textRange;
    private final PsiElement element;
    private final PsiPackage target;

    @NotNull
    public PsiElement getElement() {
        return this.element;
    }

    @NotNull
    public TextRange getRangeInElement() {
        return this.textRange;
    }

    @Nullable
    public PsiPackage resolve() {
        return this.target;
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.element.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"element.text");
        return string;
    }

    @Nullable
    public PsiElement handleElementRename(@NotNull String newElementName) {
        Intrinsics.checkNotNullParameter((Object)newElementName, (String)"newElementName");
        return null;
    }

    @Nullable
    public PsiElement bindToElement(@NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        return null;
    }

    public boolean isReferenceTo(@NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        return element2.getManager().areElementsEquivalent((PsiElement)this.resolve(), element2);
    }

    public boolean isSoft() {
        return false;
    }

    public PsiPackageReference(@NotNull PsiElement element2, @NotNull PsiPackage target) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        this.element = element2;
        this.target = target;
        TextRange textRange = this.element.getTextRange().shiftRight(-this.element.getStartOffsetInParent());
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"element.textRange.shiftR\u2026ment.startOffsetInParent)");
        this.textRange = textRange;
    }
}

