/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lang.databinding.reference;

import com.android.tools.idea.databinding.util.DataBindingUtil;
import com.android.tools.idea.lang.databinding.model.PsiModelClass;
import com.android.tools.idea.lang.databinding.model.PsiModelMethod;
import com.android.tools.idea.lang.databinding.psi.PsiDbCallExpr;
import com.android.tools.idea.lang.databinding.psi.PsiDbFunctionRefExpr;
import com.android.tools.idea.lang.databinding.psi.PsiDbId;
import com.android.tools.idea.lang.databinding.psi.PsiDbLambdaParameters;
import com.android.tools.idea.lang.databinding.psi.PsiDbRefExpr;
import com.android.tools.idea.lang.databinding.reference.DbExprReference;
import com.android.utils.StringHelper;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.impl.light.LightMethodBuilder;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.xml.XmlAttribute;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0001(B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nB\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u000b\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\fB\u001f\b\u0016\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000fB\u0017\b\u0016\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0012B'\b\u0002\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\u0017J\u0012\u0010\"\u001a\u0004\u0018\u00010\u00142\u0006\u0010#\u001a\u00020$H\u0016J\u000e\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020$R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u001bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0016\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!\u00a8\u0006)"}, d2={"Lcom/android/tools/idea/lang/databinding/reference/PsiMethodReference;", "Lcom/android/tools/idea/lang/databinding/reference/DbExprReference;", "expr", "Lcom/android/tools/idea/lang/databinding/psi/PsiDbCallExpr;", "method", "Lcom/android/tools/idea/lang/databinding/model/PsiModelMethod;", "(Lcom/android/tools/idea/lang/databinding/psi/PsiDbCallExpr;Lcom/android/tools/idea/lang/databinding/model/PsiModelMethod;)V", "Lcom/android/tools/idea/lang/databinding/psi/PsiDbRefExpr;", "kind", "Lcom/android/tools/idea/lang/databinding/reference/PsiMethodReference$Kind;", "(Lcom/android/tools/idea/lang/databinding/psi/PsiDbRefExpr;Lcom/android/tools/idea/lang/databinding/model/PsiModelMethod;Lcom/android/tools/idea/lang/databinding/reference/PsiMethodReference$Kind;)V", "Lcom/android/tools/idea/lang/databinding/psi/PsiDbFunctionRefExpr;", "(Lcom/android/tools/idea/lang/databinding/psi/PsiDbFunctionRefExpr;Lcom/android/tools/idea/lang/databinding/model/PsiModelMethod;)V", "attr", "Lcom/intellij/psi/xml/XmlAttribute;", "(Lcom/intellij/psi/xml/XmlAttribute;Lcom/android/tools/idea/lang/databinding/model/PsiModelMethod;Lcom/android/tools/idea/lang/databinding/reference/PsiMethodReference$Kind;)V", "parameters", "Lcom/android/tools/idea/lang/databinding/psi/PsiDbLambdaParameters;", "(Lcom/android/tools/idea/lang/databinding/psi/PsiDbLambdaParameters;Lcom/android/tools/idea/lang/databinding/model/PsiModelMethod;)V", "element", "Lcom/intellij/psi/PsiElement;", "textRange", "Lcom/intellij/openapi/util/TextRange;", "(Lcom/intellij/psi/PsiElement;Lcom/android/tools/idea/lang/databinding/model/PsiModelMethod;Lcom/intellij/openapi/util/TextRange;Lcom/android/tools/idea/lang/databinding/reference/PsiMethodReference$Kind;)V", "getKind", "()Lcom/android/tools/idea/lang/databinding/reference/PsiMethodReference$Kind;", "memberAccess", "Lcom/android/tools/idea/lang/databinding/model/PsiModelClass$MemberAccess;", "getMemberAccess", "()Lcom/android/tools/idea/lang/databinding/model/PsiModelClass$MemberAccess;", "resolvedType", "Lcom/android/tools/idea/lang/databinding/model/PsiModelClass;", "getResolvedType", "()Lcom/android/tools/idea/lang/databinding/model/PsiModelClass;", "handleElementRename", "newElementName", "", "isSetterReferenceFrom", "", "fieldName", "Kind", "intellij.android.lang-databinding"})
public final class PsiMethodReference
extends DbExprReference {
    @Nullable
    private final PsiModelClass resolvedType;
    @NotNull
    private final PsiModelClass.MemberAccess memberAccess;
    @NotNull
    private final Kind kind;

    @Override
    @Nullable
    public PsiModelClass getResolvedType() {
        return this.resolvedType;
    }

    @Override
    @NotNull
    public PsiModelClass.MemberAccess getMemberAccess() {
        return this.memberAccess;
    }

    @Override
    @Nullable
    public PsiElement handleElementRename(@NotNull String newElementName) {
        Intrinsics.checkNotNullParameter((Object)newElementName, (String)"newElementName");
        PsiElement psiElement = this.getElement().findElementAt(this.getRangeInElement().getStartOffset());
        if (!(psiElement instanceof LeafPsiElement)) {
            psiElement = null;
        }
        LeafPsiElement leafPsiElement = (LeafPsiElement)psiElement;
        if (leafPsiElement == null) {
            return null;
        }
        LeafPsiElement identifier = leafPsiElement;
        PsiElement psiElement2 = this.resolve();
        if (!(psiElement2 instanceof PsiMethod)) {
            psiElement2 = null;
        }
        PsiMethod psiMethod = (PsiMethod)psiElement2;
        if (psiMethod == null) {
            return null;
        }
        PsiMethod resolved = psiMethod;
        LightMethodBuilder lightMethod = new LightMethodBuilder(resolved.getManager(), resolved.getLanguage(), newElementName, resolved.getParameterList(), resolved.getModifierList()).setMethodReturnType(resolved.getReturnType());
        String string = DataBindingUtil.stripPrefixFromMethod((PsiMethod)lightMethod);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"stripPrefixFromMethod(lightMethod)");
        String stripped = string;
        identifier.rawReplaceWithText(stripped);
        return (PsiElement)identifier;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isSetterReferenceFrom(@NotNull String fieldName) {
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        if (this.kind != Kind.METHOD_REFERENCE) return false;
        PsiElement psiElement = this.resolve();
        if (psiElement == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.psi.PsiMethod");
        }
        if (!Intrinsics.areEqual((Object)((PsiMethod)psiElement).getName(), (Object)("set" + StringHelper.usLocaleCapitalize((String)fieldName)))) return false;
        return true;
    }

    @NotNull
    public final Kind getKind() {
        return this.kind;
    }

    private PsiMethodReference(PsiElement element2, PsiModelMethod method2, TextRange textRange, Kind kind) {
        super(element2, (PsiElement)method2.getPsiMethod(), textRange);
        this.kind = kind;
        this.resolvedType = this.kind == Kind.METHOD_REFERENCE ? null : method2.getReturnType();
        this.memberAccess = PsiModelClass.MemberAccess.ALL_MEMBERS;
    }

    public PsiMethodReference(@NotNull PsiDbCallExpr expr, @NotNull PsiModelMethod method2) {
        Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
        Intrinsics.checkNotNullParameter((Object)method2, (String)"method");
        PsiElement psiElement = expr;
        PsiDbRefExpr psiDbRefExpr = expr.getRefExpr();
        Intrinsics.checkNotNullExpressionValue((Object)psiDbRefExpr, (String)"expr.refExpr");
        PsiDbId psiDbId = psiDbRefExpr.getId();
        Intrinsics.checkNotNullExpressionValue((Object)psiDbId, (String)"expr.refExpr.id");
        TextRange textRange = psiDbId.getTextRange().shiftLeft(expr.getTextOffset());
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"expr.refExpr.id.textRang\u2026hiftLeft(expr.textOffset)");
        this(psiElement, method2, textRange, Kind.METHOD_CALL);
    }

    public PsiMethodReference(@NotNull PsiDbRefExpr expr, @NotNull PsiModelMethod method2, @NotNull Kind kind) {
        Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
        Intrinsics.checkNotNullParameter((Object)method2, (String)"method");
        Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
        PsiElement psiElement = expr;
        PsiDbId psiDbId = expr.getId();
        Intrinsics.checkNotNullExpressionValue((Object)psiDbId, (String)"expr.id");
        TextRange textRange = psiDbId.getTextRange().shiftLeft(expr.getTextOffset());
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"expr.id.textRange.shiftLeft(expr.textOffset)");
        this(psiElement, method2, textRange, kind);
    }

    public PsiMethodReference(@NotNull PsiDbFunctionRefExpr expr, @NotNull PsiModelMethod method2) {
        Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
        Intrinsics.checkNotNullParameter((Object)method2, (String)"method");
        PsiElement psiElement = expr;
        PsiDbId psiDbId = expr.getId();
        Intrinsics.checkNotNullExpressionValue((Object)psiDbId, (String)"expr.id");
        TextRange textRange = psiDbId.getTextRange().shiftLeft(expr.getTextOffset());
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"expr.id.textRange.shiftLeft(expr.textOffset)");
        this(psiElement, method2, textRange, Kind.METHOD_REFERENCE);
    }

    public PsiMethodReference(@NotNull XmlAttribute attr, @NotNull PsiModelMethod method2, @NotNull Kind kind) {
        Intrinsics.checkNotNullParameter((Object)attr, (String)"attr");
        Intrinsics.checkNotNullParameter((Object)method2, (String)"method");
        Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
        PsiElement psiElement = (PsiElement)attr;
        TextRange textRange = attr.getTextRange().shiftLeft(attr.getTextOffset());
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"attr.textRange.shiftLeft(attr.textOffset)");
        this(psiElement, method2, textRange, kind);
    }

    public PsiMethodReference(@NotNull PsiDbLambdaParameters parameters2, @NotNull PsiModelMethod method2) {
        Intrinsics.checkNotNullParameter((Object)parameters2, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)method2, (String)"method");
        PsiElement psiElement = parameters2;
        TextRange textRange = parameters2.getTextRange().shiftLeft(parameters2.getTextOffset());
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"parameters.textRange.shi\u2026ft(parameters.textOffset)");
        this(psiElement, method2, textRange, Kind.METHOD_REFERENCE);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/android/tools/idea/lang/databinding/reference/PsiMethodReference$Kind;", "", "(Ljava/lang/String;I)V", "METHOD_CALL", "METHOD_REFERENCE", "intellij.android.lang-databinding"})
    public static final class Kind
    extends Enum<Kind> {
        public static final /* enum */ Kind METHOD_CALL;
        public static final /* enum */ Kind METHOD_REFERENCE;
        private static final /* synthetic */ Kind[] $VALUES;

        static {
            Kind[] kindArray = new Kind[2];
            Kind[] kindArray2 = kindArray;
            kindArray[0] = METHOD_CALL = new Kind();
            kindArray[1] = METHOD_REFERENCE = new Kind();
            $VALUES = kindArray;
        }

        public static Kind[] values() {
            return (Kind[])$VALUES.clone();
        }

        public static Kind valueOf(String string) {
            return Enum.valueOf(Kind.class, string);
        }
    }
}

