/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.instantapp;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.ResourceValueImpl;
import com.android.ide.common.resources.ResourceResolver;
import com.android.resources.ResourceType;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.model.MergedManifestManager;
import com.android.tools.lint.checks.AndroidPatternMatcher;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.TreeMultimap;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class InstantAppUrlFinder {
    @NotNull
    private final Collection<Element> myActivities;
    @NotNull
    private final AttributesResolver myResolver;

    public InstantAppUrlFinder(@NotNull Module module2) {
        if (module2 == null) {
            InstantAppUrlFinder.$$$reportNull$$$0(0);
        }
        this(new AttributesResolver(module2), MergedManifestManager.getSnapshot(module2).getActivities());
    }

    @VisibleForTesting
    InstantAppUrlFinder(@NotNull AttributesResolver resolver, @NotNull Collection<Element> activities) {
        if (resolver == null) {
            InstantAppUrlFinder.$$$reportNull$$$0(1);
        }
        if (activities == null) {
            InstantAppUrlFinder.$$$reportNull$$$0(2);
        }
        this.myResolver = resolver;
        this.myActivities = activities;
    }

    @NotNull
    public ImmutableCollection<String> getAllUrls() {
        TreeMultimap allUrls = TreeMultimap.create();
        for (Element activity : this.myActivities) {
            for (Node node2 = activity.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                InstantAppIntentFilterWrapper wrapper = new InstantAppIntentFilterWrapper(this.myResolver, node2);
                UrlData urlData = wrapper.getUrlData();
                if (!urlData.isValid()) continue;
                allUrls.put((Object)wrapper.getOrder(), (Object)urlData.getUrl());
            }
        }
        ImmutableList immutableList = ImmutableList.copyOf((Collection)allUrls.values());
        if (immutableList == null) {
            InstantAppUrlFinder.$$$reportNull$$$0(3);
        }
        return immutableList;
    }

    @NotNull
    public String getDefaultUrl() {
        ImmutableCollection<String> urls = this.getAllUrls();
        if (!urls.isEmpty()) {
            String string = (String)urls.iterator().next();
            if (string == null) {
                InstantAppUrlFinder.$$$reportNull$$$0(4);
            }
            return string;
        }
        return "";
    }

    public boolean matchesUrl(@NotNull String url) {
        if (url == null) {
            InstantAppUrlFinder.$$$reportNull$$$0(5);
        }
        for (Element activity : this.myActivities) {
            for (Node node2 = activity.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                InstantAppIntentFilterWrapper wrapper = new InstantAppIntentFilterWrapper(this.myResolver, node2);
                if (!wrapper.matchesUrl(url)) continue;
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolver";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activities";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/instantapp/InstantAppUrlFinder";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/instantapp/InstantAppUrlFinder";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllUrls";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultUrl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "matchesUrl";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @VisibleForTesting
    static class AttributesResolver {
        @Nullable
        private final ResourceResolver myResourceResolver;

        private AttributesResolver(@NotNull Module module2) {
            if (module2 == null) {
                AttributesResolver.$$$reportNull$$$0(0);
            }
            List<VirtualFile> manifestFiles = MergedManifestManager.getSnapshot(module2).getManifestFiles();
            this.myResourceResolver = manifestFiles == null || manifestFiles.isEmpty() ? null : ConfigurationManager.getOrCreateInstance(module2).getConfiguration(manifestFiles.get(0)).getResourceResolver();
        }

        @Nullable
        String resolveResource(@NotNull String name, @Nullable String value2) {
            if (name == null) {
                AttributesResolver.$$$reportNull$$$0(1);
            }
            if (this.myResourceResolver == null) {
                return value2;
            }
            ResourceValue resolvedResource = this.myResourceResolver.resolveResValue((ResourceValue)new ResourceValueImpl(ResourceNamespace.RES_AUTO, ResourceType.STRING, name, value2));
            return resolvedResource == null ? value2 : resolvedResource.getValue();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/instantapp/InstantAppUrlFinder$AttributesResolver";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "resolveResource";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    @VisibleForTesting
    static class UrlData {
        @NotNull
        private AttributesResolver myResolver;
        @NotNull
        private final Collection<String> mySchemes;
        @NotNull
        private final Collection<String> myHosts;
        @NotNull
        private final Collection<String> myPaths;
        @NotNull
        private final Collection<String> myPathPrefixes;
        @NotNull
        private final Collection<String> myPathPatterns;

        @VisibleForTesting
        UrlData(@NotNull AttributesResolver resolver) {
            if (resolver == null) {
                UrlData.$$$reportNull$$$0(0);
            }
            this.mySchemes = new HashSet<String>();
            this.myHosts = new HashSet<String>();
            this.myPaths = new HashSet<String>();
            this.myPathPrefixes = new HashSet<String>();
            this.myPathPatterns = new HashSet<String>();
            this.myResolver = resolver;
        }

        @VisibleForTesting
        void addFromStrings(@NotNull String scheme, @NotNull String host, @NotNull String path2, @NotNull String pathPrefix, @NotNull String pathPattern) {
            if (scheme == null) {
                UrlData.$$$reportNull$$$0(1);
            }
            if (host == null) {
                UrlData.$$$reportNull$$$0(2);
            }
            if (path2 == null) {
                UrlData.$$$reportNull$$$0(3);
            }
            if (pathPrefix == null) {
                UrlData.$$$reportNull$$$0(4);
            }
            if (pathPattern == null) {
                UrlData.$$$reportNull$$$0(5);
            }
            UrlData.addTo(this.mySchemes, scheme);
            UrlData.addTo(this.myHosts, host);
            UrlData.addTo(this.myPaths, path2);
            UrlData.addTo(this.myPathPrefixes, pathPrefix);
            UrlData.addTo(this.myPathPatterns, pathPattern);
        }

        @VisibleForTesting
        void addFromNode(@NotNull Node node2) {
            if (node2 == null) {
                UrlData.$$$reportNull$$$0(6);
            }
            if (node2.getNodeType() == 1 && "data".equals(node2.getNodeName())) {
                Element element2 = (Element)node2;
                UrlData.addTo(this.mySchemes, this.myResolver.resolveResource("scheme", element2.getAttributeNS("http://schemas.android.com/apk/res/android", "scheme")));
                UrlData.addTo(this.myHosts, this.myResolver.resolveResource("host", element2.getAttributeNS("http://schemas.android.com/apk/res/android", "host")));
                UrlData.addTo(this.myPaths, this.myResolver.resolveResource("path", element2.getAttributeNS("http://schemas.android.com/apk/res/android", "path")));
                UrlData.addTo(this.myPathPrefixes, this.myResolver.resolveResource("pathPrefix", element2.getAttributeNS("http://schemas.android.com/apk/res/android", "pathPrefix")));
                UrlData.addTo(this.myPathPatterns, this.myResolver.resolveResource("pathPattern", element2.getAttributeNS("http://schemas.android.com/apk/res/android", "pathPattern")));
            }
        }

        private static void addTo(@NotNull Collection<String> collection2, @Nullable String string) {
            if (collection2 == null) {
                UrlData.$$$reportNull$$$0(7);
            }
            if (StringUtil.isNotEmpty((String)string)) {
                collection2.add(string);
            }
        }

        @NotNull
        @VisibleForTesting
        static String convertPatternToExample(@NotNull String pattern) {
            if (pattern == null) {
                UrlData.$$$reportNull$$$0(8);
            }
            String string = pattern.replace(".*", "example");
            if (string == null) {
                UrlData.$$$reportNull$$$0(9);
            }
            return string;
        }

        @VisibleForTesting
        boolean isValid() {
            return !this.mySchemes.isEmpty() && !this.myHosts.isEmpty() && this.getEffectivePath().startsWith("/");
        }

        @NotNull
        private String getEffectivePath() {
            String path2;
            String string = path2 = this.myPaths.isEmpty() ? "" : this.myPaths.iterator().next();
            if (StringUtil.isEmpty((String)path2)) {
                String string2 = path2 = this.myPathPrefixes.isEmpty() ? "" : this.myPathPrefixes.iterator().next() + "/.*";
            }
            if (StringUtil.isEmpty((String)path2)) {
                path2 = this.myPathPatterns.isEmpty() ? "" : this.myPathPatterns.iterator().next();
            }
            return StringUtil.isNotEmpty((String)path2) ? path2 : "/";
        }

        @NotNull
        @VisibleForTesting
        String getUrl() {
            if (!this.isValid()) {
                return "";
            }
            String scheme = this.mySchemes.iterator().next();
            String host = this.myHosts.iterator().next();
            String string = String.format("%s://%s%s", scheme, host, UrlData.convertPatternToExample(this.getEffectivePath()));
            if (string == null) {
                UrlData.$$$reportNull$$$0(10);
            }
            return string;
        }

        @VisibleForTesting
        boolean matchesUrl(@NotNull String url) {
            if (url == null) {
                UrlData.$$$reportNull$$$0(11);
            }
            if (!this.isValid()) {
                return false;
            }
            boolean schemeMatched = false;
            for (String scheme : this.mySchemes) {
                if (!url.startsWith(scheme + "://")) continue;
                url = url.replaceFirst(scheme + "://", "");
                schemeMatched = true;
                break;
            }
            if (!schemeMatched) {
                return false;
            }
            boolean hostMatched = false;
            for (String host : this.myHosts) {
                if (!url.startsWith(host)) continue;
                url = url.replaceFirst(host, "");
                hostMatched = true;
                break;
            }
            if (!hostMatched) {
                return false;
            }
            for (String path2 : this.myPaths) {
                if (!StringUtil.isNotEmpty((String)path2) || !new AndroidPatternMatcher(path2, 0).match(url)) continue;
                return true;
            }
            for (String pathPrefix : this.myPathPrefixes) {
                if (!StringUtil.isNotEmpty((String)pathPrefix) || !new AndroidPatternMatcher(pathPrefix, 1).match(url)) continue;
                return true;
            }
            for (String pathPattern : this.myPathPatterns) {
                if (!StringUtil.isNotEmpty((String)pathPattern) || !new AndroidPatternMatcher(pathPattern, 2).match(url)) continue;
                return true;
            }
            if (!(this.myPaths.isEmpty() && this.myPathPrefixes.isEmpty() && this.myPathPatterns.isEmpty())) {
                return false;
            }
            return url.isEmpty() || url.compareTo("/") == 0;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 9: 
                case 10: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 9: 
                case 10: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resolver";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scheme";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "host";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pathPrefix";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pathPattern";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "collection";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pattern";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/instantapp/InstantAppUrlFinder$UrlData";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "url";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/instantapp/InstantAppUrlFinder$UrlData";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "convertPatternToExample";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUrl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "addFromStrings";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "addFromNode";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "addTo";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "convertPatternToExample";
                    break;
                }
                case 9: 
                case 10: {
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "matchesUrl";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 9: 
                case 10: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    @VisibleForTesting
    static class InstantAppIntentFilterWrapper {
        @NotNull
        AttributesResolver myResolver;
        @Nullable
        private final Element myElement;
        private final int myOrder;

        @VisibleForTesting
        InstantAppIntentFilterWrapper(@NotNull AttributesResolver resolver, @NotNull Node node2) {
            int order;
            Element element2;
            if (resolver == null) {
                InstantAppIntentFilterWrapper.$$$reportNull$$$0(0);
            }
            if (node2 == null) {
                InstantAppIntentFilterWrapper.$$$reportNull$$$0(1);
            }
            try {
                element2 = InstantAppIntentFilterWrapper.getElement(node2);
                order = InstantAppIntentFilterWrapper.getOrder(element2);
            }
            catch (IllegalArgumentException unused) {
                element2 = null;
                order = -1;
            }
            this.myElement = element2;
            this.myOrder = order;
            this.myResolver = resolver;
        }

        @NotNull
        @VisibleForTesting
        static Element getElement(@NotNull Node node2) {
            if (node2 == null) {
                InstantAppIntentFilterWrapper.$$$reportNull$$$0(2);
            }
            if (node2.getNodeType() == 1 && "intent-filter".equals(node2.getNodeName())) {
                Element element2 = (Element)node2;
                if (element2 == null) {
                    InstantAppIntentFilterWrapper.$$$reportNull$$$0(3);
                }
                return element2;
            }
            throw new IllegalArgumentException();
        }

        @VisibleForTesting
        static int getOrder(@NotNull Element element2) {
            String orderValue;
            if (element2 == null) {
                InstantAppIntentFilterWrapper.$$$reportNull$$$0(4);
            }
            if (StringUtil.isNotEmpty((String)(orderValue = element2.getAttributeNS("http://schemas.android.com/apk/res/android", "order")))) {
                try {
                    return Integer.parseUnsignedInt(orderValue);
                }
                catch (NumberFormatException unused) {
                    throw new IllegalArgumentException();
                }
            }
            return 0;
        }

        @NotNull
        UrlData getUrlData() {
            UrlData urlData = new UrlData(this.myResolver);
            if (this.myElement != null) {
                for (Node node2 = this.myElement.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                    urlData.addFromNode(node2);
                }
            }
            UrlData urlData2 = urlData;
            if (urlData2 == null) {
                InstantAppIntentFilterWrapper.$$$reportNull$$$0(5);
            }
            return urlData2;
        }

        int getOrder() {
            return this.myOrder;
        }

        boolean matchesUrl(@NotNull String url) {
            if (url == null) {
                InstantAppIntentFilterWrapper.$$$reportNull$$$0(6);
            }
            return this.getUrlData().matchesUrl(url);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resolver";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/instantapp/InstantAppUrlFinder$InstantAppIntentFilterWrapper";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "url";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/instantapp/InstantAppUrlFinder$InstantAppIntentFilterWrapper";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getElement";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUrlData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getElement";
                    break;
                }
                case 3: 
                case 5: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getOrder";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "matchesUrl";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

