/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.variant.view;

import com.android.tools.idea.gradle.project.facet.ndk.NdkFacet;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.model.NdkModuleModel;
import com.android.tools.idea.gradle.project.model.VariantAbi;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.ModuleTypeComparator;
import com.android.tools.idea.gradle.variant.conflict.Conflict;
import com.android.tools.idea.gradle.variant.conflict.ConflictResolution;
import com.android.tools.idea.gradle.variant.conflict.ConflictSet;
import com.android.tools.idea.gradle.variant.view.BuildVariantUpdater;
import com.android.tools.idea.model.AndroidModel;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.CommonBundle;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.serviceContainer.NonInjectable;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.TableUtil;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.table.JBTable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.AbstractTableCellEditor;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildVariantView {
    private static final Object[] TABLE_COLUMN_NAMES_WITHOUT_ABI = new Object[]{"Module", "Active Build Variant"};
    private static final Object[] TABLE_COLUMN_NAMES_WITH_ABI = new Object[]{"Module", "Active Build Variant", "Active ABI"};
    private static final int MODULE_COLUMN_INDEX = 0;
    private static final int VARIANT_COLUMN_INDEX = 1;
    private static final int ABI_COLUMN_INDEX = 2;
    private static final Color CONFLICT_CELL_BACKGROUND = MessageType.ERROR.getPopupBackground();
    private final Project myProject;
    private BuildVariantUpdater myUpdater;
    private JPanel myToolWindowPanel;
    private JBTable myVariantsTable;
    private JPanel myNotificationPanel;
    private final List<Conflict> myConflicts;
    private boolean previousModelHadAbis;

    @NotNull
    public static BuildVariantView getInstance(@NotNull Project project) {
        if (project == null) {
            BuildVariantView.$$$reportNull$$$0(0);
        }
        BuildVariantView buildVariantView = (BuildVariantView)project.getService(BuildVariantView.class);
        if (buildVariantView == null) {
            BuildVariantView.$$$reportNull$$$0(1);
        }
        return buildVariantView;
    }

    public BuildVariantView(@NotNull Project project) {
        if (project == null) {
            BuildVariantView.$$$reportNull$$$0(2);
        }
        this(project, BuildVariantUpdater.getInstance(project));
    }

    @NonInjectable
    @VisibleForTesting
    public BuildVariantView(@NotNull Project project, @NotNull BuildVariantUpdater updater) {
        if (project == null) {
            BuildVariantView.$$$reportNull$$$0(3);
        }
        if (updater == null) {
            BuildVariantView.$$$reportNull$$$0(4);
        }
        this.$$$setupUI$$$();
        this.myConflicts = new ArrayList<Conflict>();
        this.previousModelHadAbis = false;
        this.myProject = project;
        this.myUpdater = updater;
        this.myUpdater.addSelectionChangeListener(this::invokeListeners);
        ((JComponent)this.myVariantsTable.getParent().getParent()).setBorder((Border)JBUI.Borders.empty());
    }

    private void createUIComponents() {
        this.myVariantsTable = new BuildVariantTable();
        new TableSpeedSearch((JTable)this.myVariantsTable);
        this.myNotificationPanel = new NotificationPanel();
        this.myNotificationPanel.setVisible(false);
    }

    public void createToolWindowContent(@NotNull ToolWindow toolWindow) {
        if (toolWindow == null) {
            BuildVariantView.$$$reportNull$$$0(5);
        }
        ContentFactory contentFactory = ContentFactory.SERVICE.getInstance();
        Content content2 = contentFactory.createContent((JComponent)this.myToolWindowPanel, "", false);
        toolWindow.getContentManager().addContent(content2);
        this.updateContents();
    }

    public void updateContents() {
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        ArrayList<BuildVariantItem[]> buildVariantsPerRow = new ArrayList<BuildVariantItem[]>();
        ArrayList<AbiItem[]> abisPerRow = new ArrayList<AbiItem[]>();
        int rowId = 0;
        for (Module module2 : this.getGradleModulesWithAndroidProjects()) {
            String abiName;
            String variantNameWithoutAbi;
            NdkModuleModel ndkModel;
            AndroidFacet androidFacet = AndroidFacet.getInstance((Module)module2);
            NdkFacet ndkFacet = NdkFacet.getInstance(module2);
            assert (androidFacet != null || ndkFacet != null);
            NdkModuleModel ndkModuleModel = ndkModel = ndkFacet == null ? null : BuildVariantView.getNdkModuleModelIfNotJustDummy(ndkFacet);
            if (ndkModel != null) {
                VariantAbi variantAbi = ndkFacet.getSelectedVariantAbi();
                if (variantAbi == null) {
                    variantNameWithoutAbi = "---";
                    abiName = "--";
                } else {
                    variantNameWithoutAbi = variantAbi.getVariant();
                    abiName = variantAbi.getAbi();
                }
            } else {
                assert (androidFacet != null);
                variantNameWithoutAbi = androidFacet.getProperties().SELECTED_BUILD_VARIANT;
                abiName = "";
            }
            BuildVariantItem[] buildVariantItems = BuildVariantView.getBuildVariantItems(module2);
            if (buildVariantItems.length > 0) {
                buildVariantsPerRow.add(rowId, buildVariantItems);
            } else {
                buildVariantsPerRow.add(rowId, null);
            }
            AbiItem[] abiItems = BuildVariantView.getAbiItems(module2, variantNameWithoutAbi);
            if (abiItems.length > 0) {
                abisPerRow.add(rowId, abiItems);
            } else {
                abisPerRow.add(rowId, null);
            }
            Object[] row = new Object[]{module2, variantNameWithoutAbi, abiName};
            rows.add(row);
            ++rowId;
        }
        Runnable setModelTask = () -> this.getVariantsTable().setModel(rows, buildVariantsPerRow, abisPerRow);
        Application application = ApplicationManager.getApplication();
        if (application.isDispatchThread()) {
            setModelTask.run();
        } else {
            application.invokeLater(setModelTask);
        }
    }

    public void projectImportStarted() {
        this.getVariantsTable().setLoading(true);
    }

    @NotNull
    private List<Module> getGradleModulesWithAndroidProjects() {
        ArrayList<Module> gradleModules = new ArrayList<Module>();
        for (Module module2 : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            AndroidFacet androidFacet = AndroidFacet.getInstance((Module)module2);
            if (androidFacet != null && AndroidModel.isRequired(androidFacet) && AndroidModel.get(androidFacet) != null) {
                gradleModules.add(module2);
                continue;
            }
            NdkFacet ndkFacet = NdkFacet.getInstance(module2);
            if (ndkFacet == null || BuildVariantView.getNdkModuleModelIfNotJustDummy(ndkFacet) == null) continue;
            gradleModules.add(module2);
        }
        if (!gradleModules.isEmpty()) {
            gradleModules.sort(ModuleTypeComparator.INSTANCE);
            ArrayList<Module> arrayList = gradleModules;
            if (arrayList == null) {
                BuildVariantView.$$$reportNull$$$0(6);
            }
            return arrayList;
        }
        List<Module> list = Collections.emptyList();
        if (list == null) {
            BuildVariantView.$$$reportNull$$$0(7);
        }
        return list;
    }

    @NotNull
    private BuildVariantTable getVariantsTable() {
        BuildVariantTable buildVariantTable = (BuildVariantTable)this.myVariantsTable;
        if (buildVariantTable == null) {
            BuildVariantView.$$$reportNull$$$0(8);
        }
        return buildVariantTable;
    }

    @NotNull
    private static BuildVariantItem[] getBuildVariantItems(@NotNull Module module2) {
        if (module2 == null) {
            BuildVariantView.$$$reportNull$$$0(9);
        }
        Collection<String> variantNames = BuildVariantView.getVariantNames(module2);
        Object[] items2 = new BuildVariantItem[variantNames.size()];
        int i2 = 0;
        for (String name : variantNames) {
            items2[i2++] = new BuildVariantItem(module2.getName(), name);
        }
        Arrays.sort(items2);
        if (items2 == null) {
            BuildVariantView.$$$reportNull$$$0(10);
        }
        return items2;
    }

    @NotNull
    private static Collection<String> getVariantNames(@NotNull Module module2) {
        NdkModuleModel ndkModuleModel;
        if (module2 == null) {
            BuildVariantView.$$$reportNull$$$0(11);
        }
        HashSet<String> buildVariantNames = new HashSet<String>();
        AndroidModuleModel androidModel = AndroidModuleModel.get(module2);
        if (androidModel != null) {
            buildVariantNames.addAll(androidModel.getVariantNames());
        }
        if ((ndkModuleModel = BuildVariantView.getNdkModuleModelIfNotJustDummy(module2)) != null) {
            buildVariantNames.addAll(ContainerUtil.map(ndkModuleModel.getAllVariantAbis(), VariantAbi::getVariant));
        }
        HashSet<String> hashSet = buildVariantNames;
        if (hashSet == null) {
            BuildVariantView.$$$reportNull$$$0(12);
        }
        return hashSet;
    }

    @NotNull
    private static AbiItem[] getAbiItems(@NotNull Module module2, @NotNull String variantNameWithoutAbi) {
        if (module2 == null) {
            BuildVariantView.$$$reportNull$$$0(13);
        }
        if (variantNameWithoutAbi == null) {
            BuildVariantView.$$$reportNull$$$0(14);
        }
        Collection<String> variantNames = BuildVariantView.getAbiNames(module2, variantNameWithoutAbi);
        Object[] items2 = new AbiItem[variantNames.size()];
        int i2 = 0;
        for (String name : variantNames) {
            items2[i2++] = new AbiItem(module2.getName(), name);
        }
        Arrays.sort(items2);
        if (items2 == null) {
            BuildVariantView.$$$reportNull$$$0(15);
        }
        return items2;
    }

    @NotNull
    private static Collection<String> getAbiNames(@NotNull Module module2, @NotNull String variantNameWithoutAbi) {
        NdkModuleModel ndkModuleModel;
        if (module2 == null) {
            BuildVariantView.$$$reportNull$$$0(16);
        }
        if (variantNameWithoutAbi == null) {
            BuildVariantView.$$$reportNull$$$0(17);
        }
        if ((ndkModuleModel = BuildVariantView.getNdkModuleModelIfNotJustDummy(module2)) == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                BuildVariantView.$$$reportNull$$$0(18);
            }
            return list;
        }
        Collection<VariantAbi> allVariantAbis = ndkModuleModel.getAllVariantAbis();
        Collection collection2 = allVariantAbis.stream().filter(variantAbi -> variantAbi.getVariant().equals(variantNameWithoutAbi)).map(VariantAbi::getAbi).collect(Collectors.toList());
        if (collection2 == null) {
            BuildVariantView.$$$reportNull$$$0(19);
        }
        return collection2;
    }

    public void updateContents(@NotNull List<Conflict> conflicts) {
        if (conflicts == null) {
            BuildVariantView.$$$reportNull$$$0(20);
        }
        this.myNotificationPanel.setVisible(!conflicts.isEmpty());
        ((NotificationPanel)this.myNotificationPanel).myCurrentConflictIndex = -1;
        this.myConflicts.clear();
        this.myConflicts.addAll(conflicts);
        this.updateContents();
    }

    public void findAndSelect(@NotNull Module module2) {
        if (module2 == null) {
            BuildVariantView.$$$reportNull$$$0(21);
        }
        this.findAndSelect(module2, 0);
    }

    public void findAndSelectVariantEditor(@NotNull Module module2) {
        if (module2 == null) {
            BuildVariantView.$$$reportNull$$$0(22);
        }
        this.findAndSelect(module2, 1);
    }

    private void findAndSelect(@NotNull Module module2, int columnIndex) {
        if (module2 == null) {
            BuildVariantView.$$$reportNull$$$0(23);
        }
        int rowCount = this.myVariantsTable.getRowCount();
        for (int row = 0; row < rowCount; ++row) {
            if (!module2.equals(this.myVariantsTable.getValueAt(row, 0))) continue;
            this.myVariantsTable.getSelectionModel().setSelectionInterval(row, row);
            this.myVariantsTable.getColumnModel().getSelectionModel().setSelectionInterval(columnIndex, columnIndex);
            TableUtil.scrollSelectionToVisible((JTable)this.myVariantsTable);
            this.myVariantsTable.requestFocusInWindow();
            break;
        }
    }

    private void invokeListeners() {
        Application application = ApplicationManager.getApplication();
        if (application.isUnitTestMode()) {
            this.updateContents();
        } else {
            application.invokeLater(this::updateContents);
        }
    }

    @Nullable
    private static NdkModuleModel getNdkModuleModelIfNotJustDummy(@NotNull NdkFacet ndkFacet) {
        NdkModuleModel ndkModel;
        if (ndkFacet == null) {
            BuildVariantView.$$$reportNull$$$0(24);
        }
        if ((ndkModel = NdkModuleModel.get(ndkFacet)) == null || ndkFacet.getSelectedVariantAbi() == null) {
            return null;
        }
        return ndkModel;
    }

    @Nullable
    private static NdkModuleModel getNdkModuleModelIfNotJustDummy(@NotNull Module module2) {
        NdkFacet ndkFacet;
        if (module2 == null) {
            BuildVariantView.$$$reportNull$$$0(25);
        }
        if ((ndkFacet = NdkFacet.getInstance(module2)) == null) {
            return null;
        }
        return BuildVariantView.getNdkModuleModelIfNotJustDummy(ndkFacet);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 15: 
            case 18: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 15: 
            case 18: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 15: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/variant/view/BuildVariantView";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindow";
                break;
            }
            case 9: 
            case 11: 
            case 13: 
            case 16: 
            case 21: 
            case 22: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variantNameWithoutAbi";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conflicts";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ndkFacet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/variant/view/BuildVariantView";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getGradleModulesWithAndroidProjects";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariantsTable";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildVariantItems";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariantNames";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getAbiItems";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getAbiNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 15: 
            case 18: 
            case 19: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createToolWindowContent";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getBuildVariantItems";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getVariantNames";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getAbiItems";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getAbiNames";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "updateContents";
                break;
            }
            case 21: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "findAndSelect";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "findAndSelectVariantEditor";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getNdkModuleModelIfNotJustDummy";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 15: 
            case 18: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        this.createUIComponents();
        this.myToolWindowPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, new GridConstraints(1, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        JBTable jBTable = this.myVariantsTable;
        jBTable.setCellSelectionEnabled(true);
        jBScrollPane.setViewportView((Component)jBTable);
        JPanel jPanel2 = this.myNotificationPanel;
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 1, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myToolWindowPanel;
    }

    private static class ModuleTableCell
    extends AbstractTableCellEditor
    implements TableCellRenderer {
        private static final Border EMPTY_BORDER = JBUI.Borders.empty((int)1);
        @Nullable
        private Conflict myConflict;
        private JPanel myPanel;
        private JLabel myModuleNameLabel = new JLabel();
        private JPanel myButtonsPanel;
        private JButton myFixButton;
        private Object myValue;

        ModuleTableCell() {
            this.myModuleNameLabel.setOpaque(false);
            this.myFixButton = ModuleTableCell.createButton(AllIcons.Actions.QuickfixBulb);
            this.myFixButton.setToolTipText("Fix problem");
            this.myFixButton.addActionListener(e -> {
                if (this.myConflict != null) {
                    Project project = this.myConflict.getSource().getProject();
                    boolean solved = ConflictResolution.solveSelectionConflict(this.myConflict);
                    if (solved) {
                        ConflictSet conflicts = ConflictSet.findConflicts(project);
                        conflicts.showSelectionConflicts();
                    }
                }
                this.stopCellEditing();
            });
            this.myButtonsPanel = new JPanel();
            this.myButtonsPanel.setOpaque(false);
            this.myButtonsPanel.add(this.myFixButton);
            this.myPanel = new JPanel(new BorderLayout()){

                @Override
                public String getToolTipText(MouseEvent e) {
                    String toolTip = ModuleTableCell.getToolTipTextIfUnderX(myModuleNameLabel, e.getX());
                    if (toolTip != null) {
                        return toolTip;
                    }
                    int x = e.getX() - myButtonsPanel.getX();
                    toolTip = ModuleTableCell.getToolTipTextIfUnderX(myFixButton, x);
                    if (toolTip != null) {
                        return toolTip;
                    }
                    return super.getToolTipText(e);
                }
            };
            this.myPanel.add((Component)this.myModuleNameLabel, "Center");
            this.myPanel.add((Component)this.myButtonsPanel, "East");
        }

        @NotNull
        private static JButton createButton(@NotNull Icon icon2) {
            if (icon2 == null) {
                ModuleTableCell.$$$reportNull$$$0(0);
            }
            JButton button2 = new JButton(icon2);
            button2.setBorder(null);
            button2.setBorderPainted(false);
            button2.setContentAreaFilled(false);
            JButton jButton = button2;
            if (jButton == null) {
                ModuleTableCell.$$$reportNull$$$0(1);
            }
            return jButton;
        }

        @Nullable
        private static String getToolTipTextIfUnderX(@NotNull JComponent c, int x) {
            if (c == null) {
                ModuleTableCell.$$$reportNull$$$0(2);
            }
            if (c.isVisible() && x >= c.getX() && x <= c.getX() + c.getWidth()) {
                return c.getToolTipText();
            }
            return null;
        }

        public Component getTableCellEditorComponent(JTable table2, Object value2, boolean isSelected, int row, int column) {
            this.setUpComponent(table2, value2, true, true, row);
            return this.myPanel;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table2, Object value2, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setUpComponent(table2, value2, isSelected, hasFocus, row);
            return this.myPanel;
        }

        private void setUpComponent(@NotNull JTable table2, @Nullable Object value2, boolean isSelected, boolean hasFocus, int row) {
            Color background;
            Module module2;
            if (table2 == null) {
                ModuleTableCell.$$$reportNull$$$0(3);
            }
            this.myValue = value2;
            String moduleName2 = null;
            Icon moduleIcon = null;
            boolean isAndriodGradleModule = false;
            if (value2 instanceof Module && !(module2 = (Module)value2).isDisposed()) {
                moduleName2 = module2.getName();
                moduleIcon = GradleUtil.getModuleIcon(module2);
                isAndriodGradleModule = AndroidModuleModel.get(module2) != null;
            }
            this.myModuleNameLabel.setText(moduleName2 == null ? "" : moduleName2);
            this.myModuleNameLabel.setIcon(moduleIcon);
            Color color = background = isSelected ? table2.getSelectionBackground() : table2.getBackground();
            if (isAndriodGradleModule) {
                this.myConflict = ((BuildVariantTable)((Object)table2)).findConflict(row);
                this.myModuleNameLabel.setToolTipText(this.myConflict != null ? this.myConflict.toString() : null);
                this.myFixButton.setVisible(this.myConflict != null);
                if (this.myConflict != null) {
                    background = CONFLICT_CELL_BACKGROUND;
                }
            } else {
                this.myFixButton.setVisible(false);
            }
            this.myPanel.setBackground(background);
            Border border = hasFocus ? UIUtil.getTableFocusCellHighlightBorder() : EMPTY_BORDER;
            this.myPanel.setBorder(border);
        }

        public Object getCellEditorValue() {
            return this.myValue;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "icon";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/gradle/variant/view/BuildVariantView$ModuleTableCell";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "c";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "table";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/gradle/variant/view/BuildVariantView$ModuleTableCell";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createButton";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createButton";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getToolTipTextIfUnderX";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "setUpComponent";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class AbisCellRenderer
    extends DefaultTableCellRenderer {
        private static final String abisCellHelpTooltipText = "For NDK modules, determines the ABI that will be used by the editor";

        private AbisCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table2, Object value2, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = super.getTableCellRendererComponent(table2, value2, isSelected, hasFocus, row, column);
            if (c instanceof JLabel) {
                JLabel component = (JLabel)c;
                Color background = isSelected ? table2.getSelectionBackground() : table2.getBackground();
                component.setBackground(background);
                component.setToolTipText(abisCellHelpTooltipText);
                component.setBorder(BorderFactory.createCompoundBorder(component.getBorder(), (Border)JBUI.Borders.empty((int)3, (int)2, (int)4, (int)2)));
                if (component.getText().isEmpty()) {
                    component.setText("\u2014");
                }
            }
            return c;
        }
    }

    private static class VariantsCellRenderer
    extends DefaultTableCellRenderer {
        private static final String variantsCellHelpTooltipText = "Determines the build variant that will be deployed to device and used by the editor";

        private VariantsCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table2, Object value2, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = super.getTableCellRendererComponent(table2, value2, isSelected, hasFocus, row, column);
            if (c instanceof JLabel) {
                JLabel component = (JLabel)c;
                Color background = isSelected ? table2.getSelectionBackground() : table2.getBackground();
                Conflict conflictFound = ((BuildVariantTable)((Object)table2)).findConflict(row);
                if (conflictFound != null) {
                    background = CONFLICT_CELL_BACKGROUND;
                }
                component.setBackground(background);
                String toolTip = conflictFound != null ? conflictFound.toString() : variantsCellHelpTooltipText;
                component.setToolTipText(toolTip);
                component.setBorder(BorderFactory.createCompoundBorder(component.getBorder(), (Border)JBUI.Borders.empty((int)3, (int)2, (int)4, (int)2)));
            }
            return c;
        }
    }

    private class BuildVariantTable
    extends JBTable {
        private boolean myLoading;
        private final ModuleTableCell myModuleCellEditor;
        private List<BuildVariantItem[]> myBuildVariantsPerRow;
        private List<AbiItem[]> myAbisPerRow;
        private final ModuleTableCell myModuleCellRenderer;
        private final VariantsCellRenderer myVariantsCellRenderer;
        private final AbisCellRenderer myAbisCellRenderer;

        BuildVariantTable() {
            super((TableModel)new BuildVariantTableModel(Collections.emptyList(), BuildVariantView.this.previousModelHadAbis));
            this.myModuleCellEditor = new ModuleTableCell();
            this.myBuildVariantsPerRow = new ArrayList<BuildVariantItem[]>();
            this.myAbisPerRow = new ArrayList<AbiItem[]>();
            this.myModuleCellRenderer = new ModuleTableCell();
            this.myVariantsCellRenderer = new VariantsCellRenderer();
            this.myAbisCellRenderer = new AbisCellRenderer();
            this.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    Component editorComponent;
                    int column = BuildVariantTable.this.getSelectedColumn();
                    int row = BuildVariantTable.this.getSelectedRow();
                    if ((column == 1 || column == 2) && row >= 0 && e.getKeyCode() == 113 && BuildVariantTable.this.editCellAt(row, column) && (editorComponent = BuildVariantTable.this.getEditorComponent()) instanceof ComboBox) {
                        editorComponent.requestFocusInWindow();
                        ((ComboBox)editorComponent).showPopup();
                    }
                }
            });
            this.setExpandableItemsEnabled(false);
        }

        @Nullable
        Conflict findConflict(int row) {
            for (Conflict conflict : BuildVariantView.this.myConflicts) {
                Object module2 = this.getValueAt(row, 0);
                if (!conflict.getSource().equals(module2)) continue;
                return conflict;
            }
            return null;
        }

        public boolean isCellEditable(int row, int column) {
            return true;
        }

        void setLoading(boolean loading) {
            this.myLoading = loading;
            this.setPaintBusy(this.myLoading);
            this.clearContents();
            String text2 = this.myLoading ? CommonBundle.getLoadingTreeNodeText() : "Nothing to Show";
            this.getEmptyText().setText(text2);
        }

        private void clearContents() {
            this.setModel(new BuildVariantTableModel(Collections.emptyList(), BuildVariantView.this.previousModelHadAbis));
            this.myBuildVariantsPerRow.clear();
            this.myAbisPerRow.clear();
        }

        void setModel(@NotNull List<Object[]> rows, @NotNull List<BuildVariantItem[]> buildVariantsPerRow, @NotNull List<AbiItem[]> abisPerRow) {
            if (rows == null) {
                BuildVariantTable.$$$reportNull$$$0(0);
            }
            if (buildVariantsPerRow == null) {
                BuildVariantTable.$$$reportNull$$$0(1);
            }
            if (abisPerRow == null) {
                BuildVariantTable.$$$reportNull$$$0(2);
            }
            this.setLoading(false);
            boolean bl = BuildVariantView.this.previousModelHadAbis = abisPerRow.stream().filter(abis -> abis != null).count() > 0L;
            if (rows.isEmpty()) {
                this.setModel(new BuildVariantTableModel(rows, BuildVariantView.this.previousModelHadAbis));
                return;
            }
            boolean hasVariants = !buildVariantsPerRow.isEmpty();
            List<Object> content2 = hasVariants ? rows : Collections.emptyList();
            this.setModel(new BuildVariantTableModel(content2, BuildVariantView.this.previousModelHadAbis));
            this.addBuildVariants(buildVariantsPerRow);
            this.addAbiNames(abisPerRow);
        }

        private void addBuildVariants(@NotNull List<BuildVariantItem[]> buildVariantsPerRow) {
            if (buildVariantsPerRow == null) {
                BuildVariantTable.$$$reportNull$$$0(3);
            }
            this.myBuildVariantsPerRow = buildVariantsPerRow;
        }

        @NotNull
        private DefaultCellEditor createCellEditor(int row, BuildVariantItem[] items2) {
            BuildVariantItem selected = null;
            for (BuildVariantItem item : items2) {
                if (!item.hasBuildVariantName(this.getValueAt(row, 1))) continue;
                selected = item;
                break;
            }
            ComboBox editor2 = new ComboBox((Object[])items2);
            if (selected != null) {
                editor2.setSelectedItem(selected);
            }
            editor2.setBorder((Border)JBUI.Borders.empty());
            editor2.addItemListener(e -> {
                if (e.getStateChange() == 1) {
                    BuildVariantItem selectedVariant = (BuildVariantItem)e.getItem();
                    BuildVariantView.this.getVariantsTable().setLoading(true);
                    if (!BuildVariantView.this.myUpdater.updateSelectedBuildVariant(BuildVariantView.this.myProject, selectedVariant.myModuleName, selectedVariant.myBuildVariantName)) {
                        BuildVariantView.this.updateContents();
                    }
                }
            });
            final DefaultCellEditor defaultCellEditor = new DefaultCellEditor((JComboBox<?>)editor2);
            editor2.addKeyListener((KeyListener)new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 27) {
                        defaultCellEditor.cancelCellEditing();
                    }
                }
            });
            DefaultCellEditor defaultCellEditor2 = defaultCellEditor;
            if (defaultCellEditor2 == null) {
                BuildVariantTable.$$$reportNull$$$0(4);
            }
            return defaultCellEditor2;
        }

        private void addAbiNames(@NotNull List<AbiItem[]> abisPerRow) {
            if (abisPerRow == null) {
                BuildVariantTable.$$$reportNull$$$0(5);
            }
            this.myAbisPerRow = abisPerRow;
        }

        @NotNull
        private DefaultCellEditor createAbiCellEditor(int row, AbiItem[] items2) {
            AbiItem selected = null;
            for (AbiItem item : items2) {
                if (!item.hasAbiName(this.getValueAt(row, 2))) continue;
                selected = item;
                break;
            }
            ComboBox editor2 = new ComboBox((Object[])items2);
            if (selected != null) {
                editor2.setSelectedItem(selected);
            }
            editor2.setBorder((Border)JBUI.Borders.empty());
            editor2.addItemListener(e -> {
                if (e.getStateChange() == 1) {
                    AbiItem selectedAbi = (AbiItem)e.getItem();
                    if (!BuildVariantView.this.myUpdater.updateSelectedAbi(BuildVariantView.this.myProject, selectedAbi.myModuleName, selectedAbi.myAbiName)) {
                        BuildVariantView.this.updateContents();
                    }
                }
            });
            final DefaultCellEditor defaultCellEditor = new DefaultCellEditor((JComboBox<?>)editor2);
            editor2.addKeyListener((KeyListener)new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 27) {
                        defaultCellEditor.cancelCellEditing();
                    }
                }
            });
            DefaultCellEditor defaultCellEditor2 = defaultCellEditor;
            if (defaultCellEditor2 == null) {
                BuildVariantTable.$$$reportNull$$$0(6);
            }
            return defaultCellEditor2;
        }

        public TableCellRenderer getCellRenderer(int row, int column) {
            if (column == 0) {
                return this.myModuleCellRenderer;
            }
            if (column == 1) {
                return this.myVariantsCellRenderer;
            }
            return this.myAbisCellRenderer;
        }

        public TableCellEditor getCellEditor(int row, int column) {
            if (column == 1) {
                BuildVariantItem[] variantItems = this.myBuildVariantsPerRow.get(row);
                if (variantItems == null) {
                    return null;
                }
                return this.createCellEditor(row, variantItems);
            }
            if (column == 2) {
                AbiItem[] abiItems = this.myAbisPerRow.get(row);
                if (abiItems == null) {
                    return null;
                }
                return this.createAbiCellEditor(row, abiItems);
            }
            return this.myModuleCellEditor;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rows";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "buildVariantsPerRow";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "abisPerRow";
                    break;
                }
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/gradle/variant/view/BuildVariantView$BuildVariantTable";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/gradle/variant/view/BuildVariantView$BuildVariantTable";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createCellEditor";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createAbiCellEditor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "setModel";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "addBuildVariants";
                    break;
                }
                case 4: 
                case 6: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "addAbiNames";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class BuildVariantTableModel
    extends DefaultTableModel {
        BuildVariantTableModel(List<Object[]> rows, boolean hasAbis) {
            super((Object[][])rows.toArray((T[])new Object[rows.size()][hasAbis ? TABLE_COLUMN_NAMES_WITH_ABI.length : TABLE_COLUMN_NAMES_WITHOUT_ABI.length]), hasAbis ? TABLE_COLUMN_NAMES_WITH_ABI : TABLE_COLUMN_NAMES_WITHOUT_ABI);
        }
    }

    private static class AbiItem
    implements Comparable<AbiItem> {
        @NotNull
        final String myModuleName;
        @NotNull
        final String myAbiName;

        AbiItem(@NotNull String moduleName2, @NotNull String abiName) {
            if (moduleName2 == null) {
                AbiItem.$$$reportNull$$$0(0);
            }
            if (abiName == null) {
                AbiItem.$$$reportNull$$$0(1);
            }
            this.myModuleName = moduleName2;
            this.myAbiName = abiName;
        }

        @Override
        public int compareTo(@Nullable AbiItem o) {
            return o != null ? Collator.getInstance().compare(this.myAbiName, o.myAbiName) : 1;
        }

        boolean hasAbiName(@Nullable Object name) {
            return this.myAbiName.equals(name);
        }

        public String toString() {
            return this.myAbiName;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "moduleName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "abiName";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/gradle/variant/view/BuildVariantView$AbiItem";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class BuildVariantItem
    implements Comparable<BuildVariantItem> {
        @NotNull
        final String myModuleName;
        @NotNull
        final String myBuildVariantName;

        BuildVariantItem(@NotNull String moduleName2, @NotNull String buildVariantName) {
            if (moduleName2 == null) {
                BuildVariantItem.$$$reportNull$$$0(0);
            }
            if (buildVariantName == null) {
                BuildVariantItem.$$$reportNull$$$0(1);
            }
            this.myModuleName = moduleName2;
            this.myBuildVariantName = buildVariantName;
        }

        @Override
        public int compareTo(@Nullable BuildVariantItem o) {
            return o != null ? Collator.getInstance().compare(this.myBuildVariantName, o.myBuildVariantName) : 1;
        }

        boolean hasBuildVariantName(@Nullable Object name) {
            return this.myBuildVariantName.equals(name);
        }

        public String toString() {
            return this.myBuildVariantName;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "moduleName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "buildVariantName";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/gradle/variant/view/BuildVariantView$BuildVariantItem";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class NotificationPanel
    extends JPanel {
        int myCurrentConflictIndex;

        NotificationPanel() {
            super(new BorderLayout());
            this.myCurrentConflictIndex = -1;
            Color color = EditorColorsManager.getInstance().getGlobalScheme().getColor(EditorColors.NOTIFICATION_BACKGROUND);
            this.setBackground(color == null ? UIUtil.getToolTipBackground() : color);
            this.setBorder((Border)JBUI.Borders.empty((int)1, (int)15));
            this.setPreferredSize(new Dimension(-1, JBUIScale.scale((int)24)));
            JLabel textLabel = new JLabel("Variant selection conflicts found");
            textLabel.setOpaque(false);
            this.add((Component)textLabel, "Center");
            DefaultActionGroup group2 = new DefaultActionGroup();
            ActionManager actionManager = ActionManager.getInstance();
            AnAction nextConflictAction = new AnAction(){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    NotificationPanel.this.navigateConflicts(true);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/idea/gradle/variant/view/BuildVariantView$NotificationPanel$1", "actionPerformed"));
                }
            };
            ActionUtil.copyFrom((AnAction)nextConflictAction, (String)"NextOccurence");
            group2.add(nextConflictAction);
            AnAction prevConflictAction = new AnAction(){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    NotificationPanel.this.navigateConflicts(false);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/idea/gradle/variant/view/BuildVariantView$NotificationPanel$2", "actionPerformed"));
                }
            };
            ActionUtil.copyFrom((AnAction)prevConflictAction, (String)"PreviousOccurence");
            group2.add(prevConflictAction);
            ActionToolbar toolbar2 = actionManager.createActionToolbar("AndroidBuildVariantViewNotifications", (ActionGroup)group2, true);
            toolbar2.setReservePlaceAutoPopupIcon(false);
            toolbar2.setMinimumButtonSize((Dimension)JBUI.size((int)23, (int)23));
            JComponent toolbarComponent = toolbar2.getComponent();
            toolbarComponent.setBorder(null);
            toolbarComponent.setOpaque(false);
            this.add((Component)toolbarComponent, "East");
        }

        private void navigateConflicts(boolean forward) {
            int conflictCount = BuildVariantView.this.myConflicts.size();
            if (conflictCount == 0) {
                return;
            }
            if (forward) {
                ++this.myCurrentConflictIndex;
                if (this.myCurrentConflictIndex >= conflictCount) {
                    this.myCurrentConflictIndex = 0;
                }
            } else {
                --this.myCurrentConflictIndex;
                if (this.myCurrentConflictIndex < 0) {
                    this.myCurrentConflictIndex = conflictCount - 1;
                }
            }
            Conflict conflict = BuildVariantView.this.myConflicts.get(this.myCurrentConflictIndex);
            BuildVariantView.this.findAndSelect(conflict.getSource());
        }
    }

    static interface BuildVariantSelectionChangeListener {
        public void selectionChanged();
    }
}

