/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.variant.view;

import com.android.ide.common.gradle.model.IdeLibrary;
import com.android.tools.idea.gradle.project.ProjectStructure;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacet;
import com.android.tools.idea.gradle.project.facet.ndk.NdkFacet;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.model.GradleModuleModel;
import com.android.tools.idea.gradle.project.model.NdkModuleModel;
import com.android.tools.idea.gradle.project.model.VariantAbi;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.GradleSyncListener;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.project.sync.Modules;
import com.android.tools.idea.gradle.project.sync.idea.VariantSwitcher;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.variant.view.BuildVariantView;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.ExternalSystemModulePropertyManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BuildVariantUpdater {
    @NotNull
    public static final Key<String> MODULE_WITH_BUILD_VARIANT_SWITCHED_FROM_UI = new Key("module.with.build.variant.switched.from.ui");
    @NotNull
    public static final Key<Boolean> USE_VARIANTS_FROM_PREVIOUS_GRADLE_SYNCS = new Key("use.variants.from.previous.gradle.syncs");
    @NotNull
    private final List<BuildVariantView.BuildVariantSelectionChangeListener> mySelectionChangeListeners = ContainerUtil.createLockFreeCopyOnWriteList();

    @NotNull
    public static BuildVariantUpdater getInstance(@NotNull Project project) {
        if (project == null) {
            BuildVariantUpdater.$$$reportNull$$$0(0);
        }
        BuildVariantUpdater buildVariantUpdater = (BuildVariantUpdater)project.getService(BuildVariantUpdater.class);
        if (buildVariantUpdater == null) {
            BuildVariantUpdater.$$$reportNull$$$0(1);
        }
        return buildVariantUpdater;
    }

    BuildVariantUpdater() {
    }

    void addSelectionChangeListener(@NotNull BuildVariantView.BuildVariantSelectionChangeListener listener2) {
        if (listener2 == null) {
            BuildVariantUpdater.$$$reportNull$$$0(2);
        }
        this.mySelectionChangeListeners.add(listener2);
    }

    public boolean updateSelectedBuildVariant(@NotNull Project project, @NotNull String moduleName2, @NotNull String selectedBuildVariant) {
        Module moduleToUpdate;
        if (project == null) {
            BuildVariantUpdater.$$$reportNull$$$0(3);
        }
        if (moduleName2 == null) {
            BuildVariantUpdater.$$$reportNull$$$0(4);
        }
        if (selectedBuildVariant == null) {
            BuildVariantUpdater.$$$reportNull$$$0(5);
        }
        if ((moduleToUpdate = BuildVariantUpdater.findModule(project, moduleName2)) == null) {
            BuildVariantUpdater.logAndShowBuildVariantFailure(String.format("Cannot find module '%1$s'.", moduleName2));
            return false;
        }
        NdkModuleModel ndkModuleModel = BuildVariantUpdater.getNdkModelIfItHasNativeVariantAbis(moduleToUpdate);
        NdkFacet ndkFacet = NdkFacet.getInstance(moduleToUpdate);
        if (ndkModuleModel == null || ndkFacet == null) {
            return this.updateSelectedVariant(project, moduleName2, selectedBuildVariant);
        }
        VariantAbi newVariantAbi = BuildVariantUpdater.resolveNewVariantAbi(ndkFacet, ndkModuleModel, selectedBuildVariant, null);
        if (newVariantAbi == null) {
            BuildVariantUpdater.logAndShowBuildVariantFailure(String.format("Cannot find suitable ABI for native module '%1$s'.", moduleName2));
            return false;
        }
        return this.updateSelectedVariant(project, moduleName2, newVariantAbi.getDisplayName());
    }

    boolean updateSelectedAbi(@NotNull Project project, @NotNull String moduleName2, @NotNull String selectedAbiName) {
        Module moduleToUpdate;
        if (project == null) {
            BuildVariantUpdater.$$$reportNull$$$0(6);
        }
        if (moduleName2 == null) {
            BuildVariantUpdater.$$$reportNull$$$0(7);
        }
        if (selectedAbiName == null) {
            BuildVariantUpdater.$$$reportNull$$$0(8);
        }
        if ((moduleToUpdate = BuildVariantUpdater.findModule(project, moduleName2)) == null) {
            BuildVariantUpdater.logAndShowAbiNameFailure(String.format("Cannot find module '%1$s'.", moduleName2));
            return false;
        }
        NdkModuleModel ndkModuleModel = BuildVariantUpdater.getNdkModelIfItHasNativeVariantAbis(moduleToUpdate);
        NdkFacet ndkFacet = NdkFacet.getInstance(moduleToUpdate);
        if (ndkModuleModel == null || ndkFacet == null) {
            BuildVariantUpdater.logAndShowAbiNameFailure(String.format("Cannot find native module model '%1$s'.", moduleName2));
            return false;
        }
        VariantAbi currentSelectedVariantAbi = ndkFacet.getSelectedVariantAbi();
        VariantAbi newVariantAbi = currentSelectedVariantAbi == null ? null : BuildVariantUpdater.resolveNewVariantAbi(ndkFacet, ndkModuleModel, currentSelectedVariantAbi.getVariant(), selectedAbiName);
        if (newVariantAbi == null) {
            BuildVariantUpdater.logAndShowAbiNameFailure(String.format("Cannot find suitable ABI for native module '%1$s'.", moduleName2));
            return false;
        }
        return this.updateSelectedVariant(project, moduleName2, newVariantAbi.getDisplayName());
    }

    private boolean updateSelectedVariant(@NotNull Project project, @NotNull String moduleName2, @NotNull String buildVariantName) {
        if (project == null) {
            BuildVariantUpdater.$$$reportNull$$$0(9);
        }
        if (moduleName2 == null) {
            BuildVariantUpdater.$$$reportNull$$$0(10);
        }
        if (buildVariantName == null) {
            BuildVariantUpdater.$$$reportNull$$$0(11);
        }
        ArrayList<AndroidFacet> affectedAndroidFacets = new ArrayList<AndroidFacet>();
        ArrayList<NdkFacet> affectedNdkFacets = new ArrayList<NdkFacet>();
        boolean variantToUpdateExists = BuildVariantUpdater.findAndUpdateAffectedFacets(project, moduleName2, buildVariantName, affectedAndroidFacets, affectedNdkFacets);
        if (affectedAndroidFacets.isEmpty() && affectedNdkFacets.isEmpty()) {
            return false;
        }
        Runnable invokeVariantSelectionChangeListeners = () -> {
            for (BuildVariantView.BuildVariantSelectionChangeListener listener2 : this.mySelectionChangeListeners) {
                listener2.selectionChanged();
            }
        };
        if (BuildVariantUpdater.hasBuildFilesChanged(project)) {
            BuildVariantUpdater.setVariantSwitchedProperty(project, moduleName2);
            BuildVariantUpdater.requestFullGradleSync(project, invokeVariantSelectionChangeListeners);
        } else if (!variantToUpdateExists) {
            project.putUserData(USE_VARIANTS_FROM_PREVIOUS_GRADLE_SYNCS, (Object)true);
            BuildVariantUpdater.setVariantSwitchedProperty(project, moduleName2);
            BuildVariantUpdater.requestVariantOnlyGradleSync(project, moduleName2, invokeVariantSelectionChangeListeners);
        } else {
            ArrayList<AndroidFacet> allAndroidFacets = new ArrayList<AndroidFacet>();
            for (Module module2 : ModuleManager.getInstance((Project)project).getModules()) {
                AndroidFacet androidFacet = AndroidFacet.getInstance((Module)module2);
                if (androidFacet == null) continue;
                allAndroidFacets.add(androidFacet);
            }
            BuildVariantUpdater.setupCachedVariant(project, allAndroidFacets, invokeVariantSelectionChangeListeners);
        }
        return true;
    }

    private static void setVariantSwitchedProperty(@NotNull Project project, @NotNull String moduleName2) {
        Module moduleToUpdate;
        if (project == null) {
            BuildVariantUpdater.$$$reportNull$$$0(12);
        }
        if (moduleName2 == null) {
            BuildVariantUpdater.$$$reportNull$$$0(13);
        }
        if ((moduleToUpdate = BuildVariantUpdater.findModule(project, moduleName2)) == null) {
            return;
        }
        String moduleId = BuildVariantUpdater.getModuleIdForModule(moduleToUpdate);
        if (moduleId != null) {
            project.putUserData(MODULE_WITH_BUILD_VARIANT_SWITCHED_FROM_UI, (Object)moduleId);
        }
    }

    @Nullable
    public static String getModuleIdForModule(@NotNull Module module2) {
        String gradlePath;
        ExternalSystemModulePropertyManager propertyManager;
        String rootProjectPath;
        if (module2 == null) {
            BuildVariantUpdater.$$$reportNull$$$0(14);
        }
        if ((rootProjectPath = (propertyManager = ExternalSystemModulePropertyManager.getInstance((Module)module2)).getRootProjectPath()) != null && (gradlePath = propertyManager.getLinkedProjectId()) != null) {
            return Modules.createUniqueModuleId(rootProjectPath, gradlePath);
        }
        return null;
    }

    private static boolean findAndUpdateAffectedFacets(@NotNull Project project, @NotNull String moduleName2, @NotNull String variantToSelect, @NotNull List<AndroidFacet> affectedAndroidFacets, @NotNull List<NdkFacet> affectedNdkFacets) {
        AndroidModuleModel androidModel;
        NdkModuleModel ndkModuleModel;
        Module moduleToUpdate;
        if (project == null) {
            BuildVariantUpdater.$$$reportNull$$$0(15);
        }
        if (moduleName2 == null) {
            BuildVariantUpdater.$$$reportNull$$$0(16);
        }
        if (variantToSelect == null) {
            BuildVariantUpdater.$$$reportNull$$$0(17);
        }
        if (affectedAndroidFacets == null) {
            BuildVariantUpdater.$$$reportNull$$$0(18);
        }
        if (affectedNdkFacets == null) {
            BuildVariantUpdater.$$$reportNull$$$0(19);
        }
        if ((moduleToUpdate = BuildVariantUpdater.findModule(project, moduleName2)) == null) {
            BuildVariantUpdater.logAndShowBuildVariantFailure(String.format("Cannot find module '%1$s'.", moduleName2));
            return false;
        }
        AndroidFacet androidFacet = AndroidFacet.getInstance((Module)moduleToUpdate);
        NdkFacet ndkFacet = NdkFacet.getInstance(moduleToUpdate);
        if (androidFacet == null && ndkFacet == null) {
            String msg = String.format("Cannot find 'Android' or 'Native-Android-Gradle' facets in module '%1$s'.", moduleToUpdate.getName());
            BuildVariantUpdater.logAndShowBuildVariantFailure(msg);
        }
        boolean ndkVariantExists = true;
        boolean androidVariantExists = true;
        String variantName = variantToSelect;
        String abiName = null;
        if (ndkFacet != null && (ndkModuleModel = BuildVariantUpdater.getNdkModelIfItHasNativeVariantAbis(ndkFacet)) != null) {
            VariantAbi variantAbiToSelect = VariantAbi.fromString(variantToSelect);
            if (variantAbiToSelect == null) {
                BuildVariantUpdater.logAndShowBuildVariantFailure(String.format("Cannot parse variant and ABI '%s'.", variantToSelect));
                return false;
            }
            if (ndkModuleModel.getAllVariantAbis().contains(variantAbiToSelect)) {
                ndkVariantExists = BuildVariantUpdater.updateAffectedFacetsForNdkModule(ndkFacet, ndkModuleModel, variantAbiToSelect, affectedNdkFacets);
                variantName = variantAbiToSelect.getVariant();
                abiName = variantAbiToSelect.getAbi();
            }
        }
        if (androidFacet != null && (androidModel = BuildVariantUpdater.getAndroidModel(androidFacet)) != null) {
            androidVariantExists = BuildVariantUpdater.updateAffectedFacetsForAndroidModule(project, androidFacet, androidModel, variantName, abiName, affectedAndroidFacets, affectedNdkFacets);
        }
        return ndkVariantExists && androidVariantExists;
    }

    private static boolean updateAffectedFacetsForNdkModule(@NotNull NdkFacet ndkFacet, @NotNull NdkModuleModel ndkModuleModel, @NotNull VariantAbi variantAbiToSelect, @NotNull List<NdkFacet> affectedNdkFacets) {
        if (ndkFacet == null) {
            BuildVariantUpdater.$$$reportNull$$$0(20);
        }
        if (ndkModuleModel == null) {
            BuildVariantUpdater.$$$reportNull$$$0(21);
        }
        if (variantAbiToSelect == null) {
            BuildVariantUpdater.$$$reportNull$$$0(22);
        }
        if (affectedNdkFacets == null) {
            BuildVariantUpdater.$$$reportNull$$$0(23);
        }
        if (variantAbiToSelect.equals(ndkFacet.getSelectedVariantAbi()) && ndkModuleModel.getSyncedVariantAbis().contains(variantAbiToSelect)) {
            return true;
        }
        affectedNdkFacets.add(ndkFacet);
        ndkFacet.setSelectedVariantAbi(variantAbiToSelect);
        return ndkModuleModel.getSyncedVariantAbis().contains(variantAbiToSelect);
    }

    private static boolean updateAffectedFacetsForAndroidModule(@NotNull Project project, @NotNull AndroidFacet androidFacet, @NotNull AndroidModuleModel androidModel, @NotNull String variantToSelect, @Nullable String abiToSelect, @NotNull List<AndroidFacet> affectedAndroidFacets, @NotNull List<NdkFacet> affectedNdkFacets) {
        boolean isAbiChanged;
        if (project == null) {
            BuildVariantUpdater.$$$reportNull$$$0(24);
        }
        if (androidFacet == null) {
            BuildVariantUpdater.$$$reportNull$$$0(25);
        }
        if (androidModel == null) {
            BuildVariantUpdater.$$$reportNull$$$0(26);
        }
        if (variantToSelect == null) {
            BuildVariantUpdater.$$$reportNull$$$0(27);
        }
        if (affectedAndroidFacets == null) {
            BuildVariantUpdater.$$$reportNull$$$0(28);
        }
        if (affectedNdkFacets == null) {
            BuildVariantUpdater.$$$reportNull$$$0(29);
        }
        boolean isVariantChanged = !variantToSelect.equals(androidModel.getSelectedVariant().getName());
        boolean bl = isAbiChanged = abiToSelect != null;
        if (!isVariantChanged && !isAbiChanged) {
            return true;
        }
        if (isVariantChanged) {
            affectedAndroidFacets.add(androidFacet);
            androidFacet.getProperties().SELECTED_BUILD_VARIANT = variantToSelect;
        }
        if (!androidModel.variantExists(variantToSelect)) {
            return false;
        }
        androidModel.setSelectedVariantName(variantToSelect);
        androidModel.syncSelectedVariantAndTestArtifact(androidFacet);
        BuildVariantUpdater.updateSelectedVariantsForDependencyModules(project, androidModel, abiToSelect, affectedAndroidFacets, affectedNdkFacets);
        return true;
    }

    private static void updateSelectedVariantsForDependencyModules(@NotNull Project project, @NotNull AndroidModuleModel androidModel, @Nullable String abiToSelect, @NotNull List<AndroidFacet> affectedAndroidFacets, @NotNull List<NdkFacet> affectedNdkFacets) {
        Module dependencyModule;
        if (project == null) {
            BuildVariantUpdater.$$$reportNull$$$0(30);
        }
        if (androidModel == null) {
            BuildVariantUpdater.$$$reportNull$$$0(31);
        }
        if (affectedAndroidFacets == null) {
            BuildVariantUpdater.$$$reportNull$$$0(32);
        }
        if (affectedNdkFacets == null) {
            BuildVariantUpdater.$$$reportNull$$$0(33);
        }
        for (IdeLibrary library : androidModel.getSelectedMainCompileLevel2Dependencies().getModuleDependencies()) {
            if (!StringUtil.isNotEmpty((String)library.getVariant()) || !StringUtil.isNotEmpty((String)library.getProjectPath())) continue;
            dependencyModule = ProjectStructure.getInstance(project).getModuleFinder().findModuleFromLibrary(library);
            BuildVariantUpdater.updateDependencyModule(project, library.getProjectPath(), dependencyModule, library.getVariant(), abiToSelect, affectedAndroidFacets, affectedNdkFacets);
        }
        for (String gradlePath : androidModel.getAndroidProject().getDynamicFeatures()) {
            if (!StringUtil.isNotEmpty((String)gradlePath) || (dependencyModule = GradleUtil.findModuleByGradlePath(project, gradlePath)) == null) continue;
            AndroidModuleModel depModuleModel = AndroidModuleModel.get(dependencyModule);
            String variantToSelect = androidModel.getSelectedVariant().getName();
            if (depModuleModel == null || !depModuleModel.getVariantNames().contains(variantToSelect)) continue;
            BuildVariantUpdater.updateDependencyModule(project, gradlePath, dependencyModule, variantToSelect, abiToSelect, affectedAndroidFacets, affectedNdkFacets);
        }
    }

    private static void updateDependencyModule(@NotNull Project project, @NotNull String gradlePath, @Nullable Module dependencyModule, @NotNull String projectVariant, @Nullable String abiToSelect, @NotNull List<AndroidFacet> affectedAndroidFacets, @NotNull List<NdkFacet> affectedNdkFacets) {
        if (project == null) {
            BuildVariantUpdater.$$$reportNull$$$0(34);
        }
        if (gradlePath == null) {
            BuildVariantUpdater.$$$reportNull$$$0(35);
        }
        if (projectVariant == null) {
            BuildVariantUpdater.$$$reportNull$$$0(36);
        }
        if (affectedAndroidFacets == null) {
            BuildVariantUpdater.$$$reportNull$$$0(37);
        }
        if (affectedNdkFacets == null) {
            BuildVariantUpdater.$$$reportNull$$$0(38);
        }
        if (dependencyModule == null) {
            BuildVariantUpdater.logAndShowBuildVariantFailure(String.format("Cannot find module with Gradle path '%1$s'.", gradlePath));
            return;
        }
        AndroidFacet dependencyFacet = AndroidFacet.getInstance((Module)dependencyModule);
        if (dependencyFacet == null) {
            BuildVariantUpdater.logAndShowBuildVariantFailure(String.format("Cannot find 'Android' facet in module '%1$s'.", dependencyModule.getName()));
            return;
        }
        AndroidModuleModel dependencyModel = BuildVariantUpdater.getAndroidModel(dependencyFacet);
        if (dependencyModel != null) {
            VariantAbi projectVariantWithAbi;
            NdkModuleModel dependencyNdkModel;
            NdkFacet dependencyNdkFacet = NdkFacet.getInstance(dependencyModule);
            NdkModuleModel ndkModuleModel = dependencyNdkModel = dependencyNdkFacet == null ? null : BuildVariantUpdater.getNdkModelIfItHasNativeVariantAbis(dependencyNdkFacet);
            if (dependencyNdkModel != null && (projectVariantWithAbi = BuildVariantUpdater.resolveNewVariantAbi(dependencyNdkFacet, dependencyNdkModel, projectVariant, abiToSelect)) != null) {
                BuildVariantUpdater.updateAffectedFacetsForNdkModule(dependencyNdkFacet, dependencyNdkModel, projectVariantWithAbi, affectedNdkFacets);
            }
            BuildVariantUpdater.updateAffectedFacetsForAndroidModule(project, dependencyFacet, dependencyModel, projectVariant, abiToSelect, affectedAndroidFacets, affectedNdkFacets);
        }
    }

    @Nullable
    private static VariantAbi resolveNewVariantAbi(@NotNull NdkFacet ndkFacet, @NotNull NdkModuleModel ndkModel, @NotNull String newVariant, @Nullable String userSelectedAbi) {
        VariantAbi selectedVariantAbi;
        if (ndkFacet == null) {
            BuildVariantUpdater.$$$reportNull$$$0(39);
        }
        if (ndkModel == null) {
            BuildVariantUpdater.$$$reportNull$$$0(40);
        }
        if (newVariant == null) {
            BuildVariantUpdater.$$$reportNull$$$0(41);
        }
        if (userSelectedAbi != null) {
            VariantAbi newVariantAbi = new VariantAbi(newVariant, userSelectedAbi);
            if (ndkModel.getAllVariantAbis().contains(newVariantAbi)) {
                return newVariantAbi;
            }
        }
        if ((selectedVariantAbi = ndkFacet.getSelectedVariantAbi()) == null) {
            return null;
        }
        String existingAbi = selectedVariantAbi.getAbi();
        VariantAbi proposedVariantAbi = new VariantAbi(newVariant, existingAbi);
        if (ndkModel.getAllVariantAbis().contains(proposedVariantAbi)) {
            return proposedVariantAbi;
        }
        return ndkModel.getAllVariantAbis().stream().filter(variantAbi -> variantAbi.getVariant().equals(newVariant)).findFirst().orElse(null);
    }

    private static boolean hasBuildFilesChanged(@NotNull Project project) {
        if (project == null) {
            BuildVariantUpdater.$$$reportNull$$$0(42);
        }
        return GradleSyncState.getInstance(project).isSyncNeeded().equals((Object)ThreeState.YES);
    }

    private static void requestFullGradleSync(@NotNull Project project, @NotNull Runnable variantSelectionChangeListeners) {
        if (project == null) {
            BuildVariantUpdater.$$$reportNull$$$0(43);
        }
        if (variantSelectionChangeListeners == null) {
            BuildVariantUpdater.$$$reportNull$$$0(44);
        }
        GradleSyncInvoker.getInstance().requestProjectSync(project, GradleSyncStats.Trigger.TRIGGER_VARIANT_SELECTION_FULL_SYNC, BuildVariantUpdater.getSyncListener(variantSelectionChangeListeners));
    }

    @NotNull
    private static GradleSyncListener getSyncListener(final @NotNull Runnable variantSelectionChangeListeners) {
        if (variantSelectionChangeListeners == null) {
            BuildVariantUpdater.$$$reportNull$$$0(45);
        }
        return new GradleSyncListener(){

            @Override
            public void syncFailed(@NotNull Project project, @NotNull String errorMessage) {
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (errorMessage == null) {
                    1.$$$reportNull$$$0(1);
                }
                project.putUserData(USE_VARIANTS_FROM_PREVIOUS_GRADLE_SYNCS, null);
            }

            @Override
            public void syncSucceeded(@NotNull Project project) {
                if (project == null) {
                    1.$$$reportNull$$$0(2);
                }
                project.putUserData(USE_VARIANTS_FROM_PREVIOUS_GRADLE_SYNCS, null);
                variantSelectionChangeListeners.run();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "errorMessage";
                        break;
                    }
                }
                objectArray2[1] = "com/android/tools/idea/gradle/variant/view/BuildVariantUpdater$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "syncFailed";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "syncSucceeded";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static void requestVariantOnlyGradleSync(@NotNull Project project, @NotNull String moduleName2, @NotNull Runnable variantSelectionChangeListeners) {
        Module moduleToUpdate;
        if (project == null) {
            BuildVariantUpdater.$$$reportNull$$$0(46);
        }
        if (moduleName2 == null) {
            BuildVariantUpdater.$$$reportNull$$$0(47);
        }
        if (variantSelectionChangeListeners == null) {
            BuildVariantUpdater.$$$reportNull$$$0(48);
        }
        if ((moduleToUpdate = BuildVariantUpdater.findModule(project, moduleName2)) == null) {
            return;
        }
        GradleFacet gradleFacet = GradleFacet.getInstance(moduleToUpdate);
        if (gradleFacet == null) {
            return;
        }
        AndroidModuleModel androidModel = AndroidModuleModel.get(moduleToUpdate);
        GradleModuleModel gradleModel = gradleFacet.getGradleModuleModel();
        if (androidModel != null && gradleModel != null) {
            GradleSyncInvoker.Request request = new GradleSyncInvoker.Request(GradleSyncStats.Trigger.TRIGGER_VARIANT_SELECTION_CHANGED_BY_USER);
            GradleSyncInvoker.getInstance().requestProjectSync(project, request, BuildVariantUpdater.getSyncListener(variantSelectionChangeListeners));
        }
    }

    private static void setupCachedVariant(final @NotNull Project project, final @NotNull List<AndroidFacet> affectedAndroidFacets, final @NotNull Runnable variantSelectionChangeListeners) {
        if (project == null) {
            BuildVariantUpdater.$$$reportNull$$$0(49);
        }
        if (affectedAndroidFacets == null) {
            BuildVariantUpdater.$$$reportNull$$$0(50);
        }
        if (variantSelectionChangeListeners == null) {
            BuildVariantUpdater.$$$reportNull$$$0(51);
        }
        final Application application = ApplicationManager.getApplication();
        Task.Backgroundable task2 = new Task.Backgroundable(project, "Setting up Project", false){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    2.$$$reportNull$$$0(0);
                }
                BuildVariantUpdater.getLog().info("Starting setup of cached variant");
                VariantSwitcher.switchVariant(project, affectedAndroidFacets);
                GradleSyncState.getInstance(project).syncSkipped(null);
                if (application.isUnitTestMode()) {
                    variantSelectionChangeListeners.run();
                } else {
                    application.invokeLater(variantSelectionChangeListeners);
                }
                BuildVariantUpdater.getLog().info("Finished setup of cached variant");
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/android/tools/idea/gradle/variant/view/BuildVariantUpdater$2", "run"));
            }
        };
        if (application.isUnitTestMode()) {
            task2.run((ProgressIndicator)new EmptyProgressIndicator());
        } else {
            ProgressManager.getInstance().runProcessWithProgressAsynchronously(task2, (ProgressIndicator)new BackgroundableProcessIndicator(task2));
        }
    }

    @Nullable
    private static Module findModule(@NotNull Project project, @NotNull String moduleName2) {
        if (project == null) {
            BuildVariantUpdater.$$$reportNull$$$0(52);
        }
        if (moduleName2 == null) {
            BuildVariantUpdater.$$$reportNull$$$0(53);
        }
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        return moduleManager.findModuleByName(moduleName2);
    }

    @Nullable
    private static AndroidModuleModel getAndroidModel(@NotNull AndroidFacet facet2) {
        AndroidModuleModel androidModel;
        if (facet2 == null) {
            BuildVariantUpdater.$$$reportNull$$$0(54);
        }
        if ((androidModel = AndroidModuleModel.get(facet2)) == null) {
            BuildVariantUpdater.logAndShowBuildVariantFailure(String.format("Cannot find AndroidProject for module '%1$s'.", facet2.getModule().getName()));
        }
        return androidModel;
    }

    @Nullable
    private static NdkModuleModel getNdkModelIfItHasNativeVariantAbis(@NotNull NdkFacet facet2) {
        NdkModuleModel ndkModuleModel;
        if (facet2 == null) {
            BuildVariantUpdater.$$$reportNull$$$0(55);
        }
        if ((ndkModuleModel = NdkModuleModel.get(facet2)) == null) {
            BuildVariantUpdater.logAndShowBuildVariantFailure(String.format("Cannot find NativeAndroidProject for module '%1$s'.", facet2.getModule().getName()));
            return null;
        }
        if (ndkModuleModel.getAllVariantAbis().isEmpty()) {
            return null;
        }
        return ndkModuleModel;
    }

    @Nullable
    private static NdkModuleModel getNdkModelIfItHasNativeVariantAbis(@NotNull Module module2) {
        NdkModuleModel ndkModuleModel;
        if (module2 == null) {
            BuildVariantUpdater.$$$reportNull$$$0(56);
        }
        if ((ndkModuleModel = NdkModuleModel.get(module2)) == null) {
            return null;
        }
        if (ndkModuleModel.getAllVariantAbis().isEmpty()) {
            return null;
        }
        return ndkModuleModel;
    }

    private static void logAndShowBuildVariantFailure(@NotNull String reason) {
        if (reason == null) {
            BuildVariantUpdater.$$$reportNull$$$0(57);
        }
        String prefix = "Unable to select build variant:\n";
        String msg = prefix + reason;
        BuildVariantUpdater.getLog().error(msg);
        msg = msg + ".\n\nConsult IDE log for more details (Help | Show Log)";
        Messages.showErrorDialog((String)msg, (String)"Error");
    }

    private static void logAndShowAbiNameFailure(@NotNull String reason) {
        if (reason == null) {
            BuildVariantUpdater.$$$reportNull$$$0(58);
        }
        String prefix = "Unable to select ABI:\n";
        String msg = prefix + reason;
        BuildVariantUpdater.getLog().error(msg);
        msg = msg + ".\n\nConsult IDE log for more details (Help | Show Log)";
        Messages.showErrorDialog((String)msg, (String)"Error");
    }

    @NotNull
    private static Logger getLog() {
        Logger logger2 = Logger.getInstance(BuildVariantUpdater.class);
        if (logger2 == null) {
            BuildVariantUpdater.$$$reportNull$$$0(59);
        }
        return logger2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 59: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 59: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/variant/view/BuildVariantUpdater";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 13: 
            case 16: 
            case 47: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedBuildVariant";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedAbiName";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildVariantName";
                break;
            }
            case 14: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 17: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variantToSelect";
                break;
            }
            case 18: 
            case 28: 
            case 32: 
            case 37: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "affectedAndroidFacets";
                break;
            }
            case 19: 
            case 23: 
            case 29: 
            case 33: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "affectedNdkFacets";
                break;
            }
            case 20: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ndkFacet";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ndkModuleModel";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variantAbiToSelect";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidFacet";
                break;
            }
            case 26: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidModel";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradlePath";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectVariant";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ndkModel";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newVariant";
                break;
            }
            case 44: 
            case 45: 
            case 48: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variantSelectionChangeListeners";
                break;
            }
            case 54: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 57: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reason";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/variant/view/BuildVariantUpdater";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "getLog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 59: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addSelectionChangeListener";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "updateSelectedBuildVariant";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "updateSelectedAbi";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "updateSelectedVariant";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setVariantSwitchedProperty";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getModuleIdForModule";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findAndUpdateAffectedFacets";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "updateAffectedFacetsForNdkModule";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "updateAffectedFacetsForAndroidModule";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "updateSelectedVariantsForDependencyModules";
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "updateDependencyModule";
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "resolveNewVariantAbi";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "hasBuildFilesChanged";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "requestFullGradleSync";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getSyncListener";
                break;
            }
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "requestVariantOnlyGradleSync";
                break;
            }
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "setupCachedVariant";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "findModule";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "getAndroidModel";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "getNdkModelIfItHasNativeVariantAbis";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "logAndShowBuildVariantFailure";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "logAndShowAbiNameFailure";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 59: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

