/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.util;

import com.android.SdkConstants;
import com.android.tools.idea.util.PropertiesFiles;
import com.android.tools.idea.wizard.template.TemplateData;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.io.Resources;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.PsiManagerEx;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GradleWrapper {
    @NonNls
    public static final String GRADLEW_PROPERTIES_PATH = FileUtil.join((String[])new String[]{SdkConstants.FD_GRADLE_WRAPPER, "gradle-wrapper.properties"});
    private static final Pattern GRADLE_DISTRIBUTION_URL_PATTERN = Pattern.compile(".*/gradle-([^-]+)(-[^\\/\\\\]+)?-(bin|all).zip");
    @NotNull
    private final File myPropertiesFilePath;
    @Nullable
    private final Project myProject;

    @Nullable
    public static GradleWrapper find(@NotNull Project project) {
        String basePath;
        if (project == null) {
            GradleWrapper.$$$reportNull$$$0(0);
        }
        if ((basePath = project.getBasePath()) == null) {
            return null;
        }
        File baseDir = new File(basePath);
        File propertiesFilePath = GradleWrapper.getDefaultPropertiesFilePath(baseDir);
        return propertiesFilePath.isFile() ? new GradleWrapper(propertiesFilePath, project) : null;
    }

    @NotNull
    public static GradleWrapper get(@NotNull File propertiesFilePath, @Nullable Project project) {
        if (propertiesFilePath == null) {
            GradleWrapper.$$$reportNull$$$0(1);
        }
        return new GradleWrapper(propertiesFilePath, project);
    }

    @NotNull
    public static GradleWrapper create(@NotNull VirtualFile projectPath, @Nullable Project project) throws IOException {
        if (projectPath == null) {
            GradleWrapper.$$$reportNull$$$0(2);
        }
        return GradleWrapper.create(projectPath, "6.7.1", project);
    }

    @NotNull
    public static GradleWrapper create(@NotNull File projectPath, @Nullable Project project) throws IOException {
        if (projectPath == null) {
            GradleWrapper.$$$reportNull$$$0(3);
        }
        return GradleWrapper.create(projectPath, "6.7.1", project);
    }

    @NotNull
    public static GradleWrapper create(@NotNull File projectPath, @NotNull String gradleVersion2, @Nullable Project project) throws IOException {
        VirtualFile projectDirVirtualFile;
        if (projectPath == null) {
            GradleWrapper.$$$reportNull$$$0(4);
        }
        if (gradleVersion2 == null) {
            GradleWrapper.$$$reportNull$$$0(5);
        }
        if ((projectDirVirtualFile = VfsUtil.findFileByIoFile((File)projectPath, (boolean)true)) == null) {
            throw new IOException("Not existent project path: " + projectPath);
        }
        return GradleWrapper.create(projectDirVirtualFile, gradleVersion2, project);
    }

    @NotNull
    public static GradleWrapper create(@NotNull VirtualFile projectPath, @NotNull String gradleVersion2, @Nullable Project project) throws IOException {
        if (projectPath == null) {
            GradleWrapper.$$$reportNull$$$0(6);
        }
        if (gradleVersion2 == null) {
            GradleWrapper.$$$reportNull$$$0(7);
        }
        WriteAction.computeAndWait(() -> {
            if (projectPath.findFileByRelativePath(SdkConstants.FD_GRADLE_WRAPPER) == null) {
                boolean madeExecutable;
                VirtualFile wrapperVf = GradleWrapper.getWrapperLocation();
                String sourceRootUrl = wrapperVf.getUrl();
                VfsUtil.copyDirectory(GradleWrapper.class, (VirtualFile)wrapperVf, (VirtualFile)projectPath, it -> projectPath.findFileByRelativePath(it.getUrl().substring(sourceRootUrl.length())) == null);
                VirtualFile gradlewDest = projectPath.findChild("gradlew");
                boolean bl = madeExecutable = gradlewDest != null && new File(gradlewDest.getPath()).setExecutable(true);
                if (!madeExecutable) {
                    Logger.getInstance(GradleWrapper.class).warn("Unable to make gradlew executable");
                }
            }
            return null;
        });
        File propertiesFilePath = GradleWrapper.getDefaultPropertiesFilePath(new File(projectPath.getPath()));
        GradleWrapper gradleWrapper = GradleWrapper.get(propertiesFilePath, project);
        gradleWrapper.updateDistributionUrl(gradleVersion2);
        GradleWrapper gradleWrapper2 = gradleWrapper;
        if (gradleWrapper2 == null) {
            GradleWrapper.$$$reportNull$$$0(8);
        }
        return gradleWrapper2;
    }

    @NotNull
    private static VirtualFile getWrapperLocation() {
        File resource = new File("templates/project/wrapper");
        String resourceName = "/" + resource.getPath().replace('\\', '/');
        URL wrapperUrl = Resources.getResource(TemplateData.class, (String)resourceName);
        VirtualFile wrapperVf = VfsUtil.findFileByURL((URL)wrapperUrl);
        assert (wrapperVf != null);
        wrapperVf.refresh(false, true);
        VirtualFile virtualFile = wrapperVf;
        if (virtualFile == null) {
            GradleWrapper.$$$reportNull$$$0(9);
        }
        return virtualFile;
    }

    private GradleWrapper(@NotNull File propertiesFilePath, @Nullable Project project) {
        if (propertiesFilePath == null) {
            GradleWrapper.$$$reportNull$$$0(10);
        }
        this.myProject = project;
        this.myPropertiesFilePath = propertiesFilePath;
    }

    @NotNull
    public File getPropertiesFilePath() {
        File file2 = this.myPropertiesFilePath;
        if (file2 == null) {
            GradleWrapper.$$$reportNull$$$0(11);
        }
        return file2;
    }

    @Nullable
    public VirtualFile getPropertiesFile() {
        return VfsUtil.findFileByIoFile((File)this.myPropertiesFilePath, (boolean)true);
    }

    @NotNull
    public static File getDefaultPropertiesFilePath(@NotNull File projectPath) {
        if (projectPath == null) {
            GradleWrapper.$$$reportNull$$$0(12);
        }
        return new File(projectPath, GRADLEW_PROPERTIES_PATH);
    }

    public boolean updateDistributionUrlAndDisplayFailure(@NotNull String gradleVersion2) {
        if (gradleVersion2 == null) {
            GradleWrapper.$$$reportNull$$$0(13);
        }
        try {
            boolean updated = this.updateDistributionUrl(gradleVersion2);
            if (updated) {
                return true;
            }
        }
        catch (IOException e) {
            Object msg = String.format("Unable to update Gradle wrapper to use Gradle %1$s\n", gradleVersion2);
            msg = (String)msg + e.getMessage();
            Messages.showErrorDialog((Project)this.myProject, (String)msg, (String)"Unexpected Error");
        }
        return false;
    }

    public boolean updateDistributionUrl(@NotNull String gradleVersion2) throws IOException {
        if (gradleVersion2 == null) {
            GradleWrapper.$$$reportNull$$$0(14);
        }
        Properties properties2 = this.getProperties();
        String distributionUrl = GradleWrapper.getDistributionUrl(gradleVersion2, true);
        String property2 = properties2.getProperty("distributionUrl");
        if (property2 != null && (property2.equals(distributionUrl) || property2.equals(GradleWrapper.getDistributionUrl(gradleVersion2, true)))) {
            return false;
        }
        properties2.setProperty("distributionUrl", distributionUrl);
        GradleWrapper.saveProperties(properties2, this.myPropertiesFilePath, this.myProject);
        return true;
    }

    public boolean updateDistributionUrl(@NotNull File gradleDistribution) throws IOException {
        String path2;
        if (gradleDistribution == null) {
            GradleWrapper.$$$reportNull$$$0(15);
        }
        if (!FileUtilRt.extensionEquals((String)(path2 = gradleDistribution.getPath()), (String)"zip")) {
            throw new IllegalArgumentException("'" + path2 + "' should be a zip file");
        }
        Properties properties2 = this.getProperties();
        properties2.setProperty("distributionUrl", gradleDistribution.toURI().toURL().toString());
        GradleWrapper.saveProperties(properties2, this.myPropertiesFilePath, this.myProject);
        return true;
    }

    @NotNull
    public Properties getProperties() throws IOException {
        Properties properties2 = PropertiesFiles.getProperties(this.myPropertiesFilePath);
        if (properties2 == null) {
            GradleWrapper.$$$reportNull$$$0(16);
        }
        return properties2;
    }

    private static void saveProperties(@NotNull Properties properties2, @NotNull File file2, @Nullable Project project) throws IOException {
        if (properties2 == null) {
            GradleWrapper.$$$reportNull$$$0(17);
        }
        if (file2 == null) {
            GradleWrapper.$$$reportNull$$$0(18);
        }
        PropertiesFiles.savePropertiesToFile(properties2, file2, null);
        VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)file2, (boolean)false);
        if (virtualFile != null) {
            virtualFile.refresh(false, false);
            if (project != null) {
                Document document;
                PsiDocumentManager manager = PsiDocumentManager.getInstance((Project)project);
                PsiFile psiFile2 = PsiManagerEx.getInstanceEx((Project)project).findFile(virtualFile);
                if (psiFile2 != null && (document = manager.getDocument(psiFile2)) != null) {
                    Application app = ApplicationManager.getApplication();
                    app.invokeAndWait(() -> app.runWriteAction(() -> manager.commitDocument(document)));
                }
            }
        }
    }

    @Nullable
    public String getGradleVersion() throws IOException {
        Matcher m;
        String url = this.getProperties().getProperty("distributionUrl");
        if (url != null && (m = GRADLE_DISTRIBUTION_URL_PATTERN.matcher(url)).matches()) {
            return m.group(1);
        }
        return null;
    }

    @Nullable
    public String getGradleFullVersion() throws IOException {
        Matcher m;
        String url = this.getProperties().getProperty("distributionUrl");
        if (url != null && (m = GRADLE_DISTRIBUTION_URL_PATTERN.matcher(url)).matches()) {
            return m.group(1) + Strings.nullToEmpty((String)m.group(2));
        }
        return null;
    }

    @Nullable
    public String getDistributionSha256Sum() throws IOException {
        return this.getProperties().getProperty("distributionSha256Sum");
    }

    @Nullable
    public String getDistributionUrl() throws IOException {
        return this.getProperties().getProperty("distributionUrl");
    }

    @NotNull
    public String getUpdatedDistributionUrl(String gradleVersion2, boolean binOnlyIfCurrentlyUnknown) throws IOException {
        String current = this.getDistributionUrl();
        if (current == null) {
            return GradleWrapper.getDistributionUrl(gradleVersion2, binOnlyIfCurrentlyUnknown);
        }
        if (current.contains("://services.gradle.org/")) {
            Matcher m = GRADLE_DISTRIBUTION_URL_PATTERN.matcher(current);
            if (m.matches()) {
                return GradleWrapper.getDistributionUrl(gradleVersion2, "bin".equals(m.group(3)));
            }
            return GradleWrapper.getDistributionUrl(gradleVersion2, binOnlyIfCurrentlyUnknown);
        }
        Matcher m = GRADLE_DISTRIBUTION_URL_PATTERN.matcher(current);
        if (m.matches()) {
            StringBuilder sb = new StringBuilder();
            sb.append(current, 0, m.start(1));
            sb.append(gradleVersion2);
            sb.append(current, m.end(2) == -1 ? m.end(1) : m.end(2), current.length());
            String string = sb.toString();
            if (string == null) {
                GradleWrapper.$$$reportNull$$$0(19);
            }
            return string;
        }
        return GradleWrapper.getDistributionUrl(gradleVersion2, binOnlyIfCurrentlyUnknown);
    }

    @NotNull
    public static String getDistributionUrl(@NotNull String gradleVersion2, boolean binOnly) {
        if (gradleVersion2 == null) {
            GradleWrapper.$$$reportNull$$$0(20);
        }
        String folderName = GradleWrapper.isSnapshot(gradleVersion2) ? "distributions-snapshots" : "distributions";
        String suffix = binOnly ? "bin" : "all";
        String string = String.format("https://services.gradle.org/%1$s/gradle-%2$s-%3$s.zip", folderName, gradleVersion2, suffix);
        if (string == null) {
            GradleWrapper.$$$reportNull$$$0(21);
        }
        return string;
    }

    @VisibleForTesting
    static boolean isSnapshot(@NotNull String gradleVersion2) {
        if (gradleVersion2 == null) {
            GradleWrapper.$$$reportNull$$$0(22);
        }
        return gradleVersion2.indexOf(45) != -1 && gradleVersion2.endsWith("+0000");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 16: 
            case 19: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 16: 
            case 19: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertiesFilePath";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectPath";
                break;
            }
            case 5: 
            case 7: 
            case 13: 
            case 14: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleVersion";
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 16: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/util/GradleWrapper";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleDistribution";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/util/GradleWrapper";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getWrapperLocation";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertiesFilePath";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getProperties";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getUpdatedDistributionUrl";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getDistributionUrl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "find";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 16: 
            case 19: 
            case 21: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultPropertiesFilePath";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "updateDistributionUrlAndDisplayFailure";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "updateDistributionUrl";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "saveProperties";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getDistributionUrl";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isSnapshot";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 16: 
            case 19: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

