/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.util;

import com.android.annotations.concurrency.Slow;
import com.android.ide.common.repository.NetworkCache;
import com.android.tools.idea.gradle.util.GradleVersionsRepository;
import com.android.tools.idea.gradle.util.GradleVersionsRepositoryKt;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.io.HttpRequests;
import java.io.Closeable;
import java.io.InputStream;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.PooledThreadExecutor;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0014J\u0010\u0010\t\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\nH\u0007J\u0012\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\n0\fJ\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\bH\u0014J \u0010\u0010\u001a\n \u0012*\u0004\u0018\u00010\u00110\u00112\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0014\u00a8\u0006\u0016"}, d2={"Lcom/android/tools/idea/gradle/util/GradleVersionsRepository;", "Lcom/android/ide/common/repository/NetworkCache;", "()V", "error", "", "throwable", "", "message", "", "getKnownVersions", "", "getKnownVersionsFuture", "Lcom/google/common/util/concurrent/ListenableFuture;", "readDefaultData", "Ljava/io/InputStream;", "relative", "readUrlData", "", "kotlin.jvm.PlatformType", "url", "timeout", "", "intellij.android.core"})
public final class GradleVersionsRepository
extends NetworkCache {
    @NotNull
    public static final GradleVersionsRepository INSTANCE;

    protected byte[] readUrlData(@NotNull String url, int timeout) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return HttpRequests.request((String)url).accept("application/json").connectTimeout(timeout).readTimeout(timeout).readBytes(null);
    }

    @Nullable
    protected InputStream readDefaultData(@NotNull String relative) {
        Intrinsics.checkNotNullParameter((Object)relative, (String)"relative");
        return null;
    }

    protected void error(@NotNull Throwable throwable, @Nullable String message2) {
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        Logger.getInstance(GradleVersionsRepository.class).warn(message2, throwable);
    }

    @NotNull
    public final ListenableFuture<List<String>> getKnownVersionsFuture() {
        ListenableFuture listenableFuture = MoreExecutors.listeningDecorator((ExecutorService)PooledThreadExecutor.INSTANCE).submit((Callable)getKnownVersionsFuture.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"MoreExecutors.listeningD\u2026>> { getKnownVersions() }");
        return listenableFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Slow
    @Nullable
    public final List<String> getKnownVersions() {
        List<String> list;
        InputStream inputStream = this.findData("");
        if (inputStream != null) {
            Closeable closeable = inputStream;
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                boolean bl3 = false;
                List<String> list2 = GradleVersionsRepositoryKt.parseGradleVersionsResponse(it);
                list = list2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        } else {
            list = null;
        }
        return list;
    }

    private GradleVersionsRepository() {
        super("https://services.gradle.org/versions/all", "gradle.versions", GradleVersionsRepositoryKt.access$getCacheDir(), 0, 24, false, 40, null);
    }

    static {
        GradleVersionsRepository gradleVersionsRepository;
        INSTANCE = gradleVersionsRepository = new GradleVersionsRepository();
    }
}

