/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.util;

import com.android.ide.common.build.GenericBuiltArtifact;
import com.android.ide.common.build.GenericBuiltArtifacts;
import com.android.ide.common.build.GenericBuiltArtifactsLoader;
import com.android.ide.common.gradle.model.IdeAndroidArtifact;
import com.android.ide.common.gradle.model.IdeAndroidArtifactOutput;
import com.android.ide.common.gradle.model.IdeVariantBuildInformation;
import com.android.tools.idea.AndroidStartupActivity;
import com.android.tools.idea.gradle.project.model.AndroidModelFeatures;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.util.DynamicAppUtils;
import com.android.tools.idea.gradle.util.GradleBuildOutputUtil$WhenMappings;
import com.android.tools.idea.gradle.util.LastBuildOrSyncStartupActivity;
import com.android.tools.idea.gradle.util.OutputType;
import com.android.tools.idea.log.LogWrapper;
import com.android.tools.idea.run.AndroidRunConfigurationBase;
import com.android.utils.ILogger;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000T\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0017\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a2\u0006\u0002\u0010\b\u001a \u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010\u001a\u0018\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016\u001a(\u0010\u0017\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000f\u001a\u00020\u0010\u001a\u0012\u0010\u0017\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001a\u001a\u00020\u0016H\u0007\u001a(\u0010\u001b\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000f\u001a\u00020\u0010\u001a\u001a\u0010\u001c\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002\u001a\"\u0010\u001f\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0002\u001a\u0018\u0010 \u001a\u00020\u00192\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\"\u0014\u0010\u0000\u001a\u00020\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006!"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "emulateStartupActivityForTest", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)Lkotlin/Unit;", "getApkForRunConfiguration", "Ljava/io/File;", "module", "Lcom/intellij/openapi/module/Module;", "configuration", "Lcom/android/tools/idea/run/AndroidRunConfigurationBase;", "isTest", "", "getGenericBuiltArtifact", "Lcom/android/ide/common/build/GenericBuiltArtifacts;", "androidModel", "Lcom/android/tools/idea/gradle/project/model/AndroidModuleModel;", "variantName", "", "getOutputFileOrFolderFromListingFile", "outputType", "Lcom/android/tools/idea/gradle/util/OutputType;", "listingFile", "getOutputListingFile", "getOutputListingFileFromAndroidArtifact", "testArtifact", "Lcom/android/ide/common/gradle/model/IdeAndroidArtifact;", "getOutputListingFileFromVariantBuildInformation", "getOutputType", "intellij.android.core"})
@JvmName(name="GradleBuildOutputUtil")
public final class GradleBuildOutputUtil {
    private static final Logger getLOG() {
        Logger logger2 = Logger.getInstance((String)"#com.android.tools.idea.gradle.util.GradleBuildOutputUtil");
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"Logger.getInstance(\"#com\u2026l.GradleBuildOutputUtil\")");
        return logger2;
    }

    @Nullable
    public static final String getOutputListingFile(@NotNull AndroidModuleModel androidModel, @NotNull String variantName, @NotNull OutputType outputType, boolean isTest) {
        String string;
        Intrinsics.checkNotNullParameter((Object)androidModel, (String)"androidModel");
        Intrinsics.checkNotNullParameter((Object)variantName, (String)"variantName");
        Intrinsics.checkNotNullParameter((Object)((Object)outputType), (String)"outputType");
        if (isTest) {
            IdeAndroidArtifact ideAndroidArtifact = androidModel.getSelectedVariant().getAndroidTestArtifact();
            if (ideAndroidArtifact != null) {
                IdeAndroidArtifact ideAndroidArtifact2 = ideAndroidArtifact;
                boolean bl = false;
                boolean bl2 = false;
                IdeAndroidArtifact it = ideAndroidArtifact2;
                boolean bl3 = false;
                string = GradleBuildOutputUtil.getOutputListingFileFromAndroidArtifact(it, outputType);
            } else {
                string = null;
            }
        } else {
            string = GradleBuildOutputUtil.getOutputListingFileFromVariantBuildInformation(androidModel, variantName, outputType);
        }
        return string;
    }

    @Nullable
    public static final File getApkForRunConfiguration(@NotNull Module module2, @NotNull AndroidRunConfigurationBase configuration, boolean isTest) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        AndroidModuleModel androidModel = AndroidModuleModel.get(module2);
        if (androidModel == null) {
            return null;
        }
        AndroidModelFeatures androidModelFeatures = androidModel.getFeatures();
        Intrinsics.checkNotNullExpressionValue((Object)androidModelFeatures, (String)"androidModel.features");
        if (androidModelFeatures.isBuildOutputFileSupported()) {
            return GradleBuildOutputUtil.getOutputFileOrFolderFromListingFile(androidModel, androidModel.getSelectedVariant().getName(), GradleBuildOutputUtil.getOutputType(module2, configuration), isTest);
        }
        IdeAndroidArtifact artifact = isTest ? androidModel.getSelectedVariant().getAndroidTestArtifact() : androidModel.getSelectedVariant().getMainArtifact();
        Object object = artifact;
        return object != null && (object = object.getOutputs()) != null && (object = (IdeAndroidArtifactOutput)CollectionsKt.firstOrNull((List)object)) != null ? object.getOutputFile() : null;
    }

    @Nullable
    public static final File getOutputFileOrFolderFromListingFile(@NotNull AndroidModuleModel androidModel, @NotNull String variantName, @NotNull OutputType outputType, boolean isTest) {
        Intrinsics.checkNotNullParameter((Object)androidModel, (String)"androidModel");
        Intrinsics.checkNotNullParameter((Object)variantName, (String)"variantName");
        Intrinsics.checkNotNullParameter((Object)((Object)outputType), (String)"outputType");
        String listingFile = GradleBuildOutputUtil.getOutputListingFile(androidModel, variantName, outputType, isTest);
        if (listingFile != null) {
            return GradleBuildOutputUtil.getOutputFileOrFolderFromListingFile(listingFile);
        }
        GradleBuildOutputUtil.getLOG().warn("Could not find output listing file. Build may have failed.");
        return null;
    }

    @VisibleForTesting
    @Nullable
    public static final File getOutputFileOrFolderFromListingFile(@NotNull String listingFile) {
        Collection artifacts;
        Intrinsics.checkNotNullParameter((Object)listingFile, (String)"listingFile");
        GenericBuiltArtifacts builtArtifacts = GenericBuiltArtifactsLoader.loadFromFile((File)new File(listingFile), (ILogger)((ILogger)new LogWrapper(GradleBuildOutputUtil.getLOG())));
        if (builtArtifacts != null && !(artifacts = builtArtifacts.getElements()).isEmpty()) {
            File output = new File(((GenericBuiltArtifact)artifacts.iterator().next()).getOutputFile());
            return artifacts.size() > 1 ? output.getParentFile() : output;
        }
        GradleBuildOutputUtil.getLOG().warn("Failed to read Json output file from " + listingFile + ". Build may have failed.");
        return null;
    }

    private static final OutputType getOutputType(Module module2, AndroidRunConfigurationBase configuration) {
        return DynamicAppUtils.useSelectApksFromBundleBuilder(module2, configuration, null) ? OutputType.ApkFromBundle : OutputType.Apk;
    }

    private static final String getOutputListingFileFromVariantBuildInformation(AndroidModuleModel androidModel, String variantName, OutputType outputType) {
        String string;
        IdeVariantBuildInformation buildInformation;
        Object v0;
        block6: {
            Iterable $this$firstOrNull$iv = androidModel.getAndroidProject().getVariantsBuildInformation();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                IdeVariantBuildInformation it = (IdeVariantBuildInformation)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getVariantName(), (Object)variantName)) continue;
                v0 = element$iv;
                break block6;
            }
            v0 = null;
        }
        if ((buildInformation = (IdeVariantBuildInformation)v0) == null) {
            return null;
        }
        switch (GradleBuildOutputUtil$WhenMappings.$EnumSwitchMapping$0[outputType.ordinal()]) {
            case 1: {
                string = buildInformation.getAssembleTaskOutputListingFile();
                break;
            }
            case 2: {
                string = buildInformation.getApkFromBundleTaskOutputListingFile();
                break;
            }
            default: {
                string = buildInformation.getBundleTaskOutputListingFile();
            }
        }
        return string;
    }

    private static final String getOutputListingFileFromAndroidArtifact(IdeAndroidArtifact testArtifact, OutputType outputType) {
        String string;
        switch (GradleBuildOutputUtil$WhenMappings.$EnumSwitchMapping$1[outputType.ordinal()]) {
            case 1: {
                string = testArtifact.getAssembleTaskOutputListingFile();
                break;
            }
            case 2: {
                string = testArtifact.getApkFromBundleTaskOutputListingFile();
                break;
            }
            default: {
                string = testArtifact.getBundleTaskOutputListingFile();
            }
        }
        return string;
    }

    @Nullable
    public static final GenericBuiltArtifacts getGenericBuiltArtifact(@NotNull AndroidModuleModel androidModel, @NotNull String variantName) {
        Intrinsics.checkNotNullParameter((Object)androidModel, (String)"androidModel");
        Intrinsics.checkNotNullParameter((Object)variantName, (String)"variantName");
        String string = GradleBuildOutputUtil.getOutputListingFileFromVariantBuildInformation(androidModel, variantName, OutputType.Apk);
        if (string == null) {
            return null;
        }
        String listingFile = string;
        GenericBuiltArtifacts builtArtifacts = GenericBuiltArtifactsLoader.loadFromFile((File)new File(listingFile), (ILogger)((ILogger)new LogWrapper(GradleBuildOutputUtil.getLOG())));
        if (builtArtifacts != null) {
            return builtArtifacts;
        }
        GradleBuildOutputUtil.getLOG().warn("Failed to read Json output file from " + listingFile + ". Build may have failed.");
        return null;
    }

    @TestOnly
    @Nullable
    public static final Unit emulateStartupActivityForTest(@NotNull Project project) {
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        LastBuildOrSyncStartupActivity lastBuildOrSyncStartupActivity = (LastBuildOrSyncStartupActivity)AndroidStartupActivity.STARTUP_ACTIVITY.findExtension(LastBuildOrSyncStartupActivity.class);
        if (lastBuildOrSyncStartupActivity != null) {
            lastBuildOrSyncStartupActivity.runActivity(project, (Disposable)project);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }
}

