/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.util;

import com.android.tools.idea.IdeInfo;
import com.google.common.collect.Lists;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableEP;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class AndroidStudioPreferences {
    private static final List<String> PROJECT_PREFERENCES_TO_REMOVE = Lists.newArrayList((Object[])new String[]{"org.intellij.lang.xpath.xslt.associations.impl.FileAssociationsConfigurable", "com.intellij.uiDesigner.GuiDesignerConfigurable", "org.jetbrains.plugins.groovy.gant.GantConfigurable", "org.jetbrains.plugins.groovy.compiler.GroovyCompilerConfigurable", "org.jetbrains.android.compiler.AndroidDexCompilerSettingsConfigurable", "org.jetbrains.idea.maven.utils.MavenSettings", "com.intellij.compiler.options.CompilerConfigurable"});

    public static void cleanUpPreferences(@NotNull Project project) {
        if (project == null) {
            AndroidStudioPreferences.$$$reportNull$$$0(0);
        }
        if (!IdeInfo.getInstance().isAndroidStudio()) {
            return;
        }
        ExtensionPoint projectConfigurable = Configurable.PROJECT_CONFIGURABLE.getPoint((AreaInstance)project);
        ArrayList nonStudioExtensions = Lists.newArrayList();
        for (ConfigurableEP extension : projectConfigurable.getExtensionList()) {
            if (!PROJECT_PREFERENCES_TO_REMOVE.contains(extension.instanceClass)) continue;
            nonStudioExtensions.add(extension);
        }
        projectConfigurable.unregisterExtensions(ep -> nonStudioExtensions.contains(ep));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/AndroidStudioPreferences", "cleanUpPreferences"));
    }
}

