/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.model.repositories.search;

import com.android.tools.idea.gradle.structure.model.repositories.search.ArtifactRepositorySearchService;
import com.android.tools.idea.gradle.structure.model.repositories.search.SearchRequest;
import com.android.tools.idea.gradle.structure.model.repositories.search.SearchResult;
import com.android.tools.idea.gradle.structure.model.repositories.search.SearchResultStats;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.wireless.android.sdk.stats.PSDEvent;
import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.ide.PooledThreadExecutor;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H$J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00120\u00172\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u00020\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\nR\u0012\u0010\u000b\u001a\u00020\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/idea/gradle/structure/model/repositories/search/ArtifactRepository;", "Lcom/android/tools/idea/gradle/structure/model/repositories/search/ArtifactRepositorySearchService;", "repoForStats", "Lcom/google/wireless/android/sdk/stats/PSDEvent$PSDRepositoryUsage$PSDRepository;", "(Lcom/google/wireless/android/sdk/stats/PSDEvent$PSDRepositoryUsage$PSDRepository;)V", "executor", "Lcom/google/common/util/concurrent/ListeningExecutorService;", "kotlin.jvm.PlatformType", "isRemote", "", "()Z", "name", "", "getName", "()Ljava/lang/String;", "getRepoForStats", "()Lcom/google/wireless/android/sdk/stats/PSDEvent$PSDRepositoryUsage$PSDRepository;", "doSearch", "Lcom/android/tools/idea/gradle/structure/model/repositories/search/SearchResult;", "request", "Lcom/android/tools/idea/gradle/structure/model/repositories/search/SearchRequest;", "executeAndMeasure", "search", "Lcom/google/common/util/concurrent/ListenableFuture;", "intellij.android.projectSystem.gradle.psd"})
public abstract class ArtifactRepository
implements ArtifactRepositorySearchService {
    private final ListeningExecutorService executor;
    @NotNull
    private final PSDEvent.PSDRepositoryUsage.PSDRepository repoForStats;

    @NotNull
    public abstract String getName();

    public abstract boolean isRemote();

    @NotNull
    protected abstract SearchResult doSearch(@NotNull SearchRequest var1) throws Exception;

    @Override
    @NotNull
    public ListenableFuture<SearchResult> search(@NotNull SearchRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        ListenableFuture listenableFuture = this.executor.submit(new Callable(this, request){
            final /* synthetic */ ArtifactRepository this$0;
            final /* synthetic */ SearchRequest $request;

            public final SearchResult call() {
                return ArtifactRepository.access$executeAndMeasure(this.this$0, this.$request);
            }
            {
                this.this$0 = artifactRepository;
                this.$request = searchRequest;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"executor.submit(Callable\u2026uteAndMeasure(request) })");
        return listenableFuture;
    }

    private final SearchResult executeAndMeasure(SearchRequest request) {
        SearchResult searchResult;
        long startedAt = System.currentTimeMillis();
        try {
            searchResult = this.doSearch(request);
        }
        catch (Exception e) {
            searchResult = new SearchResult(e);
        }
        Duration duration2 = Duration.ofMillis(System.currentTimeMillis() - startedAt);
        Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"Duration.ofMillis(System\u2026TimeMillis() - startedAt)");
        return SearchResult.copy$default(searchResult, null, null, SearchResultStats.Companion.duration(this.repoForStats, duration2), 3, null);
    }

    @NotNull
    public final PSDEvent.PSDRepositoryUsage.PSDRepository getRepoForStats() {
        return this.repoForStats;
    }

    public ArtifactRepository(@NotNull PSDEvent.PSDRepositoryUsage.PSDRepository repoForStats) {
        Intrinsics.checkNotNullParameter((Object)repoForStats, (String)"repoForStats");
        this.repoForStats = repoForStats;
        this.executor = MoreExecutors.listeningDecorator((ExecutorService)PooledThreadExecutor.INSTANCE);
    }

    public static final /* synthetic */ SearchResult access$executeAndMeasure(ArtifactRepository $this, SearchRequest request) {
        return $this.executeAndMeasure(request);
    }
}

