/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.configurables.ui.treeview;

import com.android.tools.idea.gradle.structure.configurables.ui.UiUtil;
import com.android.tools.idea.gradle.structure.configurables.ui.treeview.AbstractBaseTreeBuilder;
import com.android.tools.idea.gradle.structure.configurables.ui.treeview.AbstractPsModelNode;
import com.google.common.base.Strings;
import com.intellij.ide.util.treeView.AbstractTreeUi;
import com.intellij.ide.util.treeView.TreeVisitor;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.ui.speedSearch.SpeedSearchSupply;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TreeBuilderSpeedSearch
extends SpeedSearchSupply {
    @NonNls
    private static final String ENTERED_PREFIX_PROPERTY_NAME = "enteredPrefix";
    @NotNull
    private final AbstractBaseTreeBuilder myTreeBuilder;
    @NotNull
    private final JTree myTree;
    @NotNull
    private final PropertyChangeSupport myChangeSupport;
    @NotNull
    private final SpeedSearchComparator myComparator;
    private String myRecentEnteredPrefix;
    private SearchPopup mySearchPopup;
    private JLayeredPane myPopupLayeredPane;

    public static void installTo(@NotNull AbstractBaseTreeBuilder treeBuilder) {
        if (treeBuilder == null) {
            TreeBuilderSpeedSearch.$$$reportNull$$$0(0);
        }
        new TreeBuilderSpeedSearch(treeBuilder);
    }

    private TreeBuilderSpeedSearch(@NotNull AbstractBaseTreeBuilder treeBuilder) {
        if (treeBuilder == null) {
            TreeBuilderSpeedSearch.$$$reportNull$$$0(1);
        }
        this.myChangeSupport = new PropertyChangeSupport((Object)this);
        this.myComparator = new SpeedSearchComparator(false);
        this.myTreeBuilder = treeBuilder;
        this.myTree = this.myTreeBuilder.getUi().getTree();
        this.myTree.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent event) {
                TreeBuilderSpeedSearch.this.manageSearchPopup(null);
            }

            @Override
            public void componentMoved(ComponentEvent event) {
                TreeBuilderSpeedSearch.this.moveSearchPopup();
            }

            @Override
            public void componentResized(ComponentEvent event) {
                TreeBuilderSpeedSearch.this.moveSearchPopup();
            }
        });
        this.myTree.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                TreeBuilderSpeedSearch.this.manageSearchPopup(null);
            }
        });
        this.myTree.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                TreeBuilderSpeedSearch.this.processKeyEvent(e);
            }

            @Override
            public void keyPressed(KeyEvent e) {
                TreeBuilderSpeedSearch.this.processKeyEvent(e);
            }
        });
        this.installSupplyTo(this.myTree);
    }

    private void manageSearchPopup(@Nullable SearchPopup searchPopup) {
        if (this.mySearchPopup != null) {
            this.myPopupLayeredPane.remove(this.mySearchPopup);
            UiUtil.revalidateAndRepaint(this.myPopupLayeredPane);
            this.myPopupLayeredPane = null;
        }
        this.mySearchPopup = !this.myTree.isShowing() ? null : searchPopup;
        if (this.mySearchPopup == null || !this.myTree.isDisplayable()) {
            return;
        }
        JRootPane rootPane = this.myTree.getRootPane();
        this.myPopupLayeredPane = rootPane != null ? rootPane.getLayeredPane() : null;
        if (this.myPopupLayeredPane == null) {
            return;
        }
        this.myPopupLayeredPane.add((Component)this.mySearchPopup, JLayeredPane.POPUP_LAYER);
        this.moveSearchPopup();
    }

    private void moveSearchPopup() {
        if (this.mySearchPopup == null || this.myPopupLayeredPane == null) {
            return;
        }
        Window window2 = (Window)SwingUtilities.getAncestorOfClass(Window.class, this.myTree);
        Point windowLocation = window2 instanceof JDialog ? ((JDialog)window2).getContentPane().getLocationOnScreen() : (window2 instanceof JFrame ? ((JFrame)window2).getContentPane().getLocationOnScreen() : window2.getLocationOnScreen());
        Rectangle visibleRect = this.getComponentVisibleRect();
        Dimension searchPopupPreferredSize = this.mySearchPopup.getPreferredSize();
        Point popUpLayeredPaneLocation = this.myPopupLayeredPane.getLocationOnScreen();
        Point locationOnScreen = this.getComponentLocationOnScreen();
        int y = visibleRect.y + locationOnScreen.y - popUpLayeredPaneLocation.y - searchPopupPreferredSize.height;
        y = Math.max(y, windowLocation.y - popUpLayeredPaneLocation.y);
        this.mySearchPopup.setLocation(locationOnScreen.x - popUpLayeredPaneLocation.x + visibleRect.x, y);
        this.mySearchPopup.setSize(searchPopupPreferredSize);
        this.mySearchPopup.setVisible(true);
        this.mySearchPopup.validate();
    }

    protected Rectangle getComponentVisibleRect() {
        return this.myTree.getVisibleRect();
    }

    protected Point getComponentLocationOnScreen() {
        return this.myTree.getLocationOnScreen();
    }

    protected void processKeyEvent(@NotNull KeyEvent e) {
        if (e == null) {
            TreeBuilderSpeedSearch.$$$reportNull$$$0(2);
        }
        if (e.isAltDown() || e.isShiftDown()) {
            return;
        }
        if (this.mySearchPopup != null) {
            this.mySearchPopup.processKeyEvent(e);
            return;
        }
        if (e.getID() == 400) {
            if (!UIUtil.isReallyTypedEvent((KeyEvent)e)) {
                return;
            }
            char c = e.getKeyChar();
            if (Character.isLetterOrDigit(c) || c == '_' || c == '*' || c == '/' || c == ':' || c == '.' || c == '#' || c == '$') {
                this.manageSearchPopup(new SearchPopup(String.valueOf(c)));
                e.consume();
            }
        }
    }

    @Nullable
    public String getEnteredPrefix() {
        return this.mySearchPopup != null ? this.mySearchPopup.mySearchField.getText() : null;
    }

    @Nullable
    public Iterable<TextRange> matchingFragments(@NotNull String text2) {
        String recentSearchText;
        if (text2 == null) {
            TreeBuilderSpeedSearch.$$$reportNull$$$0(3);
        }
        return StringUtil.isNotEmpty((String)(recentSearchText = this.myComparator.getRecentSearchText())) ? this.myComparator.matchingFragments(recentSearchText, text2) : null;
    }

    public void refreshSelection() {
        if (this.mySearchPopup != null) {
            this.mySearchPopup.refreshSelection();
        }
    }

    public boolean isPopupActive() {
        return this.mySearchPopup != null && this.mySearchPopup.isVisible();
    }

    public void addChangeListener(@NotNull PropertyChangeListener listener2) {
        if (listener2 == null) {
            TreeBuilderSpeedSearch.$$$reportNull$$$0(4);
        }
        this.myChangeSupport.addPropertyChangeListener(listener2);
    }

    public void removeChangeListener(@NotNull PropertyChangeListener listener2) {
        if (listener2 == null) {
            TreeBuilderSpeedSearch.$$$reportNull$$$0(5);
        }
        this.myChangeSupport.removePropertyChangeListener(listener2);
    }

    private void fireStateChanged() {
        String enteredPrefix = this.getEnteredPrefix();
        this.myChangeSupport.firePropertyChange(ENTERED_PREFIX_PROPERTY_NAME, this.myRecentEnteredPrefix, enteredPrefix);
        this.myRecentEnteredPrefix = enteredPrefix;
    }

    public void findAndSelectElement(@NotNull String searchQuery) {
        if (searchQuery == null) {
            TreeBuilderSpeedSearch.$$$reportNull$$$0(6);
        }
        final String pattern = searchQuery.trim();
        this.myTree.clearSelection();
        if (searchQuery.isEmpty()) {
            return;
        }
        ActionCallback initialized = this.myTreeBuilder.getInitialized();
        initialized.doWhenDone(() -> {
            Object foreground;
            final ArrayList nodes = new ArrayList();
            this.myTreeBuilder.accept(AbstractPsModelNode.class, (TreeVisitor)new TreeVisitor<AbstractPsModelNode>(){

                public boolean visit(@NotNull AbstractPsModelNode node2) {
                    if (node2 == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    if (TreeBuilderSpeedSearch.this.isMatchingElement(node2, pattern)) {
                        nodes.add(node2);
                    }
                    return false;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/android/tools/idea/gradle/structure/configurables/ui/treeview/TreeBuilderSpeedSearch$4", "visit"));
                }
            });
            Object object = foreground = nodes.isEmpty() ? JBColor.red : UIUtil.getToolTipForeground();
            if (this.mySearchPopup != null) {
                this.mySearchPopup.mySearchField.setForeground((Color)foreground);
            }
            if (nodes.isEmpty()) {
                return;
            }
            Runnable onDone = () -> {
                this.myTreeBuilder.expandParents(nodes);
                this.myTreeBuilder.scrollToFirstSelectedRow();
            };
            this.myTreeBuilder.getUi().userSelect(nodes.toArray(), () -> {
                AbstractTreeUi ui = this.myTreeBuilder.getUi();
                if (ui != null) {
                    ui.executeUserRunnable(onDone);
                } else {
                    onDone.run();
                }
            }, false, false);
        });
    }

    @NotNull
    private List<AbstractPsModelNode> findNodes(@NotNull String searchQuery) {
        if (searchQuery == null) {
            TreeBuilderSpeedSearch.$$$reportNull$$$0(7);
        }
        final String pattern = searchQuery.trim();
        final ArrayList<AbstractPsModelNode> nodes = new ArrayList<AbstractPsModelNode>();
        ActionCallback initialized = this.myTreeBuilder.getInitialized();
        initialized.doWhenDone(() -> this.myTreeBuilder.accept(AbstractPsModelNode.class, (TreeVisitor)new TreeVisitor<AbstractPsModelNode>(){

            public boolean visit(@NotNull AbstractPsModelNode node2) {
                if (node2 == null) {
                    5.$$$reportNull$$$0(0);
                }
                if (TreeBuilderSpeedSearch.this.isMatchingElement(node2, pattern)) {
                    nodes.add(node2);
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/android/tools/idea/gradle/structure/configurables/ui/treeview/TreeBuilderSpeedSearch$5", "visit"));
            }
        }));
        ArrayList<AbstractPsModelNode> arrayList = nodes;
        if (arrayList == null) {
            TreeBuilderSpeedSearch.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    private boolean isMatchingElement(@NotNull AbstractPsModelNode node2, @Nullable String pattern) {
        String text2;
        if (node2 == null) {
            TreeBuilderSpeedSearch.$$$reportNull$$$0(9);
        }
        return (text2 = node2.getName()) != null && this.compare(text2, pattern);
    }

    private boolean compare(@NotNull String text2, @Nullable String pattern) {
        if (text2 == null) {
            TreeBuilderSpeedSearch.$$$reportNull$$$0(10);
        }
        return pattern != null && this.myComparator.matchingFragments(pattern, text2) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treeBuilder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchQuery";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/structure/configurables/ui/treeview/TreeBuilderSpeedSearch";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/structure/configurables/ui/treeview/TreeBuilderSpeedSearch";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "findNodes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "installTo";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "processKeyEvent";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "matchingFragments";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addChangeListener";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "removeChangeListener";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findAndSelectElement";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findNodes";
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isMatchingElement";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "compare";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class SearchField
    extends JTextField {
        SearchField() {
            this.setFocusable(false);
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension preferredSize = super.getPreferredSize();
            preferredSize.width = this.getFontMetrics(this.getFont()).stringWidth(this.getText()) + 10;
            return preferredSize;
        }

        @Override
        public void processKeyEvent(KeyEvent e) {
            int keyCode = e.getKeyCode();
            if (keyCode == 8 && this.getDocument().getLength() == 0) {
                e.consume();
                return;
            }
            if (keyCode == 10 || keyCode == 27 || keyCode == 33 || keyCode == 34 || keyCode == 37 || keyCode == 39) {
                TreeBuilderSpeedSearch.this.manageSearchPopup(null);
                if (keyCode == 27) {
                    e.consume();
                }
                return;
            }
            super.processKeyEvent(e);
            if (keyCode == 8) {
                e.consume();
            }
        }
    }

    private class SearchPopup
    extends JPanel {
        @NotNull
        private final SearchField mySearchField;

        SearchPopup(String initialString) {
            super(new BorderLayout());
            JBColor background = new JBColor(UIUtil.getToolTipBackground().brighter(), (Color)Gray._111);
            this.mySearchField = new SearchField();
            this.mySearchField.setBorder(null);
            this.mySearchField.setBackground((Color)background);
            this.mySearchField.setForeground(UIUtil.getToolTipForeground());
            this.mySearchField.setDocument(new PlainDocument(){

                @Override
                public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
                    String oldText;
                    try {
                        oldText = this.getText(0, this.getLength());
                    }
                    catch (BadLocationException e1) {
                        oldText = "";
                    }
                    String newText = oldText.substring(0, offs) + str + oldText.substring(offs);
                    super.insertString(offs, str, a);
                    if (TreeBuilderSpeedSearch.this.findNodes(newText).isEmpty()) {
                        SearchPopup.this.mySearchField.setForeground((Color)JBColor.RED);
                    } else {
                        SearchPopup.this.mySearchField.setForeground(UIUtil.getToolTipForeground());
                    }
                }
            });
            this.mySearchField.setText(Strings.nullToEmpty((String)initialString));
            JLabel searchLabel = new JLabel(" Search for: ");
            searchLabel.setFont(searchLabel.getFont().deriveFont(1));
            searchLabel.setForeground(UIUtil.getToolTipForeground());
            this.setBorder(BorderFactory.createLineBorder((Color)JBColor.GRAY, 1));
            this.setBackground((Color)background);
            this.add((Component)searchLabel, "West");
            this.add((Component)this.mySearchField, "East");
            this.refreshSelection();
        }

        @Override
        public void processKeyEvent(KeyEvent e) {
            this.mySearchField.processKeyEvent(e);
            if (e.isConsumed()) {
                this.refreshSelection();
            }
        }

        void refreshSelection() {
            if (TreeBuilderSpeedSearch.this.mySearchPopup != null) {
                TreeBuilderSpeedSearch.this.mySearchPopup.setSize(TreeBuilderSpeedSearch.this.mySearchPopup.getPreferredSize());
                TreeBuilderSpeedSearch.this.mySearchPopup.validate();
            }
            TreeBuilderSpeedSearch.this.findAndSelectElement(this.mySearchField.getText());
            TreeBuilderSpeedSearch.this.fireStateChanged();
        }
    }
}

