/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.configurables.ui.treeview;

import com.android.tools.idea.gradle.structure.configurables.PsContext;
import com.android.tools.idea.gradle.structure.configurables.issues.IssuesByTypeAndTextComparator;
import com.android.tools.idea.gradle.structure.configurables.ui.UiUtil;
import com.android.tools.idea.gradle.structure.configurables.ui.treeview.AbstractPsModelNode;
import com.android.tools.idea.gradle.structure.model.PsChildModel;
import com.android.tools.idea.gradle.structure.model.PsIssue;
import com.android.tools.idea.gradle.structure.model.PsIssueCollection;
import com.android.tools.idea.gradle.structure.model.PsIssueCollectionKt;
import com.android.tools.idea.gradle.structure.model.PsModel;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.NodeRenderer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.roots.ui.CellAppearanceEx;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.ui.treeStructure.Tree;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeHyperlinkSupport<T extends SimpleNode>
implements Disposable {
    @NotNull
    private final Tree myTree;
    @NotNull
    private final Class<T> mySupportedNodeType;
    @NotNull
    private final PsContext myContext;
    private final boolean myShowIssues;
    private T myHoveredNode;
    private KeyEventDispatcher myKeyEventDispatcher;

    public NodeHyperlinkSupport(@NotNull Tree tree, @NotNull Class<T> supportedNodeType, @NotNull PsContext context, boolean showIssues) {
        if (tree == null) {
            NodeHyperlinkSupport.$$$reportNull$$$0(0);
        }
        if (supportedNodeType == null) {
            NodeHyperlinkSupport.$$$reportNull$$$0(1);
        }
        if (context == null) {
            NodeHyperlinkSupport.$$$reportNull$$$0(2);
        }
        this.myTree = tree;
        this.mySupportedNodeType = supportedNodeType;
        this.myContext = context;
        this.myShowIssues = showIssues;
        this.addHyperlinkBehaviorToSupportedNodes();
        this.myTree.repaint();
    }

    private void addHyperlinkBehaviorToSupportedNodes() {
        this.myTree.setCellRenderer((TreeCellRenderer)new NodeRenderer(){

            @NotNull
            protected SimpleTextAttributes getSimpleTextAttributes(@NotNull PresentationData presentation, Color color, @NotNull Object node2) {
                if (presentation == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (node2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                List<Object> issues = Collections.emptyList();
                if (NodeHyperlinkSupport.this.myShowIssues && node2 instanceof AbstractPsModelNode) {
                    AbstractPsModelNode modelNode = (AbstractPsModelNode)node2;
                    issues = NodeHyperlinkSupport.this.findIssues(modelNode, IssuesByTypeAndTextComparator.INSTANCE);
                    presentation.setTooltip(PsIssueCollectionKt.getTooltipText(issues, false));
                }
                if (NodeHyperlinkSupport.this.myHoveredNode != null && NodeHyperlinkSupport.this.myHoveredNode == node2) {
                    SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.LINK_ATTRIBUTES;
                    if (simpleTextAttributes == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return simpleTextAttributes;
                }
                SimpleTextAttributes textAttributes = super.getSimpleTextAttributes(presentation, color, node2);
                if (!issues.isEmpty()) {
                    PsIssue issue2 = (PsIssue)issues.get(0);
                    Color waveColor = issue2.getSeverity().getColor();
                    textAttributes = textAttributes.derive(8, null, null, waveColor);
                }
                SimpleTextAttributes simpleTextAttributes = textAttributes;
                if (simpleTextAttributes == null) {
                    1.$$$reportNull$$$0(3);
                }
                return simpleTextAttributes;
            }

            public void customizeCellRenderer(@NotNull JTree tree, Object value2, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                List<PsIssue> issues;
                AbstractPsModelNode<? extends PsModel> modelNode;
                if (tree == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (NodeHyperlinkSupport.this.myShowIssues && (modelNode = this.findModelNode(value2)) != null && !(issues = NodeHyperlinkSupport.this.findIssues(modelNode, null)).isEmpty()) {
                    modelNode.getPresentation().clearText();
                }
                super.customizeCellRenderer(tree, value2, selected, expanded, leaf, row, hasFocus);
                Object userObject = ((DefaultMutableTreeNode)value2).getUserObject();
                if (userObject instanceof CellAppearanceEx) {
                    ((CellAppearanceEx)userObject).customize((SimpleColoredComponent)this);
                }
            }

            @Nullable
            private AbstractPsModelNode<? extends PsModel> findModelNode(@Nullable Object value2) {
                DefaultMutableTreeNode node2;
                Object userObject;
                if (value2 instanceof DefaultMutableTreeNode && (userObject = (node2 = (DefaultMutableTreeNode)value2).getUserObject()) instanceof AbstractPsModelNode) {
                    return (AbstractPsModelNode)userObject;
                }
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: 
                    case 3: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: 
                    case 3: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "presentation";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "node";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/android/tools/idea/gradle/structure/configurables/ui/treeview/NodeHyperlinkSupport$1";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "tree";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/android/tools/idea/gradle/structure/configurables/ui/treeview/NodeHyperlinkSupport$1";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getSimpleTextAttributes";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getSimpleTextAttributes";
                        break;
                    }
                    case 2: 
                    case 3: {
                        break;
                    }
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "customizeCellRenderer";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: 
                    case 3: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
        MouseAdapter mouseListener2 = new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                Cursor cursor = null;
                Object node2 = NodeHyperlinkSupport.this.getIfHyperlink(e);
                if (node2 != null) {
                    cursor = Cursor.getPredefinedCursor(12);
                }
                NodeHyperlinkSupport.this.setHoveredNode(node2);
                NodeHyperlinkSupport.this.myTree.setCursor(cursor);
            }
        };
        this.myTree.addMouseMotionListener((MouseMotionListener)mouseListener2);
        this.myKeyEventDispatcher = e -> {
            T node2 = null;
            if (e.getID() == 401) {
                Cursor cursor = null;
                if (UiUtil.isMetaOrCtrlKeyPressed(e) && (node2 = (T)this.getNodeUnderMousePointer()) != null) {
                    cursor = Cursor.getPredefinedCursor(12);
                }
                this.setHoveredNode(node2);
                this.myTree.setCursor(cursor);
            } else if (e.getID() == 402) {
                if (UiUtil.isMetaOrCtrlKeyPressed(e)) {
                    this.setHoveredNode(null);
                }
                this.myTree.setCursor(null);
            }
            return false;
        };
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this.myKeyEventDispatcher);
    }

    @NotNull
    private List<PsIssue> findIssues(@NotNull AbstractPsModelNode<? extends PsModel> modelNode, @Nullable Comparator<PsIssue> comparator2) {
        if (modelNode == null) {
            NodeHyperlinkSupport.$$$reportNull$$$0(3);
        }
        ArrayList<PsIssue> issues = new ArrayList<PsIssue>();
        PsIssueCollection issueCollection = this.myContext.getAnalyzerDaemon().getIssues();
        for (PsModel model2 : modelNode.getModels()) {
            if (!(model2 instanceof PsChildModel)) continue;
            issues.addAll(issueCollection.findIssues(model2.getPath(), null));
        }
        if (comparator2 != null && issues.size() > 1) {
            issues.sort(comparator2);
        }
        ArrayList<PsIssue> arrayList = issues;
        if (arrayList == null) {
            NodeHyperlinkSupport.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    private void setHoveredNode(@Nullable T node2) {
        this.myHoveredNode = node2;
        if (this.myHoveredNode != null) {
            this.myHoveredNode.getPresentation().clearText();
        }
        this.myTree.repaint();
    }

    @Nullable
    public T getIfHyperlink(@NotNull MouseEvent e) {
        if (e == null) {
            NodeHyperlinkSupport.$$$reportNull$$$0(5);
        }
        if (UiUtil.isMetaOrCtrlKeyPressed(e)) {
            return this.getNodeForLocation(e.getX(), e.getY());
        }
        return null;
    }

    private T getNodeUnderMousePointer() {
        PointerInfo pointerInfo = MouseInfo.getPointerInfo();
        if (pointerInfo != null) {
            Point location = pointerInfo.getLocation();
            SwingUtilities.convertPointFromScreen(location, (Component)this.myTree);
            return this.getNodeForLocation(location.x, location.y);
        }
        return null;
    }

    @Nullable
    public T getNodeForLocation(int x, int y) {
        DefaultMutableTreeNode node2;
        Object userObject = null;
        TreePath path2 = this.myTree.getPathForLocation(x, y);
        if (path2 != null && (node2 = (DefaultMutableTreeNode)path2.getLastPathComponent()) != null) {
            userObject = node2.getUserObject();
        }
        return (T)(this.mySupportedNodeType.isInstance(userObject) ? (SimpleNode)this.mySupportedNodeType.cast(userObject) : null);
    }

    public void dispose() {
        if (this.myKeyEventDispatcher != null) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this.myKeyEventDispatcher);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supportedNodeType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelNode";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/structure/configurables/ui/treeview/NodeHyperlinkSupport";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/structure/configurables/ui/treeview/NodeHyperlinkSupport";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findIssues";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findIssues";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getIfHyperlink";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

