/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.configurables.ui;

import com.android.tools.idea.gradle.structure.configurables.ui.UiUtil;
import com.intellij.icons.AllIcons;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBLabel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class CollapsiblePanel
extends JPanel {
    @NotNull
    private final JPanel myPanel;
    @NotNull
    private final JBLabel myExpandButton;
    @NotNull
    private final SimpleColoredComponent myTitleComponent;
    @NotNull
    private final Icon myExpandedIcon;
    @NotNull
    private final Icon myCollapsedIcon;
    private JComponent myContents;
    private boolean myExpanded;

    public CollapsiblePanel(@NotNull String title) {
        if (title == null) {
            CollapsiblePanel.$$$reportNull$$$0(0);
        }
        super(new BorderLayout());
        this.myPanel = new JPanel(new BorderLayout());
        this.add((Component)this.myPanel, "Center");
        this.myExpandButton = new JBLabel(" ");
        this.myExpandButton.setFocusable(false);
        this.myExpandButton.addMouseListener((MouseListener)new CollapseListener());
        this.myExpandedIcon = AllIcons.General.ArrowDown;
        this.myCollapsedIcon = AllIcons.General.ArrowRight;
        this.myTitleComponent = new SimpleColoredComponent();
        this.myTitleComponent.append(title, SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
        int iconTextGap = 5;
        this.myTitleComponent.setBorder(BorderFactory.createEmptyBorder(0, iconTextGap, 0, 0));
        JPanel expandPanel = new JPanel(new BorderLayout());
        expandPanel.add((Component)this.myExpandButton, "West");
        expandPanel.add((Component)this.myTitleComponent, "Center");
        int left2 = 4;
        expandPanel.setBorder(BorderFactory.createEmptyBorder(0, left2, 0, 0));
        this.add((Component)expandPanel, "North");
        this.myPanel.setBorder(BorderFactory.createEmptyBorder(10, 10 + this.myExpandedIcon.getIconWidth() + left2 + iconTextGap, 10, 10));
        this.setExpanded(true);
    }

    public void setContents(@NotNull JComponent contents) {
        if (contents == null) {
            CollapsiblePanel.$$$reportNull$$$0(1);
        }
        if (this.myContents != null) {
            this.myPanel.remove(this.myContents);
        }
        this.myContents = contents;
        this.myPanel.add((Component)this.myContents, "Center");
        UiUtil.revalidateAndRepaint(this);
    }

    @NotNull
    public SimpleColoredComponent getTitleComponent() {
        SimpleColoredComponent simpleColoredComponent = this.myTitleComponent;
        if (simpleColoredComponent == null) {
            CollapsiblePanel.$$$reportNull$$$0(2);
        }
        return simpleColoredComponent;
    }

    @Override
    public String getToolTipText() {
        return this.myExpandButton.getToolTipText();
    }

    @Override
    public void setToolTipText(String toolTipText) {
        this.myExpandButton.setToolTipText(toolTipText);
    }

    public boolean isExpanded() {
        return this.myExpanded;
    }

    public void setExpanded(boolean expanded) {
        boolean oldExpanded = this.myExpanded;
        if (oldExpanded != expanded) {
            this.myExpanded = expanded;
            Icon icon2 = this.myExpanded ? this.myExpandedIcon : this.myCollapsedIcon;
            this.myExpandButton.setIcon(icon2);
            if (this.myExpanded) {
                this.add((Component)this.myPanel, "Center");
            } else {
                this.remove(this.myPanel);
            }
            UiUtil.revalidateAndRepaint(this);
            this.firePropertyChange("expanded", oldExpanded, expanded);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contents";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/structure/configurables/ui/CollapsiblePanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/structure/configurables/ui/CollapsiblePanel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitleComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setContents";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class CollapseListener
    extends MouseAdapter {
        private CollapseListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            CollapsiblePanel.this.setExpanded(!CollapsiblePanel.this.myExpanded);
        }
    }
}

