/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.configurables.issues;

import com.android.tools.idea.gradle.structure.configurables.PsContext;
import com.android.tools.idea.gradle.structure.configurables.issues.DependencyViewIssuesRenderer;
import com.android.tools.idea.gradle.structure.configurables.issues.NavigationHyperlinkListener;
import com.android.tools.idea.gradle.structure.configurables.ui.IssuesViewerPanel;
import com.android.tools.idea.gradle.structure.configurables.ui.UiUtil;
import com.android.tools.idea.gradle.structure.model.PsIssue;
import com.android.tools.idea.gradle.structure.model.PsPath;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IssuesViewer {
    @NotNull
    private final PsContext myContext;
    @NotNull
    private final DependencyViewIssuesRenderer myRenderer;
    private JBLabel myEmptyIssuesLabel;
    @NotNull
    private List<IssuesViewerPanel> myIssuesPanels;
    private JPanel myIssuesPanel1;
    private JPanel myIssuesPanel2;
    private JPanel myIssuesPanel3;
    private JPanel myIssuesPanel4;
    private JPanel myMainPanel;
    private boolean myShowEmptyText;
    @Nullable
    private Set<PsIssue> myLastDisplayedIssues;

    public IssuesViewer(@NotNull PsContext context, @NotNull DependencyViewIssuesRenderer renderer2) {
        if (context == null) {
            IssuesViewer.$$$reportNull$$$0(0);
        }
        if (renderer2 == null) {
            IssuesViewer.$$$reportNull$$$0(1);
        }
        this.myLastDisplayedIssues = null;
        this.myContext = context;
        this.myRenderer = renderer2;
        this.$$$setupUI$$$();
    }

    public void display(@NotNull Collection<PsIssue> issues, @Nullable PsPath scope2) {
        LinkedHashSet<PsIssue> newIssues;
        if (issues == null) {
            IssuesViewer.$$$reportNull$$$0(2);
        }
        if ((newIssues = new LinkedHashSet<PsIssue>(issues)).equals(this.myLastDisplayedIssues)) {
            return;
        }
        this.myLastDisplayedIssues = newIssues;
        if (newIssues.isEmpty()) {
            if (this.myShowEmptyText) {
                this.myEmptyIssuesLabel.setVisible(true);
            }
            for (IssuesViewerPanel panel2 : this.myIssuesPanels) {
                panel2.setVisible(false);
            }
            this.revalidateAndRepaintPanels();
            return;
        }
        this.myEmptyIssuesLabel.setVisible(false);
        HashMap issuesBySeverity2 = Maps.newHashMap();
        for (PsIssue issue2 : newIssues) {
            PsIssue.Severity severity = issue2.getSeverity();
            ArrayList<PsIssue> currentIssues = (ArrayList<PsIssue>)issuesBySeverity2.get((Object)severity);
            if (currentIssues == null) {
                currentIssues = new ArrayList<PsIssue>();
                issuesBySeverity2.put(severity, currentIssues);
            }
            currentIssues.add(issue2);
        }
        ArrayList severities = Lists.newArrayList(issuesBySeverity2.keySet());
        severities.sort((t1, t2) -> t1.getPriority() - t2.getPriority());
        int typeCount = severities.size();
        assert (typeCount < 5);
        for (int index2 = 3; index2 >= 0; --index2) {
            if (typeCount <= 0) {
                this.myIssuesPanels.get(index2).setVisible(false);
                continue;
            }
            PsIssue.Severity severity = (PsIssue.Severity)((Object)severities.get(--typeCount));
            this.myIssuesPanels.get(index2).displayIssues(scope2, this.myRenderer, severity, (List)issuesBySeverity2.get((Object)severity));
            this.myIssuesPanels.get(index2).setVisible(true);
        }
        this.revalidateAndRepaintPanels();
    }

    private void revalidateAndRepaintPanels() {
        for (IssuesViewerPanel panel2 : this.myIssuesPanels) {
            UiUtil.revalidateAndRepaint(panel2);
        }
        UiUtil.revalidateAndRepaint(this.myMainPanel);
    }

    @NotNull
    public JPanel getPanel() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            IssuesViewer.$$$reportNull$$$0(3);
        }
        return jPanel;
    }

    private void createUIComponents() {
        Font font = UIUtil.getTreeFont();
        NavigationHyperlinkListener hyperlinkListener2 = new NavigationHyperlinkListener(this.myContext);
        this.myIssuesPanel1 = new IssuesViewerPanel(hyperlinkListener2, font);
        this.myIssuesPanel2 = new IssuesViewerPanel(hyperlinkListener2, font);
        this.myIssuesPanel3 = new IssuesViewerPanel(hyperlinkListener2, font);
        this.myIssuesPanel4 = new IssuesViewerPanel(hyperlinkListener2, font);
        this.myIssuesPanels = Arrays.asList((IssuesViewerPanel)this.myIssuesPanel1, (IssuesViewerPanel)this.myIssuesPanel2, (IssuesViewerPanel)this.myIssuesPanel3, (IssuesViewerPanel)this.myIssuesPanel4);
        for (IssuesViewerPanel panel2 : this.myIssuesPanels) {
            panel2.setVisible(false);
        }
    }

    public void setShowEmptyText(boolean showEmptyText) {
        this.myShowEmptyText = showEmptyText;
        if (!this.myShowEmptyText) {
            this.myEmptyIssuesLabel.setVisible(false);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "issues";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/structure/configurables/issues/IssuesViewer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/structure/configurables/issues/IssuesViewer";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "display";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JPanel jPanel;
        this.createUIComponents();
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myEmptyIssuesLabel = jBLabel = new JBLabel();
        jBLabel.setFontColor(UIUtil.FontColor.BRIGHTER);
        jBLabel.setHorizontalAlignment(0);
        jBLabel.setText("No messages to display");
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 0, 1, 0, 0, null, null, null));
        JPanel jPanel2 = this.myIssuesPanel4;
        jPanel.add((Component)jPanel2, new GridConstraints(4, 0, 1, 1, 0, 3, 3, 7, null, null, null));
        JPanel jPanel3 = this.myIssuesPanel2;
        jPanel.add((Component)jPanel3, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel4 = this.myIssuesPanel1;
        jPanel.add((Component)jPanel4, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel5 = this.myIssuesPanel3;
        jPanel.add((Component)jPanel5, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

