/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.rendering;

import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.plugin.LatestKnownPluginVersionProvider;
import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.sync.hyperlink.FixAndroidGradlePluginVersionHyperlink;
import com.android.tools.idea.rendering.HtmlLinkManager;
import com.android.tools.idea.rendering.RenderErrorContributor;
import com.android.tools.idea.rendering.RenderLogger;
import com.android.tools.idea.rendering.RenderResult;
import com.android.tools.idea.rendering.errors.ui.RenderErrorModel;
import com.android.tools.idea.ui.designer.EditorDesignSurface;
import com.android.utils.HtmlBuilder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import java.util.Map;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleRenderErrorContributor
extends RenderErrorContributor {
    public GradleRenderErrorContributor(@Nullable EditorDesignSurface surface2, @NotNull RenderResult result2, @Nullable DataContext dataContext) {
        if (result2 == null) {
            GradleRenderErrorContributor.$$$reportNull$$$0(0);
        }
        super(surface2, result2, dataContext);
    }

    @Override
    public Collection<RenderErrorModel.Issue> reportIssues() {
        RenderResult result2 = this.getResult();
        RenderLogger logger2 = result2.getLogger();
        AndroidFacet facet2 = AndroidFacet.getInstance((Module)result2.getModule());
        this.reportIssue170841(logger2, facet2);
        return this.getIssues();
    }

    private void reportIssue170841(RenderLogger logger2, final AndroidFacet facet2) {
        Map<String, Throwable> brokenClasses = logger2.getBrokenClasses();
        if (brokenClasses.isEmpty() || facet2 == null) {
            return;
        }
        AndroidModuleModel model2 = AndroidModuleModel.get(facet2);
        if (model2 == null || !model2.getFeatures().isLayoutRenderingIssuePresent()) {
            return;
        }
        Runnable runnable2 = new Runnable(){

            @Override
            public void run() {
                FixAndroidGradlePluginVersionHyperlink quickFix = new FixAndroidGradlePluginVersionHyperlink(GradleVersion.parse((String)LatestKnownPluginVersionProvider.INSTANCE.get()), null);
                quickFix.executeIfClicked(facet2.getModule().getProject(), new HyperlinkEvent(this, HyperlinkEvent.EventType.ACTIVATED, null, quickFix.getUrl()));
            }
        };
        HtmlBuilder builder2 = new HtmlBuilder();
        HtmlLinkManager linkManager = logger2.getLinkManager();
        builder2.add("Tip: Either ").addLink("update the Gradle plugin build version to 1.2.3", linkManager.createRunnableLink(runnable2)).add(" or later, or downgrade to version 1.1.3, or as a workaround, ");
        builder2.beginList().listItem().addLink("", "Build the project", ", then", linkManager.createBuildProjectUrl()).listItem().addLink("", "Gradle Sync the project", ", then", linkManager.createSyncProjectUrl()).listItem().addLink("Manually ", "refresh the layout", " (or restart the IDE)", linkManager.createRefreshRenderUrl()).endList();
        builder2.newline();
        GradleVersion modelVersion = model2.getModelVersion();
        this.addIssue().setSeverity(HighlightSeverity.ERROR).setSummary("Using an obsolete version of the Gradle plugin (" + modelVersion + "); this can lead to layouts not rendering correctly.").setHtmlContent(builder2).build();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/gradle/rendering/GradleRenderErrorContributor", "<init>"));
    }

    public static class GradleProvider
    extends RenderErrorContributor.Provider {
        @Override
        public boolean isApplicable(Project project) {
            return GradleProjectInfo.getInstance(project).isBuildWithGradle();
        }

        @Override
        public RenderErrorContributor getContributor(@Nullable EditorDesignSurface surface2, @NotNull RenderResult result2, @Nullable DataContext dataContext) {
            if (result2 == null) {
                GradleProvider.$$$reportNull$$$0(0);
            }
            return new GradleRenderErrorContributor(surface2, result2, dataContext);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/gradle/rendering/GradleRenderErrorContributor$GradleProvider", "getContributor"));
        }
    }
}

