/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.refactoring;

import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.GradleSettingsModel;
import com.android.tools.idea.gradle.dsl.api.ProjectBuildModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.DependenciesModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.ModuleDependencyModel;
import com.android.tools.idea.gradle.dsl.api.ext.GradlePropertyModel;
import com.android.tools.idea.gradle.dsl.api.ext.ResolvedPropertyModel;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacet;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.util.GradleProjects;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.TitledHandler;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.command.undo.UnexpectedUndoException;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleGrouper;
import com.intellij.openapi.module.ModuleGrouperKt;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleWithNameAlreadyExists;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.rename.RenameHandler;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleRenameModuleHandler
implements RenameHandler,
TitledHandler {
    public boolean isAvailableOnDataContext(@NotNull DataContext dataContext) {
        Module module2;
        if (dataContext == null) {
            GradleRenameModuleHandler.$$$reportNull$$$0(0);
        }
        return (module2 = GradleRenameModuleHandler.getGradleModule(dataContext)) != null && GradleRenameModuleHandler.getModuleRootDir(module2) != null;
    }

    @Nullable
    private static VirtualFile getModuleRootDir(@NotNull Module module2) {
        File moduleRootDir;
        if (module2 == null) {
            GradleRenameModuleHandler.$$$reportNull$$$0(1);
        }
        if ((moduleRootDir = AndroidRootUtil.findModuleRootFolderPath(module2)) == null) {
            return null;
        }
        return VfsUtil.findFileByIoFile((File)moduleRootDir, (boolean)true);
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor2, @Nullable PsiFile file2, @NotNull DataContext dataContext) {
        if (project == null) {
            GradleRenameModuleHandler.$$$reportNull$$$0(2);
        }
        if (dataContext == null) {
            GradleRenameModuleHandler.$$$reportNull$$$0(3);
        }
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, @NotNull DataContext dataContext) {
        if (project == null) {
            GradleRenameModuleHandler.$$$reportNull$$$0(4);
        }
        if (dataContext == null) {
            GradleRenameModuleHandler.$$$reportNull$$$0(5);
        }
        if (elements == null) {
            GradleRenameModuleHandler.$$$reportNull$$$0(6);
        }
        Module module2 = GradleRenameModuleHandler.getGradleModule(dataContext);
        assert (module2 != null);
        String currentName = ModuleGrouper.instanceFor((Project)project).getShortenedName(module2);
        Messages.showInputDialog((Project)project, (String)IdeBundle.message((String)"prompt.enter.new.module.name", (Object[])new Object[0]), (String)IdeBundle.message((String)"title.rename.module", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon(), (String)currentName, (InputValidator)new MyInputValidator(module2));
    }

    @Nullable
    private static Module getGradleModule(@NotNull DataContext dataContext) {
        Module module2;
        if (dataContext == null) {
            GradleRenameModuleHandler.$$$reportNull$$$0(7);
        }
        if ((module2 = (Module)LangDataKeys.MODULE_CONTEXT.getData(dataContext)) != null && (GradleFacet.getInstance(module2) != null || GradleProjects.isGradleProjectModule(module2))) {
            return module2;
        }
        return null;
    }

    @NotNull
    public String getActionTitle() {
        String string = RefactoringBundle.message((String)"rename.module.title");
        if (string == null) {
            GradleRenameModuleHandler.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static void requestSync(@NotNull Project project) {
        if (project == null) {
            GradleRenameModuleHandler.$$$reportNull$$$0(9);
        }
        GradleSyncInvoker.getInstance().requestProjectSync(project, GradleSyncStats.Trigger.TRIGGER_REFACTOR_MODULE_RENAMED);
    }

    private static String getNewPath(@NotNull String oldPath, @NotNull String newName2) {
        Object newPath;
        List segments;
        ArrayList modifiableSegments;
        int segmentCount;
        if (oldPath == null) {
            GradleRenameModuleHandler.$$$reportNull$$$0(10);
        }
        if (newName2 == null) {
            GradleRenameModuleHandler.$$$reportNull$$$0(11);
        }
        if ((segmentCount = (modifiableSegments = Lists.newArrayList((Iterable)(segments = Splitter.on((String)":").splitToList((CharSequence)oldPath)))).size()) == 0) {
            newPath = ":" + newName2.trim();
        } else {
            modifiableSegments.set(segmentCount - 1, newName2);
            newPath = Joiner.on((String)":").join((Iterable)modifiableSegments);
        }
        return newPath;
    }

    private static void reset(@NotNull List<GradleBuildModel> buildModels) {
        if (buildModels == null) {
            GradleRenameModuleHandler.$$$reportNull$$$0(12);
        }
        for (GradleBuildModel buildModel : buildModels) {
            buildModel.resetState();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/refactoring/GradleRenameModuleHandler";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldPath";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildModels";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/refactoring/GradleRenameModuleHandler";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionTitle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailableOnDataContext";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getModuleRootDir";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getGradleModule";
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "requestSync";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getNewPath";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyInputValidator
    implements InputValidator {
        @NotNull
        private final Module myModule;

        private MyInputValidator(@NotNull Module module2) {
            if (module2 == null) {
                MyInputValidator.$$$reportNull$$$0(0);
            }
            this.myModule = module2;
        }

        public boolean checkInput(@Nullable String inputString) {
            String currentName = ModuleGrouper.instanceFor((Project)this.myModule.getProject()).getShortenedName(this.myModule);
            return inputString != null && !inputString.isEmpty() && !inputString.equals(currentName) && !inputString.contains(":") && !inputString.contains(".");
        }

        public boolean canClose(@NotNull String inputString) {
            Project project;
            ProjectBuildModel projectModel;
            GradleSettingsModel settingsModel;
            if (inputString == null) {
                MyInputValidator.$$$reportNull$$$0(1);
            }
            if ((settingsModel = (projectModel = ProjectBuildModel.get((Project)(project = this.myModule.getProject()))).getProjectSettingsModel()) == null) {
                Messages.showErrorDialog((Project)project, (String)"Gradle settings file not found", (String)IdeBundle.message((String)"title.rename.module", (Object[])new Object[0]));
                return true;
            }
            VirtualFile moduleRoot = GradleRenameModuleHandler.getModuleRootDir(this.myModule);
            assert (moduleRoot != null);
            if (GradleProjects.isGradleProjectModule(this.myModule)) {
                Messages.showErrorDialog((Project)project, (String)"Can't rename root module", (String)IdeBundle.message((String)"title.rename.module", (Object[])new Object[0]));
                return true;
            }
            String oldModuleGradlePath = GradleUtil.getGradlePath(this.myModule);
            if (oldModuleGradlePath == null) {
                return true;
            }
            ArrayList<GradleBuildModel> modifiedBuildModels = new ArrayList<GradleBuildModel>();
            for (Module module2 : ModuleManager.getInstance((Project)project).getModules()) {
                GradleBuildModel buildModel = projectModel.getModuleBuildModel(module2);
                if (buildModel == null) continue;
                DependenciesModel dependenciesModel = buildModel.dependencies();
                for (ModuleDependencyModel dependency : dependenciesModel.modules()) {
                    ResolvedPropertyModel path2 = dependency.path();
                    if (!oldModuleGradlePath.equals(path2.forceString())) continue;
                    path2.setValue((Object)GradleRenameModuleHandler.getNewPath(oldModuleGradlePath, inputString));
                }
                List dynamicFeatures = buildModel.android().dynamicFeatures().toList();
                if (dynamicFeatures != null) {
                    for (GradlePropertyModel feature : dynamicFeatures) {
                        if (!oldModuleGradlePath.equals(feature.forceString())) continue;
                        feature.setValue((Object)GradleRenameModuleHandler.getNewPath(oldModuleGradlePath, inputString));
                    }
                }
                if (!buildModel.isModified()) continue;
                modifiedBuildModels.add(buildModel);
            }
            String currentName = ModuleGrouper.instanceFor((Project)project).getShortenedName(this.myModule);
            String msg = IdeBundle.message((String)"command.renaming.module", (Object[])new Object[]{currentName});
            WriteCommandAction.Builder actionBuilder = WriteCommandAction.writeCommandAction((Project)project).withName(msg).withGlobalUndo();
            ThrowableComputable action2 = () -> {
                if (!settingsModel.modulePaths().contains(oldModuleGradlePath)) {
                    String settingsFileName = settingsModel.getVirtualFile().getName();
                    Messages.showErrorDialog((Project)project, (String)("Can't find module '" + currentName + "' in " + settingsFileName), (String)IdeBundle.message((String)"title.rename.module", (Object[])new Object[0]));
                    GradleRenameModuleHandler.reset(modifiedBuildModels);
                    return true;
                }
                ModifiableModuleModel modifiableModel = ModuleManager.getInstance((Project)project).getModifiableModel();
                String newName2 = inputString;
                if (ModuleGrouperKt.isQualifiedModuleNamesEnabled((Project)project)) {
                    ArrayList<String> groupPath = new ArrayList<String>(ModuleGrouper.instanceFor((Project)project).getGroupPath(this.myModule));
                    groupPath.add(inputString);
                    newName2 = StringUtil.join(groupPath, (String)".");
                }
                try {
                    modifiableModel.renameModule(this.myModule, newName2);
                }
                catch (ModuleWithNameAlreadyExists moduleWithNameAlreadyExists) {
                    ApplicationManager.getApplication().invokeLater(() -> Messages.showErrorDialog((Project)project, (String)IdeBundle.message((String)"error.module.already.exists", (Object[])new Object[]{inputString}), (String)IdeBundle.message((String)"title.rename.module", (Object[])new Object[0])));
                    GradleRenameModuleHandler.reset(modifiedBuildModels);
                    return false;
                }
                settingsModel.replaceModulePath(oldModuleGradlePath, GradleRenameModuleHandler.getNewPath(oldModuleGradlePath, inputString));
                for (GradleBuildModel buildModel : modifiedBuildModels) {
                    buildModel.applyChanges();
                }
                settingsModel.applyChanges();
                try {
                    moduleRoot.rename((Object)this, inputString);
                }
                catch (IOException e) {
                    ApplicationManager.getApplication().invokeLater(() -> Messages.showErrorDialog((Project)project, (String)("Rename folder failed: " + e.getMessage()), (String)IdeBundle.message((String)"title.rename.module", (Object[])new Object[0])));
                    GradleRenameModuleHandler.reset(modifiedBuildModels);
                    return false;
                }
                modifiableModel.commit();
                UndoManager.getInstance((Project)project).undoableActionPerformed((UndoableAction)new BasicUndoableAction(){

                    public void undo() throws UnexpectedUndoException {
                        GradleRenameModuleHandler.requestSync(project);
                    }

                    public void redo() throws UnexpectedUndoException {
                        GradleRenameModuleHandler.requestSync(project);
                    }
                });
                return true;
            };
            try {
                if (((Boolean)actionBuilder.compute(action2)).booleanValue()) {
                    GradleRenameModuleHandler.requestSync(project);
                    return true;
                }
                return false;
            }
            catch (Throwable c) {
                return false;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inputString";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/gradle/refactoring/GradleRenameModuleHandler$MyInputValidator";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "canClose";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

