/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.upgrade;

import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.dsl.api.dependencies.ArtifactDependencyModel;
import com.android.tools.idea.gradle.plugin.AndroidPluginInfo;
import com.android.tools.idea.gradle.project.sync.hyperlink.SearchInBuildFilesHyperlink;
import com.android.tools.idea.gradle.project.upgrade.AgpClasspathDependencyRefactoringProcessor;
import com.android.tools.idea.gradle.project.upgrade.AgpGradleVersionRefactoringProcessor;
import com.android.tools.idea.gradle.project.upgrade.GMavenRepositoryRefactoringProcessor;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.serviceContainer.NonInjectable;
import com.intellij.util.ThreeState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidPluginVersionUpdater {
    @NotNull
    private final Project myProject;
    @NotNull
    private final TextSearch myTextSearch;

    @NotNull
    public static AndroidPluginVersionUpdater getInstance(@NotNull Project project) {
        if (project == null) {
            AndroidPluginVersionUpdater.$$$reportNull$$$0(0);
        }
        AndroidPluginVersionUpdater androidPluginVersionUpdater = (AndroidPluginVersionUpdater)project.getService(AndroidPluginVersionUpdater.class);
        if (androidPluginVersionUpdater == null) {
            AndroidPluginVersionUpdater.$$$reportNull$$$0(1);
        }
        return androidPluginVersionUpdater;
    }

    public AndroidPluginVersionUpdater(@NotNull Project project) {
        if (project == null) {
            AndroidPluginVersionUpdater.$$$reportNull$$$0(2);
        }
        this(project, new TextSearch(project));
    }

    @NonInjectable
    @VisibleForTesting
    AndroidPluginVersionUpdater(@NotNull Project project, @NotNull TextSearch textSearch) {
        if (project == null) {
            AndroidPluginVersionUpdater.$$$reportNull$$$0(3);
        }
        if (textSearch == null) {
            AndroidPluginVersionUpdater.$$$reportNull$$$0(4);
        }
        this.myProject = project;
        this.myTextSearch = textSearch;
    }

    public boolean updatePluginVersion(@NotNull GradleVersion pluginVersion, @Nullable GradleVersion gradleVersion2) {
        UpdateResult result2;
        if (pluginVersion == null) {
            AndroidPluginVersionUpdater.$$$reportNull$$$0(5);
        }
        return (result2 = this.updatePluginVersion(pluginVersion, gradleVersion2, null)).isPluginVersionUpdated() || result2.isGradleVersionUpdated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpdateResult updatePluginVersion(@NotNull GradleVersion pluginVersion, @Nullable GradleVersion gradleVersion2, @Nullable GradleVersion oldPluginVersion) {
        String msg;
        if (pluginVersion == null) {
            AndroidPluginVersionUpdater.$$$reportNull$$$0(6);
        }
        UpdateResult result2 = new UpdateResult();
        Runnable updaterRunnable = () -> {
            this.updatePluginVersionWithResult(pluginVersion, gradleVersion2, oldPluginVersion, result2);
            UpdateResult updateResult = result2;
            synchronized (updateResult) {
                result2.complete = true;
                result2.notifyAll();
            }
        };
        Application application = ApplicationManager.getApplication();
        if (application.isDispatchThread()) {
            updaterRunnable.run();
        } else {
            DumbService.getInstance((Project)this.myProject).smartInvokeLater(updaterRunnable);
            try {
                UpdateResult updateResult = result2;
                synchronized (updateResult) {
                    while (!result2.complete) {
                        result2.wait();
                    }
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        Throwable pluginVersionUpdateError = result2.getPluginVersionUpdateError();
        Throwable gradleVersionUpdateError = result2.getGradleVersionUpdateError();
        if (pluginVersionUpdateError != null) {
            msg = String.format("Failed to update Android plugin to version '%1$s'", pluginVersion);
            AndroidPluginVersionUpdater.logUpdateError(msg, pluginVersionUpdateError);
        }
        if (gradleVersionUpdateError != null) {
            msg = String.format("Failed to update Gradle to version '%1$s'", gradleVersion2);
            AndroidPluginVersionUpdater.logUpdateError(msg, gradleVersionUpdateError);
        }
        if (result2.getPluginVersionUpdateError() != null) {
            this.myTextSearch.execute();
        }
        return result2;
    }

    private void updatePluginVersionWithResult(@NotNull GradleVersion pluginVersion, @Nullable GradleVersion gradleVersion2, @Nullable GradleVersion oldPluginVersion, UpdateResult result2) {
        if (pluginVersion == null) {
            AndroidPluginVersionUpdater.$$$reportNull$$$0(7);
        }
        if (oldPluginVersion == null) {
            oldPluginVersion = new GradleVersion(1, 0, 0);
        }
        AgpClasspathDependencyRefactoringProcessor rp1 = new AgpClasspathDependencyRefactoringProcessor(this.myProject, oldPluginVersion, pluginVersion);
        GMavenRepositoryRefactoringProcessor rp2 = new GMavenRepositoryRefactoringProcessor(this.myProject, oldPluginVersion, pluginVersion);
        try {
            rp1.run();
            if (!oldPluginVersion.isAtLeast(3, 0, 0)) {
                rp2.run();
            }
            if (rp1.getFoundUsages()) {
                result2.pluginVersionUpdated();
            }
        }
        catch (Throwable e) {
            result2.setPluginVersionUpdateError(e);
        }
        if (result2.isPluginVersionUpdated() && gradleVersion2 != null) {
            AgpGradleVersionRefactoringProcessor rp3 = new AgpGradleVersionRefactoringProcessor(this.myProject, oldPluginVersion, pluginVersion);
            try {
                rp3.run();
                result2.gradleVersionUpdated();
            }
            catch (Throwable e) {
                result2.setGradleVersionUpdateError(e);
            }
        }
    }

    private static void logUpdateError(@NotNull String msg, @NotNull Throwable error) {
        String cause;
        if (msg == null) {
            AndroidPluginVersionUpdater.$$$reportNull$$$0(8);
        }
        if (error == null) {
            AndroidPluginVersionUpdater.$$$reportNull$$$0(9);
        }
        if (StringUtil.isNotEmpty((String)(cause = error.getMessage()))) {
            msg = (String)msg + ": " + cause;
        }
        Logger.getInstance(AndroidPluginVersionUpdater.class).warn((String)msg);
    }

    @NotNull
    public static ThreeState isUpdatablePluginDependency(@NotNull GradleVersion toVersion, @NotNull ArtifactDependencyModel model2) {
        String groupId;
        String artifactId;
        if (toVersion == null) {
            AndroidPluginVersionUpdater.$$$reportNull$$$0(10);
        }
        if (model2 == null) {
            AndroidPluginVersionUpdater.$$$reportNull$$$0(11);
        }
        if (!AndroidPluginInfo.isAndroidPlugin(artifactId = model2.name().forceString(), groupId = model2.group().toString())) {
            ThreeState threeState = ThreeState.UNSURE;
            if (threeState == null) {
                AndroidPluginVersionUpdater.$$$reportNull$$$0(12);
            }
            return threeState;
        }
        String versionValue = model2.version().toString();
        ThreeState threeState = StringUtil.isEmpty((String)versionValue) || toVersion.compareTo(versionValue) != 0 ? ThreeState.YES : ThreeState.NO;
        if (threeState == null) {
            AndroidPluginVersionUpdater.$$$reportNull$$$0(13);
        }
        return threeState;
    }

    @NotNull
    public static ThreeState isUpdatablePluginRelatedDependency(@NotNull GradleVersion toVersion, @NotNull ArtifactDependencyModel model2) {
        String groupId;
        String artifactId;
        if (toVersion == null) {
            AndroidPluginVersionUpdater.$$$reportNull$$$0(14);
        }
        if (model2 == null) {
            AndroidPluginVersionUpdater.$$$reportNull$$$0(15);
        }
        if (!AndroidPluginInfo.isAndroidPluginOrApi(artifactId = model2.name().forceString(), groupId = model2.group().toString())) {
            ThreeState threeState = ThreeState.UNSURE;
            if (threeState == null) {
                AndroidPluginVersionUpdater.$$$reportNull$$$0(16);
            }
            return threeState;
        }
        String versionValue = model2.version().toString();
        ThreeState threeState = StringUtil.isEmpty((String)versionValue) || toVersion.compareTo(versionValue) != 0 ? ThreeState.YES : ThreeState.NO;
        if (threeState == null) {
            AndroidPluginVersionUpdater.$$$reportNull$$$0(17);
        }
        return threeState;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 12: 
            case 13: 
            case 16: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 12: 
            case 13: 
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 12: 
            case 13: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/upgrade/AndroidPluginVersionUpdater";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textSearch";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginVersion";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "msg";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toVersion";
                break;
            }
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/upgrade/AndroidPluginVersionUpdater";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "isUpdatablePluginDependency";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "isUpdatablePluginRelatedDependency";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 12: 
            case 13: 
            case 16: 
            case 17: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "updatePluginVersion";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "updatePluginVersionWithResult";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "logUpdateError";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isUpdatablePluginDependency";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isUpdatablePluginRelatedDependency";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 12: 
            case 13: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @VisibleForTesting
    static class TextSearch {
        @NotNull
        private final Project myProject;

        TextSearch(@NotNull Project project) {
            if (project == null) {
                TextSearch.$$$reportNull$$$0(0);
            }
            this.myProject = project;
        }

        void execute() {
            String msg = "Failed to update the version of the Android Gradle plugin.\n\nPlease click 'OK' to perform a textual search and then update the build files manually.";
            ApplicationManager.getApplication().invokeLater(() -> {
                Messages.showErrorDialog((Project)this.myProject, (String)msg, (String)"Unexpected Error");
                String textToFind = "com.android.tools.build:gradle";
                SearchInBuildFilesHyperlink.searchInBuildFiles(textToFind, this.myProject);
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/upgrade/AndroidPluginVersionUpdater$TextSearch", "<init>"));
        }
    }

    public static class UpdateResult {
        @Nullable
        private Throwable myPluginVersionUpdateError;
        @Nullable
        private Throwable myGradleVersionUpdateError;
        private boolean myPluginVersionUpdated;
        private boolean myGradleVersionUpdated;
        private boolean complete;

        @VisibleForTesting
        public UpdateResult() {
        }

        @Nullable
        public Throwable getPluginVersionUpdateError() {
            return this.myPluginVersionUpdateError;
        }

        void setPluginVersionUpdateError(@NotNull Throwable error) {
            if (error == null) {
                UpdateResult.$$$reportNull$$$0(0);
            }
            this.myPluginVersionUpdateError = error;
        }

        @Nullable
        public Throwable getGradleVersionUpdateError() {
            return this.myGradleVersionUpdateError;
        }

        void setGradleVersionUpdateError(@NotNull Throwable error) {
            if (error == null) {
                UpdateResult.$$$reportNull$$$0(1);
            }
            this.myGradleVersionUpdateError = error;
        }

        public boolean isPluginVersionUpdated() {
            return this.myPluginVersionUpdated;
        }

        void pluginVersionUpdated() {
            this.myPluginVersionUpdated = true;
        }

        public boolean isGradleVersionUpdated() {
            return this.myGradleVersionUpdated;
        }

        void gradleVersionUpdated() {
            this.myGradleVersionUpdated = true;
        }

        public boolean versionUpdateSuccess() {
            return (this.myPluginVersionUpdated || this.myGradleVersionUpdated) && this.myPluginVersionUpdateError == null && this.myGradleVersionUpdateError == null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "error";
            objectArray2[1] = "com/android/tools/idea/gradle/project/upgrade/AndroidPluginVersionUpdater$UpdateResult";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setPluginVersionUpdateError";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setGradleVersionUpdateError";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

