/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.validation.android;

import com.android.ide.common.gradle.model.IdeAndroidProject;
import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.sync.messages.GradleSyncMessages;
import com.android.tools.idea.gradle.project.sync.validation.android.AndroidProjectValidationStrategy;
import com.android.tools.idea.project.messages.MessageType;
import com.android.tools.idea.project.messages.SyncMessage;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class EncodingValidationStrategy
extends AndroidProjectValidationStrategy {
    @NotNull
    private final EncodingProjectManager myEncodings;
    @NotNull
    private final Charset myProjectEncoding;
    @NotNull
    private final GradleVersion myOneDotTwoPluginVersion;
    @Nullable
    private String myMismatchingEncoding;

    EncodingValidationStrategy(@NotNull Project project) {
        if (project == null) {
            EncodingValidationStrategy.$$$reportNull$$$0(0);
        }
        this(project, EncodingProjectManager.getInstance((Project)project));
    }

    @VisibleForTesting
    EncodingValidationStrategy(@NotNull Project project, @NotNull EncodingProjectManager encodings) {
        if (project == null) {
            EncodingValidationStrategy.$$$reportNull$$$0(1);
        }
        if (encodings == null) {
            EncodingValidationStrategy.$$$reportNull$$$0(2);
        }
        super(project);
        this.myEncodings = encodings;
        this.myProjectEncoding = this.myEncodings.getDefaultCharset();
        this.myOneDotTwoPluginVersion = new GradleVersion(1, 2, 0);
    }

    @Override
    void validate(@NotNull Module module2, @NotNull AndroidModuleModel androidModel) {
        GradleVersion modelVersion;
        if (module2 == null) {
            EncodingValidationStrategy.$$$reportNull$$$0(3);
        }
        if (androidModel == null) {
            EncodingValidationStrategy.$$$reportNull$$$0(4);
        }
        if ((modelVersion = androidModel.getModelVersion()) != null) {
            boolean isOneDotTwoOrNewer = modelVersion.compareIgnoringQualifiers(this.myOneDotTwoPluginVersion) >= 0;
            Charset modelEncoding = null;
            if (isOneDotTwoOrNewer) {
                try {
                    IdeAndroidProject androidProject = androidModel.getAndroidProject();
                    modelEncoding = Charset.forName(androidProject.getJavaCompileOptions().getEncoding());
                }
                catch (UnsupportedCharsetException unsupportedCharsetException) {
                    // empty catch block
                }
            }
            if (this.myMismatchingEncoding == null && modelEncoding != null && this.myProjectEncoding.compareTo(modelEncoding) != 0) {
                this.myMismatchingEncoding = modelEncoding.displayName();
            }
        }
    }

    @Override
    void fixAndReportFoundIssues() {
        if (this.myMismatchingEncoding != null) {
            Project project = this.getProject();
            this.myEncodings.setDefaultCharsetName(this.myMismatchingEncoding);
            String line2 = String.format("The project encoding (%1$s) has been reset to the encoding specified in the Gradle build files (%2$s).", this.myEncodings.getDefaultCharset().displayName(), this.myMismatchingEncoding);
            String[] text2 = new String[]{line2, "Mismatching encodings can lead to serious bugs."};
            SyncMessage message2 = new SyncMessage("Gradle Sync Issues", MessageType.INFO, text2);
            GradleSyncMessages.getInstance(project).report(message2);
        }
    }

    @VisibleForTesting
    @Nullable
    String getMismatchingEncoding() {
        return this.myMismatchingEncoding;
    }

    @VisibleForTesting
    void setMismatchingEncoding(@Nullable String mismatchingEncoding) {
        this.myMismatchingEncoding = mismatchingEncoding;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "encodings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidModel";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/gradle/project/sync/validation/android/EncodingValidationStrategy";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "validate";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

