/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.post.cleanup;

import com.android.repository.api.ProgressIndicator;
import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.gradle.project.sync.hyperlink.InstallPlatformHyperlink;
import com.android.tools.idea.gradle.project.sync.messages.GradleSyncMessages;
import com.android.tools.idea.gradle.project.sync.setup.post.ProjectCleanupStep;
import com.android.tools.idea.io.FilePaths;
import com.android.tools.idea.project.messages.MessageType;
import com.android.tools.idea.project.messages.SyncMessage;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.startup.ExternalAnnotationsSupport;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.roots.JavadocOrderRootType;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.ui.OrderRoot;
import com.intellij.openapi.vfs.VirtualFile;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidSdkAdditionalData;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SdksCleanupStep
extends ProjectCleanupStep {
    @NotNull
    private final AndroidSdks myAndroidSdks;

    public SdksCleanupStep() {
        this.myAndroidSdks = AndroidSdks.getInstance();
    }

    public SdksCleanupStep(@NotNull AndroidSdks androidSdks) {
        if (androidSdks == null) {
            SdksCleanupStep.$$$reportNull$$$0(0);
        }
        this.myAndroidSdks = androidSdks;
    }

    @Override
    public void cleanUpProject(@NotNull Project project, @NotNull IdeModifiableModelsProvider ideModifiableModelsProvider, @Nullable com.intellij.openapi.progress.ProgressIndicator indicator) {
        if (project == null) {
            SdksCleanupStep.$$$reportNull$$$0(1);
        }
        if (ideModifiableModelsProvider == null) {
            SdksCleanupStep.$$$reportNull$$$0(2);
        }
        HashSet<Sdk> fixedSdks = new HashSet<Sdk>();
        HashSet<Sdk> invalidSdks = new HashSet<Sdk>();
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        for (Module module2 : moduleManager.getModules()) {
            this.cleanUpSdk(module2, fixedSdks, invalidSdks);
        }
        if (!invalidSdks.isEmpty()) {
            this.reinstallMissingPlatforms(invalidSdks, project);
        }
    }

    @VisibleForTesting
    void cleanUpSdk(@NotNull Module module2, @NotNull Set<Sdk> fixedSdks, @NotNull Set<Sdk> invalidSdks) {
        AndroidFacet androidFacet;
        if (module2 == null) {
            SdksCleanupStep.$$$reportNull$$$0(3);
        }
        if (fixedSdks == null) {
            SdksCleanupStep.$$$reportNull$$$0(4);
        }
        if (invalidSdks == null) {
            SdksCleanupStep.$$$reportNull$$$0(5);
        }
        if ((androidFacet = AndroidFacet.getInstance((Module)module2)) == null) {
            return;
        }
        Sdk sdk = ModuleRootManager.getInstance((Module)module2).getSdk();
        if (sdk == null || invalidSdks.contains(sdk) || fixedSdks.contains(sdk)) {
            return;
        }
        SdksCleanupStep.updateSdkIfNeeded(sdk, this.myAndroidSdks);
        fixedSdks.add(sdk);
        if (this.isMissingAndroidLibrary(sdk)) {
            invalidSdks.add(sdk);
        }
    }

    public static void updateSdkIfNeeded(@NotNull Sdk sdk, @NotNull AndroidSdks androidSdks) {
        IAndroidTarget target;
        if (sdk == null) {
            SdksCleanupStep.$$$reportNull$$$0(6);
        }
        if (androidSdks == null) {
            SdksCleanupStep.$$$reportNull$$$0(7);
        }
        if ((target = SdksCleanupStep.getTarget(sdk, androidSdks)) != null) {
            SdksCleanupStep.updateSdkIfNeeded(sdk, androidSdks, target);
        }
    }

    @VisibleForTesting
    static void updateSdkIfNeeded(@NotNull Sdk sdk, @NotNull AndroidSdks androidSdks, @NotNull IAndroidTarget target) {
        if (sdk == null) {
            SdksCleanupStep.$$$reportNull$$$0(8);
        }
        if (androidSdks == null) {
            SdksCleanupStep.$$$reportNull$$$0(9);
        }
        if (target == null) {
            SdksCleanupStep.$$$reportNull$$$0(10);
        }
        List<OrderRoot> expectedRoots = androidSdks.getLibraryRootsForTarget(target, FilePaths.stringToFile((String)sdk.getHomePath()), true);
        HashMap urlsByRootType = new HashMap();
        for (OrderRoot root2 : expectedRoots) {
            urlsByRootType.computeIfAbsent(root2.getType(), k -> new HashSet()).add(root2.getFile().getUrl());
        }
        for (OrderRootType type : Arrays.asList(OrderRootType.CLASSES, OrderRootType.SOURCES, JavadocOrderRootType.getInstance())) {
            List<String> urlInSdk = Arrays.asList(sdk.getRootProvider().getUrls(type));
            Set expectedUrls = urlsByRootType.getOrDefault(type, Collections.emptySet());
            if (urlInSdk.size() == expectedUrls.size() && !urlInSdk.stream().anyMatch(url -> !expectedUrls.contains(url))) continue;
            SdksCleanupStep.updateSdk(sdk, expectedRoots);
            return;
        }
    }

    @Nullable
    private static IAndroidTarget getTarget(@NotNull Sdk sdk, @NotNull AndroidSdks androidSdks) {
        if (sdk == null) {
            SdksCleanupStep.$$$reportNull$$$0(11);
        }
        if (androidSdks == null) {
            SdksCleanupStep.$$$reportNull$$$0(12);
        }
        AndroidSdkAdditionalData additionalData = androidSdks.getAndroidSdkAdditionalData(sdk);
        AndroidSdkData sdkData = AndroidSdkData.getSdkData(sdk);
        if (additionalData == null || sdkData == null) {
            return null;
        }
        IAndroidTarget target = additionalData.getBuildTarget(sdkData);
        if (target == null) {
            AndroidSdkHandler sdkHandler = sdkData.getSdkHandler();
            StudioLoggerProgressIndicator logger2 = new StudioLoggerProgressIndicator(SdksCleanupStep.class);
            sdkHandler.getSdkManager((ProgressIndicator)logger2).loadSynchronously(0L, (ProgressIndicator)logger2, null, null);
            target = sdkHandler.getAndroidTargetManager((ProgressIndicator)logger2).getTargetFromHashString(additionalData.getBuildTargetHashString(), (ProgressIndicator)logger2);
        }
        return target;
    }

    private static void updateSdk(@NotNull Sdk sdk, @NotNull List<OrderRoot> expectedRoots) {
        if (sdk == null) {
            SdksCleanupStep.$$$reportNull$$$0(13);
        }
        if (expectedRoots == null) {
            SdksCleanupStep.$$$reportNull$$$0(14);
        }
        SdkModificator sdkModificator = sdk.getSdkModificator();
        sdkModificator.removeAllRoots();
        for (OrderRoot orderRoot : expectedRoots) {
            sdkModificator.addRoot(orderRoot.getFile(), orderRoot.getType());
        }
        ExternalAnnotationsSupport.attachJdkAnnotations(sdkModificator);
        ApplicationManager.getApplication().invokeAndWait(() -> ((SdkModificator)sdkModificator).commitChanges());
    }

    private boolean isMissingAndroidLibrary(@NotNull Sdk sdk) {
        if (sdk == null) {
            SdksCleanupStep.$$$reportNull$$$0(15);
        }
        if (this.myAndroidSdks.isAndroidSdk(sdk)) {
            for (VirtualFile library : sdk.getRootProvider().getFiles(OrderRootType.CLASSES)) {
                if (!library.getName().equals("android.jar") || !library.exists()) continue;
                return false;
            }
        }
        return true;
    }

    private void reinstallMissingPlatforms(@NotNull Set<Sdk> invalidSdks, @NotNull Project project) {
        if (invalidSdks == null) {
            SdksCleanupStep.$$$reportNull$$$0(16);
        }
        if (project == null) {
            SdksCleanupStep.$$$reportNull$$$0(17);
        }
        ArrayList<AndroidVersion> versionsToInstall = new ArrayList<AndroidVersion>();
        ArrayList<CallSite> missingPlatforms = new ArrayList<CallSite>();
        for (Sdk sdk : invalidSdks) {
            String platform;
            AndroidSdkAdditionalData additionalData = this.myAndroidSdks.getAndroidSdkAdditionalData(sdk);
            if (additionalData == null || (platform = additionalData.getBuildTargetHashString()) == null) continue;
            missingPlatforms.add((CallSite)((Object)("'" + platform + "'")));
            AndroidVersion version2 = AndroidTargetHash.getPlatformVersion((String)platform);
            if (version2 == null) continue;
            versionsToInstall.add(version2);
        }
        if (!versionsToInstall.isEmpty()) {
            String text2 = "Missing Android platform(s) detected: " + Joiner.on((String)", ").join(missingPlatforms);
            SyncMessage msg = new SyncMessage("Gradle Sync Issues", MessageType.ERROR, text2);
            msg.add(new InstallPlatformHyperlink(versionsToInstall));
            GradleSyncMessages.getInstance(project).report(msg);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidSdks";
                break;
            }
            case 1: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideModifiableModelsProvider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixedSdks";
                break;
            }
            case 5: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "invalidSdks";
                break;
            }
            case 6: 
            case 8: 
            case 11: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedRoots";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/gradle/project/sync/setup/post/cleanup/SdksCleanupStep";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "cleanUpProject";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "cleanUpSdk";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "updateSdkIfNeeded";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "getTarget";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "updateSdk";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "isMissingAndroidLibrary";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "reinstallMissingPlatforms";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

