/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.post;

import com.android.tools.idea.projectsystem.AndroidProjectSystem;
import com.android.tools.idea.projectsystem.ProjectSystemService;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.NotificationsManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import org.jetbrains.android.util.AndroidBundle;

public class ComposeInBetaChecker {
    private static final NotificationGroup NOTIFICATION_GROUP = new NotificationGroup("Jetpack Compose Project Notification", NotificationDisplayType.STICKY_BALLOON, true);

    public static void checkIfComposeProject(Project project) {
        if (((ComposeProjectNotification[])NotificationsManager.getNotificationsManager().getNotificationsOfType(ComposeProjectNotification.class, project)).length > 0) {
            return;
        }
        Module[] modules = ModuleManager.getInstance((Project)project).getModules();
        AndroidProjectSystem projectSystem2 = ProjectSystemService.getInstance(project).getProjectSystem();
        for (Module module2 : modules) {
            if (!projectSystem2.getModuleSystem(module2).getUsesCompose()) continue;
            ComposeInBetaChecker.showNotification(project);
            return;
        }
    }

    private static void showNotification(Project project) {
        ComposeProjectNotification notification = new ComposeProjectNotification(AndroidBundle.message("compose.feature.in.non-canary.message", new Object[0]));
        notification.setTitle(AndroidBundle.message("compose.feature.in.non-canary.title", new Object[0]));
        notification.notify(project);
    }

    static class ComposeProjectNotification
    extends Notification {
        public ComposeProjectNotification(String content2) {
            super(NOTIFICATION_GROUP.getDisplayId(), "Jetpack Compose project opened in non-Canary IDE", content2, NotificationType.INFORMATION);
            this.setListener(NotificationListener.URL_OPENING_LISTENER);
        }
    }
}

