/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.module.dependency;

import com.android.ide.common.gradle.model.IdeDependencies;
import com.android.ide.common.gradle.model.IdeLibrary;
import com.android.ide.common.repository.GradleCoordinate;
import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.project.sync.setup.module.ModuleFinder;
import com.android.tools.idea.gradle.project.sync.setup.module.dependency.DependencySet;
import com.android.tools.idea.gradle.project.sync.setup.module.dependency.LibraryDependency;
import com.android.tools.idea.gradle.project.sync.setup.module.dependency.ModuleDependency;
import com.android.tools.idea.io.FilePaths;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class DependenciesExtractor {
    @NotNull
    public static DependenciesExtractor getInstance() {
        DependenciesExtractor dependenciesExtractor = (DependenciesExtractor)ApplicationManager.getApplication().getService(DependenciesExtractor.class);
        if (dependenciesExtractor == null) {
            DependenciesExtractor.$$$reportNull$$$0(0);
        }
        return dependenciesExtractor;
    }

    @NotNull
    public DependencySet extractFrom(@NotNull IdeDependencies artifactDependencies, @NotNull ModuleFinder moduleFinder) {
        if (artifactDependencies == null) {
            DependenciesExtractor.$$$reportNull$$$0(1);
        }
        if (moduleFinder == null) {
            DependenciesExtractor.$$$reportNull$$$0(2);
        }
        DependencySet dependencies2 = new DependencySet();
        DependenciesExtractor.populate(dependencies2, artifactDependencies, moduleFinder);
        DependencySet dependencySet = dependencies2;
        if (dependencySet == null) {
            DependenciesExtractor.$$$reportNull$$$0(3);
        }
        return dependencySet;
    }

    private static void populate(@NotNull DependencySet dependencies2, @NotNull IdeDependencies artifactDependencies, @NotNull ModuleFinder moduleFinder) {
        if (dependencies2 == null) {
            DependenciesExtractor.$$$reportNull$$$0(4);
        }
        if (artifactDependencies == null) {
            DependenciesExtractor.$$$reportNull$$$0(5);
        }
        if (moduleFinder == null) {
            DependenciesExtractor.$$$reportNull$$$0(6);
        }
        for (IdeLibrary library : artifactDependencies.getJavaLibraries()) {
            LibraryDependency libraryDependency = LibraryDependency.create(library.getArtifact(), (Collection<File>)ImmutableList.of((Object)library.getArtifact()));
            dependencies2.add(libraryDependency);
        }
        for (IdeLibrary library : artifactDependencies.getAndroidLibraries()) {
            dependencies2.add(DependenciesExtractor.createLibraryDependencyFromAndroidLibrary(library));
        }
        for (IdeLibrary library : artifactDependencies.getModuleDependencies()) {
            Module module2;
            String gradlePath = library.getProjectPath();
            if (!StringUtil.isNotEmpty((String)gradlePath) || (module2 = moduleFinder.findModuleFromLibrary(library)) == null) continue;
            ModuleDependency dependency = new ModuleDependency(module2);
            dependencies2.add(dependency);
        }
    }

    @NotNull
    private static LibraryDependency createLibraryDependencyFromAndroidLibrary(@NotNull IdeLibrary library) {
        if (library == null) {
            DependenciesExtractor.$$$reportNull$$$0(7);
        }
        ImmutableList.Builder binaryPaths = new ImmutableList.Builder();
        binaryPaths.add((Object)FilePaths.stringToFile((String)library.getCompileJarFile()));
        binaryPaths.add((Object)FilePaths.stringToFile((String)library.getResFolder()));
        for (String localJar : library.getLocalJars()) {
            binaryPaths.add((Object)FilePaths.stringToFile((String)localJar));
        }
        LibraryDependency libraryDependency = LibraryDependency.create(library.getArtifact(), (Collection<File>)binaryPaths.build());
        if (libraryDependency == null) {
            DependenciesExtractor.$$$reportNull$$$0(8);
        }
        return libraryDependency;
    }

    @NotNull
    public static String getDependencyDisplayName(@NotNull IdeLibrary library) {
        String artifactAddress;
        GradleCoordinate coordinates;
        if (library == null) {
            DependenciesExtractor.$$$reportNull$$$0(9);
        }
        if ((coordinates = GradleCoordinate.parseCoordinateString((String)(artifactAddress = library.getArtifactAddress()))) != null) {
            GradleVersion version2;
            int index2;
            String groupId;
            String groupSuffix;
            Object name = coordinates.getArtifactId();
            if (!((String)name).contains("-") && !(groupSuffix = (groupId = coordinates.getGroupId()).substring((index2 = groupId.lastIndexOf(46)) + 1)).equals(name)) {
                name = groupSuffix + ":" + (String)name;
            }
            if ((version2 = coordinates.getVersion()) != null && !"unspecified".equals(version2.toString())) {
                name = (String)name + ":" + version2;
            }
            String string = name;
            if (string == null) {
                DependenciesExtractor.$$$reportNull$$$0(10);
            }
            return string;
        }
        String string = StringUtil.trimLeading((String)artifactAddress, (char)':');
        if (string == null) {
            DependenciesExtractor.$$$reportNull$$$0(11);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/setup/module/dependency/DependenciesExtractor";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactDependencies";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleFinder";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencies";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/setup/module/dependency/DependenciesExtractor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "extractFrom";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createLibraryDependencyFromAndroidLibrary";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencyDisplayName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "extractFrom";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "populate";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createLibraryDependencyFromAndroidLibrary";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getDependencyDisplayName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

