/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.module.common;

import com.android.tools.idea.io.FilePaths;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.io.File;
import java.io.UncheckedIOException;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public abstract class ModuleDependenciesSetup {
    private static final Logger LOG = Logger.getInstance(ModuleDependenciesSetup.class);

    protected void updateLibraryRootTypePaths(@NotNull Library library, @NotNull OrderRootType pathType, @NotNull IdeModifiableModelsProvider modelsProvider, File ... paths) {
        if (library == null) {
            ModuleDependenciesSetup.$$$reportNull$$$0(0);
        }
        if (pathType == null) {
            ModuleDependenciesSetup.$$$reportNull$$$0(1);
        }
        if (modelsProvider == null) {
            ModuleDependenciesSetup.$$$reportNull$$$0(2);
        }
        if (paths == null) {
            ModuleDependenciesSetup.$$$reportNull$$$0(3);
        }
        if (paths.length == 0) {
            return;
        }
        Library.ModifiableModel libraryModel = modelsProvider.getModifiableLibraryModel(library);
        for (File path2 : paths) {
            libraryModel.addRoot(FilePaths.pathToIdeaUrl((File)path2), pathType);
        }
    }

    protected void addLibraryAsDependency(@NotNull Library library, @NotNull String libraryName, @NotNull DependencyScope scope2, @NotNull Module module2, @NotNull IdeModifiableModelsProvider modelsProvider, boolean exported) {
        if (library == null) {
            ModuleDependenciesSetup.$$$reportNull$$$0(4);
        }
        if (libraryName == null) {
            ModuleDependenciesSetup.$$$reportNull$$$0(5);
        }
        if (scope2 == null) {
            ModuleDependenciesSetup.$$$reportNull$$$0(6);
        }
        if (module2 == null) {
            ModuleDependenciesSetup.$$$reportNull$$$0(7);
        }
        if (modelsProvider == null) {
            ModuleDependenciesSetup.$$$reportNull$$$0(8);
        }
        for (OrderEntry orderEntry : modelsProvider.getModifiableRootModel(module2).getOrderEntries()) {
            if (!(orderEntry instanceof LibraryOrderEntry)) continue;
            Library entryLibrary = ((LibraryOrderEntry)orderEntry).getLibrary();
            DependencyScope entryScope = ((LibraryOrderEntry)orderEntry).getScope();
            if (entryLibrary == null || !libraryName.equals(entryLibrary.getName()) || !scope2.equals((Object)entryScope)) continue;
            return;
        }
        LibraryOrderEntry orderEntry = modelsProvider.getModifiableRootModel(module2).addLibraryEntry(library);
        orderEntry.setScope(scope2);
        orderEntry.setExported(exported);
        ModuleDependenciesSetup.updateLibraryRootsInFileSystem(orderEntry);
    }

    private static void updateLibraryRootsInFileSystem(@NotNull LibraryOrderEntry orderEntry) {
        if (orderEntry == null) {
            ModuleDependenciesSetup.$$$reportNull$$$0(9);
        }
        VirtualFileManager manager = VirtualFileManager.getInstance();
        for (OrderRootType type : OrderRootType.getAllTypes()) {
            for (String url : orderEntry.getUrls(type)) {
                VirtualFile file2 = manager.findFileByUrl(url);
                if (file2 == null) {
                    file2 = manager.refreshAndFindFileByUrl(url);
                }
                if (file2 != null || !LOG.isDebugEnabled()) continue;
                LOG.debug(String.format("Can't find %s of the library '%s' at path '%s'", type, orderEntry.getLibraryName(), url));
            }
        }
    }

    protected static boolean isLibraryValid(@NotNull Library.ModifiableModel library, @NotNull File[] binaryPaths) {
        if (library == null) {
            ModuleDependenciesSetup.$$$reportNull$$$0(10);
        }
        if (binaryPaths == null) {
            ModuleDependenciesSetup.$$$reportNull$$$0(11);
        }
        if (library.isChanged()) {
            return true;
        }
        String[] cachedUrls = library.getUrls(OrderRootType.CLASSES);
        if (cachedUrls.length != binaryPaths.length) {
            return false;
        }
        if (binaryPaths.length == 0) {
            return true;
        }
        String newUrl = VfsUtil.getUrlForLibraryRoot((File)binaryPaths[0]);
        for (String url : cachedUrls) {
            try {
                if (!Objects.equals(url, newUrl)) continue;
                return true;
            }
            catch (UncheckedIOException ignored) {
                return false;
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathType";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelsProvider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orderEntry";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryPaths";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/gradle/project/sync/setup/module/common/ModuleDependenciesSetup";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "updateLibraryRootTypePaths";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "addLibraryAsDependency";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "updateLibraryRootsInFileSystem";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "isLibraryValid";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

