/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.module;

import com.android.ide.common.gradle.model.IdeLibrary;
import com.android.tools.idea.Projects;
import com.android.tools.idea.gradle.project.sync.Modules;
import com.google.common.base.Strings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.data.BuildParticipant;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;

public class ModuleFinder {
    @NotNull
    public static final ModuleFinder EMPTY = new ModuleFinder();
    @NotNull
    private final Map<String, Module> myModulesByGradlePath;
    @NotNull
    private final Map<String, Module> myModulesByModuleId;
    @NotNull
    private final Map<String, File> myIncludedProjectFolderByModuleFolder;
    @NotNull
    public static final Key<BuildParticipant> EXTRA_BUILD_PARTICIPANT_FROM_BUILD_SRC = new Key("extra.build.participant.from.build.src");

    private ModuleFinder() {
        this.myModulesByGradlePath = new HashMap<String, Module>();
        this.myModulesByModuleId = new HashMap<String, Module>();
        this.myIncludedProjectFolderByModuleFolder = new HashMap<String, File>();
    }

    public ModuleFinder(@NotNull Project project) {
        if (project == null) {
            ModuleFinder.$$$reportNull$$$0(0);
        }
        this.myModulesByGradlePath = new HashMap<String, Module>();
        this.myModulesByModuleId = new HashMap<String, Module>();
        this.myIncludedProjectFolderByModuleFolder = new HashMap<String, File>();
        this.populateIncludedProjectFolderByModuleFolder(project);
    }

    private void populateIncludedProjectFolderByModuleFolder(@NotNull Project project) {
        if (project == null) {
            ModuleFinder.$$$reportNull$$$0(1);
        }
        this.populateExtraBuildParticipants(project);
        String projectPath = project.getBasePath();
        if (projectPath == null) {
            return;
        }
        GradleProjectSettings projectSettings = (GradleProjectSettings)GradleSettings.getInstance((Project)project).getLinkedProjectSettings(projectPath);
        if (projectSettings == null) {
            return;
        }
        GradleProjectSettings.CompositeBuild compositeBuild = projectSettings.getCompositeBuild();
        if (compositeBuild == null) {
            return;
        }
        for (BuildParticipant participant : compositeBuild.getCompositeParticipants()) {
            this.addBuildParticipant(participant);
        }
    }

    private void populateExtraBuildParticipants(@NotNull Project project) {
        BuildParticipant buildParticipant;
        if (project == null) {
            ModuleFinder.$$$reportNull$$$0(2);
        }
        if ((buildParticipant = (BuildParticipant)project.getUserData(EXTRA_BUILD_PARTICIPANT_FROM_BUILD_SRC)) != null) {
            this.addBuildParticipant(buildParticipant);
        }
    }

    private void addBuildParticipant(BuildParticipant participant) {
        for (String modulePath : participant.getProjects()) {
            String path2 = Strings.nullToEmpty((String)participant.getRootPath());
            this.myIncludedProjectFolderByModuleFolder.put(modulePath, new File(path2));
        }
    }

    public void addModule(@NotNull Module module2, @NotNull String gradlePath) {
        if (module2 == null) {
            ModuleFinder.$$$reportNull$$$0(3);
        }
        if (gradlePath == null) {
            ModuleFinder.$$$reportNull$$$0(4);
        }
        this.myModulesByGradlePath.put(gradlePath, module2);
        File folderPath = this.getProjectRootFolder(module2);
        if (folderPath != null) {
            this.myModulesByModuleId.put(Modules.createUniqueModuleId(folderPath, gradlePath), module2);
        }
    }

    @Nullable
    private File getProjectRootFolder(@NotNull Module module2) {
        String modulePath;
        File moduleFolder;
        if (module2 == null) {
            ModuleFinder.$$$reportNull$$$0(5);
        }
        if ((moduleFolder = AndroidRootUtil.findModuleRootFolderPath(module2)) != null && this.myIncludedProjectFolderByModuleFolder.containsKey(modulePath = ExternalSystemApiUtil.toCanonicalPath((String)moduleFolder.getPath()))) {
            return this.myIncludedProjectFolderByModuleFolder.get(modulePath);
        }
        return Projects.getBaseDirPath((Project)module2.getProject());
    }

    @Nullable
    public Module findModuleFromLibrary(@NotNull IdeLibrary library) {
        if (library == null) {
            ModuleFinder.$$$reportNull$$$0(6);
        }
        if (library.getType() != IdeLibrary.LibraryType.LIBRARY_MODULE) {
            return null;
        }
        String gradlePath = library.getProjectPath();
        if (StringUtil.isNotEmpty((String)gradlePath)) {
            Module module2 = null;
            String projectFolderPath = library.getBuildId();
            if (StringUtil.isNotEmpty((String)projectFolderPath)) {
                String moduleId = Modules.createUniqueModuleId(projectFolderPath, gradlePath);
                module2 = this.myModulesByModuleId.get(moduleId);
            }
            return module2 != null ? module2 : this.myModulesByGradlePath.get(gradlePath);
        }
        return null;
    }

    @NotNull
    public Path getRootProjectPath(@NotNull Module module2) {
        String canonicalPath;
        File moduleFolder;
        if (module2 == null) {
            ModuleFinder.$$$reportNull$$$0(7);
        }
        if ((moduleFolder = AndroidRootUtil.findModuleRootFolderPath(module2)) != null && this.myIncludedProjectFolderByModuleFolder.containsKey(canonicalPath = ExternalSystemApiUtil.toCanonicalPath((String)moduleFolder.getPath()))) {
            Path path2 = this.myIncludedProjectFolderByModuleFolder.get(canonicalPath).toPath();
            if (path2 == null) {
                ModuleFinder.$$$reportNull$$$0(8);
            }
            return path2;
        }
        String rootPath = ExternalSystemApiUtil.getExternalRootProjectPath((Module)module2);
        if (rootPath != null) {
            Path path3 = Paths.get(rootPath, new String[0]);
            if (path3 == null) {
                ModuleFinder.$$$reportNull$$$0(9);
            }
            return path3;
        }
        Path path4 = Projects.getBaseDirPath((Project)module2.getProject()).toPath();
        if (path4 == null) {
            ModuleFinder.$$$reportNull$$$0(10);
        }
        return path4;
    }

    public String toString() {
        return "ModuleFinder{myModulesByGradlePath=" + this.myModulesByGradlePath + ", myModulesByModuleId=" + this.myModulesByModuleId + ", myIncludedProjectFolderByModuleFolder=" + this.myIncludedProjectFolderByModuleFolder + "}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradlePath";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/setup/module/ModuleFinder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/setup/module/ModuleFinder";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootProjectPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "populateIncludedProjectFolderByModuleFolder";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "populateExtraBuildParticipants";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addModule";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getProjectRootFolder";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findModuleFromLibrary";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getRootProjectPath";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Factory {
        @NotNull
        public ModuleFinder create(@NotNull Project project) {
            if (project == null) {
                Factory.$$$reportNull$$$0(0);
            }
            return new ModuleFinder(project);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/setup/module/ModuleFinder$Factory", "create"));
        }
    }
}

