/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.quickFixes;

import com.android.tools.idea.gradle.project.sync.idea.issues.DescribedBuildIssueQuickFix;
import com.android.tools.idea.gradle.project.sync.quickFixes.SetJavaLanguageLevel8Processor;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH&J\u001c\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0003H\u0007R\u0014\u0010\u0007\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/android/tools/idea/gradle/project/sync/quickFixes/AbstractSetLanguageLevel8QuickFix;", "Lcom/android/tools/idea/gradle/project/sync/idea/issues/DescribedBuildIssueQuickFix;", "setJvmTarget", "", "modulesDescription", "", "(ZLjava/lang/String;)V", "description", "getDescription", "()Ljava/lang/String;", "buildFilesToApply", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "runQuickFix", "Ljava/util/concurrent/CompletableFuture;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "setJavaLevel8InBuildFiles", "", "jvmTarget", "intellij.android.core"})
public abstract class AbstractSetLanguageLevel8QuickFix
implements DescribedBuildIssueQuickFix {
    @NotNull
    private final String description;
    private final boolean setJvmTarget;
    private final String modulesDescription;

    @Override
    @NotNull
    public String getDescription() {
        return this.description;
    }

    @NotNull
    public abstract List<VirtualFile> buildFilesToApply(@NotNull Project var1);

    @NotNull
    public CompletableFuture<?> runQuickFix(@NotNull Project project, @NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        CompletableFuture future2 = new CompletableFuture();
        try {
            if (!project.isDisposed()) {
                this.setJavaLevel8InBuildFiles(project, this.setJvmTarget);
            }
            future2.complete(null);
        }
        catch (Exception e) {
            future2.completeExceptionally(e);
        }
        return future2;
    }

    @VisibleForTesting
    public final void setJavaLevel8InBuildFiles(@NotNull Project project, boolean jvmTarget) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        List<VirtualFile> buildFiles = this.buildFilesToApply(project);
        if (buildFiles.isEmpty()) {
            Messages.showErrorDialog((Project)project, (String)"Could not determine build files to apply fix", (String)"Change Java language level to 8");
        } else {
            SetJavaLanguageLevel8Processor processor = new SetJavaLanguageLevel8Processor(project, buildFiles, jvmTarget, this.modulesDescription);
            processor.setPreviewUsages(true);
            processor.run();
        }
    }

    public AbstractSetLanguageLevel8QuickFix(boolean setJvmTarget, @NotNull String modulesDescription) {
        Intrinsics.checkNotNullParameter((Object)modulesDescription, (String)"modulesDescription");
        this.setJvmTarget = setJvmTarget;
        this.modulesDescription = modulesDescription;
        this.description = "Change Java language level" + (this.setJvmTarget ? " and jvmTarget" : "") + " to 8 in " + this.modulesDescription + " if using a lower level.";
    }

    @Override
    @NotNull
    public String getHtml() {
        return DescribedBuildIssueQuickFix.DefaultImpls.getHtml(this);
    }
}

