/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.issues.processor;

import com.android.tools.idea.gradle.dsl.api.ProjectBuildModel;
import com.android.tools.idea.gradle.dsl.api.android.AndroidModel;
import com.android.tools.idea.gradle.dsl.api.ext.ResolvedPropertyModel;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usageView.UsageViewDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class FixBuildToolsProcessor
extends BaseRefactoringProcessor {
    @NotNull
    private final List<VirtualFile> myBuildFiles;
    @NotNull
    private final String myVersion;
    private final boolean myRequestSync;
    private final boolean myRemoveBuildTools;

    public FixBuildToolsProcessor(@NotNull Project project, @NotNull List<VirtualFile> buildFiles, @NotNull String version2, boolean requestSync, boolean removeBuildTools) {
        if (project == null) {
            FixBuildToolsProcessor.$$$reportNull$$$0(0);
        }
        if (buildFiles == null) {
            FixBuildToolsProcessor.$$$reportNull$$$0(1);
        }
        if (version2 == null) {
            FixBuildToolsProcessor.$$$reportNull$$$0(2);
        }
        super(project);
        this.myBuildFiles = buildFiles;
        this.myVersion = version2;
        this.myRequestSync = requestSync;
        this.myRemoveBuildTools = removeBuildTools;
    }

    @NotNull
    public UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            FixBuildToolsProcessor.$$$reportNull$$$0(3);
        }
        return new UsageViewDescriptor(){

            public String getCodeReferencesText(int usagesCount, int filesCount) {
                return "Values to " + (FixBuildToolsProcessor.this.myRemoveBuildTools ? "remove " : "update ") + UsageViewBundle.getReferencesString((int)usagesCount, (int)filesCount);
            }

            @NotNull
            public PsiElement[] getElements() {
                if (PsiElement.EMPTY_ARRAY == null) {
                    1.$$$reportNull$$$0(0);
                }
                return PsiElement.EMPTY_ARRAY;
            }

            public String getProcessedElementsHeader() {
                return (FixBuildToolsProcessor.this.myRemoveBuildTools ? "Remove" : "Update") + " Android Build Tools Versions";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/issues/processor/FixBuildToolsProcessor$1", "getElements"));
            }
        };
    }

    @NotNull
    public UsageInfo[] findUsages() {
        ProjectBuildModel projectBuildModel2 = ProjectBuildModel.get((Project)this.myProject);
        ArrayList<UsageInfo> usages = new ArrayList<UsageInfo>();
        for (VirtualFile file2 : this.myBuildFiles) {
            PsiElement element2;
            AndroidModel android;
            ResolvedPropertyModel buildToolsVersion2;
            if (!file2.isValid() || !file2.isWritable() || this.myVersion.equals((buildToolsVersion2 = (android = projectBuildModel2.getModuleBuildModel(file2).android()).buildToolsVersion()).toString()) || (element2 = buildToolsVersion2.getFullExpressionPsiElement()) == null) continue;
            usages.add(new UsageInfo(element2));
        }
        UsageInfo[] usageInfoArray = usages.toArray(UsageInfo.EMPTY_ARRAY);
        if (usageInfoArray == null) {
            FixBuildToolsProcessor.$$$reportNull$$$0(4);
        }
        return usageInfoArray;
    }

    public void performRefactoring(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            FixBuildToolsProcessor.$$$reportNull$$$0(5);
        }
        ProjectBuildModel projectBuildModel2 = ProjectBuildModel.get((Project)this.myProject);
        List elements = Arrays.stream(usages).map(usage -> usage.getElement()).collect(Collectors.toList());
        for (VirtualFile file2 : this.myBuildFiles) {
            AndroidModel android = projectBuildModel2.getModuleBuildModel(file2).android();
            ResolvedPropertyModel buildToolsVersion2 = android.buildToolsVersion();
            PsiElement element2 = buildToolsVersion2.getFullExpressionPsiElement();
            if (element2 == null || !elements.contains(element2)) continue;
            if (this.myRemoveBuildTools) {
                buildToolsVersion2.delete();
                continue;
            }
            buildToolsVersion2.setValue((Object)this.myVersion);
        }
        projectBuildModel2.applyChanges();
        if (this.myRequestSync) {
            GradleSyncStats.Trigger trigger = this.myRemoveBuildTools ? GradleSyncStats.Trigger.TRIGGER_QF_BUILD_TOOLS_VERISON_REMOVED : GradleSyncStats.Trigger.TRIGGER_QF_BUILD_TOOLS_VERSION_CHANGED;
            GradleSyncInvoker.getInstance().requestProjectSync(this.myProject, trigger);
        }
    }

    @NotNull
    public String getCommandName() {
        String string = (this.myRemoveBuildTools ? "Remove" : "Update") + " Android Build Tools Version";
        if (string == null) {
            FixBuildToolsProcessor.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildFiles";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/issues/processor/FixBuildToolsProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/issues/processor/FixBuildToolsProcessor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsages";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createUsageViewDescriptor";
                break;
            }
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "performRefactoring";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

