/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.issues;

import com.android.ide.common.gradle.model.IdeSyncIssue;
import com.android.tools.idea.gradle.project.sync.hyperlink.CreateGradleWrapperHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.FixGradleVersionInWrapperHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.OpenFileHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.OpenGradleSettingsHyperlink;
import com.android.tools.idea.gradle.project.sync.issues.BaseSyncIssuesReporter;
import com.android.tools.idea.gradle.project.sync.issues.SyncIssueUsageReporter;
import com.android.tools.idea.gradle.project.sync.issues.SyncIssueUsageReporterUtils;
import com.android.tools.idea.gradle.util.GradleProjectSettingsFinder;
import com.android.tools.idea.gradle.util.GradleWrapper;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.android.tools.idea.project.messages.MessageType;
import com.android.tools.idea.project.messages.SyncMessage;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.NonNavigatable;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;

class UnsupportedGradleReporter
extends BaseSyncIssuesReporter {
    UnsupportedGradleReporter() {
    }

    @Override
    int getSupportedIssueType() {
        return 12;
    }

    @Override
    void report(@NotNull IdeSyncIssue syncIssue, @NotNull Module module2, @Nullable VirtualFile buildFile, @NotNull SyncIssueUsageReporter usageReporter) {
        if (syncIssue == null) {
            UnsupportedGradleReporter.$$$reportNull$$$0(0);
        }
        if (module2 == null) {
            UnsupportedGradleReporter.$$$reportNull$$$0(1);
        }
        if (usageReporter == null) {
            UnsupportedGradleReporter.$$$reportNull$$$0(2);
        }
        String text2 = syncIssue.getMessage();
        MessageType type = UnsupportedGradleReporter.getMessageType(syncIssue);
        SyncMessage message2 = new SyncMessage("Gradle Sync Issues", type, NonNavigatable.INSTANCE, text2);
        String gradleVersion2 = syncIssue.getData();
        List<NotificationHyperlink> quickFixes = UnsupportedGradleReporter.getQuickFixHyperlinksWithGradleVersion(module2.getProject(), gradleVersion2);
        message2.add(quickFixes);
        this.getSyncMessages(module2).report(message2);
        SyncIssueUsageReporterUtils.collect(usageReporter, syncIssue.getType(), quickFixes);
    }

    @NotNull
    private static List<NotificationHyperlink> getQuickFixHyperlinksWithGradleVersion(@NotNull Project project, @Nullable String gradleVersion2) {
        if (project == null) {
            UnsupportedGradleReporter.$$$reportNull$$$0(3);
        }
        ArrayList<NotificationHyperlink> hyperlinks = new ArrayList<NotificationHyperlink>();
        GradleWrapper gradleWrapper = GradleWrapper.find(project);
        if (gradleWrapper != null) {
            File propertiesFile;
            NotificationHyperlink hyperlink = FixGradleVersionInWrapperHyperlink.createIfProjectUsesGradleWrapper(project, gradleVersion2);
            if (hyperlink != null) {
                hyperlinks.add(hyperlink);
            }
            if ((propertiesFile = gradleWrapper.getPropertiesFilePath()).exists()) {
                hyperlinks.add(new OpenFileHyperlink(gradleWrapper.getPropertiesFilePath().getAbsolutePath(), "Open Gradle wrapper properties", -1, -1));
            }
        } else {
            GradleProjectSettings gradleProjectSettings = GradleProjectSettingsFinder.getInstance().findGradleProjectSettings(project);
            if (gradleProjectSettings != null && gradleProjectSettings.getDistributionType() == DistributionType.LOCAL) {
                hyperlinks.add(new CreateGradleWrapperHyperlink());
            }
        }
        hyperlinks.add(new OpenGradleSettingsHyperlink());
        ArrayList<NotificationHyperlink> arrayList = hyperlinks;
        if (arrayList == null) {
            UnsupportedGradleReporter.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "syncIssue";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageReporter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/issues/UnsupportedGradleReporter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/issues/UnsupportedGradleReporter";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuickFixHyperlinksWithGradleVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "report";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getQuickFixHyperlinksWithGradleVersion";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

