/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.issues;

import com.android.ide.common.gradle.model.IdeSyncIssue;
import com.android.ide.common.repository.GradleCoordinate;
import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.ProjectBuildModel;
import com.android.tools.idea.gradle.project.sync.hyperlink.AddGoogleMavenRepositoryHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.DisableOfflineModeHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.ShowDependencyInProjectStructureHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.ShowSyncIssuesDetailsHyperlink;
import com.android.tools.idea.gradle.project.sync.issues.SimpleDeduplicatingSyncIssueReporter;
import com.android.tools.idea.gradle.util.GradleProjects;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.android.tools.idea.project.messages.MessageType;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

@Service
public final class UnresolvedDependenciesReporter
extends SimpleDeduplicatingSyncIssueReporter {
    private static final String UNRESOLVED_DEPENDENCIES_GROUP = "Unresolved dependencies";
    private boolean myAssumeProjectNotInitialized = false;

    @Override
    int getSupportedIssueType() {
        return 2;
    }

    @Override
    @NotNull
    protected List<NotificationHyperlink> getCustomLinks(@NotNull Project project, @NotNull List<IdeSyncIssue> syncIssues2, @NotNull List<Module> affectedModules, @NotNull Map<Module, VirtualFile> buildFileMap) {
        if (project == null) {
            UnresolvedDependenciesReporter.$$$reportNull$$$0(0);
        }
        if (syncIssues2 == null) {
            UnresolvedDependenciesReporter.$$$reportNull$$$0(1);
        }
        if (affectedModules == null) {
            UnresolvedDependenciesReporter.$$$reportNull$$$0(2);
        }
        if (buildFileMap == null) {
            UnresolvedDependenciesReporter.$$$reportNull$$$0(3);
        }
        assert (!syncIssues2.isEmpty() && !affectedModules.isEmpty());
        IdeSyncIssue issue2 = syncIssues2.get(0);
        String dependency = issue2.getData();
        ArrayList<NotificationHyperlink> quickFixes = new ArrayList<NotificationHyperlink>();
        if (dependency == null) {
            ArrayList<String> extraInfo = new ArrayList<String>();
            try {
                List multiLineMessage = issue2.getMultiLineMessage();
                if (multiLineMessage != null) {
                    extraInfo.addAll(multiLineMessage);
                }
            }
            catch (UnsupportedOperationException multiLineMessage) {
                // empty catch block
            }
            if (!extraInfo.isEmpty()) {
                quickFixes.add(new ShowSyncIssuesDetailsHyperlink(issue2.getMessage(), extraInfo));
            }
            if (GradleProjects.isOfflineBuildModeEnabled(project)) {
                quickFixes.add(0, new DisableOfflineModeHyperlink());
            }
        } else {
            GradleCoordinate coordinate = GradleCoordinate.parseCoordinateString((String)dependency);
            List buildFiles = ContainerUtil.map(affectedModules, m -> (VirtualFile)buildFileMap.get(m));
            Module module2 = affectedModules.get(0);
            if (dependency.startsWith("com.android.support") || dependency.startsWith("androidx.") || dependency.startsWith("com.google.android")) {
                this.addGoogleMavenRepositoryHyperlink(project, buildFiles, quickFixes);
            } else if (GradleProjects.isOfflineBuildModeEnabled(project)) {
                quickFixes.add(new DisableOfflineModeHyperlink());
            }
            if (IdeInfo.getInstance().isAndroidStudio() && coordinate != null) {
                quickFixes.add(new ShowDependencyInProjectStructureHyperlink(module2, coordinate));
            }
        }
        ArrayList<NotificationHyperlink> arrayList = quickFixes;
        if (arrayList == null) {
            UnresolvedDependenciesReporter.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @Override
    @NotNull
    protected NotificationData setupNotificationData(@NotNull Project project, @NotNull List<IdeSyncIssue> syncIssues2, @NotNull List<Module> affectedModules, @NotNull Map<Module, VirtualFile> buildFileMap, @NotNull MessageType type) {
        if (project == null) {
            UnresolvedDependenciesReporter.$$$reportNull$$$0(5);
        }
        if (syncIssues2 == null) {
            UnresolvedDependenciesReporter.$$$reportNull$$$0(6);
        }
        if (affectedModules == null) {
            UnresolvedDependenciesReporter.$$$reportNull$$$0(7);
        }
        if (buildFileMap == null) {
            UnresolvedDependenciesReporter.$$$reportNull$$$0(8);
        }
        if (type == null) {
            UnresolvedDependenciesReporter.$$$reportNull$$$0(9);
        }
        NotificationData notificationData = super.setupNotificationData(project, syncIssues2, affectedModules, buildFileMap, type);
        notificationData.setTitle(UNRESOLVED_DEPENDENCIES_GROUP);
        String dependency = syncIssues2.get(0).getData();
        if (dependency == null) {
            NotificationData notificationData2 = notificationData;
            if (notificationData2 == null) {
                UnresolvedDependenciesReporter.$$$reportNull$$$0(10);
            }
            return notificationData2;
        }
        String message2 = "Failed to resolve: " + dependency;
        notificationData.setMessage(message2);
        NotificationData notificationData3 = notificationData;
        if (notificationData3 == null) {
            UnresolvedDependenciesReporter.$$$reportNull$$$0(11);
        }
        return notificationData3;
    }

    private void addGoogleMavenRepositoryHyperlink(@NotNull Project project, @NotNull List<VirtualFile> buildFiles, @NotNull List<NotificationHyperlink> fixes) {
        if (project == null) {
            UnresolvedDependenciesReporter.$$$reportNull$$$0(12);
        }
        if (buildFiles == null) {
            UnresolvedDependenciesReporter.$$$reportNull$$$0(13);
        }
        if (fixes == null) {
            UnresolvedDependenciesReporter.$$$reportNull$$$0(14);
        }
        if (!project.isInitialized() || this.myAssumeProjectNotInitialized) {
            fixes.add(new AddGoogleMavenRepositoryHyperlink(project));
            return;
        }
        ProjectBuildModel projectBuildModel2 = ProjectBuildModel.getOrLog((Project)project);
        if (projectBuildModel2 == null) {
            return;
        }
        ArrayList<VirtualFile> filesToFix = new ArrayList<VirtualFile>();
        for (VirtualFile file2 : buildFiles) {
            GradleBuildModel moduleModel;
            if (file2 == null || !file2.isValid() || (moduleModel = projectBuildModel2.getModuleBuildModel(file2)).repositories().hasGoogleMavenRepository()) continue;
            filesToFix.add(file2);
        }
        if (filesToFix.isEmpty()) {
            return;
        }
        GradleBuildModel buildModel = projectBuildModel2.getProjectBuildModel();
        if (buildModel != null && !buildModel.repositories().hasGoogleMavenRepository()) {
            fixes.add(new AddGoogleMavenRepositoryHyperlink((List<VirtualFile>)ImmutableList.of((Object)buildModel.getVirtualFile())));
            return;
        }
        fixes.add(new AddGoogleMavenRepositoryHyperlink(filesToFix));
    }

    @VisibleForTesting
    void assumeProjectNotInitialized(boolean assumeNotInitialized) {
        this.myAssumeProjectNotInitialized = assumeNotInitialized;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "syncIssues";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "affectedModules";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildFileMap";
                break;
            }
            case 4: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/issues/UnresolvedDependenciesReporter";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildFiles";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/issues/UnresolvedDependenciesReporter";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomLinks";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "setupNotificationData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCustomLinks";
                break;
            }
            case 4: 
            case 10: 
            case 11: {
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setupNotificationData";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addGoogleMavenRepositoryHyperlink";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

