/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.issues;

import com.android.ide.common.gradle.model.IdeSyncIssue;
import com.android.tools.idea.gradle.project.sync.issues.AndroidXUsedReporter;
import com.android.tools.idea.gradle.project.sync.issues.BaseSyncIssuesReporter;
import com.android.tools.idea.gradle.project.sync.issues.BuildToolsTooLowReporter;
import com.android.tools.idea.gradle.project.sync.issues.CxxConfigurationIssuesReporter;
import com.android.tools.idea.gradle.project.sync.issues.DeprecatedConfigurationReporter;
import com.android.tools.idea.gradle.project.sync.issues.ExternalNdkBuildIssuesReporter;
import com.android.tools.idea.gradle.project.sync.issues.MinSdkInManifestIssuesReporter;
import com.android.tools.idea.gradle.project.sync.issues.MissingSdkIssueReporter;
import com.android.tools.idea.gradle.project.sync.issues.MissingSdkPackageSyncIssuesReporter;
import com.android.tools.idea.gradle.project.sync.issues.OutOfDateThirdPartyPluginIssueReporter;
import com.android.tools.idea.gradle.project.sync.issues.SyncIssueUsageReporter;
import com.android.tools.idea.gradle.project.sync.issues.TargetSdkInManifestIssuesReporter;
import com.android.tools.idea.gradle.project.sync.issues.UnhandledIssuesReporter;
import com.android.tools.idea.gradle.project.sync.issues.UnresolvedDependenciesReporter;
import com.android.tools.idea.gradle.project.sync.issues.UnsupportedGradleReporter;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.serviceContainer.NonInjectable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

@Service
public final class SyncIssuesReporter {
    @NotNull
    private final Map<Integer, BaseSyncIssuesReporter> myStrategies;
    @NotNull
    private final BaseSyncIssuesReporter myDefaultMessageFactory;

    @NotNull
    public static SyncIssuesReporter getInstance() {
        SyncIssuesReporter syncIssuesReporter = (SyncIssuesReporter)ApplicationManager.getApplication().getService(SyncIssuesReporter.class);
        if (syncIssuesReporter == null) {
            SyncIssuesReporter.$$$reportNull$$$0(0);
        }
        return syncIssuesReporter;
    }

    public SyncIssuesReporter() {
        this(new UnresolvedDependenciesReporter(), new ExternalNdkBuildIssuesReporter(), new UnsupportedGradleReporter(), new BuildToolsTooLowReporter(), new MissingSdkPackageSyncIssuesReporter(), new MinSdkInManifestIssuesReporter(), new TargetSdkInManifestIssuesReporter(), new DeprecatedConfigurationReporter(), new MissingSdkIssueReporter(), new OutOfDateThirdPartyPluginIssueReporter(), new CxxConfigurationIssuesReporter(), new AndroidXUsedReporter());
    }

    @NonInjectable
    @VisibleForTesting
    SyncIssuesReporter(BaseSyncIssuesReporter ... strategies) {
        if (strategies == null) {
            SyncIssuesReporter.$$$reportNull$$$0(1);
        }
        this.myStrategies = new HashMap<Integer, BaseSyncIssuesReporter>(12);
        for (BaseSyncIssuesReporter strategy : strategies) {
            int issueType = strategy.getSupportedIssueType();
            this.myStrategies.put(issueType, strategy);
        }
        this.myDefaultMessageFactory = new UnhandledIssuesReporter();
    }

    public void report(@NotNull Map<Module, List<IdeSyncIssue>> issuesByModules) {
        if (issuesByModules == null) {
            SyncIssuesReporter.$$$reportNull$$$0(2);
        }
        if (issuesByModules.isEmpty()) {
            return;
        }
        LinkedHashMap syncIssues2 = new LinkedHashMap();
        IdentityHashMap<IdeSyncIssue, Module> moduleMap = new IdentityHashMap<IdeSyncIssue, Module>();
        LinkedHashMap<Module, VirtualFile> buildFileMap = new LinkedHashMap<Module, VirtualFile>();
        Project project = null;
        for (Module module2 : issuesByModules.keySet()) {
            project = module2.getProject();
            buildFileMap.put(module2, GradleUtil.getGradleBuildFile(module2));
            issuesByModules.get(module2).forEach(issue2 -> {
                if (issue2 != null) {
                    syncIssues2.computeIfAbsent(issue2.getType(), type -> new ArrayList()).add(issue2);
                    moduleMap.put((IdeSyncIssue)issue2, module2);
                }
            });
        }
        Map sortedSyncIssues = syncIssues2.entrySet().stream().sorted(Collections.reverseOrder(Map.Entry.comparingByValue(Comparator.comparing(issues -> ((IdeSyncIssue)issues.get(0)).getSeverity())))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oldVal, newVal) -> oldVal, LinkedHashMap::new));
        SyncIssueUsageReporter syncIssueUsageReporter = SyncIssueUsageReporter.Companion.getInstance(project);
        for (Map.Entry entry : sortedSyncIssues.entrySet()) {
            BaseSyncIssuesReporter strategy = this.myStrategies.get(entry.getKey());
            if (strategy == null) {
                strategy = this.myDefaultMessageFactory;
            }
            strategy.reportAll((List)entry.getValue(), moduleMap, buildFileMap, syncIssueUsageReporter);
        }
        Project finalProject = project;
        Runnable reportTask = () -> SyncIssueUsageReporter.Companion.getInstance(finalProject).reportToUsageTracker();
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            reportTask.run();
        } else {
            ApplicationManager.getApplication().invokeLater(reportTask);
        }
    }

    @VisibleForTesting
    @NotNull
    Map<Integer, BaseSyncIssuesReporter> getStrategies() {
        Map<Integer, BaseSyncIssuesReporter> map2 = this.myStrategies;
        if (map2 == null) {
            SyncIssuesReporter.$$$reportNull$$$0(3);
        }
        return map2;
    }

    @VisibleForTesting
    @NotNull
    BaseSyncIssuesReporter getDefaultMessageFactory() {
        BaseSyncIssuesReporter baseSyncIssuesReporter = this.myDefaultMessageFactory;
        if (baseSyncIssuesReporter == null) {
            SyncIssuesReporter.$$$reportNull$$$0(4);
        }
        return baseSyncIssuesReporter;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/issues/SyncIssuesReporter";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strategies";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "issuesByModules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/issues/SyncIssuesReporter";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getStrategies";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultMessageFactory";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "report";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

