/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.issues;

import com.android.ide.common.gradle.model.IdeSyncIssue;
import com.android.tools.idea.gradle.project.build.events.AndroidSyncIssueQuickFix;
import com.android.tools.idea.gradle.project.sync.hyperlink.OpenFileHyperlink;
import com.android.tools.idea.gradle.project.sync.issues.BaseSyncIssuesReporter;
import com.android.tools.idea.gradle.project.sync.issues.SyncIssueUsageReporter;
import com.android.tools.idea.gradle.project.sync.issues.SyncIssueUsageReporterUtils;
import com.android.tools.idea.gradle.project.sync.messages.GradleSyncMessages;
import com.android.tools.idea.gradle.util.AndroidGradleUtil;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.android.tools.idea.project.messages.MessageType;
import com.android.tools.idea.ui.QuickFixNotificationListener;
import com.android.tools.idea.util.PositionInFile;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SimpleDeduplicatingSyncIssueReporter
extends BaseSyncIssuesReporter {
    @Override
    final void report(@NotNull IdeSyncIssue syncIssue, @NotNull Module module2, @Nullable VirtualFile buildFile, @NotNull SyncIssueUsageReporter usageReporter) {
        if (syncIssue == null) {
            SimpleDeduplicatingSyncIssueReporter.$$$reportNull$$$0(0);
        }
        if (module2 == null) {
            SimpleDeduplicatingSyncIssueReporter.$$$reportNull$$$0(1);
        }
        if (usageReporter == null) {
            SimpleDeduplicatingSyncIssueReporter.$$$reportNull$$$0(2);
        }
        this.reportAll((List<IdeSyncIssue>)ImmutableList.of((Object)syncIssue), (Map<IdeSyncIssue, Module>)ImmutableMap.of((Object)syncIssue, (Object)module2), (Map<Module, VirtualFile>)(buildFile == null ? ImmutableMap.of() : ImmutableMap.of((Object)module2, (Object)buildFile)), usageReporter);
    }

    @Override
    final void reportAll(@NotNull List<IdeSyncIssue> syncIssues2, @NotNull Map<IdeSyncIssue, Module> moduleMap, @NotNull Map<Module, VirtualFile> buildFileMap, @NotNull SyncIssueUsageReporter usageReporter) {
        if (syncIssues2 == null) {
            SimpleDeduplicatingSyncIssueReporter.$$$reportNull$$$0(3);
        }
        if (moduleMap == null) {
            SimpleDeduplicatingSyncIssueReporter.$$$reportNull$$$0(4);
        }
        if (buildFileMap == null) {
            SimpleDeduplicatingSyncIssueReporter.$$$reportNull$$$0(5);
        }
        if (usageReporter == null) {
            SimpleDeduplicatingSyncIssueReporter.$$$reportNull$$$0(6);
        }
        LinkedHashMap<Object, List> groupedIssues = new LinkedHashMap<Object, List>();
        for (IdeSyncIssue issue2 : syncIssues2) {
            groupedIssues.computeIfAbsent(this.getDeduplicationKey(issue2), config -> new ArrayList()).add(issue2);
        }
        for (List entry : groupedIssues.values()) {
            IdeSyncIssue issue3;
            Module module2;
            if (entry.isEmpty() || (module2 = moduleMap.get(issue3 = (IdeSyncIssue)entry.get(0))) == null) continue;
            List<Module> affectedModules = entry.stream().map(moduleMap::get).filter(Objects::nonNull).distinct().sorted(Comparator.comparing(Module::getName)).collect(Collectors.toList());
            boolean isError = entry.stream().anyMatch(i2 -> i2.getSeverity() == 2);
            this.createNotificationDataAndReport(module2.getProject(), entry, affectedModules, buildFileMap, isError, usageReporter);
        }
    }

    private void createNotificationDataAndReport(@NotNull Project project, @NotNull List<IdeSyncIssue> syncIssues2, @NotNull List<Module> affectedModules, @NotNull Map<Module, VirtualFile> buildFileMap, boolean isError, @NotNull SyncIssueUsageReporter usageReporter) {
        MessageType type;
        if (project == null) {
            SimpleDeduplicatingSyncIssueReporter.$$$reportNull$$$0(7);
        }
        if (syncIssues2 == null) {
            SimpleDeduplicatingSyncIssueReporter.$$$reportNull$$$0(8);
        }
        if (affectedModules == null) {
            SimpleDeduplicatingSyncIssueReporter.$$$reportNull$$$0(9);
        }
        if (buildFileMap == null) {
            SimpleDeduplicatingSyncIssueReporter.$$$reportNull$$$0(10);
        }
        if (usageReporter == null) {
            SimpleDeduplicatingSyncIssueReporter.$$$reportNull$$$0(11);
        }
        GradleSyncMessages messages = GradleSyncMessages.getInstance(project);
        MessageType messageType = type = isError ? MessageType.WARNING : MessageType.INFO;
        assert (!syncIssues2.isEmpty());
        NotificationData notification = this.setupNotificationData(project, syncIssues2, affectedModules, buildFileMap, type);
        StringBuilder builder2 = new StringBuilder();
        List<NotificationHyperlink> customLinks = this.getCustomLinks(project, syncIssues2, affectedModules, buildFileMap);
        messages.updateNotification(notification, notification.getMessage(), customLinks);
        SyncIssueUsageReporterUtils.collect(usageReporter, syncIssues2.get(0).getType(), customLinks);
        Object message2 = notification.getMessage().trim();
        ArrayList<AndroidSyncIssueQuickFix> buildIssueLinks = new ArrayList<AndroidSyncIssueQuickFix>();
        buildIssueLinks.addAll(ContainerUtil.map(customLinks, it -> new AndroidSyncIssueQuickFix((NotificationHyperlink)it)));
        if (this.shouldIncludeModuleLinks() && !affectedModules.isEmpty()) {
            builder2.append("\nAffected Modules: ");
            Iterator<Module> it2 = affectedModules.iterator();
            while (it2.hasNext()) {
                Module m = it2.next();
                if (m == null) continue;
                NotificationHyperlink link = this.doCreateModuleLink(project, notification, builder2, m, syncIssues2, buildFileMap.get(m));
                if (link != null) {
                    buildIssueLinks.add(new AndroidSyncIssueQuickFix(link));
                }
                if (!it2.hasNext()) continue;
                builder2.append(", ");
            }
        }
        message2 = (String)message2 + builder2.toString();
        notification.setMessage((String)message2);
        messages.report(notification, buildIssueLinks);
    }

    private NotificationHyperlink doCreateModuleLink(@NotNull Project project, @NotNull NotificationData notification, @NotNull StringBuilder builder2, @NotNull Module module2, @NotNull List<IdeSyncIssue> syncIssues2, @Nullable VirtualFile buildFile) {
        if (project == null) {
            SimpleDeduplicatingSyncIssueReporter.$$$reportNull$$$0(12);
        }
        if (notification == null) {
            SimpleDeduplicatingSyncIssueReporter.$$$reportNull$$$0(13);
        }
        if (builder2 == null) {
            SimpleDeduplicatingSyncIssueReporter.$$$reportNull$$$0(14);
        }
        if (module2 == null) {
            SimpleDeduplicatingSyncIssueReporter.$$$reportNull$$$0(15);
        }
        if (syncIssues2 == null) {
            SimpleDeduplicatingSyncIssueReporter.$$$reportNull$$$0(16);
        }
        if (buildFile == null) {
            builder2.append(AndroidGradleUtil.getDisplayNameForModule(module2));
            return null;
        }
        OpenFileHyperlink link = this.createModuleLink(project, module2, syncIssues2, buildFile);
        builder2.append(link.toHtml());
        notification.setListener(link.getUrl(), (NotificationListener)new QuickFixNotificationListener(project, link));
        return link;
    }

    @NotNull
    protected OpenFileHyperlink createModuleLink(@NotNull Project project, @NotNull Module module2, @NotNull List<IdeSyncIssue> syncIssues2, @NotNull VirtualFile buildFile) {
        if (project == null) {
            SimpleDeduplicatingSyncIssueReporter.$$$reportNull$$$0(17);
        }
        if (module2 == null) {
            SimpleDeduplicatingSyncIssueReporter.$$$reportNull$$$0(18);
        }
        if (syncIssues2 == null) {
            SimpleDeduplicatingSyncIssueReporter.$$$reportNull$$$0(19);
        }
        if (buildFile == null) {
            SimpleDeduplicatingSyncIssueReporter.$$$reportNull$$$0(20);
        }
        return new OpenFileHyperlink(buildFile.getPath(), AndroidGradleUtil.getDisplayNameForModule(module2), -1, -1);
    }

    @NotNull
    protected Object getDeduplicationKey(@NotNull IdeSyncIssue issue2) {
        if (issue2 == null) {
            SimpleDeduplicatingSyncIssueReporter.$$$reportNull$$$0(21);
        }
        Object object = issue2.getData() == null ? issue2 : issue2.getData();
        if (object == null) {
            SimpleDeduplicatingSyncIssueReporter.$$$reportNull$$$0(22);
        }
        return object;
    }

    protected boolean shouldIncludeModuleLinks() {
        return true;
    }

    @NotNull
    protected List<NotificationHyperlink> getCustomLinks(@NotNull Project project, @NotNull List<IdeSyncIssue> syncIssues2, @NotNull List<Module> affectedModules, @NotNull Map<Module, VirtualFile> buildFileMap) {
        if (project == null) {
            SimpleDeduplicatingSyncIssueReporter.$$$reportNull$$$0(23);
        }
        if (syncIssues2 == null) {
            SimpleDeduplicatingSyncIssueReporter.$$$reportNull$$$0(24);
        }
        if (affectedModules == null) {
            SimpleDeduplicatingSyncIssueReporter.$$$reportNull$$$0(25);
        }
        if (buildFileMap == null) {
            SimpleDeduplicatingSyncIssueReporter.$$$reportNull$$$0(26);
        }
        ImmutableList immutableList = ImmutableList.of();
        if (immutableList == null) {
            SimpleDeduplicatingSyncIssueReporter.$$$reportNull$$$0(27);
        }
        return immutableList;
    }

    @NotNull
    protected NotificationData setupNotificationData(@NotNull Project project, @NotNull List<IdeSyncIssue> syncIssues2, @NotNull List<Module> affectedModules, @NotNull Map<Module, VirtualFile> buildFileMap, @NotNull MessageType type) {
        VirtualFile file2;
        if (project == null) {
            SimpleDeduplicatingSyncIssueReporter.$$$reportNull$$$0(28);
        }
        if (syncIssues2 == null) {
            SimpleDeduplicatingSyncIssueReporter.$$$reportNull$$$0(29);
        }
        if (affectedModules == null) {
            SimpleDeduplicatingSyncIssueReporter.$$$reportNull$$$0(30);
        }
        if (buildFileMap == null) {
            SimpleDeduplicatingSyncIssueReporter.$$$reportNull$$$0(31);
        }
        if (type == null) {
            SimpleDeduplicatingSyncIssueReporter.$$$reportNull$$$0(32);
        }
        assert (!syncIssues2.isEmpty());
        GradleSyncMessages messages = GradleSyncMessages.getInstance(project);
        PositionInFile position = null;
        if (affectedModules.size() == 1 && (file2 = buildFileMap.get(affectedModules.get(0))) != null) {
            position = new PositionInFile(file2);
        }
        NotificationData data = messages.createNotification("Gradle Sync Issues", syncIssues2.get(0).getMessage(), type.convertToCategory(), position);
        if (position != null) {
            data.setNavigatable((Navigatable)new OpenFileDescriptor(project, position.file, position.line, position.column));
        }
        NotificationData notificationData = data;
        if (notificationData == null) {
            SimpleDeduplicatingSyncIssueReporter.$$$reportNull$$$0(33);
        }
        return notificationData;
    }

    public static int getLineNumberForElement(@NotNull Project project, @Nullable PsiElement element2) {
        if (project == null) {
            SimpleDeduplicatingSyncIssueReporter.$$$reportNull$$$0(34);
        }
        return (Integer)ApplicationManager.getApplication().runReadAction(() -> {
            Document document;
            if (element2 != null && (document = PsiDocumentManager.getInstance((Project)project).getDocument(element2.getContainingFile())) != null) {
                return document.getLineNumber(element2.getTextOffset());
            }
            return -1;
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 22: 
            case 27: 
            case 33: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 22: 
            case 27: 
            case 33: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "syncIssue";
                break;
            }
            case 1: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageReporter";
                break;
            }
            case 3: 
            case 8: 
            case 16: 
            case 19: 
            case 24: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "syncIssues";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleMap";
                break;
            }
            case 5: 
            case 10: 
            case 26: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildFileMap";
                break;
            }
            case 7: 
            case 12: 
            case 17: 
            case 23: 
            case 28: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: 
            case 25: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "affectedModules";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notification";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildFile";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "issue";
                break;
            }
            case 22: 
            case 27: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/issues/SimpleDeduplicatingSyncIssueReporter";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/issues/SimpleDeduplicatingSyncIssueReporter";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeduplicationKey";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomLinks";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "setupNotificationData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "report";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "reportAll";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createNotificationDataAndReport";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "doCreateModuleLink";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createModuleLink";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getDeduplicationKey";
                break;
            }
            case 22: 
            case 27: 
            case 33: {
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getCustomLinks";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "setupNotificationData";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getLineNumberForElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 22: 
            case 27: 
            case 33: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

