/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.issues;

import com.android.ide.common.blame.Message;
import com.android.ide.common.blame.SourceFile;
import com.android.ide.common.blame.SourceFilePosition;
import com.android.ide.common.blame.SourcePosition;
import com.android.ide.common.blame.parser.PatternAwareOutputParser;
import com.android.ide.common.gradle.model.IdeSyncIssue;
import com.android.tools.idea.gradle.output.parser.BuildOutputParser;
import com.android.tools.idea.gradle.project.sync.issues.BaseSyncIssuesReporter;
import com.android.tools.idea.gradle.project.sync.issues.SyncIssueUsageReporter;
import com.android.tools.idea.gradle.project.sync.messages.GradleSyncMessages;
import com.android.tools.idea.project.messages.MessageType;
import com.android.tools.idea.project.messages.SyncMessage;
import com.android.tools.idea.util.PositionInFile;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.build.FilePosition;
import com.intellij.build.issue.BuildIssue;
import com.intellij.build.issue.BuildIssueChecker;
import com.intellij.build.issue.BuildIssueData;
import com.intellij.build.issue.BuildIssueQuickFix;
import com.intellij.ide.DataManager;
import com.intellij.openapi.externalSystem.service.notification.NotificationCategory;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.service.JpsServiceManager;
import org.jetbrains.plugins.gradle.issue.GradleIssueChecker;
import org.jetbrains.plugins.gradle.issue.GradleIssueData;

class ExternalNdkBuildIssuesReporter
extends BaseSyncIssuesReporter {
    @NotNull
    private final BuildOutputParser myBuildOutputParser;

    ExternalNdkBuildIssuesReporter() {
        this(ExternalNdkBuildIssuesReporter.createBuildOutputParser());
    }

    @NotNull
    private static BuildOutputParser createBuildOutputParser() {
        return new BuildOutputParser(JpsServiceManager.getInstance().getExtensions(PatternAwareOutputParser.class));
    }

    @VisibleForTesting
    ExternalNdkBuildIssuesReporter(@NotNull BuildOutputParser buildOutputParser) {
        if (buildOutputParser == null) {
            ExternalNdkBuildIssuesReporter.$$$reportNull$$$0(0);
        }
        this.myBuildOutputParser = buildOutputParser;
    }

    @Override
    int getSupportedIssueType() {
        return 17;
    }

    @Override
    void report(@NotNull IdeSyncIssue IdeSyncIssue2, @NotNull Module module2, @Nullable VirtualFile buildFile, @NotNull SyncIssueUsageReporter usageReporter) {
        if (IdeSyncIssue2 == null) {
            ExternalNdkBuildIssuesReporter.$$$reportNull$$$0(1);
        }
        if (module2 == null) {
            ExternalNdkBuildIssuesReporter.$$$reportNull$$$0(2);
        }
        if (usageReporter == null) {
            ExternalNdkBuildIssuesReporter.$$$reportNull$$$0(3);
        }
        String group2 = "External Native Build Issues";
        String nativeToolOutput = IdeSyncIssue2.getData();
        if (nativeToolOutput != null) {
            GradleSyncMessages messages = this.getSyncMessages(module2);
            List compilerMessages = this.myBuildOutputParser.parseGradleOutput(nativeToolOutput);
            for (Message compilerMessage : compilerMessages) {
                MessageType type = MessageType.findMatching(compilerMessage.getKind());
                PositionInFile position = ExternalNdkBuildIssuesReporter.createPosition(compilerMessage.getSourceFilePositions());
                String text2 = compilerMessage.getText();
                Project project = module2.getProject();
                if (type == MessageType.ERROR) {
                    NotificationCategory category = type.convertToCategory();
                    NotificationData notificationData = messages.createNotification(group2, text2, category, position);
                    GradleIssueData issueData = new GradleIssueData(project.getBasePath(), new Throwable(text2), null, new FilePosition(new File(position.file.getPath()), position.line, position.column));
                    List knownIssuesCheckList = GradleIssueChecker.getKnownIssuesCheckList();
                    ArrayList<BuildIssueQuickFix> quickFixes = new ArrayList<BuildIssueQuickFix>();
                    for (BuildIssueChecker checker2 : knownIssuesCheckList) {
                        BuildIssue buildIssue = checker2.check((BuildIssueData)issueData);
                        if (buildIssue == null) continue;
                        for (BuildIssueQuickFix quickFix : buildIssue.getQuickFixes()) {
                            notificationData.setListener(quickFix.getId(), (notification, event) -> {
                                if (event.getSource() instanceof JComponent) {
                                    quickFix.runQuickFix(project, DataManager.getInstance().getDataContext((Component)((JComponent)event.getSource())));
                                }
                            });
                            quickFixes.add(quickFix);
                        }
                    }
                    messages.report(notificationData, quickFixes);
                    continue;
                }
                SyncMessage message2 = position != null ? new SyncMessage(project, group2, type, position, text2) : new SyncMessage(group2, type, text2);
                messages.report(message2);
            }
        }
    }

    @Nullable
    private static PositionInFile createPosition(@NotNull List<SourceFilePosition> sourceFilePositions) {
        if (sourceFilePositions == null) {
            ExternalNdkBuildIssuesReporter.$$$reportNull$$$0(4);
        }
        assert (!sourceFilePositions.isEmpty());
        VirtualFile sourceFile = null;
        SourceFile source = sourceFilePositions.get(0).getFile();
        if (source.getSourceFile() != null) {
            sourceFile = VfsUtil.findFileByIoFile((File)source.getSourceFile(), (boolean)true);
        }
        if (sourceFile != null) {
            SourcePosition sourcePosition = sourceFilePositions.get(0).getPosition();
            return new PositionInFile(sourceFile, sourcePosition.getStartLine(), sourcePosition.getStartColumn());
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildOutputParser";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "IdeSyncIssue";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageReporter";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFilePositions";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/gradle/project/sync/issues/ExternalNdkBuildIssuesReporter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "report";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "createPosition";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

