/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.issues;

import com.android.ide.common.gradle.model.IdeSyncIssue;
import com.android.repository.Revision;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.impl.meta.RepositoryPackages;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.android.tools.idea.gradle.project.sync.errors.SdkBuildToolsTooLowIssueChecker;
import com.android.tools.idea.gradle.project.sync.errors.SdkBuildToolsTooLowIssueCheckerKt;
import com.android.tools.idea.gradle.project.sync.hyperlink.FixBuildToolsVersionHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.InstallBuildToolsHyperlink;
import com.android.tools.idea.gradle.project.sync.issues.SimpleDeduplicatingSyncIssueReporter;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.annotations.NotNull;

class BuildToolsTooLowReporter
extends SimpleDeduplicatingSyncIssueReporter {
    BuildToolsTooLowReporter() {
    }

    @Override
    int getSupportedIssueType() {
        return 13;
    }

    @Override
    @NotNull
    protected List<NotificationHyperlink> getCustomLinks(@NotNull Project project, @NotNull List<IdeSyncIssue> syncIssues2, @NotNull List<Module> affectedModules, @NotNull Map<Module, VirtualFile> buildFileMap) {
        if (project == null) {
            BuildToolsTooLowReporter.$$$reportNull$$$0(0);
        }
        if (syncIssues2 == null) {
            BuildToolsTooLowReporter.$$$reportNull$$$0(1);
        }
        if (affectedModules == null) {
            BuildToolsTooLowReporter.$$$reportNull$$$0(2);
        }
        if (buildFileMap == null) {
            BuildToolsTooLowReporter.$$$reportNull$$$0(3);
        }
        assert (!syncIssues2.isEmpty() && !affectedModules.isEmpty());
        String minimumVersion = syncIssues2.get(0).getData();
        if (minimumVersion == null) {
            ImmutableList immutableList = ImmutableList.of();
            if (immutableList == null) {
                BuildToolsTooLowReporter.$$$reportNull$$$0(4);
            }
            return immutableList;
        }
        List<NotificationHyperlink> list = this.getQuickFixHyperlinks(minimumVersion, affectedModules, buildFileMap);
        if (list == null) {
            BuildToolsTooLowReporter.$$$reportNull$$$0(5);
        }
        return list;
    }

    @NotNull
    public List<NotificationHyperlink> getQuickFixHyperlinks(@NotNull String minimumVersion, @NotNull List<Module> affectedModules, @NotNull Map<Module, VirtualFile> buildFileMap) {
        if (minimumVersion == null) {
            BuildToolsTooLowReporter.$$$reportNull$$$0(6);
        }
        if (affectedModules == null) {
            BuildToolsTooLowReporter.$$$reportNull$$$0(7);
        }
        if (buildFileMap == null) {
            BuildToolsTooLowReporter.$$$reportNull$$$0(8);
        }
        ArrayList<NotificationHyperlink> hyperlinks = new ArrayList<NotificationHyperlink>();
        boolean buildToolInstalled = false;
        AndroidSdkHandler sdkHandler = null;
        AndroidSdkData androidSdkData = AndroidSdks.getInstance().tryToChooseAndroidSdk();
        if (androidSdkData != null) {
            sdkHandler = androidSdkData.getSdkHandler();
        }
        if (sdkHandler != null) {
            StudioLoggerProgressIndicator progress = new StudioLoggerProgressIndicator(SdkBuildToolsTooLowIssueChecker.class);
            RepositoryPackages packages = sdkHandler.getSdkManager((ProgressIndicator)progress).getPackages();
            LocalPackage buildTool = (LocalPackage)packages.getLocalPackages().get(DetailsTypes.getBuildToolsPath((Revision)Revision.parseRevision((String)minimumVersion)));
            buildToolInstalled = buildTool != null;
        }
        List<VirtualFile> buildFiles = affectedModules.stream().map(m -> (VirtualFile)buildFileMap.get(m)).filter(Objects::nonNull).collect(Collectors.toList());
        if (!buildToolInstalled) {
            hyperlinks.add(new InstallBuildToolsHyperlink(minimumVersion, buildFiles, SdkBuildToolsTooLowIssueCheckerKt.doesAndroidGradlePluginPackageBuildTools(affectedModules)));
        } else if (!buildFiles.isEmpty()) {
            hyperlinks.add(new FixBuildToolsVersionHyperlink(minimumVersion, buildFiles, SdkBuildToolsTooLowIssueCheckerKt.doesAndroidGradlePluginPackageBuildTools(affectedModules)));
        }
        ArrayList<NotificationHyperlink> arrayList = hyperlinks;
        if (arrayList == null) {
            BuildToolsTooLowReporter.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "syncIssues";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "affectedModules";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildFileMap";
                break;
            }
            case 4: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/issues/BuildToolsTooLowReporter";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "minimumVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/issues/BuildToolsTooLowReporter";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomLinks";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuickFixHyperlinks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCustomLinks";
                break;
            }
            case 4: 
            case 5: 
            case 9: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getQuickFixHyperlinks";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

