/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.idea.issues;

import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.gradle.project.sync.idea.issues.BuildIssueComposer;
import com.android.tools.idea.gradle.project.sync.idea.issues.BuildIssueUtilKt;
import com.android.tools.idea.gradle.project.sync.idea.issues.DownloadAndroidStudioQuickFix;
import com.android.tools.idea.gradle.project.sync.idea.issues.DownloadJdk8QuickFix;
import com.android.tools.idea.gradle.project.sync.idea.issues.JdkImportCheckException;
import com.android.tools.idea.gradle.project.sync.idea.issues.SelectJdkFromFileSystemQuickFix;
import com.android.tools.idea.gradle.project.sync.idea.issues.UseEmbeddedJdkQuickFix;
import com.android.tools.idea.gradle.project.sync.idea.issues.UseJavaHomeAsJdkQuickFix;
import com.android.tools.idea.gradle.util.EmbeddedDistributionPaths;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.sdk.Jdks;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.build.FilePosition;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.issue.BuildIssue;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.issue.GradleIssueChecker;
import org.jetbrains.plugins.gradle.issue.GradleIssueData;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/idea/gradle/project/sync/idea/issues/JdkImportIssueChecker;", "Lorg/jetbrains/plugins/gradle/issue/GradleIssueChecker;", "()V", "check", "Lcom/intellij/build/issue/BuildIssue;", "issueData", "Lorg/jetbrains/plugins/gradle/issue/GradleIssueData;", "intellij.android.core"})
public final class JdkImportIssueChecker
implements GradleIssueChecker {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public BuildIssue check(@NotNull GradleIssueData issueData) {
        String string;
        Intrinsics.checkNotNullParameter((Object)issueData, (String)"issueData");
        if (issueData.getError() instanceof JdkImportCheckException) {
            String string2 = issueData.getError().getMessage();
            string = string2;
            Intrinsics.checkNotNull((Object)string2);
        } else {
            String string3 = issueData.getError().getMessage();
            if (string3 == null) return null;
            if (!StringsKt.contains$default((CharSequence)string3, (CharSequence)"Unsupported major.minor version 52.0", (boolean)false, (int)2, null)) return null;
            ModalityState modalityState$iv = null;
            boolean $i$f$invokeLater = false;
            Application application = ApplicationManager.getApplication();
            Runnable runnable2 = new Runnable(issueData){
                final /* synthetic */ GradleIssueData $issueData$inlined;
                {
                    this.$issueData$inlined = gradleIssueData;
                }

                public final void run() {
                    boolean bl = false;
                    BuildIssueUtilKt.updateUsageTracker(this.$issueData$inlined.getProjectPath(), AndroidStudioEvent.GradleSyncFailure.JDK8_REQUIRED);
                }
            };
            ModalityState modalityState = ModalityState.defaultModalityState();
            Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"ModalityState.defaultModalityState()");
            application.invokeLater(runnable2, modalityState);
            StringBuilder stringBuilder = new StringBuilder();
            String string4 = issueData.getError().getMessage();
            Intrinsics.checkNotNull((Object)string4);
            string = stringBuilder.append(string4).append("\nPlease use JDK 8 or newer.").toString();
        }
        String message2 = string;
        BuildIssueComposer buildIssueComposer = new BuildIssueComposer(message2, null, 2, null);
        boolean bl = false;
        boolean bl2 = false;
        BuildIssueComposer $this$apply = buildIssueComposer;
        boolean bl3 = false;
        IdeInfo ideInfo = IdeInfo.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)ideInfo, (String)"IdeInfo.getInstance()");
        if (ideInfo.isAndroidStudio()) {
            String jdkFromHome;
            IdeSdks ideSdks = IdeSdks.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)ideSdks, (String)"IdeSdks.getInstance()");
            IdeSdks ideSdks2 = ideSdks;
            if (!ideSdks2.isUsingJavaHomeJdk() && (jdkFromHome = IdeSdks.getJdkFromJavaHome()) != null && ideSdks2.validateJdkPath(Paths.get(jdkFromHome, new String[0])) != null) {
                $this$apply.addQuickFix(new UseJavaHomeAsJdkQuickFix(jdkFromHome));
            }
            if ($this$apply.getIssueQuickFixes().isEmpty()) {
                Path embeddedJdkPath = EmbeddedDistributionPaths.getInstance().tryToGetEmbeddedJdkPath();
                if (embeddedJdkPath != null && Jdks.isJdkRunnableOnPlatform(((Object)embeddedJdkPath.toAbsolutePath()).toString())) {
                    $this$apply.addQuickFix(new UseEmbeddedJdkQuickFix());
                } else {
                    $this$apply.addQuickFix(new DownloadAndroidStudioQuickFix());
                }
            }
        }
        $this$apply.addQuickFix(new SelectJdkFromFileSystemQuickFix());
        $this$apply.addQuickFix(new DownloadJdk8QuickFix());
        return buildIssueComposer.composeBuildIssue();
    }

    public boolean consumeBuildOutputFailureMessage(@NotNull String message2, @NotNull String failureCause, @Nullable String stacktrace, @Nullable FilePosition location, @NotNull Object parentEventId, @NotNull Consumer<? super BuildEvent> messageConsumer) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        Intrinsics.checkNotNullParameter((Object)failureCause, (String)"failureCause");
        Intrinsics.checkNotNullParameter((Object)parentEventId, (String)"parentEventId");
        Intrinsics.checkNotNullParameter(messageConsumer, (String)"messageConsumer");
        return GradleIssueChecker.DefaultImpls.consumeBuildOutputFailureMessage((GradleIssueChecker)this, (String)message2, (String)failureCause, (String)stacktrace, (FilePosition)location, (Object)parentEventId, messageConsumer);
    }
}

