/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.idea.data.service;

import com.android.tools.idea.gradle.project.model.ModuleModel;
import com.android.tools.idea.gradle.project.sync.idea.data.service.AndroidProjectKeys;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractProjectDataService;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.data.GradleSourceSetData;

public abstract class ModuleModelDataService<T extends ModuleModel>
extends AbstractProjectDataService<T, Module> {
    public final void importData(@NotNull Collection<? extends DataNode<T>> toImport, @Nullable ProjectData projectData, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (toImport == null) {
            ModuleModelDataService.$$$reportNull$$$0(0);
        }
        if (project == null) {
            ModuleModelDataService.$$$reportNull$$$0(1);
        }
        if (modelsProvider == null) {
            ModuleModelDataService.$$$reportNull$$$0(2);
        }
        WriteCommandAction.runWriteCommandAction((Project)project, () -> {
            if (project.isDisposed()) {
                return;
            }
            Map<String, T> modelsByModuleName = this.indexByModuleName(toImport, modelsProvider);
            this.importData(toImport, project, modelsProvider, modelsByModuleName);
        });
    }

    protected abstract void importData(@NotNull Collection<? extends DataNode<T>> var1, @NotNull Project var2, @NotNull IdeModifiableModelsProvider var3, @NotNull Map<String, T> var4);

    @NotNull
    public Computable<Collection<Module>> computeOrphanData(@NotNull Collection<? extends DataNode<T>> toImport, @NotNull ProjectData projectData, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (toImport == null) {
            ModuleModelDataService.$$$reportNull$$$0(3);
        }
        if (projectData == null) {
            ModuleModelDataService.$$$reportNull$$$0(4);
        }
        if (project == null) {
            ModuleModelDataService.$$$reportNull$$$0(5);
        }
        if (modelsProvider == null) {
            ModuleModelDataService.$$$reportNull$$$0(6);
        }
        Map modelsByModuleName = this.indexByModuleName(toImport, modelsProvider);
        Computable computable = () -> {
            SmartList orphanIdeModules = new SmartList();
            for (Module module2 : modelsProvider.getModules()) {
                if (!ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)projectData.getOwner(), (Module)module2) || ExternalSystemApiUtil.getExternalModuleType((Module)module2) != null) continue;
                String rootProjectPath = ExternalSystemApiUtil.getExternalRootProjectPath((Module)module2);
                if (!projectData.getLinkedExternalProjectPath().equals(rootProjectPath) || modelsByModuleName.get(module2.getName()) != null) continue;
                orphanIdeModules.add(module2);
            }
            return orphanIdeModules;
        };
        if (computable == null) {
            ModuleModelDataService.$$$reportNull$$$0(7);
        }
        return computable;
    }

    @NotNull
    private Map<String, T> indexByModuleName(@NotNull Collection<? extends DataNode<T>> dataNodes, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (dataNodes == null) {
            ModuleModelDataService.$$$reportNull$$$0(8);
        }
        if (modelsProvider == null) {
            ModuleModelDataService.$$$reportNull$$$0(9);
        }
        if (dataNodes.isEmpty()) {
            Map map2 = Collections.emptyMap();
            if (map2 == null) {
                ModuleModelDataService.$$$reportNull$$$0(10);
            }
            return map2;
        }
        HashMap<String, ModuleModel> index2 = new HashMap<String, ModuleModel>();
        for (DataNode<T> dataNode : dataNodes) {
            ModuleModel model2 = (ModuleModel)dataNode.getData();
            String moduleName2 = model2.getModuleName();
            if (dataNode.getParent() != null) {
                ModuleData moduleData = (ModuleData)dataNode.getParent().getData();
                Module module2 = modelsProvider.findIdeModule(moduleData);
                if (module2 != null && !module2.getName().equals(moduleName2)) {
                    moduleName2 = module2.getName();
                }
                if (!dataNode.getKey().equals(AndroidProjectKeys.ANDROID_MODEL)) {
                    this.indexModulesForSourceSetsByModuleName(index2, dataNode, model2);
                }
            }
            index2.put(moduleName2, model2);
        }
        HashMap<String, ModuleModel> hashMap = index2;
        if (hashMap == null) {
            ModuleModelDataService.$$$reportNull$$$0(11);
        }
        return hashMap;
    }

    private void indexModulesForSourceSetsByModuleName(@NotNull Map<String, T> index2, @NotNull DataNode<T> dataNode, @NotNull T model2) {
        if (index2 == null) {
            ModuleModelDataService.$$$reportNull$$$0(12);
        }
        if (dataNode == null) {
            ModuleModelDataService.$$$reportNull$$$0(13);
        }
        if (model2 == null) {
            ModuleModelDataService.$$$reportNull$$$0(14);
        }
        if (dataNode.getParent() == null) {
            return;
        }
        for (DataNode node2 : dataNode.getParent().getChildren()) {
            if (!node2.getKey().equals((Object)GradleSourceSetData.KEY)) continue;
            GradleSourceSetData sourceSetData = (GradleSourceSetData)node2.getData();
            index2.put(sourceSetData.getInternalName(), model2);
        }
    }

    @NotNull
    protected Logger getLog() {
        Logger logger2 = Logger.getInstance(((Object)((Object)this)).getClass());
        if (logger2 == null) {
            ModuleModelDataService.$$$reportNull$$$0(15);
        }
        return logger2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 10: 
            case 11: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 10: 
            case 11: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toImport";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelsProvider";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectData";
                break;
            }
            case 7: 
            case 10: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/idea/data/service/ModuleModelDataService";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataNodes";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataNode";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/idea/data/service/ModuleModelDataService";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "computeOrphanData";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "indexByModuleName";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getLog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "importData";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "computeOrphanData";
                break;
            }
            case 7: 
            case 10: 
            case 11: 
            case 15: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "indexByModuleName";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "indexModulesForSourceSetsByModuleName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 10: 
            case 11: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

