/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.idea.data;

import com.android.tools.idea.Projects;
import com.android.tools.idea.gradle.project.sync.idea.data.service.AndroidProjectKeys;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.ProjectDataManager;
import com.intellij.openapi.externalSystem.service.project.manage.ProjectDataManagerImpl;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class DataNodeCaches {
    @NotNull
    private final Project myProject;

    @NotNull
    public static DataNodeCaches getInstance(@NotNull Project project) {
        if (project == null) {
            DataNodeCaches.$$$reportNull$$$0(0);
        }
        DataNodeCaches dataNodeCaches = (DataNodeCaches)project.getService(DataNodeCaches.class);
        if (dataNodeCaches == null) {
            DataNodeCaches.$$$reportNull$$$0(1);
        }
        return dataNodeCaches;
    }

    public DataNodeCaches(@NotNull Project project) {
        if (project == null) {
            DataNodeCaches.$$$reportNull$$$0(2);
        }
        this.myProject = project;
    }

    @Nullable
    public DataNode<ProjectData> getCachedProjectData() {
        ExternalProjectInfo projectInfo = this.getExternalProjectInfo();
        return projectInfo != null ? projectInfo.getExternalProjectStructure() : null;
    }

    @Nullable
    private ExternalProjectInfo getExternalProjectInfo() {
        ProjectDataManager dataManager = ProjectDataManager.getInstance();
        String projectPath = Projects.getBaseDirPath((Project)this.myProject).getPath();
        return dataManager.getExternalProjectData(this.myProject, GradleConstants.SYSTEM_ID, projectPath);
    }

    public void clearCaches() {
        ExternalProjectInfo projectInfo = this.getExternalProjectInfo();
        if (projectInfo == null) {
            return;
        }
        DataNode cache = projectInfo.getExternalProjectStructure();
        if (cache == null) {
            return;
        }
        DataNodeCaches.clearCaches((DataNode<ProjectData>)cache);
        ProjectDataManagerImpl.getInstance().updateExternalProjectData(this.myProject, projectInfo);
        this.myProject.save();
    }

    private static void clearCaches(@NotNull DataNode<ProjectData> cache) {
        if (cache == null) {
            DataNodeCaches.$$$reportNull$$$0(3);
        }
        DataNodeCaches.clearCachesOfType(cache, AndroidProjectKeys.GRADLE_MODULE_MODEL);
        DataNodeCaches.clearCachesOfType(cache, AndroidProjectKeys.ANDROID_MODEL);
        DataNodeCaches.clearCachesOfType(cache, AndroidProjectKeys.JAVA_MODULE_MODEL);
        DataNodeCaches.clearCachesOfType(cache, AndroidProjectKeys.NDK_MODEL);
    }

    private static <T> void clearCachesOfType(@NotNull DataNode<ProjectData> cache, @NotNull Key<T> type) {
        if (cache == null) {
            DataNodeCaches.$$$reportNull$$$0(4);
        }
        if (type == null) {
            DataNodeCaches.$$$reportNull$$$0(5);
        }
        for (DataNode dataNode : ExternalSystemApiUtil.findAllRecursively(cache, type)) {
            dataNode.clear(true);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/idea/data/DataNodeCaches";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cache";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/idea/data/DataNodeCaches";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "clearCaches";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "clearCachesOfType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

