/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.idea;

import com.android.tools.idea.flags.ExperimentalSettingsConfigurable;
import com.android.tools.idea.gradle.project.GradleExperimentalSettings;
import com.android.tools.idea.gradle.project.sync.idea.DependencyUtilKt;
import com.android.utils.FileUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.intellij.diagnostic.VMOptions;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000\"\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a \u0010\u0002\u001a\u00020\u00032\u0018\u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u00060\u0005\u001a\u0010\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u0001H\u0007\u001a\b\u0010\t\u001a\u00020\u0001H\u0007\u001a\n\u0010\n\u001a\u0004\u0018\u00010\u0001H\u0002\u001a\b\u0010\u000b\u001a\u00020\fH\u0002\u001a\u0012\u0010\r\u001a\u00020\u00032\b\b\u0002\u0010\u000e\u001a\u00020\fH\u0007\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"defaultTraceMethods", "", "addTraceJvmArgs", "", "args", "", "Lcom/intellij/openapi/util/Pair;", "createTraceProfileFile", "traceMethods", "findAgentJar", "getTraceMethods", "getVMOptionsFile", "Ljava/io/File;", "updateTraceArgsInFile", "vmOptionsFile", "intellij.android.core"})
@JvmName(name="TraceSyncUtil")
public final class TraceSyncUtil {
    private static final String defaultTraceMethods = "# GRADLE\nTrace: com.android.build.gradle.internal.ide.DefaultAndroidProject\nTrace: com.android.build.gradle.internal.ide.ModelBuilder\nTrace: com.android.build.gradle.internal.ide.VariantImpl\nTrace: com.android.build.gradle.internal.ide.dependencies.ArtifactDependencyGraph\nTrace: com.android.build.gradle.internal.ide.dependencies.ArtifactUtils\nTrace: com.android.build.gradle.internal.tasks.factory.TaskAction\nTrace: com.android.build.gradle.internal.tasks.factory.TaskAction2\nTrace: org.gradle.api.internal.artifacts.configurations.DefaultConfiguration$ConfigurationArtifactCollection\nTrace: org.gradle.api.internal.tasks.execution.ExecuteActionsTaskExecuter::execute\nTrace: org.gradle.api.internal.tasks.execution.SkipUpToDateTaskExecuter::execute\nTrace: org.jetbrains.kotlin.gradle.model.builder.KotlinModelBuilder\nTrace: org.jetbrains.kotlin.kapt.idea.KaptModelBuilderService\nTrace: org.jetbrains.plugins.gradle.tooling.internal.ExtraModelBuilder\nTrace: org.jetbrains.kotlin.gradle.KotlinGradleModelBuilder\nTrace: org.jetbrains.kotlin.gradle.KotlinMPPGradleModelBuilder\n\n# IDEA\nTrace: com.android.tools.idea.gradle.project.sync.GradleSyncState::syncFailed\nTrace: com.android.tools.idea.gradle.project.sync.GradleSyncState::syncStarted\nTrace: com.android.tools.idea.gradle.project.sync.GradleSyncState::syncSucceeded\nTrace: com.android.tools.idea.gradle.project.sync.idea.AndroidGradleProjectResolver::populateProjectExtraModels\nTrace: com.android.tools.idea.gradle.project.sync.idea.AndroidGradleProjectResolver::populateModuleContentRoots\nTrace: com.android.tools.idea.gradle.project.sync.idea.AndroidGradleProjectResolver::populateModuleDependencies\nTrace: com.android.tools.idea.gradle.project.sync.idea.data.service.GradleModuleModelDataService::importData\nTrace: com.android.tools.idea.gradle.project.sync.idea.data.service.JavaModuleModelDataService::importData\nTrace: com.android.tools.idea.gradle.project.sync.idea.data.service.NdkModuleModelDataService::importData\nTrace: com.intellij.openapi.externalSystem.service.project.manage.ContentRootDataService::importData\nTrace: com.intellij.openapi.externalSystem.service.project.manage.LibraryDataService::importData\nTrace: com.intellij.openapi.externalSystem.service.project.manage.LibraryDependencyDataService::importData\nTrace: com.intellij.openapi.externalSystem.service.project.manage.ModuleDataService::importData\nTrace: com.intellij.openapi.externalSystem.service.project.manage.ModuleDependencyDataService::importData\nTrace: com.intellij.openapi.externalSystem.service.project.manage.ProjectDataServiceImpl::importData\n";

    public static final void addTraceJvmArgs(@NotNull List<Pair<String, String>> args) {
        block3: {
            Object v3;
            block2: {
                Intrinsics.checkNotNullParameter(args, (String)"args");
                String expectedKey = "-javaagent:" + TraceSyncUtil.findAgentJar();
                RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
                Intrinsics.checkNotNullExpressionValue((Object)runtimeMXBean, (String)"ManagementFactory.getRuntimeMXBean()");
                List<String> list = runtimeMXBean.getInputArguments();
                Intrinsics.checkNotNullExpressionValue(list, (String)"ManagementFactory.getRun\u2026meMXBean().inputArguments");
                Iterable $this$firstOrNull$iv = list;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    String it = (String)element$iv;
                    boolean bl = false;
                    String string = it;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it");
                    if (!StringsKt.startsWith$default((String)string, (String)expectedKey, (boolean)false, (int)2, null)) continue;
                    v3 = element$iv;
                    break block2;
                }
                v3 = null;
            }
            String string = v3;
            if (string == null) break block3;
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            List optionLine = StringsKt.split$default((CharSequence)it, (char[])new char[]{'='}, (boolean)false, (int)0, (int)6, null);
            if (optionLine.size() == 2) {
                DependencyUtilKt.getRESOLVER_LOG().info("Launch Gradle with trace jvm option: " + it);
                args.add((Pair<String, String>)new Pair(optionLine.get(0), optionLine.get(1)));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public static final void updateTraceArgsInFile(@NotNull File vmOptionsFile) {
        void $this$filterNotTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)vmOptionsFile, (String)"vmOptionsFile");
        String traceArgsPrefix = "-javaagent:" + TraceSyncUtil.findAgentJar() + '=';
        vmOptionsFile.createNewFile();
        Object $this$filterNot$iv = FilesKt.readLines$default((File)vmOptionsFile, null, (int)1, null);
        boolean $i$f$filterNot = false;
        Object object = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            String line2 = (String)element$iv$iv;
            boolean bl = false;
            if (StringsKt.startsWith$default((String)line2, (String)traceArgsPrefix, (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List vmOptions = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
        if (GradleExperimentalSettings.getInstance().TRACE_GRADLE_SYNC) {
            String string = TraceSyncUtil.getTraceMethods();
            if (string != null) {
                $this$filterNot$iv = string;
                boolean bl = false;
                boolean bl2 = false;
                Object traceMethods = $this$filterNot$iv;
                boolean bl3 = false;
                vmOptions.add(traceArgsPrefix + TraceSyncUtil.createTraceProfileFile((String)traceMethods));
            }
        }
        try {
            String text2 = vmOptions.isEmpty() ? "" : CollectionsKt.joinToString$default((Iterable)vmOptions, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null) + "\n";
            Path path2 = vmOptionsFile.toPath();
            String string = text2;
            object = Charsets.UTF_8;
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            byte[] byArray = string2.getBytes((Charset)object);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            Files.write(path2, byArray, new OpenOption[0]);
        }
        catch (IOException e) {
            DependencyUtilKt.getRESOLVER_LOG().error("Unable to write to vm options file from " + vmOptionsFile.getPath() + '.');
        }
    }

    public static /* synthetic */ void updateTraceArgsInFile$default(File file2, int n, Object object) {
        if ((n & 1) != 0) {
            file2 = TraceSyncUtil.getVMOptionsFile();
        }
        TraceSyncUtil.updateTraceArgsInFile(file2);
    }

    @JvmOverloads
    public static final void updateTraceArgsInFile() {
        TraceSyncUtil.updateTraceArgsInFile$default(null, 1, null);
    }

    private static final File getVMOptionsFile() {
        return new File(PathManager.getBinPath(), VMOptions.getCustomVMOptionsFileName());
    }

    private static final String getTraceMethods() {
        String string;
        GradleExperimentalSettings gradleExperimentalSettings = GradleExperimentalSettings.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)gradleExperimentalSettings, (String)"GradleExperimentalSettings.getInstance()");
        GradleExperimentalSettings settings = gradleExperimentalSettings;
        if (settings.TRACE_PROFILE_SELECTION == ExperimentalSettingsConfigurable.TraceProfileItem.DEFAULT) {
            return defaultTraceMethods;
        }
        File localProfile = new File(Strings.nullToEmpty((String)settings.TRACE_PROFILE_LOCATION));
        if (!localProfile.isFile()) {
            DependencyUtilKt.getRESOLVER_LOG().error("Unable to trace Gradle: could not load trace profile from " + localProfile.getPath() + '.');
            string = null;
        } else {
            string = FilesKt.readText$default((File)localProfile, null, (int)1, null);
        }
        return string;
    }

    @VisibleForTesting
    @NotNull
    public static final String findAgentJar() {
        File path2 = new File(PathManager.getHomePath(), "plugins/android/resources/trace_agent.jar");
        if (!path2.exists()) {
            path2 = new File(PathManager.getHomePath(), "../../bazel-bin/tools/base/tracer/trace_agent.jar");
        }
        String string = path2.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"path.absolutePath");
        return string;
    }

    @VisibleForTesting
    @NotNull
    public static final String createTraceProfileFile(@NotNull String traceMethods) {
        Intrinsics.checkNotNullParameter((Object)traceMethods, (String)"traceMethods");
        String outputFileName = "sync_profile_report_" + new SimpleDateFormat("yyyyMMdd-HHmmss", Locale.US).format(System.currentTimeMillis()) + ".json";
        String string = FileUtil.toSystemDependentName((String)new File(PathManager.getLogPath(), outputFileName).getAbsolutePath());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"FileUtil.toSystemDepende\u2026utFileName).absolutePath)");
        String outputFilePath = string;
        String profileContent = "Output: " + outputFilePath + '\n' + traceMethods;
        File file2 = FileUtil.createTempFile((String)"sync.trace", (String)".profile");
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"FileUtil.createTempFile(\"sync.trace\", \".profile\")");
        File traceProfile = file2;
        FileUtils.writeToFile((File)traceProfile, (String)profileContent);
        DependencyUtilKt.getRESOLVER_LOG().info("Trace output file: " + outputFileName);
        String string2 = traceProfile.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"traceProfile.path");
        return string2;
    }
}

