/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.idea;

import com.android.repository.api.ProgressIndicator;
import com.android.tools.idea.gradle.project.sync.SdkSync;
import com.android.tools.idea.gradle.project.sync.idea.AndroidGradleProjectResolver;
import com.android.tools.idea.gradle.project.sync.idea.SdkSyncUtil;
import com.android.tools.idea.gradle.project.sync.idea.issues.SdkPlatformNotFoundException;
import com.android.tools.idea.gradle.util.LocalProperties;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000>\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\b\u0010\u0000\u001a\u00020\u0001H\u0002\u001a\u0018\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a:\u0010\u0007\u001a\u0004\u0018\u00010\u0004*\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u00062\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\r2\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0004*\u00020\b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\rH\u0002\u001a\u0017\u0010\u0011\u001a\u00020\u0001*\u00020\u00122\u000b\u0010\u0013\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0014\u00a8\u0006\u0015"}, d2={"logAndroidSdkHomeNotFound", "", "logSdkFound", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "moduleName", "", "computeSdkReloadingAsNeeded", "Lcom/android/tools/idea/sdk/AndroidSdks;", "project", "Lcom/intellij/openapi/project/Project;", "compileTarget", "bootClasspath", "", "ideSdks", "Lcom/android/tools/idea/sdk/IdeSdks;", "findMatchingSdkForAddon", "syncAndroidSdks", "Lcom/android/tools/idea/gradle/project/sync/SdkSync;", "projectPath", "Lorg/jetbrains/annotations/SystemDependent;", "intellij.android.core"})
@JvmName(name="SdkSyncUtil")
public final class SdkSyncUtil {
    public static final void syncAndroidSdks(@NotNull SdkSync $this$syncAndroidSdks, @NotNull String projectPath) {
        Intrinsics.checkNotNullParameter((Object)$this$syncAndroidSdks, (String)"$this$syncAndroidSdks");
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        File projectDir = new File(projectPath);
        if (!projectDir.isDirectory()) {
            throw (Throwable)new IllegalStateException("The project directory does not exist!");
        }
        LocalProperties localProperties = new LocalProperties(projectDir);
        $this$syncAndroidSdks.syncIdeAndProjectAndroidSdks(localProperties);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final Sdk computeSdkReloadingAsNeeded(@NotNull AndroidSdks $this$computeSdkReloadingAsNeeded, @NotNull Project project, @NotNull String moduleName2, @NotNull String compileTarget, @NotNull Collection<String> bootClasspath, @NotNull IdeSdks ideSdks) {
        void newSdk;
        Intrinsics.checkNotNullParameter((Object)$this$computeSdkReloadingAsNeeded, (String)"$this$computeSdkReloadingAsNeeded");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)moduleName2, (String)"moduleName");
        Intrinsics.checkNotNullParameter((Object)compileTarget, (String)"compileTarget");
        Intrinsics.checkNotNullParameter(bootClasspath, (String)"bootClasspath");
        Intrinsics.checkNotNullParameter((Object)ideSdks, (String)"ideSdks");
        Sdk sdk = $this$computeSdkReloadingAsNeeded.findSuitableAndroidSdk(compileTarget);
        if (sdk != null) {
            VirtualFile[] virtualFileArray = sdk.getRootProvider().getFiles(OrderRootType.CLASSES);
            Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"sdk.rootProvider.getFiles(CLASSES)");
            VirtualFile[] virtualFileArray2 = virtualFileArray;
            boolean bl = false;
            if (virtualFileArray2.length == 0) {
                ProjectJdkTable.getInstance().removeJdk(sdk);
                sdk = null;
            }
        }
        if (sdk != null) {
            SdkSyncUtil.logSdkFound(sdk, moduleName2);
            return sdk;
        }
        StudioLoggerProgressIndicator progress = new StudioLoggerProgressIndicator(AndroidGradleProjectResolver.class);
        ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable($this$computeSdkReloadingAsNeeded, progress){
            final /* synthetic */ AndroidSdks $this_computeSdkReloadingAsNeeded;
            final /* synthetic */ StudioLoggerProgressIndicator $progress;

            public final void run() {
                this.$this_computeSdkReloadingAsNeeded.tryToChooseSdkHandler().getSdkManager((ProgressIndicator)this.$progress).reloadLocalIfNeeded((ProgressIndicator)this.$progress);
            }
            {
                this.$this_computeSdkReloadingAsNeeded = androidSdks;
                this.$progress = studioLoggerProgressIndicator;
            }
        }, "Reloading SDKs", false, project);
        File androidSdkHomePath = ideSdks.getAndroidSdkPath();
        if (androidSdkHomePath == null) {
            SdkSyncUtil.logAndroidSdkHomeNotFound();
            return null;
        }
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        ActionsKt.invokeAndWaitIfNeeded$default(null, (Function0)((Function0)new Function0<Unit>($this$computeSdkReloadingAsNeeded, (Ref.ObjectRef)newSdk, androidSdkHomePath, compileTarget){
            final /* synthetic */ AndroidSdks $this_computeSdkReloadingAsNeeded;
            final /* synthetic */ Ref.ObjectRef $newSdk;
            final /* synthetic */ File $androidSdkHomePath;
            final /* synthetic */ String $compileTarget;

            public final void invoke() {
                this.$newSdk.element = (Sdk)ApplicationUtilsKt.runWriteAction((Function0)((Function0)new Function0<Sdk>(this){
                    final /* synthetic */ computeSdkReloadingAsNeeded.2 this$0;

                    @Nullable
                    public final Sdk invoke() {
                        return this.this$0.$this_computeSdkReloadingAsNeeded.tryToCreate(this.this$0.$androidSdkHomePath, this.this$0.$compileTarget);
                    }
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }
                }));
            }
            {
                this.$this_computeSdkReloadingAsNeeded = androidSdks;
                this.$newSdk = objectRef;
                this.$androidSdkHomePath = file2;
                this.$compileTarget = string;
                super(0);
            }
        }), (int)1, null);
        if ((Sdk)newSdk.element != null) {
            Sdk sdk2 = (Sdk)newSdk.element;
            if (sdk2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.projectRoots.Sdk");
            }
            SdkSyncUtil.logSdkFound(sdk2, moduleName2);
            Sdk sdk3 = (Sdk)newSdk.element;
            if (sdk3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.projectRoots.Sdk");
            }
            return sdk3;
        }
        Sdk addonSdk = SdkSyncUtil.findMatchingSdkForAddon($this$computeSdkReloadingAsNeeded, bootClasspath);
        if (addonSdk == null) {
            String message2 = "Module: '" + moduleName2 + "' platform '" + compileTarget + "' not found.";
            AndroidGradleProjectResolver.RESOLVER_LOG.warn(message2);
            throw (Throwable)new SdkPlatformNotFoundException(message2);
        }
        return addonSdk;
    }

    /*
     * WARNING - void declaration
     */
    private static final Sdk findMatchingSdkForAddon(AndroidSdks $this$findMatchingSdkForAddon, Collection<String> bootClasspath) {
        Object element$iv2;
        block8: {
            Object v0;
            block6: {
                void $this$mapTo$iv$iv;
                if (bootClasspath.size() <= 1) {
                    return null;
                }
                Iterable $this$map$iv = bootClasspath;
                boolean $i$f$map = false;
                Iterator iterator = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void path2;
                    String string = (String)item$iv$iv;
                    Collection collection2 = destination$iv$iv;
                    boolean bl = false;
                    File file2 = new File((String)path2);
                    collection2.add(file2);
                }
                Iterable $this$firstOrNull$iv = (List)destination$iv$iv;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv2 : $this$firstOrNull$iv) {
                    File file3 = (File)element$iv2;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)file3.getName(), (Object)"android.jar")) continue;
                    v0 = element$iv2;
                    break block6;
                }
                v0 = null;
            }
            File file4 = v0;
            if (file4 == null) {
                return null;
            }
            File androidJarPath = file4;
            List<Sdk> list = $this$findMatchingSdkForAddon.getAllAndroidSdks();
            Intrinsics.checkNotNullExpressionValue(list, (String)"allAndroidSdks");
            Iterable $this$first$iv = list;
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                boolean bl;
                block7: {
                    VirtualFile[] $this$any$iv;
                    Sdk sdk = (Sdk)element$iv2;
                    boolean bl2 = false;
                    Sdk sdk2 = sdk;
                    Intrinsics.checkNotNullExpressionValue((Object)sdk2, (String)"sdk");
                    Intrinsics.checkNotNullExpressionValue((Object)sdk2.getRootProvider().getFiles(OrderRootType.CLASSES), (String)"sdk.rootProvider.getFiles(CLASSES)");
                    boolean $i$f$any = false;
                    VirtualFile[] virtualFileArray = $this$any$iv;
                    int n = virtualFileArray.length;
                    for (int j = 0; j < n; ++j) {
                        VirtualFile element$iv3;
                        VirtualFile sdkFile = element$iv3 = virtualFileArray[j];
                        boolean bl3 = false;
                        if (!FileUtil.filesEqual((File)VfsUtilCore.virtualToIoFile((VirtualFile)sdkFile), (File)androidJarPath)) continue;
                        bl = true;
                        break block7;
                    }
                    bl = false;
                }
                if (!bl) continue;
                break block8;
            }
            throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        return (Sdk)element$iv2;
    }

    private static final void logAndroidSdkHomeNotFound() {
        AndroidGradleProjectResolver.RESOLVER_LOG.warn("Path to Android SDK not set");
        IdeSdks ideSdks = IdeSdks.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)ideSdks, (String)"IdeSdks.getInstance()");
        List<Sdk> list = ideSdks.getEligibleAndroidSdks();
        Intrinsics.checkNotNullExpressionValue(list, (String)"IdeSdks.getInstance().eligibleAndroidSdks");
        List<Sdk> sdks = list;
        AndroidGradleProjectResolver.RESOLVER_LOG.warn("# of eligible SDKs: " + sdks.size());
        Iterable $this$forEach$iv = sdks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Sdk sdk = (Sdk)element$iv;
            boolean bl = false;
            AndroidGradleProjectResolver.RESOLVER_LOG.info("sdk: " + sdk);
        }
    }

    private static final void logSdkFound(Sdk sdk, String moduleName2) {
        String string = sdk.getHomePath();
        if (string == null) {
            string = "<path not set>";
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sdk.homePath ?: \"<path not set>\"");
        String sdkPath = string;
        AndroidGradleProjectResolver.RESOLVER_LOG.info("Set Android SDK '" + sdk.getName() + "' (" + sdkPath + ") to module " + moduleName2);
    }
}

