/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.idea;

import com.android.annotations.concurrency.WorkerThread;
import com.android.tools.idea.gradle.project.sync.GradleSyncListener;
import com.android.tools.idea.gradle.project.sync.idea.IdeaSyncPopulateProjectTask;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.service.project.ExternalProjectRefreshCallback;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.project.Project;
import com.intellij.util.ui.UIUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ProjectSetUpTask
implements ExternalProjectRefreshCallback {
    @NotNull
    private final Project myProject;
    @Nullable
    private final GradleSyncListener mySyncListener;

    ProjectSetUpTask(@NotNull Project project, @Nullable GradleSyncListener syncListener) {
        if (project == null) {
            ProjectSetUpTask.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.mySyncListener = syncListener;
    }

    @WorkerThread
    public void onSuccess(@NotNull ExternalSystemTaskId taskId, @Nullable DataNode<ProjectData> projectInfo) {
        if (taskId == null) {
            ProjectSetUpTask.$$$reportNull$$$0(1);
        }
        assert (projectInfo != null);
        this.doPopulateProject(projectInfo);
    }

    @WorkerThread
    private void doPopulateProject(@NotNull DataNode<ProjectData> projectInfo) {
        if (projectInfo == null) {
            ProjectSetUpTask.$$$reportNull$$$0(2);
        }
        IdeaSyncPopulateProjectTask task2 = new IdeaSyncPopulateProjectTask(this.myProject);
        task2.populateProject(projectInfo, this.mySyncListener);
    }

    public void onFailure(@NotNull ExternalSystemTaskId externalTaskId, @NotNull String errorMessage, @Nullable String errorDetails) {
        if (externalTaskId == null) {
            ProjectSetUpTask.$$$reportNull$$$0(3);
        }
        if (errorMessage == null) {
            ProjectSetUpTask.$$$reportNull$$$0(4);
        }
        if (errorMessage.contains(ExternalSystemBundle.message((String)"error.resolve.already.running", (Object[])new Object[]{""}))) {
            return;
        }
        UIUtil.invokeAndWaitIfNeeded(() -> {
            if (!this.myProject.isDisposed()) {
                ExternalSystemUtil.ensureToolWindowContentInitialized((Project)this.myProject, (ProjectSystemId)GradleUtil.GRADLE_SYSTEM_ID);
            }
        });
        String exceptionMessage = errorDetails == null || errorMessage.contains(errorDetails) ? errorMessage : errorMessage + "\n" + errorDetails;
        String messageWithGuide = ExternalSystemBundle.message((String)"error.resolve.with.reason", (Object[])new Object[]{exceptionMessage});
        if (this.mySyncListener != null) {
            this.mySyncListener.syncFailed(this.myProject, messageWithGuide);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskId";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectInfo";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalTaskId";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorMessage";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/gradle/project/sync/idea/ProjectSetUpTask";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "onSuccess";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "doPopulateProject";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "onFailure";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

